options ls=80;                                                                
/*                                                                            
***************************************************************************** 
*                                                                             
*               SAS DATA DEFINITION STATEMENTS FOR ICPSR 7439                 
*           Panel Study of Income Dynamics, 1968-1999: Annual Core Data       
*          PART 205: Family File, 1997  (Wave 30)  Public Release I           
*                           1ST ICPSR VERSION                                 
*                             February, 2002                                  
*                                                                             
***************************************************************************** 
*  Typical SAS data definition statements (setup files) contain some or       
*  all of the following statements:                                           
*                                                                             
*  PROC FORMAT:  creates user-defined formats for the variables. Formats      
*  replace original value codes with value code descriptions. Not all         
*  variables necessarily have user-defined formats.                           
*                                                                             
*  DATA:  begins a SAS data step and names an output SAS data set.            
*                                                                             
*  INFILE:  identifies the input file to be read with the input statement.    
*  Users must replace the "physical-filename" with host computer specific     
*  input file specifications.                                                 
*                                                                             
*  INPUT:  assigns the name, type, decimal specification (if any) and         
*  identifies the beginning and ending column locations for each variable     
*  in the data file.                                                          
*                                                                             
*  LABEL: assigns  descriptive  labels to all variables.  Variable labels     
*  may be identical to variable names for some data files.                    
*                                                                             
*  MISSING VALUE RECODES:  sets user-defined numeric missing values to        
*  missing as interpreted by the SAS system. Only variables with              
*  user-defined missing values are included in the statements.                
*                                                                             
*  FORMAT:  associates the formats created by the PROC FORMAT step with       
*  the variables named in the INPUT statement.                                
*                                                                             
*  NOTE:  Users should modify these data definition statements to suit        
*  their specific needs. PROC FORMAT, FORMAT, and MISSING VALUE RECODES       
*  sections (when included) have been marked by SAS comment statements.       
*  To include these sections in a final SAS setup, users should remove        
*  the SAS comment statements from the desired section(s).                    
*                                                                             
*  These data definition statements have been tested for compatibility        
*  with SAS Release 8.1 for UNIX and/or SAS Release 7.00 for Windows.         
***************************************************************************** 
* SAS DATA, INFILE, INPUT STATEMENTS;                                         
*/                                                                            
                                                                              
DATA;                                                                         
INFILE "physical-filename" LRECL=3558;                                        
INPUT                                                                         
   ER10001 1 ER10002 2-6 ER10003 7-10 ER10004 11-12 ER10005 13-14 ER10006     
   15-16 ER10007 17-20 ER10008 21-22 ER10009 23-25 ER10010 26 ER10011 27-29   
   ER10012 30 ER10013 31-32 ER10014 33 ER10015 34 ER10016 35 ER10017 36       
   ER10018 37 ER10019 38 ER10020 39 ER10021 40 ER10022 41 ER10023 42 ER10024  
   43 ER10025 44 ER10026 45 ER10027 46 ER10028 47 ER10029 48-49 ER10030 50-51 
   ER10031 52-53 ER10032 54-55 ER10033 56 ER10034 57-60 ER10035 61 ER10036    
   62-68 ER10037 69-73 ER10038 74-77 ER10039 78 ER10040 79 ER10041 80 ER10042 
   81 ER10043 82 ER10044 83-89 ER10045 90-96 ER10046 97-101 ER10047 102-106   
   ER10048 107-110 .1 ER10049 111-112 ER10050 113-115 ER10051 116-118 ER10052 
   119-122 ER10053 123-126 ER10054 127-128 ER10055 129-130 ER10056 131 ER10057
   132 ER10058 133 ER10059 134 ER10060 135-139 ER10061 140 ER10062 141 ER10063
   142 ER10064 143 ER10065 144 ER10066 145-148 ER10067 149 ER10068 150 ER10069
   151 ER10070 152 ER10071 153 ER10072 154 ER10073 155-156 ER10074 157 ER10075
   158-159 ER10076 160 ER10077 161 ER10078 162 ER10079 163 ER10080 164 ER10081
   165-166 ER10082 167 ER10083 168 ER10084 169-172 ER10085 173 ER10086 174    
   ER10087 175 ER10088 176 ER10089 177 ER10090 178 ER10091 179 ER10092 180-188
   .2 ER10093 189 ER10094 190 ER10095 191 ER10096 192 ER10097 193 ER10098     
   194-199 .2 ER10099 200 ER10100 201 ER10101 202 ER10102 203-210 ER10103 211 
   ER10104 212-218 ER10105 219 ER10106 220 ER10107 221-229 .2 ER10108 230     
   ER10109 231 ER10110 232 ER10111 233 ER10112 234 ER10113 235 ER10114 236    
   ER10115 237 ER10116 238 ER10117 239-240 ER10118 241-242 ER10119 243-244    
   ER10120 245-246 ER10121 247-250 ER10122 251 ER10123 252-253 ER10124 254-257
   ER10125 258 ER10126 259 ER10127 260 ER10128 261-262 ER10129 263-266 ER10130
   267-268 ER10131 269-272 ER10132 273 ER10133 274-275 ER10134 276 ER10135    
   277-289 .2 ER10136 290 ER10137 291-293 ER10138 294 ER10139 295 ER10140 296 
   ER10141 297 ER10142 298 ER10143 299 ER10144 300 ER10145 301 ER10146 302    
   ER10147 303 ER10148 304 ER10149 305 ER10150 306 ER10151 307 ER10152 308    
   ER10153 309 ER10154 310 ER10155 311 ER10156 312 ER10157 313 ER10158 314    
   ER10159 315 ER10160 316 ER10161 317 ER10162 318 ER10163 319 ER10164 320    
   ER10165 321 ER10166 322-334 .2 ER10167 335 ER10168 336-338 ER10169 339     
   ER10170 340-341 ER10171 342 ER10172 343-344 ER10173 345-348 ER10174 349-361
   .2 ER10175 362 ER10176 363-367 .1 ER10177 368 ER10178 369-370 ER10179      
   371-374 ER10180 375-387 .2 ER10181 388 ER10182 389-391 ER10183 392 ER10184 
   393-395 ER10185 396 ER10186 397-398 ER10187 399 ER10188 400-404 .1 ER10189 
   405-406 ER10190 407-408 ER10191 409 ER10192 410-412 ER10193 413-414 ER10194
   415-416 ER10195 417 ER10196 418-419 ER10197 420 ER10198 421 ER10199 422    
   ER10200 423-425 ER10201 426-427 ER10202 428-429 ER10203 430 ER10204 431    
   ER10205 432 ER10206 433 ER10207 434 ER10208 435 ER10209 436 ER10210 437    
   ER10211 438 ER10212 439 ER10213 440 ER10214 441 ER10215 442 ER10216 443-445
   ER10217 446-447 ER10218 448-449 ER10219 450 ER10220 451 ER10221 452 ER10222
   453 ER10223 454 ER10224 455 ER10225 456 ER10226 457 ER10227 458 ER10228 459
   ER10229 460 ER10230 461 ER10231 462-463 ER10232 464-466 ER10233 467 ER10234
   468-471 ER10235 472 ER10236 473 ER10237 474-486 .2 ER10238 487 ER10239     
   488-489 ER10240 490-494 .1 ER10241 495-496 ER10242 497-500 ER10243 501     
   ER10244 502 ER10245 503 ER10246 504 ER10247 505 ER10248 506 ER10249 507    
   ER10250 508 ER10251 509 ER10252 510 ER10253 511 ER10254 512 ER10255 513    
   ER10256 514-515 ER10257 516-519 ER10258 520 ER10259 521 ER10260 522-534 .2 
   ER10261 535 ER10262 536-537 ER10263 538-540 ER10264 541-542 ER10265 543-546
   ER10266 547 ER10267 548 ER10268 549 ER10269 550 ER10270 551 ER10271 552    
   ER10272 553 ER10273 554 ER10274 555 ER10275 556 ER10276 557 ER10277 558    
   ER10278 559 ER10279 560-561 ER10280 562-565 ER10281 566 ER10282 567-576    
   ER10283 577 ER10284 578-579 ER10285 580-581 ER10286 582-583 ER10287 584-587
   ER10288 588 ER10289 589 ER10290 590 ER10291 591 ER10292 592 ER10293 593    
   ER10294 594 ER10295 595 ER10296 596 ER10297 597 ER10298 598 ER10299 599    
   ER10300 600 ER10301 601 ER10302 602-605 ER10303 606 ER10304 607-611 ER10305
   612 ER10306 613-614 ER10307 615-616 ER10308 617 ER10309 618-621 ER10310 622
   ER10311 623 ER10312 624 ER10313 625 ER10314 626 ER10315 627 ER10316 628    
   ER10317 629 ER10318 630 ER10319 631 ER10320 632 ER10321 633 ER10322 634    
   ER10323 635 ER10324 636 ER10325 637 ER10326 638 ER10327 639 ER10328 640    
   ER10329 641 ER10330 642 ER10331 643 ER10332 644 ER10333 645 ER10334 646-647
   ER10335 648-649 ER10336 650-651 ER10337 652 ER10338 653-654 ER10339 655-658
   ER10340 659 ER10341 660-661 ER10342 662 ER10343 663 ER10344 664 ER10345 665
   ER10346 666 ER10347 667 ER10348 668 ER10349 669 ER10350 670 ER10351 671    
   ER10352 672 ER10353 673 ER10354 674 ER10355 675 ER10356 676 ER10357 677-678
   ER10358 679-682 ER10359 683 ER10360 684-685 ER10361 686-689 ER10362 690    
   ER10363 691 ER10364 692 ER10365 693-694 ER10366 695-698 ER10367 699-700    
   ER10368 701-704 ER10369 705 ER10370 706 ER10371 707 ER10372 708-720 .2     
   ER10373 721 ER10374 722-723 ER10375 724 ER10376 725 ER10377 726 ER10378 727
   ER10379 728 ER10380 729 ER10381 730 ER10382 731 ER10383 732 ER10384 733    
   ER10385 734 ER10386 735 ER10387 736 ER10388 737 ER10389 738 ER10390 739    
   ER10391 740 ER10392 741 ER10393 742 ER10394 743 ER10395 744 ER10396 745    
   ER10397 746 ER10398 747 ER10399 748 ER10400 749 ER10401 750 ER10402 751    
   ER10403 752-764 .2 ER10404 765 ER10405 766-769 .1 ER10406 770 ER10407 771  
   ER10408 772 ER10409 773-774 ER10410 775-778 ER10411 779-791 .2 ER10412 792 
   ER10413 793-794 ER10414 795 ER10415 796-797 ER10416 798-801 ER10417 802    
   ER10418 803 ER10419 804-816 .2 ER10420 817 ER10421 818-820 ER10422 821     
   ER10423 822-824 ER10424 825 ER10425 826 ER10426 827 ER10427 828-830 ER10428
   831-832 ER10429 833-834 ER10430 835 ER10431 836-837 ER10432 838 ER10433    
   839-840 ER10434 841 ER10435 842 ER10436 843 ER10437 844 ER10438 845 ER10439
   846-848 ER10440 849-850 ER10441 851-852 ER10442 853 ER10443 854 ER10444 855
   ER10445 856 ER10446 857 ER10447 858 ER10448 859 ER10449 860 ER10450 861    
   ER10451 862 ER10452 863 ER10453 864 ER10454 865 ER10455 866-868 ER10456    
   869-870 ER10457 871-872 ER10458 873 ER10459 874 ER10460 875 ER10461 876    
   ER10462 877 ER10463 878 ER10464 879 ER10465 880 ER10466 881 ER10467 882    
   ER10468 883 ER10469 884 ER10470 885-886 ER10471 887-889 ER10472 890 ER10473
   891-894 ER10474 895 ER10475 896 ER10476 897-909 .2 ER10477 910 ER10478     
   911-912 ER10479 913-915 ER10480 916-917 ER10481 918-921 ER10482 922 ER10483
   923 ER10484 924 ER10485 925 ER10486 926 ER10487 927 ER10488 928 ER10489 929
   ER10490 930 ER10491 931 ER10492 932 ER10493 933 ER10494 934 ER10495 935    
   ER10496 936-939 ER10497 940 ER10498 941-943 ER10499 944 ER10500 945 ER10501
   946-947 ER10502 948-949 ER10503 950-953 ER10504 954 ER10505 955 ER10506 956
   ER10507 957 ER10508 958 ER10509 959 ER10510 960 ER10511 961 ER10512 962    
   ER10513 963 ER10514 964 ER10515 965 ER10516 966 ER10517 967-968 ER10518    
   969-972 ER10519 973 ER10520 974 ER10521 975 ER10522 976 ER10523 977 ER10524
   978 ER10525 979 ER10526 980 ER10527 981 ER10528 982 ER10529 983 ER10530 984
   ER10531 985 ER10532 986 ER10533 987 ER10534 988 ER10535 989 ER10536 990    
   ER10537 991 ER10538 992 ER10539 993 ER10540 994 ER10541 995 ER10542 996    
   ER10543 997 ER10544 998 ER10545 999 ER10546 1000 ER10547 1001 ER10548 1002 
   ER10549 1003 ER10550 1004 ER10551 1005 ER10552 1006 ER10553 1007 ER10554   
   1008 ER10555 1009 ER10556 1010 ER10557 1011 ER10558 1012 ER10559 1013      
   ER10560 1014 ER10561 1015 ER10562 1016 ER10563 1017-1018 ER10564 1019      
   ER10565 1020 ER10566 1021-1024 ER10567 1025 ER10568 1026 ER10569 1027      
   ER10570 1028 ER10571 1029 ER10572 1030 ER10573 1031 ER10574 1032-1040 .2   
   ER10575 1041 ER10576 1042 ER10577 1043 ER10578 1044 ER10579 1045 ER10580   
   1046-1051 .2 ER10581 1052 ER10582 1053 ER10583 1054 ER10584 1055-1062      
   ER10585 1063 ER10586 1064-1070 ER10587 1071 ER10588 1072 ER10589 1073-1081 
   .2 ER10590 1082 ER10591 1083 ER10592 1084 ER10593 1085 ER10594 1086 ER10595
   1087 ER10596 1088 ER10597 1089 ER10598 1090 ER10599 1091-1092 ER10600      
   1093-1094 ER10601 1095-1096 ER10602 1097-1098 ER10603 1099-1102 ER10604    
   1103 ER10605 1104-1105 ER10606 1106-1109 ER10607 1110 ER10608 1111-1112    
   ER10609 1113 ER10610 1114-1115 ER10611 1116-1119 ER10612 1120-1121 ER10613 
   1122-1125 ER10614 1126 ER10615 1127-1128 ER10616 1129 ER10617 1130-1142 .2 
   ER10618 1143 ER10619 1144-1148 .1 ER10620 1149 ER10621 1150 ER10622 1151   
   ER10623 1152 ER10624 1153 ER10625 1154 ER10626 1155 ER10627 1156 ER10628   
   1157 ER10629 1158 ER10630 1159 ER10631 1160 ER10632 1161 ER10633 1162      
   ER10634 1163 ER10635 1164 ER10636 1165 ER10637 1166 ER10638 1167 ER10639   
   1168 ER10640 1169 ER10641 1170 ER10642 1171 ER10643 1172 ER10644 1173      
   ER10645 1174 ER10646 1175 ER10647 1176 ER10648 1177-1189 .2 ER10649 1190   
   ER10650 1191-1193 ER10651 1194 ER10652 1195-1196 ER10653 1197 ER10654      
   1198-1199 ER10655 1200-1203 ER10656 1204-1216 .2 ER10657 1217 ER10658      
   1218-1220 ER10659 1221 ER10660 1222-1223 ER10661 1224-1227 ER10662         
   1228-1240 .2 ER10663 1241 ER10664 1242-1244 ER10665 1245 ER10666 1246-1248 
   ER10667 1249-1250 ER10668 1251 ER10669 1252 ER10670 1253-1257 .1 ER10671   
   1258-1259 ER10672 1260-1261 ER10673 1262 ER10674 1263-1265 ER10675         
   1266-1267 ER10676 1268-1269 ER10677 1270 ER10678 1271 ER10679 1272 ER10680 
   1273 ER10681 1274 ER10682 1275-1276 ER10683 1277-1278 ER10684 1279-1280    
   ER10685 1281 ER10686 1282 ER10687 1283 ER10688 1284 ER10689 1285 ER10690   
   1286 ER10691 1287 ER10692 1288 ER10693 1289 ER10694 1290 ER10695 1291      
   ER10696 1292 ER10697 1293 ER10698 1294-1296 ER10699 1297-1298 ER10700      
   1299-1300 ER10701 1301 ER10702 1302 ER10703 1303 ER10704 1304 ER10705 1305 
   ER10706 1306 ER10707 1307 ER10708 1308 ER10709 1309 ER10710 1310 ER10711   
   1311 ER10712 1312 ER10713 1313-1314 ER10714 1315-1319 .1 ER10715 1320      
   ER10716 1321-1326 .1 ER10717 1327 ER10718 1328 ER10719 1329-1341 .2 ER10720
   1342 ER10721 1343-1344 ER10722 1345-1349 .1 ER10723 1350-1351 ER10724      
   1352-1355 ER10725 1356 ER10726 1357 ER10727 1358 ER10728 1359 ER10729 1360 
   ER10730 1361 ER10731 1362 ER10732 1363 ER10733 1364 ER10734 1365 ER10735   
   1366 ER10736 1367 ER10737 1368 ER10738 1369-1370 ER10739 1371-1374 ER10740 
   1375 ER10741 1376 ER10742 1377-1389 .2 ER10743 1390 ER10744 1391-1392      
   ER10745 1393-1394 ER10746 1395-1396 ER10747 1397-1400 ER10748 1401 ER10749 
   1402 ER10750 1403 ER10751 1404 ER10752 1405 ER10753 1406 ER10754 1407      
   ER10755 1408 ER10756 1409 ER10757 1410 ER10758 1411 ER10759 1412 ER10760   
   1413 ER10761 1414 ER10762 1415-1418 ER10763 1419 ER10764 1420-1429 ER10765 
   1430 ER10766 1431 ER10767 1432-1433 ER10768 1434-1435 ER10769 1436-1439    
   ER10770 1440 ER10771 1441 ER10772 1442 ER10773 1443 ER10774 1444 ER10775   
   1445 ER10776 1446 ER10777 1447 ER10778 1448 ER10779 1449 ER10780 1450      
   ER10781 1451 ER10782 1452 ER10783 1453 ER10784 1454 ER10785 1455 ER10786   
   1456 ER10787 1457 ER10788 1458 ER10789 1459 ER10790 1460 ER10791 1461      
   ER10792 1462 ER10793 1463 ER10794 1464 ER10795 1465 ER10796 1466 ER10797   
   1467 ER10798 1468 ER10799 1469 ER10800 1470 ER10801 1471 ER10802 1472      
   ER10803 1473 ER10804 1474 ER10805 1475 ER10806 1476 ER10807 1477 ER10808   
   1478 ER10809 1479 ER10810 1480 ER10811 1481 ER10812 1482 ER10813 1483      
   ER10814 1484 ER10815 1485 ER10816 1486 ER10817 1487-1488 ER10818 1489      
   ER10819 1490 ER10820 1491-1492 ER10821 1493-1496 ER10822 1497 ER10823      
   1498-1499 ER10824 1500 ER10825 1501 ER10826 1502 ER10827 1503 ER10828 1504 
   ER10829 1505 ER10830 1506 ER10831 1507 ER10832 1508 ER10833 1509 ER10834   
   1510 ER10835 1511 ER10836 1512 ER10837 1513 ER10838 1514 ER10839 1515-1516 
   ER10840 1517-1520 ER10841 1521 ER10842 1522 ER10843 1523-1526 ER10844 1527 
   ER10845 1528 ER10846 1529 ER10847 1530-1531 ER10848 1532-1535 ER10849      
   1536-1537 ER10850 1538-1541 ER10851 1542 ER10852 1543 ER10853 1544 ER10854 
   1545-1557 .2 ER10855 1558 ER10856 1559-1560 ER10857 1561 ER10858 1562      
   ER10859 1563 ER10860 1564 ER10861 1565 ER10862 1566 ER10863 1567 ER10864   
   1568 ER10865 1569 ER10866 1570 ER10867 1571 ER10868 1572 ER10869 1573      
   ER10870 1574 ER10871 1575 ER10872 1576 ER10873 1577 ER10874 1578 ER10875   
   1579 ER10876 1580 ER10877 1581 ER10878 1582 ER10879 1583 ER10880 1584      
   ER10881 1585 ER10882 1586 ER10883 1587 ER10884 1588 ER10885 1589-1596 .2   
   ER10886 1597 ER10887 1598-1599 ER10888 1600 ER10889 1601 ER10890 1602      
   ER10891 1603-1604 ER10892 1605-1608 ER10893 1609-1621 .2 ER10894 1622      
   ER10895 1623-1625 ER10896 1626 ER10897 1627-1628 ER10898 1629-1632 ER10899 
   1633 ER10900 1634 ER10901 1635-1642 .2 ER10902 1643 ER10903 1644-1646      
   ER10904 1647 ER10905 1648-1650 ER10906 1651-1652 ER10907 1653 ER10908 1654 
   ER10909 1655-1656 ER10910 1657-1658 ER10911 1659-1660 ER10912 1661 ER10913 
   1662-1663 ER10914 1664-1665 ER10915 1666-1667 ER10916 1668 ER10917 1669    
   ER10918 1670 ER10919 1671 ER10920 1672 ER10921 1673 ER10922 1674-1675      
   ER10923 1676-1677 ER10924 1678 ER10925 1679 ER10926 1680 ER10927 1681      
   ER10928 1682 ER10929 1683 ER10930 1684 ER10931 1685 ER10932 1686 ER10933   
   1687 ER10934 1688 ER10935 1689 ER10936 1690 ER10937 1691-1693 ER10938      
   1694-1695 ER10939 1696-1697 ER10940 1698 ER10941 1699 ER10942 1700 ER10943 
   1701 ER10944 1702 ER10945 1703 ER10946 1704 ER10947 1705 ER10948 1706      
   ER10949 1707 ER10950 1708 ER10951 1709 ER10952 1710-1711 ER10953 1712-1714 
   ER10954 1715 ER10955 1716-1719 ER10956 1720 ER10957 1721 ER10958 1722-1734 
   .2 ER10959 1735 ER10960 1736-1737 ER10961 1738-1739 ER10962 1740-1741      
   ER10963 1742-1745 ER10964 1746 ER10965 1747 ER10966 1748 ER10967 1749      
   ER10968 1750 ER10969 1751 ER10970 1752 ER10971 1753 ER10972 1754 ER10973   
   1755 ER10974 1756 ER10975 1757 ER10976 1758 ER10977 1759-1760 ER10978      
   1761-1764 ER10979 1765 ER10980 1766 ER10981 1767 ER10982 1768 ER10983 1769 
   ER10984 1770 ER10985 1771 ER10986 1772 ER10987 1773 ER10988 1774 ER10989   
   1775 ER10990 1776 ER10991 1777 ER10992 1778 ER10993 1779 ER10994 1780      
   ER10995 1781 ER10996 1782 ER10997 1783 ER10998 1784 ER10999 1785 ER11000   
   1786 ER11001 1787 ER11002 1788 ER11003 1789 ER11004 1790 ER11005 1791      
   ER11006 1792 ER11007 1793 ER11008 1794 ER11009 1795 ER11010 1796 ER11011   
   1797 ER11012 1798 ER11013 1799 ER11014 1800 ER11015 1801 ER11016 1802      
   ER11017 1803 ER11018 1804 ER11019 1805 ER11020 1806 ER11021 1807 ER11022   
   1808 ER11023 1809 ER11024 1810 ER11025 1811 ER11026 1812 ER11027 1813      
   ER11028 1814 ER11029 1815 ER11030 1816 ER11031 1817 ER11032 1818 ER11033   
   1819 ER11034 1820 ER11035 1821 ER11036 1822 ER11037 1823 ER11038 1824      
   ER11039 1825 ER11040 1826 ER11041 1827 ER11042 1828 ER11043 1829 ER11044   
   1830 ER11045 1831-1833 ER11046 1834-1839 .2 ER11047 1840 ER11048 1841-1845 
   ER11049 1846 ER11050 1847-1851 ER11051 1852 ER11052 1853 ER11053 1854      
   ER11054 1855 ER11055 1856 ER11056 1857 ER11057 1858 ER11058 1859 ER11059   
   1860 ER11060 1861 ER11061 1862 ER11062 1863 ER11063 1864 ER11064 1865      
   ER11065 1866 ER11066 1867-1869 ER11067 1870 ER11068 1871-1878 ER11069 1879 
   ER11070 1880 ER11071 1881-1888 ER11072 1889 ER11073 1890-1900 .2 ER11074   
   1901 ER11075 1902 ER11076 1903-1913 .2 ER11077 1914 ER11078 1915 ER11079   
   1916-1926 .2 ER11080 1927 ER11081 1928-1938 .2 ER11082 1939 ER11083 1940   
   ER11084 1941 ER11085 1942-1948 ER11086 1949-1955 ER11087 1956-1962 ER11088 
   1963 ER11089 1964 ER11090 1965 ER11091 1966 ER11092 1967 ER11093 1968      
   ER11094 1969 ER11095 1970 ER11096 1971 ER11097 1972 ER11098 1973 ER11099   
   1974-1980 ER11100 1981-1987 ER11101 1988 ER11102 1989 ER11103 1990 ER11104 
   1991 ER11105 1992 ER11106 1993 ER11107 1994 ER11108 1995 ER11109 1996      
   ER11110 1997 ER11111 1998-2004 ER11112 2005-2011 ER11113 2012 ER11114 2013 
   ER11115 2014 ER11116 2015 ER11117 2016 ER11118 2017 ER11119 2018 ER11120   
   2019 ER11121 2020 ER11122 2021 ER11123 2022-2028 ER11124 2029-2033 ER11125 
   2034 ER11126 2035 ER11127 2036 ER11128 2037 ER11129 2038 ER11130 2039      
   ER11131 2040 ER11132 2041 ER11133 2042 ER11134 2043 ER11135 2044-2048      
   ER11136 2049-2052 ER11137 2053 ER11138 2054 ER11139 2055 ER11140 2056      
   ER11141 2057 ER11142 2058 ER11143 2059 ER11144 2060 ER11145 2061 ER11146   
   2062 ER11147 2063 ER11148 2064 ER11149 2065 ER11150 2066-2072 ER11151 2073 
   ER11152 2074 ER11153 2075 ER11154 2076 ER11155 2077 ER11156 2078 ER11157   
   2079-2084 ER11158 2085-2090 ER11159 2091-2096 ER11160 2097-2102 ER11161    
   2103-2108 ER11162 2109 ER11163 2110-2116 ER11164 2117 ER11165 2118 ER11166 
   2119 ER11167 2120 ER11168 2121 ER11169 2122 ER11170 2123 ER11171 2124      
   ER11172 2125 ER11173 2126 ER11174 2127 ER11175 2128 ER11176 2129 ER11177   
   2130 ER11178 2131 ER11179 2132-2138 ER11180 2139 ER11181 2140 ER11182 2141 
   ER11183 2142 ER11184 2143 ER11185 2144 ER11186 2145 ER11187 2146 ER11188   
   2147 ER11189 2148 ER11190 2149 ER11191 2150 ER11192 2151 ER11193 2152      
   ER11194 2153 ER11195 2154-2160 ER11196 2161 ER11197 2162 ER11198 2163      
   ER11199 2164 ER11200 2165 ER11201 2166 ER11202 2167 ER11203 2168 ER11204   
   2169 ER11205 2170 ER11206 2171 ER11207 2172 ER11208 2173 ER11209 2174      
   ER11210 2175 ER11211 2176-2182 ER11212 2183 ER11213 2184-2189 ER11214 2190 
   ER11215 2191 ER11216 2192 ER11217 2193 ER11218 2194 ER11219 2195 ER11220   
   2196 ER11221 2197 ER11222 2198 ER11223 2199 ER11224 2200 ER11225 2201      
   ER11226 2202 ER11227 2203 ER11228 2204-2209 ER11229 2210 ER11230 2211      
   ER11231 2212 ER11232 2213 ER11233 2214 ER11234 2215 ER11235 2216 ER11236   
   2217 ER11237 2218 ER11238 2219 ER11239 2220 ER11240 2221 ER11241 2222      
   ER11242 2223 ER11243 2224-2229 ER11244 2230 ER11245 2231 ER11246 2232      
   ER11247 2233 ER11248 2234 ER11249 2235 ER11250 2236 ER11251 2237 ER11252   
   2238 ER11253 2239 ER11254 2240 ER11255 2241 ER11256 2242 ER11257 2243      
   ER11258 2244-2249 ER11259 2250 ER11260 2251 ER11261 2252 ER11262 2253      
   ER11263 2254 ER11264 2255 ER11265 2256 ER11266 2257 ER11267 2258 ER11268   
   2259 ER11269 2260 ER11270 2261 ER11271 2262 ER11272 2263 ER11273 2264-2269 
   ER11274 2270 ER11275 2271 ER11276 2272 ER11277 2273 ER11278 2274 ER11279   
   2275 ER11280 2276 ER11281 2277 ER11282 2278 ER11283 2279 ER11284 2280      
   ER11285 2281 ER11286 2282 ER11287 2283 ER11288 2284 ER11289 2285-2290      
   ER11290 2291 ER11291 2292 ER11292 2293 ER11293 2294 ER11294 2295 ER11295   
   2296 ER11296 2297 ER11297 2298 ER11298 2299 ER11299 2300 ER11300 2301      
   ER11301 2302 ER11302 2303 ER11303 2304 ER11304 2305-2310 ER11305 2311      
   ER11306 2312 ER11307 2313 ER11308 2314 ER11309 2315 ER11310 2316 ER11311   
   2317 ER11312 2318 ER11313 2319 ER11314 2320 ER11315 2321 ER11316 2322      
   ER11317 2323 ER11318 2324 ER11319 2325 ER11320 2326 ER11321 2327 ER11322   
   2328-2332 ER11323 2333 ER11324 2334 ER11325 2335 ER11326 2336 ER11327 2337 
   ER11328 2338 ER11329 2339 ER11330 2340 ER11331 2341 ER11332 2342 ER11333   
   2343 ER11334 2344 ER11335 2345 ER11336 2346 ER11337 2347-2352 ER11338 2353 
   ER11339 2354 ER11340 2355 ER11341 2356 ER11342 2357 ER11343 2358 ER11344   
   2359 ER11345 2360 ER11346 2361 ER11347 2362 ER11348 2363 ER11349 2364      
   ER11350 2365 ER11351 2366 ER11352 2367-2372 ER11353 2373 ER11354 2374      
   ER11355 2375 ER11356 2376 ER11357 2377 ER11358 2378 ER11359 2379 ER11360   
   2380 ER11361 2381 ER11362 2382 ER11363 2383 ER11364 2384 ER11365 2385      
   ER11366 2386 ER11367 2387-2391 ER11368 2392 ER11369 2393 ER11370 2394      
   ER11371 2395 ER11372 2396 ER11373 2397 ER11374 2398 ER11375 2399 ER11376   
   2400 ER11377 2401 ER11378 2402 ER11379 2403 ER11380 2404 ER11381 2405      
   ER11382 2406 ER11383 2407-2411 ER11384 2412 ER11385 2413 ER11386 2414      
   ER11387 2415 ER11388 2416 ER11389 2417 ER11390 2418 ER11391 2419 ER11392   
   2420 ER11393 2421 ER11394 2422 ER11395 2423 ER11396 2424 ER11397 2425      
   ER11398 2426-2430 ER11399 2431 ER11400 2432 ER11401 2433 ER11402 2434      
   ER11403 2435 ER11404 2436 ER11405 2437 ER11406 2438 ER11407 2439 ER11408   
   2440 ER11409 2441 ER11410 2442 ER11411 2443 ER11412 2444 ER11413 2445-2449 
   ER11414 2450 ER11415 2451 ER11416 2452 ER11417 2453 ER11418 2454 ER11419   
   2455 ER11420 2456 ER11421 2457 ER11422 2458 ER11423 2459 ER11424 2460      
   ER11425 2461 ER11426 2462 ER11427 2463 ER11428 2464-2468 ER11429 2469      
   ER11430 2470 ER11431 2471 ER11432 2472 ER11433 2473 ER11434 2474 ER11435   
   2475 ER11436 2476 ER11437 2477 ER11438 2478 ER11439 2479 ER11440 2480      
   ER11441 2481 ER11442 2482 ER11443 2483-2487 ER11444 2488 ER11445 2489      
   ER11446 2490 ER11447 2491 ER11448 2492 ER11449 2493 ER11450 2494 ER11451   
   2495 ER11452 2496 ER11453 2497 ER11454 2498 ER11455 2499 ER11456 2500      
   ER11457 2501 ER11458 2502-2506 ER11459 2507 ER11460 2508 ER11461 2509      
   ER11462 2510 ER11463 2511 ER11464 2512 ER11465 2513 ER11466 2514 ER11467   
   2515 ER11468 2516 ER11469 2517 ER11470 2518 ER11471 2519 ER11472 2520      
   ER11473 2521-2525 ER11474 2526 ER11475 2527 ER11476 2528 ER11477 2529      
   ER11478 2530 ER11479 2531 ER11480 2532 ER11481 2533 ER11482 2534 ER11483   
   2535 ER11484 2536 ER11485 2537 ER11486 2538 ER11487 2539 ER11488 2540      
   ER11489 2541 ER11490 2542 ER11491 2543-2549 ER11492 2550 ER11493 2551      
   ER11494 2552-2556 ER11495 2557 ER11496 2558 ER11497 2559 ER11498 2560      
   ER11499 2561 ER11500 2562 ER11501 2563 ER11502 2564 ER11503 2565 ER11504   
   2566 ER11505 2567 ER11506 2568 ER11507 2569 ER11508 2570 ER11509 2571-2575 
   ER11510 2576 ER11511 2577 ER11512 2578 ER11513 2579 ER11514 2580 ER11515   
   2581 ER11516 2582 ER11517 2583 ER11518 2584 ER11519 2585 ER11520 2586      
   ER11521 2587 ER11522 2588 ER11523 2589 ER11524 2590-2595 ER11525 2596      
   ER11526 2597 ER11527 2598 ER11528 2599 ER11529 2600 ER11530 2601 ER11531   
   2602 ER11532 2603 ER11533 2604 ER11534 2605 ER11535 2606 ER11536 2607      
   ER11537 2608 ER11538 2609 ER11539 2610-2615 ER11540 2616 ER11541 2617      
   ER11542 2618 ER11543 2619 ER11544 2620 ER11545 2621 ER11546 2622 ER11547   
   2623 ER11548 2624 ER11549 2625 ER11550 2626 ER11551 2627 ER11552 2628      
   ER11553 2629 ER11554 2630-2635 ER11555 2636 ER11556 2637 ER11557 2638      
   ER11558 2639 ER11559 2640 ER11560 2641 ER11561 2642 ER11562 2643 ER11563   
   2644 ER11564 2645 ER11565 2646 ER11566 2647 ER11567 2648 ER11568 2649      
   ER11569 2650-2655 ER11570 2656 ER11571 2657 ER11572 2658 ER11573 2659      
   ER11574 2660 ER11575 2661 ER11576 2662 ER11577 2663 ER11578 2664 ER11579   
   2665 ER11580 2666 ER11581 2667 ER11582 2668 ER11583 2669 ER11584 2670      
   ER11585 2671-2675 ER11586 2676 ER11587 2677 ER11588 2678 ER11589 2679      
   ER11590 2680 ER11591 2681 ER11592 2682 ER11593 2683 ER11594 2684 ER11595   
   2685 ER11596 2686 ER11597 2687 ER11598 2688 ER11599 2689 ER11600 2690-2693 
   ER11601 2694 ER11602 2695 ER11603 2696 ER11604 2697 ER11605 2698 ER11606   
   2699 ER11607 2700 ER11608 2701 ER11609 2702 ER11610 2703 ER11611 2704      
   ER11612 2705 ER11613 2706 ER11614 2707 ER11615 2708-2712 ER11616 2713      
   ER11617 2714 ER11618 2715 ER11619 2716 ER11620 2717 ER11621 2718 ER11622   
   2719 ER11623 2720 ER11624 2721 ER11625 2722 ER11626 2723 ER11627 2724      
   ER11628 2725 ER11629 2726 ER11630 2727-2731 ER11631 2732 ER11632 2733      
   ER11633 2734 ER11634 2735 ER11635 2736 ER11636 2737 ER11637 2738 ER11638   
   2739 ER11639 2740 ER11640 2741 ER11641 2742 ER11642 2743 ER11643 2744      
   ER11644 2745 ER11645 2746-2750 ER11646 2751 ER11647 2752 ER11648 2753      
   ER11649 2754 ER11650 2755 ER11651 2756 ER11652 2757 ER11653 2758 ER11654   
   2759 ER11655 2760 ER11656 2761 ER11657 2762 ER11658 2763 ER11659 2764      
   ER11660 2765-2769 ER11661 2770 ER11662 2771 ER11663 2772 ER11664 2773      
   ER11665 2774 ER11666 2775 ER11667 2776 ER11668 2777 ER11669 2778 ER11670   
   2779 ER11671 2780 ER11672 2781 ER11673 2782 ER11674 2783 ER11675 2784-2787 
   ER11676 2788 ER11677 2789 ER11678 2790 ER11679 2791 ER11680 2792 ER11681   
   2793 ER11682 2794 ER11683 2795 ER11684 2796 ER11685 2797 ER11686 2798      
   ER11687 2799 ER11688 2800 ER11689 2801 ER11690 2802-2806 ER11691 2807      
   ER11692 2808 ER11693 2809 ER11694 2810 ER11695 2811 ER11696 2812 ER11697   
   2813 ER11698 2814 ER11699 2815 ER11700 2816 ER11701 2817 ER11702 2818      
   ER11703 2819 ER11704 2820 ER11705 2821-2827 ER11706 2828-2834 ER11707 2835 
   ER11708 2836 ER11709 2837 ER11710 2838-2839 ER11711 2840-2841 ER11712      
   2842-2843 ER11713 2844-2845 ER11714 2846-2847 ER11715 2848-2854 ER11716    
   2855 ER11717 2856-2862 ER11718 2863 ER11719 2864-2870 ER11720 2871 ER11721 
   2872-2873 ER11722 2874 ER11723 2875 ER11724 2876 ER11725 2877 ER11726 2878 
   ER11727 2879 ER11728 2880 ER11729 2881 ER11730 2882 ER11731 2883 ER11732   
   2884-2885 ER11733 2886-2887 ER11734 2888 ER11735 2889-2890 ER11736 2891    
   ER11737 2892 ER11738 2893-2894 ER11739 2895 ER11740 2896-2897 ER11741      
   2898-2899 ER11742 2900 ER11743 2901-2902 ER11744 2903 ER11745 2904 ER11746 
   2905-2906 ER11747 2907 ER11748 2908 ER11749 2909-2910 ER11750 2911 ER11751 
   2912 ER11752 2913-2914 ER11753 2915 ER11754 2916 ER11755 2917-2918 ER11756 
   2919 ER11757 2920 ER11758 2921-2922 ER11759 2923 ER11760 2924 ER11761 2925 
   ER11762 2926 ER11763 2927 ER11764 2928 ER11765 2929 ER11766 2930 ER11767   
   2931-2932 ER11768 2933-2936 ER11769 2937-2938 ER11770 2939-2940 ER11771    
   2941-2944 ER11772 2945-2946 ER11773 2947-2950 ER11774 2951-2952 ER11775    
   2953-2954 ER11776 2955-2958 ER11777 2959 ER11778 2960-2961 ER11779         
   2962-2965 ER11780 2966 ER11781 2967 ER11782 2968-2969 ER11783 2970-2971    
   ER11784 2972-2975 ER11785 2976 ER11786 2977-2978 ER11787 2979 ER11788 2980 
   ER11789 2981 ER11790 2982 ER11791 2983-2984 ER11792 2985-2986 ER11793      
   2987-2990 ER11794 2991 ER11795 2992 ER11796 2993 ER11797 2994-2995 ER11798 
   2996-2997 ER11799 2998-3001 ER11800 3002 ER11801 3003 ER11802 3004 ER11803 
   3005 ER11804 3006-3007 ER11805 3008-3011 ER11806 3012 ER11807 3013-3014    
   ER11808 3015-3016 ER11809 3017-3018 ER11810 3019-3020 ER11811 3021 ER11812 
   3022 ER11813 3023-3024 ER11814 3025-3026 ER11815 3027 ER11816 3028-3029    
   ER11817 3030 ER11818 3031 ER11819 3032-3033 ER11820 3034 ER11821 3035-3037 
   ER11822 3038-3039 ER11823 3040 ER11824 3041-3042 ER11825 3043 ER11826 3044 
   ER11827 3045-3046 ER11828 3047 ER11829 3048 ER11830 3049-3050 ER11831 3051 
   ER11832 3052 ER11833 3053-3054 ER11834 3055 ER11835 3056 ER11836 3057-3058 
   ER11837 3059 ER11838 3060 ER11839 3061-3062 ER11840 3063 ER11841 3064      
   ER11842 3065-3066 ER11843 3067 ER11844 3068 ER11845 3069 ER11846 3070      
   ER11847 3071 ER11848 3072 ER11849 3073 ER11850 3074 ER11851 3075 ER11852   
   3076 ER11853 3077 ER11854 3078 ER11855 3079-3080 ER11856 3081-3084 ER11857 
   3085-3086 ER11858 3087-3088 ER11859 3089-3092 ER11860 3093-3094 ER11861    
   3095-3098 ER11862 3099-3100 ER11863 3101-3102 ER11864 3103-3106 ER11865    
   3107 ER11866 3108-3109 ER11867 3110-3113 ER11868 3114 ER11869 3115 ER11870 
   3116-3117 ER11871 3118-3119 ER11872 3120-3123 ER11873 3124 ER11874         
   3125-3126 ER11875 3127 ER11876 3128 ER11877 3129 ER11878 3130 ER11879      
   3131-3132 ER11880 3133-3134 ER11881 3135-3138 ER11882 3139 ER11883 3140    
   ER11884 3141 ER11885 3142-3143 ER11886 3144-3145 ER11887 3146-3149 ER11888 
   3150 ER11889 3151 ER11890 3152 ER11891 3153 ER11892 3154 ER11893 3155-3158 
   ER11894 3159 ER11895 3160-3161 ER11896 3162-3163 ER11897 3164-3165 ER11898 
   3166-3167 ER11899 3168 ER11900 3169 ER11901 3170 ER11902 3171 ER11903      
   3172-3173 ER11904 3174-3177 ER11905 3178-3179 ER11906 3180-3183 ER11907    
   3184 ER11908 3185 ER11909 3186-3188 ER11910 3189-3197 .2 ER11911 3198      
   ER11912 3199 ER11913 3200 ER11914 3201 ER11915 3202 ER11916 3203 ER11917   
   3204-3205 ER11918 3206-3207 ER11919 3208-3211 ER11920 3212-3213 ER11921    
   3214-3217 ER11922 3218 ER11923 3219-3221 ER11924 3222-3230 .2 ER11925 3231 
   ER11926 3232 ER11927 3233 ER11928 3234 ER11929 3235-3236 ER11930 3237      
   ER11931 3238 ER11932 3239-3240 ER11933 3241-3242 ER11934 3243 ER11935 3244 
   ER11936 3245 ER11937 3246-3248 ER11938 3249 ER11939 3250 ER11940 3251      
   ER11941 3252 ER11942 3253 ER11943 3254 ER11944 3255 ER11945 3256 ER11946   
   3257 ER11947 3258 ER11948 3259 ER11949 3260 ER11950 3261 ER11951 3262      
   ER11952 3263 ER11953 3264-3265 ER11954 3266-3267 ER11955 3268-3271 ER11956 
   3272-3273 ER11957 3274 ER11958 3275 ER11959 3276 ER11960 3277-3278 ER11961 
   3279-3282 ER11962 3283-3284 ER11963 3285-3286 ER11964 3287-3288 ER11965    
   3289-3290 ER11966 3291-3292 ER11967 3293-3294 ER11968 3295-3296 ER11969    
   3297 ER11970 3298 ER11971 3299-3300 ER11972 3301 ER11973 3302-3305 ER11974 
   3306 ER11975 3307 ER11976 3308-3309 ER11977 3310-3311 ER11978 3312 ER11979 
   3313-3314 ER11980 3315-3316 ER11981 3317-3320 ER11982 3321 ER11983 3322    
   ER11984 3323 ER11985 3324-3325 ER11986 3326-3329 ER11987 3330-3331 ER11988 
   3332-3335 ER11989 3336 ER11990 3337 ER11991 3338-3340 ER11992 3341-3346    
   ER11993 3347 ER11994 3348 ER11995 3349 ER11996 3350 ER11997 3351 ER11998   
   3352 ER11999 3353-3354 ER12000 3355-3356 ER12001 3357-3360 ER12002         
   3361-3362 ER12003 3363-3366 ER12004 3367 ER12005 3368-3370 ER12006         
   3371-3379 .2 ER12007 3380 ER12008 3381 ER12009 3382 ER12010 3383 ER12011   
   3384-3385 ER12012 3386 ER12013 3387 ER12014 3388-3389 ER12015 3390-3391    
   ER12016 3392 ER12017 3393 ER12018 3394 ER12019 3395-3397 ER12020 3398      
   ER12021 3399 ER12022 3400 ER12023 3401 ER12024 3402 ER12025 3403 ER12026   
   3404 ER12027 3405 ER12028 3406 ER12029 3407 ER12030 3408 ER12031 3409      
   ER12032 3410 ER12033 3411 ER12034 3412 ER12035 3413-3414 ER12036 3415-3416 
   ER12037 3417-3420 ER12038 3421-3422 ER12039 3423 ER12040 3424 ER12041 3425 
   ER12042 3426-3427 ER12043 3428-3431 ER12044 3432-3433 ER12045 3434-3435    
   ER12046 3436 ER12047 3437 ER12048 3438 ER12049 3439-3440 ER12050 3441-3442 
   ER12051 3443 ER12052 3444 ER12053 3445-3446 ER12054 3447 ER12055 3448-3451 
   ER12056 3452 ER12057 3453 ER12058 3454-3455 ER12059 3456-3457 ER12060 3458 
   ER12061 3459-3460 ER12062 3461-3462 ER12063 3463-3466 ER12064 3467 ER12065 
   3468-3473 ER12066 3474 ER12067 3475-3480 ER12068 3481 ER12069 3482-3491 .3 
   ER12070 3492-3493 ER12071 3494-3503 .3 ER12072 3504 ER12073 3505-3510      
   ER12074 3511 ER12075 3512-3516 ER12076 3517 ER12077 3518-3523 ER12078 3524 
   ER12079 3525-3534 .3 ER12080 3535-3544 .3 ER12081 3545 ER12082 3546-3551   
   ER12083 3552 ER12084 3553-3558 .3;                                         
                                                                              
* Assign variable labels;                                                     
                                                                              
LABEL                                                                         
   ER10001="RELEASE NUMBER"                                                   
   ER10002="1997 INTERVIEW #"                                                 
   ER10003="INTERVIEWER ID"                                                   
   ER10004="CURRENT STATE"                                                    
   ER10005="MONTH  CURRENT IW"                                                
   ER10006="DAY CURRENT IW"                                                   
   ER10007="YEAR CURRENT IW"                                                  
   ER10008="# IN FU"                                                          
   ER10009="AGE OF HEAD"                                                      
   ER10010="SEX OF HEAD"                                                      
   ER10011="AGE OF WIFE"                                                      
   ER10012="# CHILDREN IN FU"                                                 
   ER10013="AGE YOUNGEST CHILD"                                               
   ER10014="# NONFU SHARING HU"                                               
   ER10015="WHO WAS RESPONDENT"                                               
   ER10016="HEAD MARITAL STATUS"                                              
   ER10017="A4 TYPE DU"                                                       
   ER10018="A6 LIVE IN ELDERLY HSNG"                                          
   ER10019="A7 TYPE ELDERLY HSNG"                                             
   ER10020="A8 PROVIDE MED/INJECTION"                                         
   ER10021="A9 PROVIDE MEALS"                                                 
   ER10022="A10 PROVIDE CLEANING"                                             
   ER10023="A11 PROVIDE OTR SERVICES"                                         
   ER10024="A12 XTRA SERVS MENTION 1"                                         
   ER10025="A12 XTRA SERVS MENTION 2"                                         
   ER10026="A12 XTRA SERVS MENTION 3"                                         
   ER10027="A12 XTRA SERVS MENTION 4"                                         
   ER10028="A14 SERVICES INCLUDED"                                            
   ER10029="TYPE HEATING 1ST MENTION"                                         
   ER10030="TYPE HEATING 2ND MENTION"                                         
   ER10031="TYPE HEATING 3RD MENTION"                                         
   ER10032="A16 ACTUAL # ROOMS"                                               
   ER10033="A17 RECD GOVT HTG SUBSDY"                                         
   ER10034="A18 AMT GOVT HTG SUBSDY"                                          
   ER10035="A19 OWN/RENT OR WHAT"                                             
   ER10036="A20 HOUSE VALUE"                                                  
   ER10037="A21 ANNUAL PROPERTY TAX"                                          
   ER10038="A22 ANNUAL OWNR INSURANC"                                         
   ER10039="A23 HAVE MORTGAGE?"                                               
   ER10040="A23A TYPE MORTGAGE MOR 1"                                         
   ER10041="A23A TYPE MORTGAGE MOR 2"                                         
   ER10042="A23B WTR REFINANCED MTG1"                                         
   ER10043="A23B WTR REFINANCED MTG2"                                         
   ER10044="A24 REM PRINCIPAL MOR 1"                                          
   ER10045="A24 REM PRINCIPAL MOR 2"                                          
   ER10046="A25 MNTHLY PMTS MOR   1"                                          
   ER10047="A25 MNTHLY PMTS MOR   2"                                          
   ER10048="A25B CURR INT RATE MOR 1"                                         
   ER10049="A25B CURR INT RATE MOR 2"                                         
   ER10050="A25C             MOR   1"                                         
   ER10051="A25C             MOR   2"                                         
   ER10052="A26 YRS PAYING MOR    1"                                          
   ER10053="A26 YRS PAYING MOR    2"                                          
   ER10054="A27 YRS TO PAY MOR    1"                                          
   ER10055="A27 YRS TO PAY MOR    2"                                          
   ER10056="A28 2ND MORTGAGE"                                                 
   ER10057="A28 3RD MORTGAGE"                                                 
   ER10058="A29 MTG INCL PROP TAXES"                                          
   ER10059="A30 MTG INCL INS PREM"                                            
   ER10060="A31 DOLLARS RENT"                                                 
   ER10061="A31 DOLLLARS PER WHAT"                                            
   ER10062="A32 FURNISHED APT/HOUSE"                                          
   ER10063="A33 RENT INCL HEAT"                                               
   ER10064="A34 IN PUBLIC OWND PROJ?"                                         
   ER10065="A35 GOVT PAY PART RENT?"                                          
   ER10066="A37 DOLLARS RENT IF RENT"                                         
   ER10067="A37 DOLLARS PER WHAT"                                             
   ER10068="A38 IN PUBLIC OWND PROJ?"                                         
   ER10069="A39 GOVT PAY ALL RENT?"                                           
   ER10070="A40 HAVE AIR CONDITNG"                                            
   ER10071="A41 A/C ALL OR SOME ROOM"                                         
   ER10072="A42 MOVED SINCE SPG?"                                             
   ER10073="A43 MONTH MOVED"                                                  
   ER10074="A43 1 DIGIT YEAR MOVED"                                           
   ER10075="A44 WHY MOVED 1ST"                                                
   ER10076="A44 WHY MOVED 2ND"                                                
   ER10077="A44 WHY MOVED 3RD"                                                
   ER10078="A44 WHY MOVED 4TH"                                                
   ER10079="A45 WTR MIGHT MOVE"                                               
   ER10080="A46 LIKELIHOOD OF MOVING"                                         
   ER10081="B1 1ST MENTION"                                                   
   ER10082="B1 2ND MENTION"                                                   
   ER10083="B1 3RD MENTION"                                                   
   ER10084="B2 YEAR RETIRED (HD-R)"                                           
   ER10085="B3 WORK FOR MONEY?(HD-E)"                                         
   ER10086="B4 WORK SELF/OTR? (HD-E)"                                         
   ER10087="B5 CORP/UNCORP BUS(HD-E)"                                         
   ER10088="B6 WORK FOR GOVT? (HD-E)"                                         
   ER10089="B7 JOB NOW UNION? (H-E)"                                          
   ER10090="B8 BELONG UNION? (HD-E)"                                          
   ER10091="B12 SLRY/HRLY/OTR (H-E)"                                          
   ER10092="B13 SALARY AMOUNT"                                                
   ER10093="B13 SALARY PER WHAT"                                              
   ER10094="B14 WTR SAL PD OT (HD-E)"                                         
   ER10095="B15 HOW PAID FOR OT"                                              
   ER10096="B15 2ND MENTION"                                                  
   ER10097="B15  3RD MENTION"                                                 
   ER10098="B16 HOURLY REGULAR RATE"                                          
   ER10099="B17 OT DIFFERENTIAL 1ST"                                          
   ER10100="B17 OT DIFFERENTIAL 2ND"                                          
   ER10101="B17 OT DIFFERENTIAL 3RD"                                          
   ER10102="B17B AVG TIPS/COMM"                                               
   ER10103="B17B TIPS/COMM PER WHAT"                                          
   ER10104="B17C AVG TIPS/COMM"                                               
   ER10105="B17C TIPS/COMM PER WHAT"                                          
   ER10106="B18 HOW PAID-OTR (HD-E)"                                          
   ER10107="B19 OT RATE"                                                      
   ER10108="B20 GET NEW JOB? (HD-E)"                                          
   ER10109="B21 FIND JOB 1 (HD-E)"                                            
   ER10110="B21 FIND JOB 2 (HD-E)"                                            
   ER10111="B21 FIND JOB 3 (HD-E)"                                            
   ER10112="B21 FIND JOB 4 (HD-E)"                                            
   ER10113="B21 FIND JOB 5 ( HD-E)"                                           
   ER10114="B21 FIND JOB 6 (HD-E)"                                            
   ER10115="B21 FIND JOB 7 (HD-E)"                                            
   ER10116="B21 DID NOTHING (HD-E)"                                           
   ER10117="B23 YRS PRES EMP (H-E)"                                           
   ER10118="B23 MOS PRES EMP (H-E)"                                           
   ER10119="B23 WKS PRES EMP (H-E)"                                           
   ER10120="B24 MO BEG PRES EMP(H-E)"                                         
   ER10121="B24 YR BEG PRES EMP(H-E)"                                         
   ER10122="B25 BEG WRK PRES POS H-E"                                         
   ER10123="B26 MO BEG PRES POS(H-E)"                                         
   ER10124="B26 YR BEG PRES POS(H-E)"                                         
   ER10125="B27 CHGE POS      (HD-E)"                                         
   ER10126="B28 MO CHGE POS (HD-E)"                                           
   ER10127="B29 TYPE OF CHGE (HD-E)"                                          
   ER10128="B30 MO BEG PRES POS(H-E)"                                         
   ER10129="B30 YR BEG PRES POS(H-E)"                                         
   ER10130="B31 MO BEG PRES POS(H-E)"                                         
   ER10131="B31 YR BEG PRES POS(H-E)"                                         
   ER10132="B32 CHGE POS      (HD-E)"                                         
   ER10133="B33 MO CHGE POS (HD-E)"                                           
   ER10134="B34 TYPE OF CHGE (HD-E)"                                          
   ER10135="B37 STARTING WAGE"                                                
   ER10136="B37 STARTING WAGE PER"                                            
   ER10137="B38 STARTING HR/WK"                                               
   ER10138="B39 PRES EMP JAN  (H-E)"                                          
   ER10139="B39 PRES EMP FEB  (H-E)"                                          
   ER10140="B39 PRES EMP MAR  (H-E)"                                          
   ER10141="B39 PRES EMP APR  (H-E)"                                          
   ER10142="B39 PRES EMP MAY  (H-E)"                                          
   ER10143="B39 PRES EMP JUN  (H-E)"                                          
   ER10144="B39 PRES EMP JUL  (H-E)"                                          
   ER10145="B39 PRES EMP AUG  (H-E)"                                          
   ER10146="B39 PRES EMP SEP  (H-E)"                                          
   ER10147="B39 PRES EMP OCT  (H-E)"                                          
   ER10148="B39 PRES EMP NOV  (H-E)"                                          
   ER10149="B39 PRES EMP DEC  (H-E)"                                          
   ER10150="B42 OTR EMP JAN  (H-E)"                                           
   ER10151="B42 OTR EMP FEB  (H-E)"                                           
   ER10152="B42 OTR EMP MAR  (H-E)"                                           
   ER10153="B42 OTR EMP APR  (H-E)"                                           
   ER10154="B42 OTR EMP MAY  (H-E)"                                           
   ER10155="B42 OTR EMP JUN  (H-E)"                                           
   ER10156="B42 OTR EMP JUL  (H-E)"                                           
   ER10157="B42 OTR EMP AUG  (H-E)"                                           
   ER10158="B42 OTR EMP SEP  (H-E)"                                           
   ER10159="B42 OTR EMP OCT  (H-E)"                                           
   ER10160="B42 OTR EMP NOV  (H-E)"                                           
   ER10161="B42 OTR EMP DEC  (H-E)"                                           
   ER10162="B42A OVERLAP INDICATOR"                                           
   ER10163="B43 WORK SELF/OTR?(HD-E)"                                         
   ER10164="B44 CORP/UNCORP BUS(H-E)"                                         
   ER10165="B45 WORK FOR GOVT?(HD-E)"                                         
   ER10166="B45A AMOUNT"                                                      
   ER10167="B45A AMOUNT PER WHAT"                                             
   ER10168="B45B HOURS PER WEEK"                                              
   ER10169="B46 CHG POS OTR EMP(H-E)"                                         
   ER10170="B46A MO CHGE POS (HD-E)"                                          
   ER10171="B47 TYPE CHG OTR EMP H-E"                                         
   ER10172="B48 MO BEG OTR EMP (HD-E"                                         
   ER10173="B48 YR BEG OTR EMP (HD-E"                                         
   ER10174="B51 STARTING WAGE"                                                
   ER10175="B51 STARTING WAGE PER"                                            
   ER10176="B52 BEG HR/WK OTR EMP HD"                                         
   ER10177="B53 STOP WRK OTR EMP H-E"                                         
   ER10178="B54 MO END OTR EMP (H-E)"                                         
   ER10179="B54 YR END OTR EMP (H-E)"                                         
   ER10180="B56 FINAL WAGE"                                                   
   ER10181="B56 FINAL WAGE PER WHAT"                                          
   ER10182="B57A END HR/WK OTR EMP H"                                         
   ER10183="B60 WTR OTRS ILL (HD-E)"                                          
   ER10184="B61 DAYS OTHERS SICK"                                             
   ER10185="B61 WEEKS OTHERS SICK"                                            
   ER10186="B61 MONTHS OTHERS SICK"                                           
   ER10187="B63 WTR SELF ILL (HD-E)"                                          
   ER10188="B64 DAYS SELF SICK"                                               
   ER10189="B64 WEEKS SELF SICK"                                              
   ER10190="B64 MONTHS SELF SICK"                                             
   ER10191="B66 WTR VACATION (HD-E)"                                          
   ER10192="B67 DAYS VACATION"                                                
   ER10193="B67 WEEKS VACATION"                                               
   ER10194="B67 MONTHS VACATION"                                              
   ER10195="B69 WTR STRIKE (HD-E)"                                            
   ER10196="B70 DAYS STRIKE"                                                  
   ER10197="B70 WEEKS STRIKE"                                                 
   ER10198="B70 MONTHS STRIKE"                                                
   ER10199="B72 WTR UNEMPLOYED(HD-E)"                                         
   ER10200="B73 DAYS UNEMPLOYED"                                              
   ER10201="B73 WEEKS UNEMPLOYED"                                             
   ER10202="B73 MONTHS UNEMPLOYED"                                            
   ER10203="B74A UNEMPLOYED JAN"                                              
   ER10204="B74A UNEMPLOYED FEB"                                              
   ER10205="B74A UNEMPLOYED MAR"                                              
   ER10206="B74A UNEMPLOYED APR"                                              
   ER10207="B74A UNEMPLOYED MAY"                                              
   ER10208="B74A UNEMPLOYED JUN"                                              
   ER10209="B74A UNEMPLOYED JUL"                                              
   ER10210="B74A UNEMPLOYED AUG"                                              
   ER10211="B74A UNEMPLOYED SEP"                                              
   ER10212="B74A UNEMPLOYED OCT"                                              
   ER10213="B74A UNEMPLOYED NOV"                                              
   ER10214="B74A UNEMPLOYED DEC"                                              
   ER10215="B75 WTR OUT LAB FRC(H-E)"                                         
   ER10216="B76 DAYS OUT OF LAB FORC"                                         
   ER10217="B76 WEEKS OUT LABOR FORC"                                         
   ER10218="B76 MONTHS OUT LABR FORC"                                         
   ER10219="B77A OUT LAB FORC JAN"                                            
   ER10220="B77A OUT LAB FORC FEB"                                            
   ER10221="B77A OUT LAB FORC MAR"                                            
   ER10222="B77A OUT LAB FORC APR"                                            
   ER10223="B77A OUT LAB FORC MAY"                                            
   ER10224="B77A OUT LAB FORC JUN"                                            
   ER10225="B77A OUT LAB FORC JUL"                                            
   ER10226="B77A OUT LAB FORC AUG"                                            
   ER10227="B77A OUT LAB FORC SEP"                                            
   ER10228="B77A OUT LAB FORC OCT"                                            
   ER10229="B77A OUT LAB FORC NOV"                                            
   ER10230="B77A OUT LAB FORC DEC"                                            
   ER10231="B78 # WKS WORKED (HD-E)"                                          
   ER10232="B79 # HR/WK WORKED (H-E)"                                         
   ER10233="B80 WTR WORKED OT (HD-E)"                                         
   ER10234="B81 HOURS OF OVERTIME"                                            
   ER10235="B82 WTR XTRA JOBS (HD-E)"                                         
   ER10236="B83 WORK FOR GOVT?(HD-E)"                                         
   ER10237="B87 AMT MADE XTRA JOB1"                                           
   ER10238="B87 AMT MADE PER    JOB1"                                         
   ER10239="B88 # WKS XTRA JOB1(H-E)"                                         
   ER10240="B89 HR/WK XTRA JOB1(H-E)"                                         
   ER10241="B90 MO BEG XTRA JOB1 H-E"                                         
   ER10242="B90 YR BEG XTRA JOB1 H-E"                                         
   ER10243="B91 WRK XJB1 JAN  (H-E)"                                          
   ER10244="B91 WRK XJB1 FEB  (H-E)"                                          
   ER10245="B91 WRK XJB1 MAR  (H-E)"                                          
   ER10246="B91 WRK XJB1 APR  (H-E)"                                          
   ER10247="B91 WRK XJB1 MAY  (H-E)"                                          
   ER10248="B91 WRK XJB1 JUN  (H-E)"                                          
   ER10249="B91 WRK XJB1 JUL  (H-E)"                                          
   ER10250="B91 WRK XJB1 AUG  (H-E)"                                          
   ER10251="B91 WRK XJB1 SEP  (H-E)"                                          
   ER10252="B91 WRK XJB1 OCT  (H-E)"                                          
   ER10253="B91 WRK XJB1 NOV  (H-E)"                                          
   ER10254="B91 WRK XJB1 DEC  (H-E)"                                          
   ER10255="B92 STOP WRK XJOB1 (H-E)"                                         
   ER10256="B93 MO END XJOB1 (HD-E)"                                          
   ER10257="B93 YR END XJOB1 (HD-E)"                                          
   ER10258="B94 WTR OTR XJOB (HD-E)"                                          
   ER10259="B95 WRK FOR GOV XJB2 H-E"                                         
   ER10260="B99 AMT MADE XTRA JOB2"                                           
   ER10261="B99 AMT MADE XTRA JOB2"                                           
   ER10262="B100 #WKS XTRA JB2+(H-E)"                                         
   ER10263="B101 AV HR/WK X JB2+ H-E"                                         
   ER10264="B102 MO BEG XJOB2 (H-E)"                                          
   ER10265="B102 YR BEG XJOB2 (H-E)"                                          
   ER10266="B103 WRK XJOB2 JAN  H-E"                                          
   ER10267="B103 WRK XJOB2 FEB  H-E"                                          
   ER10268="B103 WRK XJOB2 MAR  H-E"                                          
   ER10269="B103 WRK XJOB2 APR  H-E"                                          
   ER10270="B103 WRK XJOB2 MAY  H-E"                                          
   ER10271="B103 WRK XJOB2 JUN  H-E"                                          
   ER10272="B103 WRK XJOB2 JUL  H-E"                                          
   ER10273="B103 WRK XJOB2 AUG  H-E"                                          
   ER10274="B103 WRK XJOB2 SEP  H-E"                                          
   ER10275="B103 WRK XJOB2 OCT  H-E"                                          
   ER10276="B103 WRK XJOB2 NOV  H-E"                                          
   ER10277="B103 WRK XJOB2 DEC  H-E"                                          
   ER10278="B104 STOP WORK XJOB2 H-E"                                         
   ER10279="B105 MO END XJOB2 (HD-E)"                                         
   ER10280="B105 YR END XJOB2 (HD-E)"                                         
   ER10281="B110 WRK FOR GOV XJB3 HE"                                         
   ER10282="B111 AMT MADE XTRA JOB3"                                          
   ER10283="B111 AMT MADE PER JOB3"                                           
   ER10284="B112 #WKS XTRA JOB3"                                              
   ER10285="B113 HR/WK XTRA JOB3"                                             
   ER10286="B114 MO BEG XTRA JOB3"                                            
   ER10287="B114 YR BEG XTRA JOB3"                                            
   ER10288="B115 XTRA JOB3 JAN"                                               
   ER10289="B115 XTRA JOB3 FEB"                                               
   ER10290="B115 XTRA JOB3 MAR"                                               
   ER10291="B115 XTRA JOB3 APR"                                               
   ER10292="B115 XTRA JOB3 MAY"                                               
   ER10293="B115 XTRA JOB3 JUN"                                               
   ER10294="B115 XTRA JOB3 JUL"                                               
   ER10295="B115 XTRA JOB3 AUG"                                               
   ER10296="B115 XTRA JOB3 SEP"                                               
   ER10297="B115 XTRA JOB3 OCT"                                               
   ER10298="B115 XTRA JOB3 NOV"                                               
   ER10299="B115 XTRA JOB3 DEC"                                               
   ER10300="B116 STOP WRK XTRA JOB3"                                          
   ER10301="B117 MO END XTRA JOB3"                                            
   ER10302="B117 YR END XTRA JOB3"                                            
   ER10303="B119 WORK FOR GOVT? JOB4"                                         
   ER10304="B123 AMT MADE XTRA JOB4"                                          
   ER10305="B123 AMT MADE PER   JOB4"                                         
   ER10306="B124 #WKS XTRA JOB4"                                              
   ER10307="B125 HR/WK XTRA JOB4"                                             
   ER10308="B126 MO BEG XTRA JOB4"                                            
   ER10309="B126 YR BEG XTRA JOB4"                                            
   ER10310="B127 XTRA JOB4 JAN"                                               
   ER10311="B127 XTRA JOB4 FEB"                                               
   ER10312="B127 XTRA JOB4 MAR"                                               
   ER10313="B127 XTRA JOB4 APR"                                               
   ER10314="B127 XTRA JOB4 MAY"                                               
   ER10315="B127 XTRA JOB4 JUN"                                               
   ER10316="B127 XTRA JOB4 JUL"                                               
   ER10317="B127 XTRA JOB4 AUG"                                               
   ER10318="B127 XTRA JOB4 SEP"                                               
   ER10319="B127 XTRA JOB4 OCT"                                               
   ER10320="B127 XTRA JOB4 NOV"                                               
   ER10321="B127 XTRA JOB4 DEC"                                               
   ER10322="B128 STOP WRK XTRA JOB4"                                          
   ER10323="B129 MO END XTRA JOB4"                                            
   ER10324="B129 YR END XTRA JOB4"                                            
   ER10325="C1 WTR LOOK FOR JOB(H-U)"                                         
   ER10326="C2 FIND JOB 1 (HD-U)"                                             
   ER10327="C2 FIND JOB 2 (HD-U)"                                             
   ER10328="C2 FIND JOB 3 (HD-U)"                                             
   ER10329="C2 FIND JOB 4 (HD-U)"                                             
   ER10330="C2 FIND JOB 5 (HD-U)"                                             
   ER10331="C2 FIND JOB 6 (HD-U)"                                             
   ER10332="C2 FIND JOB 7 (HD-U)"                                             
   ER10333="C2 DID NOTHING (HD-U)"                                            
   ER10334="C3 YRS LOOK WRK (H-U)"                                            
   ER10335="C3 MOS LOOK WRK (H-U)"                                            
   ER10336="C3 WKS LOOK WRK (H-U)"                                            
   ER10337="C4 EVER WORKED? (HD-U)"                                           
   ER10338="C5 MO LAST WORKED (HD-U)"                                         
   ER10339="C5 YR LAST WORKED (HD-U)"                                         
   ER10340="C6 WTR UNEMP   (H-U)"                                             
   ER10341="C7 # WK UNEMP   (H-U)"                                            
   ER10342="C8 LOOKING FOR WORK JAN"                                          
   ER10343="C8 LOOKING FOR WORK FEB"                                          
   ER10344="C8 LOOKING FOR WORK MAR"                                          
   ER10345="C8 LOOKING FOR WORK APR"                                          
   ER10346="C8 LOOKING FOR WORK MAY"                                          
   ER10347="C8 LOOKING FOR WORK JUN"                                          
   ER10348="C8 LOOKING FOR WORK JUL"                                          
   ER10349="C8 LOOKING FOR WORK AUG"                                          
   ER10350="C8 LOOKING FOR WORK SEP"                                          
   ER10351="C8 LOOKING FOR WORK OCT"                                          
   ER10352="C8 LOOKING FOR WORK NOV"                                          
   ER10353="C8 LOOKING FOR WORK DEC"                                          
   ER10354="C12 WRK SELF/OTR? (HD-U)"                                         
   ER10355="C13 CORP/UNCORP BUS(H-U)"                                         
   ER10356="C14 WORK FOR GOVT? (H-U)"                                         
   ER10357="C16 MO BEG LAST EMP H-U"                                          
   ER10358="C16 YR BEG LAST EMP H-U"                                          
   ER10359="C17 BEG WK LAST POS(H-U)"                                         
   ER10360="C18 MO BEG LAST POS (H-U"                                         
   ER10361="C18 YR BEG LAST POS (H-U"                                         
   ER10362="C19 CHGE POS      (HD-U)"                                         
   ER10363="C20 MO CHGE POS (HD-U)"                                           
   ER10364="C21 TYPE OF CHGE (HD-U)"                                          
   ER10365="C22 MO BEG LAST POS(H-U)"                                         
   ER10366="C22 YR BEG LAST POS(H-U)"                                         
   ER10367="C23 MO BEG LAST POS(H-U)"                                         
   ER10368="C23 YR BEG LAST POS(H-U)"                                         
   ER10369="C24 CHGE POS      (HD-U)"                                         
   ER10370="C25 MO CHGE POS (HD-U)"                                           
   ER10371="C26 TYPE OF CHGE (HD-U)"                                          
   ER10372="C29 STARTING WAGE"                                                
   ER10373="C29 STARTING WAGE PER"                                            
   ER10374="C30 HR/WK BEG LAST EMP H"                                         
   ER10375="C31 LAST EMP JAN  (H-U)"                                          
   ER10376="C31 LAST EMP FEB  (H-U)"                                          
   ER10377="C31 LAST EMP MAR  (H-U)"                                          
   ER10378="C31 LAST EMP APR  (H-U)"                                          
   ER10379="C31 LAST EMP MAY  (H-U)"                                          
   ER10380="C31 LAST EMP JUN  (H-U)"                                          
   ER10381="C31 LAST EMP JUL  (H-U)"                                          
   ER10382="C31 LAST EMP AUG  (H-U)"                                          
   ER10383="C31 LAST EMP SEP  (H-U)"                                          
   ER10384="C31 LAST EMP OCT  (H-U)"                                          
   ER10385="C31 LAST EMP NOV  (H-U)"                                          
   ER10386="C31 LAST EMP DEC  (H-U)"                                          
   ER10387="C34 OTR EMP JAN  (H-U)"                                           
   ER10388="C34 OTR EMP FEB  (H-U)"                                           
   ER10389="C34 OTR EMP MAR  (H-U)"                                           
   ER10390="C34 OTR EMP APR  (H-U)"                                           
   ER10391="C34 OTR EMP MAY  (H-U)"                                           
   ER10392="C34 OTR EMP JUN  (H-U)"                                           
   ER10393="C34 OTR EMP JUL  (H-U)"                                           
   ER10394="C34 OTR EMP AUG  (H-U)"                                           
   ER10395="C34 OTR EMP SEP  (H-U)"                                           
   ER10396="C34 OTR EMP OCT  (H-U)"                                           
   ER10397="C34 OTR EMP NOV  (H-U)"                                           
   ER10398="C34 OTR EMP DEC  (H-U)"                                           
   ER10399="C34A OVERLAP (H-U)"                                               
   ER10400="C35 WORK SELF/OTR?(HD-U)"                                         
   ER10401="C36 CORP/UNCORP BUS(H-U)"                                         
   ER10402="C37 WRK GOV-OTH EMP H-U"                                          
   ER10403="C37A AMT EARNED THIS JOB"                                         
   ER10404="C37A AMT EARNED PER"                                              
   ER10405="C37B # HR/WK WORKED H-U"                                          
   ER10406="C38 CHG POS OTR EMP(H-U)"                                         
   ER10407="C38A MO CHGE POS (HD-U)"                                          
   ER10408="C39 TYPE CHG OTR EMP H-U"                                         
   ER10409="C40 MO BEG OTR EMP(HD-U)"                                         
   ER10410="C40 YR BEG OTR EMP(HD-U)"                                         
   ER10411="C43 STARTING SALARY WAGE"                                         
   ER10412="C43 START SAL/WAGE PER"                                           
   ER10413="C44 BEG HR/WK OTR EMP HD"                                         
   ER10414="C45 STOP WRK OTR EMP H-U"                                         
   ER10415="C46 MO END OTR EMP (HD-U"                                         
   ER10416="C46 YR END OTR EMP (HD-U"                                         
   ER10417="C48A FINAL SALARY/WAGE"                                           
   ER10418="C48A FINAL SAL/WAGE PER"                                          
   ER10419="C49 FINAL SALARY/WAGE"                                            
   ER10420="C49 FINAL SAL/WAGE PER"                                           
   ER10421="C49A END HR/WK OTR EMP H"                                         
   ER10422="C52 WTR OTRS ILL (HD-U)"                                          
   ER10423="C53 DAYS OTHERS SICK"                                             
   ER10424="C53 WEEKS OTHERS SICK"                                            
   ER10425="C53 MONTHS OTHERS SICK"                                           
   ER10426="C55 WTR SELF ILL (HD-U)"                                          
   ER10427="C56 DAYS SELF SICK"                                               
   ER10428="C56 WEEKS SELF SICK"                                              
   ER10429="C56 MONTHS SELF SICK"                                             
   ER10430="C58 WTR VACATION (HD-U)"                                          
   ER10431="C59 DAYS VACATION"                                                
   ER10432="C59 WEEKS VACATION"                                               
   ER10433="C59 MONTHS VACATION"                                              
   ER10434="C61 WTR ON STRIKE (HD-U)"                                         
   ER10435="C62 DAYS STRIKE"                                                  
   ER10436="C62 WEEKS STRIKE"                                                 
   ER10437="C62 MONTHS STRIKE"                                                
   ER10438="C64 WTR UNEMPLOYED (H-U)"                                         
   ER10439="C65 DAYS UNEMPLOYED"                                              
   ER10440="C65 WEEKS UNEMPLOYED"                                             
   ER10441="C65 MONTHS UNEMPLOYED"                                            
   ER10442="C66A UNEMPLOYED JAN"                                              
   ER10443="C66A UNEMPLOYED FEB"                                              
   ER10444="C66A UNEMPLOYED MAR"                                              
   ER10445="C66A UNEMPLOYED APR"                                              
   ER10446="C66A UNEMPLOYED MAY"                                              
   ER10447="C66A UNEMPLOYED JUN"                                              
   ER10448="C66A UNEMPLOYED JUL"                                              
   ER10449="C66A UNEMPLOYED AUG"                                              
   ER10450="C66A UNEMPLOYED SEP"                                              
   ER10451="C66A UNEMPLOYED OCT"                                              
   ER10452="C66A UNEMPLOYED NOV"                                              
   ER10453="C66A UNEMPLOYED DEC"                                              
   ER10454="C67 WTR OUT LAB FRC(H-U)"                                         
   ER10455="C68 DAYS OUT LABOR FORCE"                                         
   ER10456="C68 WEEKS OUT LABOR FORC"                                         
   ER10457="C68 MONTHS OUT LABR FORC"                                         
   ER10458="C69A OUT LABR FORC JAN"                                           
   ER10459="C69A OUT LABR FORC FEB"                                           
   ER10460="C69A OUT LABR FORC MAR"                                           
   ER10461="C69A OUT LABR FORC APR"                                           
   ER10462="C69A OUT LABR FORC MAY"                                           
   ER10463="C69A OUT LABR FORC JUN"                                           
   ER10464="C69A OUT LABR FORC JUL"                                           
   ER10465="C69A OUT LABR FORC AUG"                                           
   ER10466="C69A OUT LABR FORC SEP"                                           
   ER10467="C69A OUT LABR FORC OCT"                                           
   ER10468="C69A OUT LABR FORC NOV"                                           
   ER10469="C69A OUT LABR FORC DEC"                                           
   ER10470="C70 WEEKS WORKED"                                                 
   ER10471="C71 HR/WK WORKED (HD-U)"                                          
   ER10472="C72 WTR WORKED OT (HD-U)"                                         
   ER10473="C73 AMOUNT OVERTIME"                                              
   ER10474="C74 WTR XTRA JOBS (HD-U)"                                         
   ER10475="C75 WORK FOR GOVT?(HD-U)"                                         
   ER10476="C79 AMT MADE XTRA JOB1"                                           
   ER10477="C79 AMT MADE JOB1 PER"                                            
   ER10478="C80 # WKS EXTRA JOB1 H-U"                                         
   ER10479="C81 HR/WK XTRA JOB1(H-U)"                                         
   ER10480="C82 MO BEG XTRA JOB1 H-U"                                         
   ER10481="C82 YR BEG XTRA JOB1 H-U"                                         
   ER10482="C83 WRK XJOB1 JAN  H-U"                                           
   ER10483="C83 WRK XJOB1 FEB  H-U"                                           
   ER10484="C83 WRK XJOB1 MAR  H-U"                                           
   ER10485="C83 WRK XJOB1 APR  H-U"                                           
   ER10486="C83 WRK XJOB1 MAY  H-U"                                           
   ER10487="C83 WRK XJOB1 JUN  H-U"                                           
   ER10488="C83 WRK XJOB1 JUL  H-U"                                           
   ER10489="C83 WRK XJOB1 AUG  H-U"                                           
   ER10490="C83 WRK XJOB1 SEP  H-U"                                           
   ER10491="C83 WRK XJOB1 OCT  H-U"                                           
   ER10492="C83 WRK XJOB1 NOV  H-U"                                           
   ER10493="C83 WRK XJOB1 DEC  H-U"                                           
   ER10494="C84 STOP WORK XJOB1 H-U"                                          
   ER10495="C85 MO END XJOB1 (HD-U)"                                          
   ER10496="C85 YR END XJOB1 (HD-U)"                                          
   ER10497="C87 WRK FOR GOV XJB2 H-U"                                         
   ER10498="C91 AMT MADE XTRA JOB2"                                           
   ER10499="C91 AMT MADE JOB2 PER"                                            
   ER10500="C92 # WK XTRA JOB2+(H-U)"                                         
   ER10501="C93 AV HR/WK X JB2+(H-U)"                                         
   ER10502="C94 MO BEG XJOB2 (H-U)"                                           
   ER10503="C94 YR BEG XJOB2 (H-U)"                                           
   ER10504="C95 WRK XJOB2 JAN  H-U"                                           
   ER10505="C95 WRK XJOB2 FEB  H-U"                                           
   ER10506="C95 WRK XJOB2 MAR  H-U"                                           
   ER10507="C95 WRK XJOB2 APR  H-U"                                           
   ER10508="C95 WRK XJOB2 MAY  H-U"                                           
   ER10509="C95 WRK XJOB2 JUN  H-U"                                           
   ER10510="C95 WRK XJOB2 JUL  H-U"                                           
   ER10511="C95 WRK XJOB2 AUG  H-U"                                           
   ER10512="C95 WRK XJOB2 SEP  H-U"                                           
   ER10513="C95 WRK XJOB2 OCT  H-U"                                           
   ER10514="C95 WRK XJOB2 NOV  H-U"                                           
   ER10515="C95 WRK XJOB2 DEC  H-U"                                           
   ER10516="C96 STOP WORK XJOB2 H-U"                                          
   ER10517="C97 MO END JOB2 (HD-U)"                                           
   ER10518="C97 YR END JOB2 (HD-U)"                                           
   ER10519="C99 WRK FOR GOV XJB3 HU"                                          
   ER10520="C103 AMT MADE XTRA JOB3"                                          
   ER10521="C103 AMT MADE JOB3 PER"                                           
   ER10522="C104 #WEEKS XTRA JOB3"                                            
   ER10523="C105 HRS/WK XTRA JOB3"                                            
   ER10524="C106 MO BEG XTRA JOB3"                                            
   ER10525="C106 YR BEG XTRA JOB3"                                            
   ER10526="C107 EXTRA JOB3 JAN"                                              
   ER10527="C107 EXTRA JOB3 FEB"                                              
   ER10528="C107 EXTRA JOB3 MAR"                                              
   ER10529="C107 EXTRA JOB3 APR"                                              
   ER10530="C107 EXTRA JOB3 MAY"                                              
   ER10531="C107 EXTRA JOB3 JUN"                                              
   ER10532="C107 EXTRA JOB3 JUL"                                              
   ER10533="C107 EXTRA JOB3 AUG"                                              
   ER10534="C107 EXTRA JOB3 SEP"                                              
   ER10535="C107 EXTRA JOB3 OCT"                                              
   ER10536="C107 EXTRA JOB3 NOV"                                              
   ER10537="C107 EXTRA JOB3 DEC"                                              
   ER10538="C108 STOP WRK XTRA JOB3"                                          
   ER10539="C109 MO END XTRA JOB3"                                            
   ER10540="C109 YR END XTRA JOB3"                                            
   ER10541="C114 WRK FOR GOV XJB4 HU"                                         
   ER10542="C115 AMT MADE XTRA JOB4"                                          
   ER10543="C115 AMT MADE JOB4 PER"                                           
   ER10544="C116 #WEEKS XTRA JOB4"                                            
   ER10545="C117 HRS/WK XTRA JOB4"                                            
   ER10546="C118 MO BEG XTRA JOB4"                                            
   ER10547="C118 YR BEG XTRA JOB4"                                            
   ER10548="C119 EXTRA JOB4 JAN"                                              
   ER10549="C119 EXTRA JOB4 FEB"                                              
   ER10550="C119 EXTRA JOB4 MAR"                                              
   ER10551="C119 EXTRA JOB4 APR"                                              
   ER10552="C119 EXTRA JOB4 MAY"                                              
   ER10553="C119 EXTRA JOB4 JUN"                                              
   ER10554="C119 EXTRA JOB4 JUL"                                              
   ER10555="C119 EXTRA JOB4 AUG"                                              
   ER10556="C119 EXTRA JOB4 SEP"                                              
   ER10557="C119 EXTRA JOB4 OCT"                                              
   ER10558="C119 EXTRA JOB4 NOV"                                              
   ER10559="C119 EXTRA JOB4 DEC"                                              
   ER10560="C120 STOP WORK XTRA JOB4"                                         
   ER10561="C121 MO END XTRA JOB4"                                            
   ER10562="C121 YR END XTRA JOB4"                                            
   ER10563="D1 1ST MENTION"                                                   
   ER10564="D1 2ND MENTION"                                                   
   ER10565="D1 3RD MENTION"                                                   
   ER10566="D2 YEAR RETIRED (WF-R)"                                           
   ER10567="D3 WORK FOR MONEY?(WF-E)"                                         
   ER10568="D4 WORK SELF/OTR? (WF-E)"                                         
   ER10569="D5 CORP/UNCORP BUS(WF-E)"                                         
   ER10570="D6 WORK FOR GOVT? (WF-E)"                                         
   ER10571="D7 JOB NOW UNION? (W-E)"                                          
   ER10572="D8 BELONG UNION? (WF-E)"                                          
   ER10573="D12 SLRY/HRLY/OTR (W-E)"                                          
   ER10574="D13 SALARY AMOUNT"                                                
   ER10575="D13 SALARY PER WHAT"                                              
   ER10576="D14 WTR SAL PD OT (WF-E)"                                         
   ER10577="D15 HOURLY OVERTIME"                                              
   ER10578="D15 2ND MENTION"                                                  
   ER10579="D15 3RD MENTION"                                                  
   ER10580="D16 HOURLY REGULAR RATE"                                          
   ER10581="D17 HOURLY RATE OT (W-E)"                                         
   ER10582="D17 2ND MENTION"                                                  
   ER10583="D17 3RD MENTION"                                                  
   ER10584="D17B AVG TIPS/COMM"                                               
   ER10585="D17B TIPS/COMM PER WHAT"                                          
   ER10586="D17C AVG TIPS/COMM"                                               
   ER10587="D17C TIPS/COMM PER WHAT"                                          
   ER10588="D18 HOW PAID-OTR (WF-E)"                                          
   ER10589="D19 HOURLY OVERTIME"                                              
   ER10590="D20 GET NEW JOB? (WF-E)"                                          
   ER10591="D21 FIND JOB 1 (W-E)"                                             
   ER10592="D21 FIND JOB 2 (W-E)"                                             
   ER10593="D21 FIND JOB 3 (W-E)"                                             
   ER10594="D21 FIND JOB 4(W-E)"                                              
   ER10595="D21 FIND JOB 5 (W-E)"                                             
   ER10596="D21 FIND JOB 6 (W-E)"                                             
   ER10597="D21 FIND JOB 7 (W-E)"                                             
   ER10598="D21 DID NOTHING (W-E)"                                            
   ER10599="D23 YRS PRES EMP (W-E)"                                           
   ER10600="D23 MOS PRES EMP (W-E)"                                           
   ER10601="D23 WKS PRES EMP (W-E)"                                           
   ER10602="D24 MO BEG PRES EMP(W-E)"                                         
   ER10603="D24 YR BEG PRES EMP(W-E)"                                         
   ER10604="D25 BEG WRK PRES POS W-E"                                         
   ER10605="D26 MO BEG PRES POS(W-E)"                                         
   ER10606="D26 YR BEG PRES POS(W-E)"                                         
   ER10607="D27 CHGE POS      (WF-E)"                                         
   ER10608="D28 MO CHGE POS (WF-E)"                                           
   ER10609="D29 TYPE OF CHGE (WF-E)"                                          
   ER10610="D30 MO BEG PRES POS (W-E"                                         
   ER10611="D30 YR BEG PRES POS(W-E)"                                         
   ER10612="D31 MO BEG PRES POS(W-E)"                                         
   ER10613="D31 YR BEG PRES POS(W-E)"                                         
   ER10614="D32 CHGE POS      (WF-E)"                                         
   ER10615="D33 MO CHGE POS (WF-E)"                                           
   ER10616="D34 TYPE OF CHGE (WF-E)"                                          
   ER10617="D37 STARTING WAGE"                                                
   ER10618="D51 STARING WAGE PER"                                             
   ER10619="D38 STARTING HR/WK"                                               
   ER10620="D39 PRES EMP JAN  (W-E)"                                          
   ER10621="D39 PRES EMP FEB  (W-E)"                                          
   ER10622="D39 PRES EMP MAR  (W-E)"                                          
   ER10623="D39 PRES EMP APR  (W-E)"                                          
   ER10624="D39 PRES EMP MAY  (W-E)"                                          
   ER10625="D39 PRES EMP JUN  (W-E)"                                          
   ER10626="D39 PRES EMP JUL  (W-E)"                                          
   ER10627="D39 PRES EMP AUG  (W-E)"                                          
   ER10628="D39 PRES EMP SEP  (W-E)"                                          
   ER10629="D39 PRES EMP OCT  (W-E)"                                          
   ER10630="D39 PRES EMP NOV  (W-E)"                                          
   ER10631="D39 PRES EMP DEC  (W-E)"                                          
   ER10632="D42 OTR EMP JAN  (W-E)"                                           
   ER10633="D42 OTR EMP FEB  (W-E)"                                           
   ER10634="D42 OTR EMP MAR  (W-E)"                                           
   ER10635="D42 OTR EMP APR  (W-E)"                                           
   ER10636="D42 OTR EMP MAY  (W-E)"                                           
   ER10637="D42 OTR EMP JUN  (W-E)"                                           
   ER10638="D42 OTR EMP JUL  (W-E)"                                           
   ER10639="D42 OTR EMP AUG  (W-E)"                                           
   ER10640="D42 OTR EMP SEP  (W-E)"                                           
   ER10641="D42 OTR EMP OCT  (W-E)"                                           
   ER10642="D42 OTR EMP NOV  (W-E)"                                           
   ER10643="D42 OTR EMP DEC  (W-E)"                                           
   ER10644="D42A OVERLAP CODE"                                                
   ER10645="D43 WORK SELF/OTR?(WF-E)"                                         
   ER10646="D44 CORP/UNCORP BUS(W-E)"                                         
   ER10647="D45 WORK FOR GOVT?(WF-E)"                                         
   ER10648="D45A AMOUNT MADE      19"                                         
   ER10649="D45A AMOUNT MADE PER"                                             
   ER10650="D45B HOURS PER WEEK"                                              
   ER10651="D46 CHG POS OTR EMP(W-E)"                                         
   ER10652="D46A MO CHGE POS (WF-E)"                                          
   ER10653="D47 TYPE CHG OTR EMP W-E"                                         
   ER10654="D48 MO BEG OTR EMP(WF-E)"                                         
   ER10655="D48 YR BEG OTR EMP(WF-E)"                                         
   ER10656="D51 STARTING WAGE"                                                
   ER10657="E43 STARTING WAGE PER"                                            
   ER10658="D52 BEG HR/WK OTR EMP WF"                                         
   ER10659="D53 STOP WRK OTR EMP W-E"                                         
   ER10660="D54 MO END OTR EMP (W-E)"                                         
   ER10661="D54 YR END OTR EMP (W-E)"                                         
   ER10662="D56 AMOUNT FINAL WAGES"                                           
   ER10663="D56 AMOUNT WAGES PER"                                             
   ER10664="D57A END HR/WK OTR EM WF"                                         
   ER10665="D60 WTR OTRS ILL (WF-E)"                                          
   ER10666="D61 DAYS OTHER SICK"                                              
   ER10667="D61 WEEKS OTHER SICK"                                             
   ER10668="D61 MONTHS OTHER SICK"                                            
   ER10669="D63 WTR SELF ILL (WF-E)"                                          
   ER10670="D64 DAYS SELF SICK"                                               
   ER10671="D64 WEEKS SELF SICK"                                              
   ER10672="D64 MONTHS SELF SICK"                                             
   ER10673="D66 WTR VACATION (WF-E)"                                          
   ER10674="D67 DAYS VACATION"                                                
   ER10675="D67 WEEKS VACATION"                                               
   ER10676="D67 MONTHS VACATION"                                              
   ER10677="D69 WTR STRIKE (WF-E)"                                            
   ER10678="D70 DAYS STRIKE"                                                  
   ER10679="D70 WEEKS STRIKE"                                                 
   ER10680="D70 MONTHS STRIKE"                                                
   ER10681="D72 WTR UNEMPLOYED(WF-E)"                                         
   ER10682="D73 DAYS UNEMPLOYED"                                              
   ER10683="D73 WEEKS UNEMPLOYED"                                             
   ER10684="D73 MONTHS UNEMPLOYED"                                            
   ER10685="D74A UNEMPLOYED JAN"                                              
   ER10686="D74A UNEMPLOYED FEB"                                              
   ER10687="D74A UNEMPLOYED MAR"                                              
   ER10688="D74A UNEMPLOYED APR"                                              
   ER10689="D74A UNEMPLOYED MAY"                                              
   ER10690="D74A UNEMPLOYED JUN"                                              
   ER10691="D74A UNEMPLOYED JUL"                                              
   ER10692="D74A UNEMPLOYED AUG"                                              
   ER10693="D74A UNEMPLOYED SEP"                                              
   ER10694="D74A UNEMPLOYED OCT"                                              
   ER10695="D74A UNEMPLOYED NOV"                                              
   ER10696="D74A UNEMPLOYED DEC"                                              
   ER10697="D75 WTR OUT LAB FRC(W-E)"                                         
   ER10698="D76 DAYS OUT OF LAB FORC"                                         
   ER10699="D76 WEEKS OUT OF LAB FOR"                                         
   ER10700="D76 MONTHS OUT OF LAB FO"                                         
   ER10701="D77A OUT LABR FORC JAN"                                           
   ER10702="D77A OUT LABR FORC FEB"                                           
   ER10703="D77A OUT LABR FORC MAR"                                           
   ER10704="D77A OUT LABR FORC APR"                                           
   ER10705="D77A OUT LABR FORC MAY"                                           
   ER10706="D77A OUT LABR FORC JUN"                                           
   ER10707="D77A OUT LABR FORC JUL"                                           
   ER10708="D77A OUT LABR FORC AUG"                                           
   ER10709="D77A OUT LABR FORC SEP"                                           
   ER10710="D77A OUT LABR FORC OCT"                                           
   ER10711="D77A OUT LABR FORC NOV"                                           
   ER10712="D77A OUT LABR FORC DEC"                                           
   ER10713="D78 # WEEKS WORKED"                                               
   ER10714="D79 # HR/WK WORKED (W-E)"                                         
   ER10715="D80 WTR WORKED OT (WF-E)"                                         
   ER10716="D81 HOURS OF OVERTIME"                                            
   ER10717="D82 WTR XTRA JOBS (WF-E)"                                         
   ER10718="D83 WORK FOR GOVT?(WF-E)"                                         
   ER10719="D87 AMT MADE XTRA JOB1"                                           
   ER10720="D87 AMT MADE JOB1 PER"                                            
   ER10721="D88 # WKS XTRA JOB1(W-E)"                                         
   ER10722="D89 HR/WK XTRA JOB1(W-E)"                                         
   ER10723="D90 MO BEG XTRA JOB1 W-E"                                         
   ER10724="D90 YR BEG XTRA JOB1 W-E"                                         
   ER10725="D91 WRK XJB1 JAN  (W-E)"                                          
   ER10726="D91 WRK XJB1 FEB  (W-E)"                                          
   ER10727="D91 WRK XJB1 MAR  (W-E)"                                          
   ER10728="D91 WRK XJB1 APR  (W-E)"                                          
   ER10729="D91 WRK XJB1 MAY  (W-E)"                                          
   ER10730="D91 WRK XJB1 JUN  (W-E)"                                          
   ER10731="D91 WRK XJB1 JUL  (W-E)"                                          
   ER10732="D91 WRK XJB1 AUG  (W-E)"                                          
   ER10733="D91 WRK XJB1 SEP  (W-E)"                                          
   ER10734="D91 WRK XJB1 OCT  (W-E)"                                          
   ER10735="D91 WRK XJB1 NOV  (W-E)"                                          
   ER10736="D91 WRK XJB1 DEC  (W-E)"                                          
   ER10737="D92 STOP WRK XJOB1 (W-E)"                                         
   ER10738="D93 MO END XJOB1 (WF-E)"                                          
   ER10739="D93 YR END XJOB1 (WF-E)"                                          
   ER10740="D94 WTR OTR XJOB (WF-E)"                                          
   ER10741="D95 WRK FOR GOV XJB2 W-E"                                         
   ER10742="D99 AMT MADE XTRA JOB2"                                           
   ER10743="D99 AMT MADE JOB2 PER"                                            
   ER10744="D100 #WKS XTRA JB2+(W-E)"                                         
   ER10745="D101 AV HR/WK X JB2+ W-E"                                         
   ER10746="D102 MO BEG XJOB2 (W-E)"                                          
   ER10747="D102 YR BEG XJOB2 (W-E)"                                          
   ER10748="D103 WRK XJOB2 JAN  W-E"                                          
   ER10749="D103 WRK XJOB2 FEB  W-E"                                          
   ER10750="D103 WRK XJOB2 MAR  W-E"                                          
   ER10751="D103 WRK XJOB2 APR  W-E"                                          
   ER10752="D103 WRK XJOB2 MAY  W-E"                                          
   ER10753="D103 WRK XJOB2 JUN  W-E"                                          
   ER10754="D103 WRK XJOB2 JUL  W-E"                                          
   ER10755="D103 WRK XJOB2 AUG  W-E"                                          
   ER10756="D103 WRK XJOB2 SEP  W-E"                                          
   ER10757="D103 WRK XJOB2 OCT  W-E"                                          
   ER10758="D103 WRK XJOB2 NOV  W-E"                                          
   ER10759="D103 WRK XJOB2 DEC  W-E"                                          
   ER10760="D104 STOP WRK XJOB2 W-E"                                          
   ER10761="D105 MO END XJOB2 (WF-E)"                                         
   ER10762="D105 YR END XJOB2 (WF-E)"                                         
   ER10763="D110 WRK FOR GOV XJB3 WE"                                         
   ER10764="D111 AMT MADE XTRA JOB3"                                          
   ER10765="D111 AMT MADE JOB3 PER"                                           
   ER10766="D112 #WKS XTRA JOB3"                                              
   ER10767="D113 HR/WK XTRA JOB3"                                             
   ER10768="D114 MO BEG XTRA JOB3"                                            
   ER10769="D114 YR BEG XTRA JOB3"                                            
   ER10770="MONTHS XTRA JOB3 JAN"                                             
   ER10771="MONTHS XTRA JOB3 FEB"                                             
   ER10772="MONTHS XTRA JOB3 MAR"                                             
   ER10773="MONTHS XTRA JOB3 APR"                                             
   ER10774="MONTHS XTRA JOB3 MAY"                                             
   ER10775="MONTHS XTRA JOB3 JUN"                                             
   ER10776="MONTHS XTRA JOB3 JUL"                                             
   ER10777="MONTHS XTRA JOB3 AUG"                                             
   ER10778="MONTHS XTRA JOB3 SEP"                                             
   ER10779="MONTHS XTRA JOB3 OCT"                                             
   ER10780="MONTHS XTRA JOB3 NOV"                                             
   ER10781="MONTHS XTRA JOB3 DEC"                                             
   ER10782="D116 STOP WRK XTRA JOB3"                                          
   ER10783="D117 MO END XTRA JOB3"                                            
   ER10784="D117 YR END XTRA JOB3"                                            
   ER10785="D119 WORK FOR GOVT? JOB4"                                         
   ER10786="D123 AMT MADE XTRA JOB4"                                          
   ER10787="D123 AMT MADE JOB4 PER"                                           
   ER10788="D124 #WKS XTRA JOB4"                                              
   ER10789="D125 HR/WK XTRA JOB4"                                             
   ER10790="D126 MO BEG XTRA JOB4"                                            
   ER10791="D126 YR BEG XTRA JOB4"                                            
   ER10792="MONTHS XTRA JOB4 JAN"                                             
   ER10793="MONTHS XTRA JOB4 FEB"                                             
   ER10794="MONTHS XTRA JOB4 MAR"                                             
   ER10795="MONTHS XTRA JOB4 APR"                                             
   ER10796="MONTHS XTRA JOB4 MAY"                                             
   ER10797="MONTHS XTRA JOB4 JUN"                                             
   ER10798="MONTHS XTRA JOB4 JUL"                                             
   ER10799="MONTHS XTRA JOB4 AUG"                                             
   ER10800="MONTHS XTRA JOB4 SEP"                                             
   ER10801="MONTHS XTRA JOB4 OCT"                                             
   ER10802="MONTHS XTRA JOB4 NOV"                                             
   ER10803="MONTHS XTRA JOB4 DEC"                                             
   ER10804="D128 STOP WRK XTRA JOB4"                                          
   ER10805="D129 MO END XTRA JOB4"                                            
   ER10806="D129 YR END XTRA JOB4"                                            
   ER10807="E1 WTR LOOK FOR JOB(W-U)"                                         
   ER10808="E2 FIND JOB 1 (W-U)"                                              
   ER10809="E2 FIND JOB 2 (W-U)"                                              
   ER10810="E2 FIND JOB 3 (W-U)"                                              
   ER10811="E2 FIND JOB 4 (W-U)"                                              
   ER10812="E2 FIND JOB 5 (W-U)"                                              
   ER10813="E2 FIND JOB 6 (W-U)"                                              
   ER10814="E2 FIND JOB 7 (W-U)"                                              
   ER10815="E2 FIND JOB 8 (W-U)"                                              
   ER10816="E3 YRS LOOK WRK (W-U)"                                            
   ER10817="E3 MOS LOOK WRK (W-U)"                                            
   ER10818="E3 WKS LOOK WRK (W-U)"                                            
   ER10819="E4 EVER WORKED? (WF-U)"                                           
   ER10820="E5 MO LAST WORKED (WF-U)"                                         
   ER10821="E5 YR LAST WORKED (WF-U)"                                         
   ER10822="E6 WTR UNEMP   (W-U)"                                             
   ER10823="E7 # WK UNEMP   (W-U)"                                            
   ER10824="E8 LOOKING FOR WORK JAN"                                          
   ER10825="E8 LOOKING FOR WORK FEB"                                          
   ER10826="E8 LOOKING FOR WORK MAR"                                          
   ER10827="E8 LOOKING FOR WORK APR"                                          
   ER10828="E8 LOOKING FOR WORK MAY"                                          
   ER10829="E8 LOOKING FOR WORK JUN"                                          
   ER10830="E8 LOOKING FOR WORK JUL"                                          
   ER10831="E8 LOOKING FOR WORK AUG"                                          
   ER10832="E8 LOOKING FOR WORK SEP"                                          
   ER10833="E8 LOOKING FOR WORK OCT"                                          
   ER10834="E8 LOOKING FOR WORK NOV"                                          
   ER10835="E8 LOOKING FOR WORK DEC"                                          
   ER10836="E12 WRK SELF/OTR? (WF-U)"                                         
   ER10837="E13 CORP/UNCORP BUS(W-U)"                                         
   ER10838="E14 WORK FOR GOVT? (W-U)"                                         
   ER10839="E16 MO BEG LAST EMP (W-U"                                         
   ER10840="E16 YR BEG LAST EMP (W-U"                                         
   ER10841="E17 BEG WK LAST POS(W-U)"                                         
   ER10842="E18 MO BEG LAST POS(W-U)"                                         
   ER10843="E18 YR BEG LAST POS(W-U)"                                         
   ER10844="E19 CHGE POS      (WF-U)"                                         
   ER10845="E20 MO CHGE POS (WF-U)"                                           
   ER10846="E21 TYPE OF CHGE (WF-U)"                                          
   ER10847="E22 MO BEG LAST POS(W-U)"                                         
   ER10848="E22 YR BEG LAST POS(W-U)"                                         
   ER10849="E23 MO BEG LAST POS(W-U)"                                         
   ER10850="E23 YR BEG LAST POS(W-U)"                                         
   ER10851="E24 CHGE POS      (WF-U)"                                         
   ER10852="E25 MO CHGE POS (WF-U)"                                           
   ER10853="E26 TYPE OF CHGE (WF-U)"                                          
   ER10854="E29 STARTING WAGE"                                                
   ER10855="E29 STARTING WAGE PER"                                            
   ER10856="E30 HR/WK BEG LAST EMP W"                                         
   ER10857="E31 LAST EMP JAN  (W-U)"                                          
   ER10858="E31 LAST EMP FEB  (W-U)"                                          
   ER10859="E31 LAST EMP MAR  (W-U)"                                          
   ER10860="E31 LAST EMP APR  (W-U)"                                          
   ER10861="E31 LAST EMP MAY  (W-U)"                                          
   ER10862="E31 LAST EMP JUN  (W-U)"                                          
   ER10863="E31 LAST EMP JUL  (W-U)"                                          
   ER10864="E31 LAST EMP AUG  (W-U)"                                          
   ER10865="E31 LAST EMP SEP  (W-U)"                                          
   ER10866="E31 LAST EMP OCT  (W-U)"                                          
   ER10867="E31 LAST EMP NOV  (W-U)"                                          
   ER10868="E31 LAST EMP DEC  (W-U)"                                          
   ER10869="E34 OTR EMP JAN  (W-U)"                                           
   ER10870="E34 OTR EMP FEB  (W-U)"                                           
   ER10871="E34 OTR EMP MAR  (W-U)"                                           
   ER10872="E34 OTR EMP APR  (W-U)"                                           
   ER10873="E34 OTR EMP MAY  (W-U)"                                           
   ER10874="E34 OTR EMP JUN  (W-U)"                                           
   ER10875="E34 OTR EMP JUL  (W-U)"                                           
   ER10876="E34 OTR EMP AUG  (W-U)"                                           
   ER10877="E34 OTR EMP SEP  (W-U)"                                           
   ER10878="E34 OTR EMP OCT  (W-U)"                                           
   ER10879="E34 OTR EMP NOV  (W-U)"                                           
   ER10880="E34 OTR EMP DEC  (W-U)"                                           
   ER10881="E31/E34 OVERLAP"                                                  
   ER10882="E35 WORK SELF/OTR?(WF-U)"                                         
   ER10883="E36 CORP/UNCORP BUS(W-U)"                                         
   ER10884="E37 WRK GOV-OTH EMP W-U"                                          
   ER10885="E37A AMT MADE THIS JOB"                                           
   ER10886="E37A AMT MADE PER"                                                
   ER10887="E37B # HR/WK WORKED W-U"                                          
   ER10888="E38 CHG POS OTR EMP(W-U)"                                         
   ER10889="E38A MO CHGE POS (WF-U)"                                          
   ER10890="E39 TYPE CHG OTR EMP W-U"                                         
   ER10891="E40 MO BEG OTR EMP(WF-U)"                                         
   ER10892="E40 YR BEG OTR EMP(WF-U)"                                         
   ER10893="E43 STARTING WAGE"                                                
   ER10894="E43 STARTING WAGE PER"                                            
   ER10895="E44 BEG HR/WK OTR EMP WF"                                         
   ER10896="E45 STOP WRK OTR EMP W-U"                                         
   ER10897="E46 MO END OTR EMP(WF-U)"                                         
   ER10898="E46 YR END OTR EMP(WF-U)"                                         
   ER10899="E48 FINAL SAL/WAGE AMT"                                           
   ER10900="E48 FINAL SAL/WAGE PER"                                           
   ER10901="E49 FINAL WAGE"                                                   
   ER10902="E49 FINAL WAGE PER"                                               
   ER10903="E49A END HR/WK OTR EMP W"                                         
   ER10904="E52 WTR OTRS ILL (WF-U)"                                          
   ER10905="E53 DAYS OTHER SICK"                                              
   ER10906="E53 WEEKS OTHER SICK"                                             
   ER10907="E53 MONTHS OTHER SICK"                                            
   ER10908="E55 WTR SELF ILL (WF-U)"                                          
   ER10909="E56 DAYS SELF SICK"                                               
   ER10910="E56 WEEKS SELF SICK"                                              
   ER10911="E56 MONTHS SELF SICK"                                             
   ER10912="E58 WTR VACATION (WF-U)"                                          
   ER10913="E59 DAYS VACATION"                                                
   ER10914="E59 WEEKS VACATION"                                               
   ER10915="E59 MONTHS VACATION"                                              
   ER10916="E61 WTR ON STRIKE (WF-U)"                                         
   ER10917="E62 DAYS STRIKE"                                                  
   ER10918="E62 WEEKS STRIKE"                                                 
   ER10919="E62 MONTHS STRIKE"                                                
   ER10920="E64 WTR UNEMPLOYED (W-U)"                                         
   ER10921="E65 DAYS UNEMPLOYED"                                              
   ER10922="E65 WEEKS UNEMPLOYED"                                             
   ER10923="E65 MONTHS UNEMPLOYED"                                            
   ER10924="E66A UNEMPLOYED JAN"                                              
   ER10925="E66A UNEMPLOYED FEB"                                              
   ER10926="E66A UNEMPLOYED MAR"                                              
   ER10927="E66A UNEMPLOYED APR"                                              
   ER10928="E66A UNEMPLOYED MAY"                                              
   ER10929="E66A UNEMPLOYED JUN"                                              
   ER10930="E66A UNEMPLOYED JUL"                                              
   ER10931="E66A UNEMPLOYED AUG"                                              
   ER10932="E66A UNEMPLOYED SEP"                                              
   ER10933="E66A UNEMPLOYED OCT"                                              
   ER10934="E66A UNEMPLOYED NOV"                                              
   ER10935="E66A UNEMPLOYED DEC"                                              
   ER10936="E67 WTR OUT LAB FRC(W-U)"                                         
   ER10937="E68 DAYS OUT LABOR FORCE"                                         
   ER10938="E68 WEEKS OUT LABOR FORC"                                         
   ER10939="E68 MONTHS OUT LABR FORC"                                         
   ER10940="E69A OUT LABOR FORCE JAN"                                         
   ER10941="E69A OUT LABOR FORCE FEB"                                         
   ER10942="E69A OUT LABOR FORCE MAR"                                         
   ER10943="E69A OUT LABOR FORCE APR"                                         
   ER10944="E69A OUT LABOR FORCE MAY"                                         
   ER10945="E69A OUT LABOR FORCE JUN"                                         
   ER10946="E69A OUT LABOR FORCE JUL"                                         
   ER10947="E69A OUT LABOR FORCE AUG"                                         
   ER10948="E69A OUT LABOR FORCE SEP"                                         
   ER10949="E69A OUT LABOR FORCE OCT"                                         
   ER10950="E69A OUT LABOR FORCE NOV"                                         
   ER10951="E69A OUT LABOR FORCE DEC"                                         
   ER10952="E70 WEEKS WORKED"                                                 
   ER10953="E71 HR/WK WORKED (WF-U)"                                          
   ER10954="E72 WTR WORKED OT (WF-U)"                                         
   ER10955="E73 AMOUNT OVERTIME"                                              
   ER10956="E74 WTR XTRA JOBS (WF-U)"                                         
   ER10957="E75 WORK FOR GOVT?(WF-U)"                                         
   ER10958="E79 AMT MADE XTRA JOB1"                                           
   ER10959="E79 AMT MADE JOB1 PER"                                            
   ER10960="E80 # WKS EXTRA JOB1 W-U"                                         
   ER10961="E81 HR/WK XTRA JOB1(W-U)"                                         
   ER10962="E82 MO BEG XTRA JOB1 W-U"                                         
   ER10963="E82 YR BEG XTRA JOB1 W-U"                                         
   ER10964="E83 WRK XJOB1 JAN  W-U"                                           
   ER10965="E83 WRK XJOB1 FEB  W-U"                                           
   ER10966="E83 WRK XJOB1 MAR  W-U"                                           
   ER10967="E83 WRK XJOB1 APR  W-U"                                           
   ER10968="E83 WRK XJOB1 MAY  W-U"                                           
   ER10969="E83 WRK XJOB1 JUN  W-U"                                           
   ER10970="E83 WRK XJOB1 JUL  W-U"                                           
   ER10971="E83 WRK XJOB1 AUG  W-U"                                           
   ER10972="E83 WRK XJOB1 SEP  W-U"                                           
   ER10973="E83 WRK XJOB1 OCT  W-U"                                           
   ER10974="E83 WRK XJOB1 NOV  W-U"                                           
   ER10975="E83 WRK XJOB1 DEC  W-U"                                           
   ER10976="E84 STOP WORK XJOB1 W-U"                                          
   ER10977="E85 MO END XJOB1 (WF-U)"                                          
   ER10978="E85 YR END XJOB1 (WF-U)"                                          
   ER10979="E87 WRK FOR GOV XJB2 W-U"                                         
   ER10980="E91 AMT MADE XTRA JOB2"                                           
   ER10981="E91 AMT MADE JOB2 PER"                                            
   ER10982="E92 # WK XTRA JOB2+(W-U)"                                         
   ER10983="E93 AV HR/WK X JB2+(W-U)"                                         
   ER10984="E94 MO BEG XJOB2 (W-U)"                                           
   ER10985="E94 YR BEG XJOB2 (W-U)"                                           
   ER10986="E95 WRK XJOB2 JAN  W-U"                                           
   ER10987="E95 WRK XJOB2 FEB  W-U"                                           
   ER10988="E95 WRK XJOB2 MAR  W-U"                                           
   ER10989="E95 WRK XJOB2 APR  W-U"                                           
   ER10990="E95 WRK XJOB2 MAY  W-U"                                           
   ER10991="E95 WRK XJOB2 JUN  W-U"                                           
   ER10992="E95 WRK XJOB2 JUL  W-U"                                           
   ER10993="E95 WRK XJOB2 AUG  W-U"                                           
   ER10994="E95 WRK XJOB2 SEP  W-U"                                           
   ER10995="E95 WRK XJOB2 OCT  W-U"                                           
   ER10996="E95 WRK XJOB2 NOV  W-U"                                           
   ER10997="E95 WRK XJOB2 DEC  W-U"                                           
   ER10998="E96 STOP WORK XJOB2 W-U"                                          
   ER10999="E97 MO END JOB2 (WF-U)"                                           
   ER11000="E97 YR END JOB2 (WF-U)"                                           
   ER11001="E99 WRK FOR GOV XJOB3 WU"                                         
   ER11002="E103 AMT MADE XTRA JOB3"                                          
   ER11003="E103 AMT MADE JOB3 PER"                                           
   ER11004="E104 #WEEKS XTRA JOB3"                                            
   ER11005="E105 HRS/WK XTRA JOB3"                                            
   ER11006="E106 MO BEG XTRA JOB3"                                            
   ER11007="E106 YR BEG XTRA JOB3"                                            
   ER11008="E107 EXTRA JOB3 JAN"                                              
   ER11009="E107 EXTRA JOB3 FEB"                                              
   ER11010="E107 EXTRA JOB3 MAR"                                              
   ER11011="E107 EXTRA JOB3 APR"                                              
   ER11012="E107 EXTRA JOB3 MAY"                                              
   ER11013="E107 EXTRA JOB3 JUN"                                              
   ER11014="E107 EXTRA JOB3 JUL"                                              
   ER11015="E107 EXTRA JOB3 AUG"                                              
   ER11016="E107 EXTRA JOB3 SEP"                                              
   ER11017="E107 EXTRA JOB3 OCT"                                              
   ER11018="E107 EXTRA JOB3 NOV"                                              
   ER11019="E107 EXTRA JOB3 DEC"                                              
   ER11020="E108 STOP WRK XTRA JOB3"                                          
   ER11021="E109 MO END XTRA JOB3"                                            
   ER11022="E109 YR END XTRA JOB3"                                            
   ER11023="E114 WRK FOR GOV XJB4 WU"                                         
   ER11024="E115 AMT MADE XTRA JOB4"                                          
   ER11025="E115 AMT MADE JOB4 PER"                                           
   ER11026="E116 #WEEKS XTRA JOB4"                                            
   ER11027="E117 HRS/WK XTRA JOB4"                                            
   ER11028="E118 MO BEG XTRA JOB4"                                            
   ER11029="E118 YR BEG XTRA JOB4"                                            
   ER11030="E119 EXTRA JOB4 JAN"                                              
   ER11031="E119 EXTRA JOB4 FEB"                                              
   ER11032="E119 EXTRA JOB4 MAR"                                              
   ER11033="E119 EXTRA JOB4 APR"                                              
   ER11034="E119 EXTRA JOB4 MAY"                                              
   ER11035="E119 EXTRA JOB4 JUN"                                              
   ER11036="E119 EXTRA JOB4 JUL"                                              
   ER11037="E119 EXTRA JOB4 AUG"                                              
   ER11038="E119 EXTRA JOB4 SEP"                                              
   ER11039="E119 EXTRA JOB4 OCT"                                              
   ER11040="E119 EXTRA JOB4 NOV"                                              
   ER11041="E119 EXTRA JOB4 DEC"                                              
   ER11042="E120 STOP WRK XTRA JOB4"                                          
   ER11043="E121 MO END XTRA JOB4"                                            
   ER11044="E121 YR END XTRA JOB4"                                            
   ER11045="F2 HOUSEWORK HRS-WIFE"                                            
   ER11046="F3 HOUSEWORK HOURS-HEAD"                                          
   ER11047="F5 FAM TOGETHR MAIN MEAL"                                         
   ER11048="F7 COST CHILD CARE    19"                                         
   ER11049="F8 REC FOOD STAMPS PYR"                                           
   ER11050="F9 $ FD STMPS RECD PYR"                                           
   ER11051="F9 $ FD STMPS RECD PER"                                           
   ER11052="USE FOOD STAMPS JAN"                                              
   ER11053="USE FOOD STAMPS FEB"                                              
   ER11054="USE FOOD STAMPS MAR"                                              
   ER11055="USE FOOD STAMPS APR"                                              
   ER11056="USE FOOD STAMPS MAY"                                              
   ER11057="USE FOOD STAMPS JUN"                                              
   ER11058="USE FOOD STAMPS JUL"                                              
   ER11059="USE FOOD STAMPS AUG"                                              
   ER11060="USE FOOD STAMPS SEP"                                              
   ER11061="USE FOOD STAMPS OCT"                                              
   ER11062="USE FOOD STAMPS NOV"                                              
   ER11063="USE FOOD STAMPS DEC"                                              
   ER11064="F11 USE STAMPS LAST MON"                                          
   ER11065="F12 FOR HOW MANY PEOPLE"                                          
   ER11066="F13 AMT STAMPS LAST MON"                                          
   ER11067="F14 BUY FOOD NOT FD STMP"                                         
   ER11068="F15$SPENT NOT FDSTMP AMT"                                         
   ER11069="F15$SPENT NOT FDSTMP PER"                                         
   ER11070="F16 ANY FOOD DELIVERED"                                           
   ER11071="F17 AMT FD DELIVERD"                                              
   ER11072="F17 AMT FD DELIVERD PER"                                          
   ER11073="F18 AMT EATING OUT"                                               
   ER11074="F18 AMT EATING OUT PER"                                           
   ER11075="F18A  WTR $ FOR  FOOD"                                            
   ER11076="F19 AMT SPENT ON FOOD"                                            
   ER11077="F19 $ SPENT ON FOOD PER"                                          
   ER11078="F20 ANY FOOD DELIVERED"                                           
   ER11079="F21 AMT FD DELIVERED"                                             
   ER11080="F21 AMT FD DELIVERED PER"                                         
   ER11081="F22 AMT EATING OUT"                                               
   ER11082="F22 AMT EATING OUT PER"                                           
   ER11083="F23 WTR $ FOR MORE FOOD"                                          
   ER11084="G1A WHETHER HEAD FARMER"                                          
   ER11085="G2 TOTAL FARM RECEIPTS"                                           
   ER11086="G3 PYR FARM EXPENSES"                                             
   ER11087="G4 PYR NET FARM INCOME"                                           
   ER11088="G5 WHETHER BUSINESS"                                              
   ER11089="G8 HEAD OWN BUSINESS 1?"                                          
   ER11090="G8 WIFE OWN BUSINESS 1?"                                          
   ER11091="G8OTR RELATIVE OWN BUS1?"                                         
   ER11092="G8OTHER PERSON OWN BUS1?"                                         
   ER11093="HEAD WORK IN BUSINESS 1"                                          
   ER11094="HEAD REPORT HRS BUSNS 1"                                          
   ER11095="WIFE WORK IN BUSINESS 1"                                          
   ER11096="WIFE REPORT HRS BUSNS 1"                                          
   ER11097="G10 CORP/UNINCORP BUS1"                                           
   ER11098="G11PROFIT/LOSS/EVEN BUS1"                                         
   ER11099="G11A PROFIT BUSINESS  1"                                          
   ER11100="G11B LOSS BUSINESS1"                                              
   ER11101="G8 HEAD OWN BUSINESS 2?"                                          
   ER11102="G8 WIFE OWN BUSINESS 2?"                                          
   ER11103="G8OTR RELATIVE OWN BUS2?"                                         
   ER11104="G8OTHER PERSON OWN BUS2?"                                         
   ER11105="HEAD WORK IN BUSINESS 2"                                          
   ER11106="HEAD REPORT HRS BUSNS 2"                                          
   ER11107="WIFE WORK IN BUSINESS 2"                                          
   ER11108="WIFE REPORT HRS BUSNS 2"                                          
   ER11109="G10 CORP/UNINCORP BUS2"                                           
   ER11110="G11PROFIT/LOSS/EVEN BUS2"                                         
   ER11111="G11A PROFIT BUSINESS  2"                                          
   ER11112="G11B LOSS BUSINESS2"                                              
   ER11113="G8 HEAD OWN BUSINESS 3?"                                          
   ER11114="G8 WIFE OWN BUSINESS 3?"                                          
   ER11115="G8OTR RELATIVE OWN BUS3?"                                         
   ER11116="G8OTHER PERSON OWN BUS3?"                                         
   ER11117="HEAD WORK IN BUSINESS 3"                                          
   ER11118="HEAD REPORT HRS BUSNS 3"                                          
   ER11119="WIFE WORK IN BUSINESS 3"                                          
   ER11120="WIFE REPORT HRS BUSNS 3"                                          
   ER11121="G10 CORP/UNINCORP BUS3"                                           
   ER11122="G11PROFIT/LOSS/EVEN BUS3"                                         
   ER11123="G11A PROFIT BUSINESS  3"                                          
   ER11124="G11B LOSS BUSINESS3"                                              
   ER11125="G8 HEAD OWN BUSINESS 4?"                                          
   ER11126="G8 WIFE OWN BUSINESS 4?"                                          
   ER11127="G8OTR RELATIVE OWN BUS4?"                                         
   ER11128="G8OTHER PERSON OWN BUS4?"                                         
   ER11129="HEAD WORK IN BUSINESS 4"                                          
   ER11130="HEAD REPORT HRS BUSNS 4"                                          
   ER11131="WIFE WORK IN BUSINESS 4"                                          
   ER11132="WIFE REPORT HRS BUSNS 4"                                          
   ER11133="G10 CORP/UNINCORP BUS4"                                           
   ER11134="G11PROFIT/LOSS/EVEN BUS4"                                         
   ER11135="G11A PROFIT BUSINESS  4"                                          
   ER11136="G11B LOSS BUSINESS4"                                              
   ER11137="G8 HEAD OWN BUSINESS 5?"                                          
   ER11138="G8 WIFE OWN BUSINESS 5?"                                          
   ER11139="G8OTR RELATIVE OWN BUS5?"                                         
   ER11140="G8OTHER PERSON OWN BUS5?"                                         
   ER11141="HEAD WORK IN BUSINESS 5"                                          
   ER11142="HEAD REPORT HRS BUSNS 5"                                          
   ER11143="WIFE WORK IN BUSINESS 5"                                          
   ER11144="WIFE REPORT HRS BUSNS 5"                                          
   ER11145="G10 CORP/UNINCORP BUS5"                                           
   ER11146="G11PROFIT/LOSS/EVEN BUS5"                                         
   ER11147="G11A PROFIT BUSINESS  5"                                          
   ER11148="G11B LOSS BUSINESS5"                                              
   ER11149="G12 HEAD HAVE WAGES"                                              
   ER11150="G13 WAGES/SALARY OF HEAD"                                         
   ER11151="G14/16 HD BONUS/OT/COMM"                                          
   ER11152="HEAD HAVE BONUS"                                                  
   ER11153="HEAD HAVE OVERTIME"                                               
   ER11154="HEAD HAVE TIPS"                                                   
   ER11155="HEAD HAVE COMMISSION"                                             
   ER11156="HEAD HAVE OTHER"                                                  
   ER11157="AMT HEAD BONUS"                                                   
   ER11158="AMT HEAD OVERTIME"                                                
   ER11159="AMT HEAD TIPS"                                                    
   ER11160="AMT HEAD COMMISSION"                                              
   ER11161="AMT HEAD OTHER"                                                   
   ER11162="WTR HEAD PROF PRACT"                                              
   ER11163="AMT PROF PRACTICE OF HD"                                          
   ER11164="AMT PROF PRACTICE PER"                                            
   ER11165="PROF/TRADE INCOME H JAN"                                          
   ER11166="PROF/TRADE INCOME H FEB"                                          
   ER11167="PROF/TRADE INCOME H MAR"                                          
   ER11168="PROF/TRADE INCOME H APR"                                          
   ER11169="PROF/TRADE INCOME H MAY"                                          
   ER11170="PROF/TRADE INCOME H JUN"                                          
   ER11171="PROF/TRADE INCOME H JUL"                                          
   ER11172="PROF/TRADE INCOME H AUG"                                          
   ER11173="PROF/TRADE INCOME H SEP"                                          
   ER11174="PROF/TRADE INCOME H OCT"                                          
   ER11175="PROF/TRADE INCOME H NOV"                                          
   ER11176="PROF/TRADE INCOME H DEC"                                          
   ER11177="WORK HRS FOR PROF PRAC"                                           
   ER11178="WTR HEAD MKT GDNING"                                              
   ER11179="AMT MKT GARDENING OF HD"                                          
   ER11180="AMT MKT GARDENING PER"                                            
   ER11181="GARDEN/FARM INCOME H JAN"                                         
   ER11182="GARDEN/FARM INCOME H FEB"                                         
   ER11183="GARDEN/FARM INCOME H MAR"                                         
   ER11184="GARDEN/FARM INCOME H APR"                                         
   ER11185="GARDEN/FARM INCOME H MAY"                                         
   ER11186="GARDEN/FARM INCOME H JUN"                                         
   ER11187="GARDEN/FARM INCOME H JUL"                                         
   ER11188="GARDEN/FARM INCOME H AUG"                                         
   ER11189="GARDEN/FARM INCOME H SEP"                                         
   ER11190="GARDEN/FARM INCOME H OCT"                                         
   ER11191="GARDEN/FARM INCOME H NOV"                                         
   ER11192="GARDEN/FARM INCOME H DEC"                                         
   ER11193="WORK HRS FOR MKT GRDNG"                                           
   ER11194="WTR HEAD ROOMERS"                                                 
   ER11195="AMT ROOMERS/BOARDERS HD"                                          
   ER11196="AMT ROOMERS/BOARDERS PER"                                         
   ER11197="ROOM/BORD INCOME H JAN"                                           
   ER11198="ROOM/BORD INCOME H FEB"                                           
   ER11199="ROOM/BORD INCOME H MAR"                                           
   ER11200="ROOM/BORD INCOME H APR"                                           
   ER11201="ROOM/BORD INCOME H MAY"                                           
   ER11202="ROOM/BORD INCOME H JUN"                                           
   ER11203="ROOM/BORD INCOME H JUL"                                           
   ER11204="ROOM/BORD INCOME H AUG"                                           
   ER11205="ROOM/BORD INCOME H SEP"                                           
   ER11206="ROOM/BORD INCOME H OCT"                                           
   ER11207="ROOM/BORD INCOME H NOV"                                           
   ER11208="ROOM/BORD INCOME H DEC"                                           
   ER11209="WORK HRS FOR ROOMERS"                                             
   ER11210="INCL EARNINGS XTRA JOB"                                           
   ER11211="AMT FROM XTRA JOBS"                                               
   ER11212="WHETHER RENT HEAD"                                                
   ER11213="RENT OF HEAD"                                                     
   ER11214="RENT OF HEAD PER"                                                 
   ER11215="RENT INCOME HEAD JAN"                                             
   ER11216="RENT INCOME HEAD FEB"                                             
   ER11217="RENT INCOME HEAD MAR"                                             
   ER11218="RENT INCOME HEAD APR"                                             
   ER11219="RENT INCOME HEAD MAY"                                             
   ER11220="RENT INCOME HEAD JUN"                                             
   ER11221="RENT INCOME HEAD JUL"                                             
   ER11222="RENT INCOME HEAD AUG"                                             
   ER11223="RENT INCOME HEAD SEP"                                             
   ER11224="RENT INCOME HEAD OCT"                                             
   ER11225="RENT INCOME HEAD NOV"                                             
   ER11226="RENT INCOME HEAD DEC"                                             
   ER11227="WHETHER DIVIDENDS HEAD"                                           
   ER11228="DIVIDENDS OF HEAD"                                                
   ER11229="DIVIDENDS OF HEAD PER"                                            
   ER11230="DIVIDEND INCOME HEAD JAN"                                         
   ER11231="DIVIDEND INCOME HEAD FEB"                                         
   ER11232="DIVIDEND INCOME HEAD MAR"                                         
   ER11233="DIVIDEND INCOME HEAD APR"                                         
   ER11234="DIVIDEND INCOME HEAD MAY"                                         
   ER11235="DIVIDEND INCOME HEAD JUN"                                         
   ER11236="DIVIDEND INCOME HEAD JUL"                                         
   ER11237="DIVIDEND INCOME HEAD AUG"                                         
   ER11238="DIVIDEND INCOME HEAD SEP"                                         
   ER11239="DIVIDEND INCOME HEAD OCT"                                         
   ER11240="DIVIDEND INCOME HEAD NOV"                                         
   ER11241="DIVIDEND INCOME HEAD DEC"                                         
   ER11242="WHETHER INTEREST HEAD"                                            
   ER11243="INTEREST OF HEAD"                                                 
   ER11244="INTEREST OF HEAD PER"                                             
   ER11245="INTEREST INCOME HEAD JAN"                                         
   ER11246="INTEREST INCOME HEAD FEB"                                         
   ER11247="INTEREST INCOME HEAD MAR"                                         
   ER11248="INTEREST INCOME HEAD APR"                                         
   ER11249="INTEREST INCOME HEAD MAY"                                         
   ER11250="INTEREST INCOME HEAD JUN"                                         
   ER11251="INTEREST INCOME HEAD JUL"                                         
   ER11252="INTEREST INCOME HEAD AUG"                                         
   ER11253="INTEREST INCOME HEAD SEP"                                         
   ER11254="INTEREST INCOME HEAD OCT"                                         
   ER11255="INTEREST INCOME HEAD NOV"                                         
   ER11256="INTEREST INCOME HEAD DEC"                                         
   ER11257="WHETHER TRUST FUND HEAD"                                          
   ER11258="TRUST FUND OF HEAD"                                               
   ER11259="TRUST FUND OF HEAD PER"                                           
   ER11260="TRUST/ROYAL INCOME H JAN"                                         
   ER11261="TRUST/ROYAL INCOME H FEB"                                         
   ER11262="TRUST/ROYAL INCOME H MAR"                                         
   ER11263="TRUST/ROYAL INCOME H APR"                                         
   ER11264="TRUST/ROYAL INCOME H MAY"                                         
   ER11265="TRUST/ROYAL INCOME H JUN"                                         
   ER11266="TRUST/ROYAL INCOME H JUL"                                         
   ER11267="TRUST/ROYAL INCOME H AUG"                                         
   ER11268="TRUST/ROYAL INCOME H SEP"                                         
   ER11269="TRUST/ROYAL INCOME H OCT"                                         
   ER11270="TRUST/ROYAL INCOME H NOV"                                         
   ER11271="TRUST/ROYAL INCOME H DEC"                                         
   ER11272="WHETHER ADC/AFDC HEAD"                                            
   ER11273="ADC/AFDC OF HEAD"                                                 
   ER11274="ADC/AFDC OF HEAD PER"                                             
   ER11275="ADC/AFDC INCOME HEAD JAN"                                         
   ER11276="ADC/AFDC INCOME HEAD FEB"                                         
   ER11277="ADC/AFDC INCOME HEAD MAR"                                         
   ER11278="ADC/AFDC INCOME HEAD APR"                                         
   ER11279="ADC/AFDC INCOME HEAD MAY"                                         
   ER11280="ADC/AFDC INCOME HEAD JUN"                                         
   ER11281="ADC/AFDC INCOME HEAD JUL"                                         
   ER11282="ADC/AFDC INCOME HEAD AUG"                                         
   ER11283="ADC/AFDC INCOME HEAD SEP"                                         
   ER11284="ADC/AFDC INCOME HEAD OCT"                                         
   ER11285="ADC/AFDC INCOME HEAD NOV"                                         
   ER11286="ADC/AFDC INCOME HEAD DEC"                                         
   ER11287="WHETHER SSI HEAD"                                                 
   ER11288="HEAD SSI SELF/ELSE/BOTH"                                          
   ER11289="SSI OF HEAD"                                                      
   ER11290="SSI OF HEAD PER"                                                  
   ER11291="SSI INCOME HEAD JAN"                                              
   ER11292="SSI INCOME HEAD FEB"                                              
   ER11293="SSI INCOME HEAD MAR"                                              
   ER11294="SSI INCOME HEAD APR"                                              
   ER11295="SSI INCOME HEAD MAY"                                              
   ER11296="SSI INCOME HEAD JUN"                                              
   ER11297="SSI INCOME HEAD JUL"                                              
   ER11298="SSI INCOME HEAD AUG"                                              
   ER11299="SSI INCOME HEAD SEP"                                              
   ER11300="SSI INCOME HEAD OCT"                                              
   ER11301="SSI INCOME HEAD NOV"                                              
   ER11302="SSI INCOME HEAD DEC"                                              
   ER11303="WHETHER OTHER WELFARE HD"                                         
   ER11304="OTHER WELFARE OF HEAD"                                            
   ER11305="OTHER WELFARE OF HD PER"                                          
   ER11306="OTH WELFARE INCOME H JAN"                                         
   ER11307="OTH WELFARE INCOME H FEB"                                         
   ER11308="OTH WELFARE INCOME H MAR"                                         
   ER11309="OTH WELFARE INCOME H APR"                                         
   ER11310="OTH WELFARE INCOME H MAY"                                         
   ER11311="OTH WELFARE INCOME H JUN"                                         
   ER11312="OTH WELFARE INCOME H JUL"                                         
   ER11313="OTH WELFARE INCOME H AUG"                                         
   ER11314="OTH WELFARE INCOME H SEP"                                         
   ER11315="OTH WELFARE INCOME H OCT"                                         
   ER11316="OTH WELFARE INCOME H NOV"                                         
   ER11317="OTH WELFARE INCOME H DEC"                                         
   ER11318="ANY FU MEMB GET SOCSEC"                                           
   ER11319="WHETHER HEAD VA PENSION"                                          
   ER11320="G37 WTR HEAD VA PENSION2"                                         
   ER11321="G37 WTR HEAD VA PENSION3"                                         
   ER11322="VA PENSION OF HEAD AMT"                                           
   ER11323="VA PENSION OF HEAD PER"                                           
   ER11324="VA INCOME HEAD JAN"                                               
   ER11325="VA INCOME HEAD FEB"                                               
   ER11326="VA INCOME HEAD MAR"                                               
   ER11327="VA INCOME HEAD APR"                                               
   ER11328="VA INCOME HEAD MAY"                                               
   ER11329="VA INCOME HEAD JUN"                                               
   ER11330="VA INCOME HEAD JUL"                                               
   ER11331="VA INCOME HEAD AUG"                                               
   ER11332="VA INCOME HEAD SEP"                                               
   ER11333="VA INCOME HEAD OCT"                                               
   ER11334="VA INCOME HEAD NOV"                                               
   ER11335="VA INCOME HEAD DEC"                                               
   ER11336="WTR NONVA RETIREMT-HEAD"                                          
   ER11337="NONVA RETIREMENT-HEAD"                                            
   ER11338="NONVA RETIREMENT PER-HD"                                          
   ER11339="RETIREMENT INCOME H JAN"                                          
   ER11340="RETIREMENT INCOME H FEB"                                          
   ER11341="RETIREMENT INCOME H MAR"                                          
   ER11342="RETIREMENT INCOME H APR"                                          
   ER11343="RETIREMENT INCOME H MAY"                                          
   ER11344="RETIREMENT INCOME H JUN"                                          
   ER11345="RETIREMENT INCOME H JUL"                                          
   ER11346="RETIREMENT INCOME H AUG"                                          
   ER11347="RETIREMENT INCOME H SEP"                                          
   ER11348="RETIREMENT INCOME H OCT"                                          
   ER11349="RETIREMENT INCOME H NOV"                                          
   ER11350="RETIREMENT INCOME H DEC"                                          
   ER11351="WHETHER HEAD ANNUITIES"                                           
   ER11352="ANNUITIES OF HEAD"                                                
   ER11353="ANNUITIES OF HEAD PER"                                            
   ER11354="ANNUITIES INCOME JAN"                                             
   ER11355="ANNUITIES INCOME FEB"                                             
   ER11356="ANNUITIES INCOME MAR"                                             
   ER11357="ANNUITIES INCOME APR"                                             
   ER11358="ANNUITIES INCOME MAY"                                             
   ER11359="ANNUITIES INCOME JUN"                                             
   ER11360="ANNUITIES INCOME JUL"                                             
   ER11361="ANNUITIES INCOME AUG"                                             
   ER11362="ANNUITIES INCOME SEP"                                             
   ER11363="ANNUITIES INCOME OCT"                                             
   ER11364="ANNUITIES INCOME NOV"                                             
   ER11365="ANNUITIES INCOME DEC"                                             
   ER11366="WHETHER HEAD OTR PENSION"                                         
   ER11367="OTHER PENSION OF HEAD"                                            
   ER11368="OTHER PENSION OF HD PER"                                          
   ER11369="OTR PENSION HEAD JAN"                                             
   ER11370="OTR PENSION HEAD FEB"                                             
   ER11371="OTR PENSION HEAD MAR"                                             
   ER11372="OTR PENSION HEAD APR"                                             
   ER11373="OTR PENSION HEAD MAY"                                             
   ER11374="OTR PENSION HEAD JUN"                                             
   ER11375="OTR PENSION HEAD JUL"                                             
   ER11376="OTR PENSION HEAD AUG"                                             
   ER11377="OTR PENSION HEAD SEP"                                             
   ER11378="OTR PENSION HEAD OCT"                                             
   ER11379="OTR PENSION HEAD NOV"                                             
   ER11380="OTR PENSION HEAD DEC"                                             
   ER11381="NUM OF HEAD NON VA PENSN"                                         
   ER11382="WTR UNEMPL COMP OF HEAD"                                          
   ER11383="AMT UNEMPL COMP OF HEAD"                                          
   ER11384="AMT UNEMPL COMP HD PER"                                           
   ER11385="UNEMPLOY INCOME HEAD JAN"                                         
   ER11386="UNEMPLOY INCOME HEAD FEB"                                         
   ER11387="UNEMPLOY INCOME HEAD MAR"                                         
   ER11388="UNEMPLOY INCOME HEAD APR"                                         
   ER11389="UNEMPLOY INCOME HEAD MAY"                                         
   ER11390="UNEMPLOY INCOME HEAD JUN"                                         
   ER11391="UNEMPLOY INCOME HEAD JUL"                                         
   ER11392="UNEMPLOY INCOME HEAD AUG"                                         
   ER11393="UNEMPLOY INCOME HEAD SEP"                                         
   ER11394="UNEMPLOY INCOME HEAD OCT"                                         
   ER11395="UNEMPLOY INCOME HEAD NOV"                                         
   ER11396="UNEMPLOY INCOME HEAD DEC"                                         
   ER11397="WTR WORKMEN COMP OF HEAD"                                         
   ER11398="AMT WORKMEN COMP OF HEAD"                                         
   ER11399="AMT WORKMEN COMP HD PER"                                          
   ER11400="WORKER COMP INCOME H JAN"                                         
   ER11401="WORKER COMP INCOME H FEB"                                         
   ER11402="WORKER COMP INCOME H MAR"                                         
   ER11403="WORKER COMP INCOME H APR"                                         
   ER11404="WORKER COMP INCOME H MAY"                                         
   ER11405="WORKER COMP INCOME H JUN"                                         
   ER11406="WORKER COMP INCOME H JUL"                                         
   ER11407="WORKER COMP INCOME H AUG"                                         
   ER11408="WORKER COMP INCOME H SEP"                                         
   ER11409="WORKER COMP INCOME H OCT"                                         
   ER11410="WORKER COMP INCOME H NOV"                                         
   ER11411="WORKER COMP INCOME H DEC"                                         
   ER11412="WTR CHILD SUPPORT OF HD"                                          
   ER11413="AMT CHILD SUPPORT OF HD"                                          
   ER11414="AMT CHILD SUPPORT HD PER"                                         
   ER11415="CHILD SUPPORT INC H JAN"                                          
   ER11416="CHILD SUPPORT INC H FEB"                                          
   ER11417="CHILD SUPPORT INC H MAR"                                          
   ER11418="CHILD SUPPORT INC H APR"                                          
   ER11419="CHILD SUPPORT INC H MAY"                                          
   ER11420="CHILD SUPPORT INC H JUN"                                          
   ER11421="CHILD SUPPORT INC H JUL"                                          
   ER11422="CHILD SUPPORT INC H AUG"                                          
   ER11423="CHILD SUPPORT INC H SEP"                                          
   ER11424="CHILD SUPPORT INC H OCT"                                          
   ER11425="CHILD SUPPORT INC H NOV"                                          
   ER11426="CHILD SUPPORT INC H DEC"                                          
   ER11427="WTR ALIMONY OF HEAD"                                              
   ER11428="AMT ALIMONY OF HEAD"                                              
   ER11429="AMT ALIMONY OF HEAD PER"                                          
   ER11430="ALIMONY INCOME HEAD JAN"                                          
   ER11431="ALIMONY INCOME HEAD FEB"                                          
   ER11432="ALIMONY INCOME HEAD MAR"                                          
   ER11433="ALIMONY INCOME HEAD APR"                                          
   ER11434="ALIMONY INCOME HEAD MAY"                                          
   ER11435="ALIMONY INCOME HEAD JUN"                                          
   ER11436="ALIMONY INCOME HEAD JUL"                                          
   ER11437="ALIMONY INCOME HEAD AUG"                                          
   ER11438="ALIMONY INCOME HEAD SEP"                                          
   ER11439="ALIMONY INCOME HEAD OCT"                                          
   ER11440="ALIMONY INCOME HEAD NOV"                                          
   ER11441="ALIMONY INCOME HEAD DEC"                                          
   ER11442="WTRHELP FRM RELATIV HEAD"                                         
   ER11443="AMT HELP FRM RELATIV HD"                                          
   ER11444="AMT HELP FRM RELATIV PER"                                         
   ER11445="HELP FROM RELATIVE H JAN"                                         
   ER11446="HELP FROM RELATIVE H FEB"                                         
   ER11447="HELP FROM RELATIVE H MAR"                                         
   ER11448="HELP FROM RELATIVE H APR"                                         
   ER11449="HELP FROM RELATIVE H MAY"                                         
   ER11450="HELP FROM RELATIVE H JUN"                                         
   ER11451="HELP FROM RELATIVE H JUL"                                         
   ER11452="HELP FROM RELATIVE H AUG"                                         
   ER11453="HELP FROM RELATIVE H SEP"                                         
   ER11454="HELP FROM RELATIVE H OCT"                                         
   ER11455="HELP FROM RELATIVE H NOV"                                         
   ER11456="HELP FROM RELATIVE H DEC"                                         
   ER11457="WTR HELP FRM OTHERS HEAD"                                         
   ER11458="AMT HELP FRM OTHERS HD"                                           
   ER11459="AMT HELP FRM OTHERS PER"                                          
   ER11460="HELP FROM OTHERS H JAN"                                           
   ER11461="HELP FROM OTHERS H FEB"                                           
   ER11462="HELP FROM OTHERS H MAR"                                           
   ER11463="HELP FROM OTHERS H APR"                                           
   ER11464="HELP FROM OTHERS H MAY"                                           
   ER11465="HELP FROM OTHERS H JUN"                                           
   ER11466="HELP FROM OTHERS H JUL"                                           
   ER11467="HELP FROM OTHERS H AUG"                                           
   ER11468="HELP FROM OTHERS H SEP"                                           
   ER11469="HELP FROM OTHERS H OCT"                                           
   ER11470="HELP FROM OTHERS H NOV"                                           
   ER11471="HELP FROM OTHERS H DEC"                                           
   ER11472="WTR ANYTHING ELSE OF HD"                                          
   ER11473="AMT ANYTHING ELSE OF HD"                                          
   ER11474="AMT ANYTHING ELSE PER"                                            
   ER11475="ANY OTHER INCOME H JAN"                                           
   ER11476="ANY OTHER INCOME H FEB"                                           
   ER11477="ANY OTHER INCOME H MAR"                                           
   ER11478="ANY OTHER INCOME H APR"                                           
   ER11479="ANY OTHER INCOME H MAY"                                           
   ER11480="ANY OTHER INCOME H JUN"                                           
   ER11481="ANY OTHER INCOME H JUL"                                           
   ER11482="ANY OTHER INCOME H AUG"                                           
   ER11483="ANY OTHER INCOME H SEP"                                           
   ER11484="ANY OTHER INCOME H OCT"                                           
   ER11485="ANY OTHER INCOME H NOV"                                           
   ER11486="ANY OTHER INCOME H DEC"                                           
   ER11487="G49 WTR WIFE IN FU NOW"                                           
   ER11488="WHETHER WIFE HAD INCOME"                                          
   ER11489="WHETHER WIFE LABOR INC"                                           
   ER11490="WHETHER WFE INC FRM WORK"                                         
   ER11491="WAGES/SALARY OF WIFE"                                             
   ER11492="WTR WORK HOURS FOR WIFE"                                          
   ER11493="WHETHER UNEMPLOYMENT WFE"                                         
   ER11494="UNEMPLOYMNT COMP OF WIFE"                                         
   ER11495="UNEMPLOYMNT COMP WFE PER"                                         
   ER11496="UNEMPLOY INCOME WIFE JAN"                                         
   ER11497="UNEMPLOY INCOME WIFE FEB"                                         
   ER11498="UNEMPLOY INCOME WIFE MAR"                                         
   ER11499="UNEMPLOY INCOME WIFE APR"                                         
   ER11500="UNEMPLOY INCOME WIFE MAY"                                         
   ER11501="UNEMPLOY INCOME WIFE JUN"                                         
   ER11502="UNEMPLOY INCOME WIFE JUL"                                         
   ER11503="UNEMPLOY INCOME WIFE AUG"                                         
   ER11504="UNEMPLOY INCOME WIFE SEP"                                         
   ER11505="UNEMPLOY INCOME WIFE OCT"                                         
   ER11506="UNEMPLOY INCOME WIFE NOV"                                         
   ER11507="UNEMPLOY INCOME WIFE DEC"                                         
   ER11508="WHETHER WORKMEN COMP WFE"                                         
   ER11509="WORKMEN COMP OF WIFE"                                             
   ER11510="WORKMEN COMP OF WIFE PER"                                         
   ER11511="WORKER COMP INCOME W JAN"                                         
   ER11512="WORKER COMP INCOME W FEB"                                         
   ER11513="WORKER COMP INCOME W MAR"                                         
   ER11514="WORKER COMP INCOME W APR"                                         
   ER11515="WORKER COMP INCOME W MAY"                                         
   ER11516="WORKER COMP INCOME W JUN"                                         
   ER11517="WORKER COMP INCOME W JUL"                                         
   ER11518="WORKER COMP INCOME W AUG"                                         
   ER11519="WORKER COMP INCOME W SEP"                                         
   ER11520="WORKER COMP INCOME W OCT"                                         
   ER11521="WORKER COMP INCOME W NOV"                                         
   ER11522="WORKER COMP INCOME W DEC"                                         
   ER11523="WHETHER WIFE DIVIDENDS"                                           
   ER11524="DIVIDENDS OF WIFE AMT"                                            
   ER11525="DIVIDENDS OF WIFE PER"                                            
   ER11526="DIVIDEND INCOME WIFE JAN"                                         
   ER11527="DIVIDEND INCOME WIFE FEB"                                         
   ER11528="DIVIDEND INCOME WIFE MAR"                                         
   ER11529="DIVIDEND INCOME WIFE APR"                                         
   ER11530="DIVIDEND INCOME WIFE MAY"                                         
   ER11531="DIVIDEND INCOME WIFE JUN"                                         
   ER11532="DIVIDEND INCOME WIFE JUL"                                         
   ER11533="DIVIDEND INCOME WIFE AUG"                                         
   ER11534="DIVIDEND INCOME WIFE SEP"                                         
   ER11535="DIVIDEND INCOME WIFE OCT"                                         
   ER11536="DIVIDEND INCOME WIFE NOV"                                         
   ER11537="DIVIDEND INCOME WIFE DEC"                                         
   ER11538="WHETHER WIFE INTEREST"                                            
   ER11539="INTEREST OF WIFE AMT"                                             
   ER11540="INTEREST OF WIFE AMT PER"                                         
   ER11541="INTEREST INCOME WIFE JAN"                                         
   ER11542="INTEREST INCOME WIFE FEB"                                         
   ER11543="INTEREST INCOME WIFE MAR"                                         
   ER11544="INTEREST INCOME WIFE APR"                                         
   ER11545="INTEREST INCOME WIFE MAY"                                         
   ER11546="INTEREST INCOME WIFE JUN"                                         
   ER11547="INTEREST INCOME WIFE JUL"                                         
   ER11548="INTEREST INCOME WIFE AUG"                                         
   ER11549="INTEREST INCOME WIFE SEP"                                         
   ER11550="INTEREST INCOME WIFE OCT"                                         
   ER11551="INTEREST INCOME WIFE NOV"                                         
   ER11552="INTEREST INCOME WIFE DEC"                                         
   ER11553="WHETHER WIFE TRUST FUND"                                          
   ER11554="TRUST FUND OF WIFE AMT"                                           
   ER11555="TRUST FUND OF WIFE PER"                                           
   ER11556="TRUST INCOME WIFE JAN"                                            
   ER11557="TRUST INCOME WIFE FEB"                                            
   ER11558="TRUST INCOME WIFE MAR"                                            
   ER11559="TRUST INCOME WIFE APR"                                            
   ER11560="TRUST INCOME WIFE MAY"                                            
   ER11561="TRUST INCOME WIFE JUN"                                            
   ER11562="TRUST INCOME WIFE JUL"                                            
   ER11563="TRUST INCOME WIFE AUG"                                            
   ER11564="TRUST INCOME WIFE SEP"                                            
   ER11565="TRUST INCOME WIFE OCT"                                            
   ER11566="TRUST INCOME WIFE NOV"                                            
   ER11567="TRUST INCOME WIFE DEC"                                            
   ER11568="WHETHER WIFE OTHER ASSET"                                         
   ER11569="OTHER ASSETS OF WIFE"                                             
   ER11570="OTHER ASSETS OF WIFE PER"                                         
   ER11571="OTHER ASSET INCOME W JAN"                                         
   ER11572="OTHER ASSET INCOME W FEB"                                         
   ER11573="OTHER ASSET INCOME W MAR"                                         
   ER11574="OTHER ASSET INCOME W APR"                                         
   ER11575="OTHER ASSET INCOME W MAY"                                         
   ER11576="OTHER ASSET INCOME W JUN"                                         
   ER11577="OTHER ASSET INCOME W JUL"                                         
   ER11578="OTHER ASSET INCOME W AUG"                                         
   ER11579="OTHER ASSET INCOME W SEP"                                         
   ER11580="OTHER ASSET INCOME W OCT"                                         
   ER11581="OTHER ASSET INCOME W NOV"                                         
   ER11582="OTHER ASSET INCOME W DEC"                                         
   ER11583="WHETHER WIFE RECD SSI"                                            
   ER11584="WIFE SSI SELF/ELSE/BOTH"                                          
   ER11585="SSI OF WIFE AMT"                                                  
   ER11586="SSI OF WIFE AMT PER"                                              
   ER11587="SSI INCOME WIFE JAN"                                              
   ER11588="SSI INCOME WIFE FEB"                                              
   ER11589="SSI INCOME WIFE MAR"                                              
   ER11590="SSI INCOME WIFE APR"                                              
   ER11591="SSI INCOME WIFE MAY"                                              
   ER11592="SSI INCOME WIFE JUN"                                              
   ER11593="SSI INCOME WIFE JUL"                                              
   ER11594="SSI INCOME WIFE AUG"                                              
   ER11595="SSI INCOME WIFE SEP"                                              
   ER11596="SSI INCOME WIFE OCT"                                              
   ER11597="SSI INCOME WIFE NOV"                                              
   ER11598="SSI INCOME WIFE DEC"                                              
   ER11599="WTR WIFE RECD ADC/AFDC"                                           
   ER11600="ADC/AFDC OF WIFE AMT"                                             
   ER11601="ADC/AFDC OF WIFE AMT PER"                                         
   ER11602="ADC/AFDC INCOME WIFE JAN"                                         
   ER11603="ADC/AFDC INCOME WIFE FEB"                                         
   ER11604="ADC/AFDC INCOME WIFE MAR"                                         
   ER11605="ADC/AFDC INCOME WIFE APR"                                         
   ER11606="ADC/AFDC INCOME WIFE MAY"                                         
   ER11607="ADC/AFDC INCOME WIFE JUN"                                         
   ER11608="ADC/AFDC INCOME WIFE JUL"                                         
   ER11609="ADC/AFDC INCOME WIFE AUG"                                         
   ER11610="ADC/AFDC INCOME WIFE SEP"                                         
   ER11611="ADC/AFDC INCOME WIFE OCT"                                         
   ER11612="ADC/AFDC INCOME WIFE NOV"                                         
   ER11613="ADC/AFDC INCOME WIFE DEC"                                         
   ER11614="WTR WF RECD CHILD SUPPRT"                                         
   ER11615="CHILD SUPPORT OF WF AMT"                                          
   ER11616="CHILD SUPPORT OF WF PER"                                          
   ER11617="CHILD SUPPORT INC W JAN"                                          
   ER11618="CHILD SUPPORT INC W FEB"                                          
   ER11619="CHILD SUPPORT INC W MAR"                                          
   ER11620="CILD SUPPORT INC W APR"                                           
   ER11621="CHILD SUPPORT INC W MAY"                                          
   ER11622="CHILD SUPPORT INC W JUN"                                          
   ER11623="CHILD SUPPORT INC W JUL"                                          
   ER11624="CHILD SUPPORT INC W AUG"                                          
   ER11625="CHILD SUPPORT INC W SEP"                                          
   ER11626="CHILD SUPPORT INC W OCT"                                          
   ER11627="CHILD SUPPORT INC W NOV"                                          
   ER11628="CHILD SUPPORT INC W DEC"                                          
   ER11629="WTR WF RECD OTR WELFARE"                                          
   ER11630="OTHER WELFARE OF WF AMT"                                          
   ER11631="OTHER WELFARE OF WF PER"                                          
   ER11632="OTHER WELFARE INC W JAN"                                          
   ER11633="OTHER WELFARE INC W FEB"                                          
   ER11634="OTHER WELFARE INC W MAR"                                          
   ER11635="OTHER WELFARE INC W APR"                                          
   ER11636="OTHER WELFARE INC W MAY"                                          
   ER11637="OTHER WELFARE INC W JUN"                                          
   ER11638="OTHER WELFARE INC W JUL"                                          
   ER11639="OTHER WELFARE INC W AUG"                                          
   ER11640="OTHER WELFARE INC W SEP"                                          
   ER11641="OTHER WELFARE INC W OCT"                                          
   ER11642="OTHER WELFARE INC W NOV"                                          
   ER11643="OTHER WELFARE INC W DEC"                                          
   ER11644="WTR WF RECD PENS/ANNUITY"                                         
   ER11645="PENSION/ANNUITY WF AMT"                                           
   ER11646="PENSION/ANNUITY WF PER"                                           
   ER11647="PENSION/ANNUITY W JAN"                                            
   ER11648="PENSION/ANNUITY W FEB"                                            
   ER11649="PENSION/ANNUITY W MAR"                                            
   ER11650="PENSION/ANNUITY W APR"                                            
   ER11651="PENSION/ANNUITY W MAY"                                            
   ER11652="PENSION/ANNUITY W JUN"                                            
   ER11653="PENSION/ANNUITY W JUL"                                            
   ER11654="PENSION/ANNUITY W AUG"                                            
   ER11655="PENSION/ANNUITY W SEP"                                            
   ER11656="PENSION/ANNUITY W OCT"                                            
   ER11657="PENSION/ANNUITY W NOV"                                            
   ER11658="PENSION/ANNUITY W DEC"                                            
   ER11659="WTR WF HELP FR RELATIVES"                                         
   ER11660="HELP FR RELATIVES WF AMT"                                         
   ER11661="HELP FR RELS WF PER"                                              
   ER11662="HELP FR RELATIVES WF JAN"                                         
   ER11663="HELP FR RELATIVES WF FEB"                                         
   ER11664="HELP FR RELATIVES WF MAR"                                         
   ER11665="HELP FR RELATIVES WF APR"                                         
   ER11666="HELP FR RELATIVES WF MAY"                                         
   ER11667="HELP FR RELATIVES WF JUN"                                         
   ER11668="HELP FR RELATIVES WF JUL"                                         
   ER11669="HELP FR RELATIVES WF AUG"                                         
   ER11670="HELP FR RELATIVES WF SEP"                                         
   ER11671="HELP FR RELATIVES WF OCT"                                         
   ER11672="HELP FR RELATIVES WF NOV"                                         
   ER11673="HELP FR RELATIVES WF DEC"                                         
   ER11674="WTR WF HELP FROM FRIENDS"                                         
   ER11675="HELP FR FRIENDS WF AMT"                                           
   ER11676="HELP FR FRIENDS WF PER"                                           
   ER11677="HELP FROM FRIENDS W JAN"                                          
   ER11678="HELP FROM FRIENDS W FEB"                                          
   ER11679="HELP FROM FRIENDS W MAR"                                          
   ER11680="HELP FROM FRIENDS W APR"                                          
   ER11681="HELP FROM FRIENDS W MAY"                                          
   ER11682="HELP FROM FRIENDS W JUN"                                          
   ER11683="HELP FROM FRIENDS W JUL"                                          
   ER11684="HELP FROM FRIENDS W AUG"                                          
   ER11685="HELP FROM FRIENDS W SEP"                                          
   ER11686="HELP FROM FRIENDS W OCT"                                          
   ER11687="HELP FROM FRIENDS W NOV"                                          
   ER11688="HELP FROM FRIENDS W DEC"                                          
   ER11689="WTR WFE RECD OTR INCOME"                                          
   ER11690="WIFE OTHER INCOME AMT"                                            
   ER11691="WIFE OTHER INCOME PER"                                            
   ER11692="ANY OTHER INCOME W JAN"                                           
   ER11693="ANY OTHER INCOME W FEB"                                           
   ER11694="ANY OTHER INCOME W MAR"                                           
   ER11695="ANY OTHER INCOME W APR"                                           
   ER11696="ANY OTHER INCOME W MAY"                                           
   ER11697="ANY OTHER INCOME W JUN"                                           
   ER11698="ANY OTHER INCOME W JUL"                                           
   ER11699="ANY OTHER INCOME W AUG"                                           
   ER11700="ANY OTHER INCOME W SEP"                                           
   ER11701="ANY OTHER INCOME W OCT"                                           
   ER11702="ANY OTHER INCOME W NOV"                                           
   ER11703="ANY OTHER INCOME W DEC"                                           
   ER11704="G99 WTR LUMP SUM PAYMNTS"                                         
   ER11705="G100 LUMP SUM PAYMENTS"                                           
   ER11706="G101 INHERITANCE"                                                 
   ER11707="G102 WTR ITEMIZE FOR TAX"                                         
   ER11708="G103 WTR HELP OTRS"                                               
   ER11709="G104 # OTRS SUPPORTED"                                            
   ER11710="G105 WHO SUPPORT      1"                                          
   ER11711="G105 WHO SUPPORT      2"                                          
   ER11712="G105 WHO SUPPORT      3"                                          
   ER11713="G105 WHO SUPPORT      4"                                          
   ER11714="G105 WHO SUPPORT      5"                                          
   ER11715="G106 TOTAL SUPP OF OTRS"                                          
   ER11716="G107 ANY CHILD SUPPORT"                                           
   ER11717="AMT OF CHLD SUPPRT GIVEN"                                         
   ER11718="G109 ANY ALIMONY"                                                 
   ER11719="AMT OF ALIMONY GIVEN"                                             
   ER11720="G112 WTR DEPNDT OTRS"                                             
   ER11721="G113 NUMBER DEPNDT OTR"                                           
   ER11722="G114 WTR DEPNDT OTHS"                                             
   ER11723="H1 STATUS OF HEALTH-HEAD"                                         
   ER11724="H2 LIMIT TYPE/AMT WRK H"                                          
   ER11725="H3 NOT DO CERTAIN WRK H"                                          
   ER11726="H4 LIMIT AMT WRK DO H"                                            
   ER11727="H8 STATUS OF HEALTH-WIFE"                                         
   ER11728="H9 LIMIT TYPE/AMT WRK-WF"                                         
   ER11729="H10 NOT DO CERTAIN WK-WF"                                         
   ER11730="H11 LIMIT AMT WRK DO-WF"                                          
   ER11731="K1 CKPT: WTR WIFE"                                                
   ER11732="K2/67 ST FATHER BORN-WF"                                          
   ER11733="K3/68 ST FTH GREW UP-WF"                                          
   ER11734="K4/69 FTH EDUC IN US-WF"                                          
   ER11735="K5/70 EDUC OF FTHR US-WF"                                         
   ER11736="K6/71 FTHR READ/WRITE-WF"                                         
   ER11737="K7/72 CKPT FTH ED OUT US"                                         
   ER11738="K8/73 YRS ED FTHR OUT US"                                         
   ER11739="K9/74 HGHST DEG FTHR OUT"                                         
   ER11740="K12/77 ST MOTHER BORN-WF"                                         
   ER11741="K13/78 ST MTHR GREW UP-W"                                         
   ER11742="K14/79 MTHR EDUC IN US-W"                                         
   ER11743="K15/80 ED OF MTH IN US-W"                                         
   ER11744="K16/81 MTH READ/WRITE-WF"                                         
   ER11745="K17/82 CKP MTH ED OUT US"                                         
   ER11746="K18/83 YRS  ED MTH  OUT"                                          
   ER11747="K19/84 HGHST DEG MTH OUT"                                         
   ER11748="K22 WHETHER BROTHERS WF"                                          
   ER11749="K23 # BROTHERS WIFE"                                              
   ER11750="K24 ONLY BRO STILL ALIVE"                                         
   ER11751="K25 ONLY BRO OLDR THAN W"                                         
   ER11752="K26 # BRO STILL ALIVE"                                            
   ER11753="K27 ANY BRO OLDR THAN WF"                                         
   ER11754="K28 WHETHER SISTERS WF"                                           
   ER11755="K29 # SISTERS WIFE"                                               
   ER11756="K30 ONLY SIS STILL ALIVE"                                         
   ER11757="K31 ONLY SIS OLDR THAN W"                                         
   ER11758="K32 # SIS STILL ALIVE WF"                                         
   ER11759="K33 ANY SIS OLDR THAN WF"                                         
   ER11760="K34/87 RACE OF WIFE 1"                                            
   ER11761="K34/87 RACE OF WIFE 2"                                            
   ER11762="K34/87 RACE OF WIFE 3"                                            
   ER11763="K34/87 RACE OF WIFE 4"                                            
   ER11764="K35 WTR IN MILIT SERV WF"                                         
   ER11765="K36 WTR WIFE EDUC IN US"                                          
   ER11766="K37 WTR GRADUATED HS WF"                                          
   ER11767="K38 MO GRADUATED HS WF"                                           
   ER11768="K38 YR GRADUATED HS WF"                                           
   ER11769="K39 GRADE LEVEL IF GED-W"                                         
   ER11770="K40 MO LAST IN SCH-GED-W"                                         
   ER11771="K40 YR LAST IN SCH GED-W"                                         
   ER11772="K41 MO RECEIVED GED-WF"                                           
   ER11773="K41 YR RECEIVED GED-WF"                                           
   ER11774="K42 GRD OF SCH FINISH-W"                                          
   ER11775="K43 MO LAST IN SCH-WF"                                            
   ER11776="K43 YR LAST IN SCH-WF"                                            
   ER11777="K44 WTR ATTEND COLLEGE"                                           
   ER11778="K45 MO LAST ATTEND COLL"                                          
   ER11779="K45 YR LAST ATTEND COLL"                                          
   ER11780="K46 HGHST YR COLL COMP"                                           
   ER11781="K47 WTR RECD COLL DEG-W"                                          
   ER11782="K48 HGHST COLL DEG REC-W"                                         
   ER11783="K51 MO RECD COLL DEG-W"                                           
   ER11784="K51 YR RECD COLL DEG-W"                                           
   ER11785="K52 CKPT WF ED OUT US"                                            
   ER11786="K53/90 YRS SCHL OUT US"                                           
   ER11787="K54/91 HGHST DEG OUT US"                                          
   ER11788="K55 WTR REC OTR DEG/CER"                                          
   ER11789="K56 TYPE OTR DEG/CERT 1"                                          
   ER11790="K57 FIELD OTR DEG/CERT 1"                                         
   ER11791="K58 INST/ORG DEG/CERT 1"                                          
   ER11792="K59 MO RECD DEG/CERT 1"                                           
   ER11793="K59 YR RECD DEG/CERT 1"                                           
   ER11794="K60 OTHER TRAINING 1"                                             
   ER11795="K56 TYPE OTR DEG/CERT 2"                                          
   ER11796="K57 FIELD OTR DEG/CERT 2"                                         
   ER11797="K58 INST/ORG DEG/CERT 2"                                          
   ER11798="K59 MO RECD DEG/CERT 2"                                           
   ER11799="K59 YR RECD DEG/CERT 2"                                           
   ER11800="K60 OTHER TRAINING 2"                                             
   ER11801="K56 TYPE OTR DEG/CERT 3"                                          
   ER11802="K57 FIELD OTR DEG/CERT 3"                                         
   ER11803="K58 INST/ORG DEG/CERT 3"                                          
   ER11804="K59 MO RECD DEG/CERT 3"                                           
   ER11805="K59 YR RECD DEG/CERT 3"                                           
   ER11806="K60 OTHER TRAINING 3"                                             
   ER11807="K61 RELIGIOUS PREF-WF"                                            
   ER11808="K62 RELIG DENOMINTN-WF"                                           
   ER11809="K63 #YRS WRKD SINCE 18-W"                                         
   ER11810="K64 #YR WRKED FULLTIME-W"                                         
   ER11811="K89 REC ANY ED OUT US-WF"                                         
   ER11812="L1 CKPT: WTR NEW HEAD"                                            
   ER11813="L2/75 ST FATHER BORN-HD"                                          
   ER11814="L3/76 ST FTH GREW UP-HD"                                          
   ER11815="L4/77 FTH EDUC IN US-HD"                                          
   ER11816="L5/78 EDUC OF FTHR US-HD"                                         
   ER11817="L6/79 FTHR READ/WRITE-HD"                                         
   ER11818="L7/80 CKPT FTH ED OUT US"                                         
   ER11819="L8/81 YRS ED FTHR OUT US"                                         
   ER11820="L9/82 HGHST DEG FTHR OUT"                                         
   ER11821="L12/85 ST MOTHER BORN-HD"                                         
   ER11822="L13/86 ST MTHR GREW UP-H"                                         
   ER11823="L14/87 MTHR EDUC IN US-H"                                         
   ER11824="L15/88 ED OF MTH IN US-H"                                         
   ER11825="L16/89 MTH READ/WRITE-HD"                                         
   ER11826="L17/90 CKP MTH ED OUT US"                                         
   ER11827="L18/91 YRS  ED MTH  OUT"                                          
   ER11828="L19/92 HGHST DEG MTH OUT"                                         
   ER11829="L22 WHETHER BROTHERS HD"                                          
   ER11830="L23 # BROTHERS HEAD"                                              
   ER11831="L24 ONLY BRO STILL ALIVE"                                         
   ER11832="L25 ONLY BRO OLDR THAN H"                                         
   ER11833="L26 # BRO STILL ALIVE"                                            
   ER11834="L27 ANY BRO OLDR THAN HD"                                         
   ER11835="L28 WHETHER SISTERS HD"                                           
   ER11836="L29 # SISTERS HEAD"                                               
   ER11837="L30 ONLY SIS STILL ALIVE"                                         
   ER11838="L31 ONLY SIS OLDR THAN H"                                         
   ER11839="L32 # SIS STILL ALIVE HD"                                         
   ER11840="L33 ANY SIS OLDR THAN HD"                                         
   ER11841="L34 GREW UP FARM OR? HD"                                          
   ER11842="L34 STATE HD GREW UP"                                             
   ER11843="L35 EVER LIVE OTHER ST"                                           
   ER11844="L36 EVER MOVE FOR JOB?"                                           
   ER11845="L37 NOT MOVED FOR JOB?"                                           
   ER11846="L38 PARENTS POOR OR? HD"                                          
   ER11847="L39 LIVE W/BOTH PARENTS"                                          
   ER11848="L40/95 RACE OF HEAD 1"                                            
   ER11849="L40/95 RACE OF HEAD 2"                                            
   ER11850="L40/95 RACE OF HEAD 3"                                            
   ER11851="L40/95 RACE OF HEAD 4"                                            
   ER11852="L42 WTR IN MILIT SERV-HD"                                         
   ER11853="L43 WTR HEAD EDUC IN US"                                          
   ER11854="L44 WTR GRADUATED HS HD"                                          
   ER11855="L45 MO GRADUATED HS HD"                                           
   ER11856="L45 YR GRADUATED HS HD"                                           
   ER11857="L46 GRADE LEVEL IF GED-H"                                         
   ER11858="L47 MO LAST IN SCH-GED-H"                                         
   ER11859="L47 YR LAST IN SCH GED-H"                                         
   ER11860="L48 MO RECEIVED GED-HD"                                           
   ER11861="L48 YR RECEIVED GED-HD"                                           
   ER11862="L49 GRD OF SCH FINISH-HD"                                         
   ER11863="L50 MO LAST IN SCHL-HD"                                           
   ER11864="L50 YR LAST IN SCHL-HD"                                           
   ER11865="L51 WTR ATTEND COLLEGE"                                           
   ER11866="L52 MO LAST ATTEND COLL"                                          
   ER11867="L52 YR LAST ATTEND COLL"                                          
   ER11868="L53 HGHST YR COLL COMP"                                           
   ER11869="L54 WTR RECD COLL DEG-HD"                                         
   ER11870="L55 HGHST COLL DEG REC-H"                                         
   ER11871="L58 MO RECD COLL DEG-HD"                                          
   ER11872="L58 YR RECD COLL DEG-HD"                                          
   ER11873="L59 CKPT HD ED OUT US"                                            
   ER11874="L60/98 YRS SCHL OUT US"                                           
   ER11875="L61/99 HGHST DEG OUT US"                                          
   ER11876="L62 WTR REC OTR DEG/CER"                                          
   ER11877="L63 TYPE OTR DEG/CERT 1"                                          
   ER11878="L64 FIELD OTR DEG/CERT 1"                                         
   ER11879="L65 INST/ORG DEG/CERT 1"                                          
   ER11880="L66 MO RECD DEG/CERT 1"                                           
   ER11881="L66 YR RECD DEG/CERT 1"                                           
   ER11882="L67 OTHER TRAINING 1"                                             
   ER11883="L63 TYPE OTR DEG/CERT 2"                                          
   ER11884="L64 FIELD OTR DEG/CERT 2"                                         
   ER11885="L65 INST/ORG DEG/CERT 2"                                          
   ER11886="L66 MO RECD DEG/CERT 2"                                           
   ER11887="L66 YR RECD DEG/CERT 2"                                           
   ER11888="L67 OTHER TRAINING 2"                                             
   ER11889="L63 TYPE OTR DEG/CERT 3"                                          
   ER11890="L64 FIELD OTR DEG/CERT 3"                                         
   ER11891="L65 INST/ORG DEG/CERT 3"                                          
   ER11892="L66 MO RECD DEG/CERT 3"                                           
   ER11893="L66 YR RECD DEG/CERT 3"                                           
   ER11894="L67 OTHER TRAINING 3"                                             
   ER11895="L68 RELIGIOUS PREF-HD"                                            
   ER11896="L69 RELIG DENOMINTN-HD"                                           
   ER11897="L70 #YRS WRKD SINCE 18-H"                                         
   ER11898="L71 #YR WRKED FULLTIME-H"                                         
   ER11899="L72 # DIFF JOBS OR? HD"                                           
   ER11900="L97 REC ANY ED OUT US-HD"                                         
   ER11901="M2 WK FOR $ BEFORE US-HD"                                         
   ER11902="M3 SAME JOB AS 1ST JOB-H"                                         
   ER11903="M6 MO BEGAN LAST JOB-HD"                                          
   ER11904="M6 YR BEGAN LAST JOB-HD"                                          
   ER11905="M7 MO END LAST JOB-HD"                                            
   ER11906="M7 YR END LAST JOB-HD"                                            
   ER11907="M8 WTR SELF-EMPLOY-HD"                                            
   ER11908="M9 WTR 1 JOB OR MORE-HD"                                          
   ER11909="M10 END HRS/WK LST JOB-H"                                         
   ER11910="M11 FINAL WAGE/SAL LST J"                                         
   ER11911="M11 FINAL WAGE PER WHAT"                                          
   ER11912="M11A WTR WAGE IN US $-HD"                                         
   ER11913="M12 WTR JOB NATIVE CNTRY"                                         
   ER11914="M12B WTR WK FOR $ IN US"                                          
   ER11915="M13 SAME JOB AS CURRENT"                                          
   ER11916="M14 SAME JOB AS 1ST JOB"                                          
   ER11917="M17 ST WHERE 1ST US JOB"                                          
   ER11918="M18 MO BEGAN 1ST US JOB"                                          
   ER11919="M18 YR BEGAN 1ST US JOB"                                          
   ER11920="M19 MO END 1ST US JOB-HD"                                         
   ER11921="M19 YR END 1ST US JOB-HD"                                         
   ER11922="M20 WTR 1 JOB OR MORE-HD"                                         
   ER11923="M21 END HRS/WK 1ST JOB-H"                                         
   ER11924="M22 FINAL WAGE/SAL 1ST J"                                         
   ER11925="M22 FINAL WAGE PER WHAT"                                          
   ER11926="M23 PROB FIND JOB US-HD"                                          
   ER11927="M24 WTR CHLDRN OUT FU-HD"                                         
   ER11928="M25 # CHLDRN OUT OF US-H"                                         
   ER11929="M26 # US CHLD OUT FU-HD"                                          
   ER11930="M27 CKPT SIBS LIVING-HD"                                          
   ER11931="M28 WTR SIBS OUT FU-HD"                                           
   ER11932="M29 # SIBS OUT OF US-HD"                                          
   ER11933="M30 # US SIBS OUT FU-HD"                                          
   ER11934="M31 WHERE IS MOTHER-HD"                                           
   ER11935="M32 WHERE IS FATHER-HD"                                           
   ER11936="M33 ENGLISH 1ST LANG-HD"                                          
   ER11937="M35 AGE LEARN ENGLISH-HD"                                         
   ER11938="M36 NONENGLISH SPOKEN-HD"                                         
   ER11939="M38 CKPT ENGLISH ONLY-HD"                                         
   ER11940="M39 ENGL READ SKILL-HD"                                           
   ER11941="M40 ENGL WRITE SKILL-HD"                                          
   ER11942="M41 OTR LNG READ SKLL-HD"                                         
   ER11943="M42 OTR LNG WRTE SKLL-HD"                                         
   ER11944="M44 LANG SPOKEN SPOUSE-H"                                         
   ER11945="M45 LANG SPOKEN ELDERS-H"                                         
   ER11946="M46 LANG SPOKEN SIBS-HD"                                          
   ER11947="M47 LANG SPOKEN CHLDN-HD"                                         
   ER11948="M47A CKPT WORKING NOW-HD"                                         
   ER11949="M48 LANG SPOKEN ON JOB-H"                                         
   ER11950="M49 LANG SPOKEN FRNDS-HD"                                         
   ER11951="M50 CKPT HEAD BORN IN US"                                         
   ER11952="M51 1ST TIME IN US? HD"                                           
   ER11953="M52 1ST ST IN US LIVE-HD"                                         
   ER11954="M53 MO 1ST STAY US-HD"                                            
   ER11955="M53 YR 1ST STAY US-HD"                                            
   ER11956="M54 LENGTH 1ST STAY-YR H"                                         
   ER11957="M54 LENGTH 1ST STAY-MO H"                                         
   ER11958="M54 LENGTH 1ST STAY-WK H"                                         
   ER11959="M54 LENGTH 1ST STAY-DA H"                                         
   ER11960="M55 MO THIS STAY US-HD"                                           
   ER11961="M55 YR THIS STAY US-HD"                                           
   ER11962="M56 REASON IN US-HD 1ST"                                          
   ER11963="M56 REASON IN US-HD 2ND"                                          
   ER11964="M56 REASON IN US-HD 3RD"                                          
   ER11965="M56 REASON IN US-HD 4TH"                                          
   ER11966="M56 REASON IN US-HD 5TH"                                          
   ER11967="M56 MAIN REASON IN US-HD"                                         
   ER11968="M57 REL HELPR COME TO US"                                         
   ER11969="M58 WTR SPONSORED-HD"                                             
   ER11970="M59 REL SPONSOR TO HD"                                            
   ER11971="M62 AGE OF SPONSOR-HD"                                            
   ER11972="M63 WTR NATURALIZD CIT-H"                                         
   ER11973="M64 YR NATURALIZED-HD"                                            
   ER11974="M65 WTR PLAN CITIZEN-HD"                                          
   ER11975="M66 CKPT 1ST TIME US-HD"                                          
   ER11976="M67 STATUS AT 1ST STAY-H"                                         
   ER11977="M68 STATUS AT LST STAY-H"                                         
   ER11978="M69 CKPT WTR CITIZEN-HD"                                          
   ER11979="M70 CURRENT STATUS-HD"                                            
   ER11980="M71 MO VISA/PMT EXPIRE-H"                                         
   ER11981="M71 YR VISA/PMT EXPIRE-H"                                         
   ER11982="M72 WTR STATUS CHG YR-HD"                                         
   ER11983="M2 WK FOR $ BEFORE US-WF"                                         
   ER11984="M3 SAME JOB AS 1ST JOB-W"                                         
   ER11985="M6 MO BEGAN LAST JOB-WF"                                          
   ER11986="M6 YR BEGAN LAST JOB-WF"                                          
   ER11987="M7 MO END LAST JOB-WF"                                            
   ER11988="M7 YR END LAST JOB-WF"                                            
   ER11989="M8 WTR SELF-EMPLOY-WF"                                            
   ER11990="M9 WTR 1 JOB OR MORE-WF"                                          
   ER11991="M10 END HRS/WK LST JOB-W"                                         
   ER11992="M11 FINAL WAGE/SAL LST J"                                         
   ER11993="M11 FINAL WAGE PER WHAT"                                          
   ER11994="M11A WTR WAGE IN US $-HD"                                         
   ER11995="M12 WTR JOB NATIVE CNTRY"                                         
   ER11996="M12B WTR WK FOR $ IN US"                                          
   ER11997="M13 SAME JOB AS CURRENT"                                          
   ER11998="M14 SAME JOB AS 1ST JOB"                                          
   ER11999="M17 ST WHERE 1ST US JOB"                                          
   ER12000="M18 MO BEGAN 1ST US JOB"                                          
   ER12001="M18 YR BEGAN 1ST US JOB"                                          
   ER12002="M19 MO END 1ST US JOB-WF"                                         
   ER12003="M19 YR END 1ST US JOB-WF"                                         
   ER12004="M20 WTR 1 JOB OR MORE-WF"                                         
   ER12005="M21 END HRS/WK 1ST JOB-W"                                         
   ER12006="M22 FINAL WAGE/SAL 1ST J"                                         
   ER12007="M22 FINAL WAGE PER WHAT"                                          
   ER12008="M23 PROB FIND JOB US-WF"                                          
   ER12009="M24 WTR CHLDRN OUT FU-WF"                                         
   ER12010="M25 # CHLDRN OUT OF US-W"                                         
   ER12011="M26 # US CHLD OUT FU-WF"                                          
   ER12012="M27 CKPT SIBS LIVING-WF"                                          
   ER12013="M28 WTR SIBS OUT FU-WF"                                           
   ER12014="M29 # SIBS OUT OF US-WF"                                          
   ER12015="M30 # US SIBS OUT FU-WF"                                          
   ER12016="M31 WHERE IS MOTHER-WF"                                           
   ER12017="M32 WHERE IS FATHER-WF"                                           
   ER12018="M33 ENGLISH 1ST LANG-WF"                                          
   ER12019="M35 AGE LEARN ENGLISH-WF"                                         
   ER12020="M36 NONENGLISH SPOKEN-WF"                                         
   ER12021="M38 CKPT ENGLISH ONLY-WF"                                         
   ER12022="M39 ENGL READ SKILL-WF"                                           
   ER12023="M40 ENGL WRITE SKILL-WF"                                          
   ER12024="M41 OTR LNG READ SKLL-WF"                                         
   ER12025="M42 OTR LNG WRTE SKLL-WF"                                         
   ER12026="M44 LANG SPOKEN SPOUSE-W"                                         
   ER12027="M45 LANG SPOKEN ELDERS-W"                                         
   ER12028="M46 LANG SPOKEN SIBS-WF"                                          
   ER12029="M47 LANG SPOKEN CHLDN-WF"                                         
   ER12030="M47A CKPT WORKING NOW-WF"                                         
   ER12031="M48 LANG SPOKEN ON JOB-W"                                         
   ER12032="M49 LANG SPOKEN FRNDS-WF"                                         
   ER12033="M50 CKPT WIFE BORN IN US"                                         
   ER12034="M51 1ST TIME IN US? WF"                                           
   ER12035="M52 1ST ST IN US LIVE-WF"                                         
   ER12036="M53 MO 1ST STAY US-WF"                                            
   ER12037="M53 YR 1ST STAY US-WF"                                            
   ER12038="M54 LENGTH 1ST STAY-YR W"                                         
   ER12039="M54 LENGTH 1ST STAY-MO W"                                         
   ER12040="M54 LENGTH 1ST STAY-WK W"                                         
   ER12041="M54 LENGTH 1ST STAY-DA W"                                         
   ER12042="M55 MO THIS STAY US-WF"                                           
   ER12043="M55 YR THIS STAY US-WF"                                           
   ER12044="M56 REASON IN US-WF 1ST"                                          
   ER12045="M56 REASON IN US-WF 2ND"                                          
   ER12046="M56 REASON IN US-WF 3RD"                                          
   ER12047="M56 REASON IN US-WF 4TH"                                          
   ER12048="M56 REASON IN US-WF 5TH"                                          
   ER12049="M56 MAIN REASON IN US-WF"                                         
   ER12050="M57 REL HELPR COME TO US"                                         
   ER12051="M58 WTR SPONSORED-WF"                                             
   ER12052="M59 REL SPONSOR TO WF"                                            
   ER12053="M62 AGE OF SPONSOR-WF"                                            
   ER12054="M63 WTR NATURALIZD CIT-W"                                         
   ER12055="M64 YR NATURALIZED-WF"                                            
   ER12056="M65 WTR PLAN CITIZEN-WF"                                          
   ER12057="M66 CKPT 1ST TIME US-WF"                                          
   ER12058="M67 STATUS AT 1ST STAY-W"                                         
   ER12059="M68 STATUS AT LST STAY-W"                                         
   ER12060="M69 CKPT WTR CITIZEN-WF"                                          
   ER12061="M70 CURRENT STATUS-WF"                                            
   ER12062="M71 MO VISA/PMT EXPIRE-W"                                         
   ER12063="M71 YR VISA/PMT EXPIRE-W"                                         
   ER12064="M72 WTR STATUS CHG YR-WF"                                         
   ER12065="FARM INCOME"                                                      
   ER12066="ACC FARM INCOME"                                                  
   ER12067="BUSINESS INCOME"                                                  
   ER12068="ACC BUSINESS INCOME"                                              
   ER12069="HD+WF TAXABLE INCOME"                                             
   ER12070="ACC HD+WF TAXABLE INCOME"                                         
   ER12071="HD+WF TRANSFER INCOME"                                            
   ER12072="ACC H+W TRANSFER INCOME"                                          
   ER12073="OFUM TAXABLE INCOME"                                              
   ER12074="ACC OFUM TAXABLE INCOME"                                          
   ER12075="OFUM TRANSFER INCOME"                                             
   ER12076="ACC OFUM TRANSFER INCOME"                                         
   ER12077="SOCIAL SECURITY INCOME"                                           
   ER12078="ACC SOCIAL SECURITY INC"                                          
   ER12079="TOTAL FAMILY INCOME"                                              
   ER12080="LABOR INCOME-HEAD"                                                
   ER12081="ACC LABOR INCOME-HD"                                              
   ER12082="LABOR INCOME-WIFE"                                                
   ER12083="ACC LABOR INCOME-WF"                                              
   ER12084="FAMILY WEIGHT";                                                   
