/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.InnerClass;
import org.apache.bcel.classfile.Visitor;

public final class InnerClasses
extends Attribute {
    private InnerClass[] inner_classes;

    public InnerClasses(InnerClasses c) {
        this(c.getNameIndex(), c.getLength(), c.getInnerClasses(), c.getConstantPool());
    }

    public InnerClasses(int name_index, int length, InnerClass[] inner_classes, ConstantPool constant_pool) {
        super((byte)6, name_index, length, constant_pool);
        this.inner_classes = inner_classes != null ? inner_classes : new InnerClass[]{};
    }

    InnerClasses(int name_index, int length, DataInput input, ConstantPool constant_pool) throws IOException {
        this(name_index, length, (InnerClass[])null, constant_pool);
        int number_of_classes = input.readUnsignedShort();
        this.inner_classes = new InnerClass[number_of_classes];
        for (int i = 0; i < number_of_classes; ++i) {
            this.inner_classes[i] = new InnerClass(input);
        }
    }

    @Override
    public void accept(Visitor v) {
        v.visitInnerClasses(this);
    }

    @Override
    public void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.inner_classes.length);
        for (InnerClass inner_class : this.inner_classes) {
            inner_class.dump(file);
        }
    }

    public InnerClass[] getInnerClasses() {
        return this.inner_classes;
    }

    public void setInnerClasses(InnerClass[] inner_classes) {
        this.inner_classes = inner_classes != null ? inner_classes : new InnerClass[]{};
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("InnerClasses(");
        buf.append(this.inner_classes.length);
        buf.append("):\n");
        for (InnerClass inner_class : this.inner_classes) {
            buf.append(inner_class.toString(super.getConstantPool())).append("\n");
        }
        return buf.substring(0, buf.length() - 1);
    }

    @Override
    public Attribute copy(ConstantPool _constant_pool) {
        InnerClasses c = (InnerClasses)this.clone();
        c.inner_classes = new InnerClass[this.inner_classes.length];
        for (int i = 0; i < this.inner_classes.length; ++i) {
            c.inner_classes[i] = this.inner_classes[i].copy();
        }
        c.setConstantPool(_constant_pool);
        return c;
    }
}

