/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javac.code;

import java.util.HashMap;
import java.util.Map;
import org.openjdk.javax.lang.model.SourceVersion;
import org.openjdk.tools.javac.jvm.Target;
import org.openjdk.tools.javac.main.Option;
import org.openjdk.tools.javac.util.Context;
import org.openjdk.tools.javac.util.Options;

public enum Source {
    JDK1_2("1.2"),
    JDK1_3("1.3"),
    JDK1_4("1.4"),
    JDK1_5("1.5"),
    JDK1_6("1.6"),
    JDK1_7("1.7"),
    JDK1_8("1.8"),
    JDK1_9("1.9");

    private static final Context.Key<Source> sourceKey;
    public final String name;
    private static final Map<String, Source> tab;
    public static final Source MIN;
    private static final Source MAX;
    public static final Source DEFAULT;

    public static Source instance(Context context) {
        Source source = context.get(sourceKey);
        if (source == null) {
            Options options = Options.instance(context);
            String string = options.get(Option.SOURCE);
            if (string != null) {
                source = Source.lookup(string);
            }
            if (source == null) {
                source = DEFAULT;
            }
            context.put(sourceKey, source);
        }
        return source;
    }

    private Source(String string2) {
        this.name = string2;
    }

    public static Source lookup(String string) {
        return tab.get(string);
    }

    public Target requiredTarget() {
        if (this.compareTo(JDK1_9) >= 0) {
            return Target.JDK1_9;
        }
        if (this.compareTo(JDK1_8) >= 0) {
            return Target.JDK1_8;
        }
        if (this.compareTo(JDK1_7) >= 0) {
            return Target.JDK1_7;
        }
        if (this.compareTo(JDK1_6) >= 0) {
            return Target.JDK1_6;
        }
        if (this.compareTo(JDK1_5) >= 0) {
            return Target.JDK1_5;
        }
        if (this.compareTo(JDK1_4) >= 0) {
            return Target.JDK1_4;
        }
        return Target.JDK1_1;
    }

    public boolean allowDiamond() {
        return this.compareTo(JDK1_7) >= 0;
    }

    public boolean allowMulticatch() {
        return this.compareTo(JDK1_7) >= 0;
    }

    public boolean allowImprovedRethrowAnalysis() {
        return this.compareTo(JDK1_7) >= 0;
    }

    public boolean allowImprovedCatchAnalysis() {
        return this.compareTo(JDK1_7) >= 0;
    }

    public boolean allowModules() {
        return this.compareTo(JDK1_9) >= 0;
    }

    public boolean allowTryWithResources() {
        return this.compareTo(JDK1_7) >= 0;
    }

    public boolean allowEffectivelyFinalVariablesInTryWithResources() {
        return this.compareTo(JDK1_9) >= 0;
    }

    public boolean allowBinaryLiterals() {
        return this.compareTo(JDK1_7) >= 0;
    }

    public boolean allowUnderscoresInLiterals() {
        return this.compareTo(JDK1_7) >= 0;
    }

    public boolean allowStringsInSwitch() {
        return this.compareTo(JDK1_7) >= 0;
    }

    public boolean allowDeprecationOnImport() {
        return this.compareTo(JDK1_9) < 0;
    }

    public boolean allowSimplifiedVarargs() {
        return this.compareTo(JDK1_7) >= 0;
    }

    public boolean allowObjectToPrimitiveCast() {
        return this.compareTo(JDK1_7) >= 0;
    }

    public boolean enforceThisDotInit() {
        return this.compareTo(JDK1_7) >= 0;
    }

    public boolean allowPoly() {
        return this.compareTo(JDK1_8) >= 0;
    }

    public boolean allowLambda() {
        return this.compareTo(JDK1_8) >= 0;
    }

    public boolean allowMethodReferences() {
        return this.compareTo(JDK1_8) >= 0;
    }

    public boolean allowDefaultMethods() {
        return this.compareTo(JDK1_8) >= 0;
    }

    public boolean allowStaticInterfaceMethods() {
        return this.compareTo(JDK1_8) >= 0;
    }

    public boolean allowStrictMethodClashCheck() {
        return this.compareTo(JDK1_8) >= 0;
    }

    public boolean allowEffectivelyFinalInInnerClasses() {
        return this.compareTo(JDK1_8) >= 0;
    }

    public boolean allowTypeAnnotations() {
        return this.compareTo(JDK1_8) >= 0;
    }

    public boolean allowAnnotationsAfterTypeParams() {
        return this.compareTo(JDK1_8) >= 0;
    }

    public boolean allowRepeatedAnnotations() {
        return this.compareTo(JDK1_8) >= 0;
    }

    public boolean allowIntersectionTypesInCast() {
        return this.compareTo(JDK1_8) >= 0;
    }

    public boolean allowGraphInference() {
        return this.compareTo(JDK1_8) >= 0;
    }

    public boolean allowFunctionalInterfaceMostSpecific() {
        return this.compareTo(JDK1_8) >= 0;
    }

    public boolean allowPostApplicabilityVarargsAccessCheck() {
        return this.compareTo(JDK1_8) >= 0;
    }

    public boolean mapCapturesToBounds() {
        return this.compareTo(JDK1_8) < 0;
    }

    public boolean allowPrivateSafeVarargs() {
        return this.compareTo(JDK1_9) >= 0;
    }

    public boolean allowDiamondWithAnonymousClassCreation() {
        return this.compareTo(JDK1_9) >= 0;
    }

    public boolean allowUnderscoreIdentifier() {
        return this.compareTo(JDK1_8) <= 0;
    }

    public boolean allowPrivateInterfaceMethods() {
        return this.compareTo(JDK1_9) >= 0;
    }

    public static SourceVersion toSourceVersion(Source source) {
        switch (source) {
            case JDK1_2: {
                return SourceVersion.RELEASE_2;
            }
            case JDK1_3: {
                return SourceVersion.RELEASE_3;
            }
            case JDK1_4: {
                return SourceVersion.RELEASE_4;
            }
            case JDK1_5: {
                return SourceVersion.RELEASE_5;
            }
            case JDK1_6: {
                return SourceVersion.RELEASE_6;
            }
            case JDK1_7: {
                return SourceVersion.RELEASE_7;
            }
            case JDK1_8: {
                return SourceVersion.RELEASE_8;
            }
            case JDK1_9: {
                return SourceVersion.RELEASE_9;
            }
        }
        return null;
    }

    static {
        sourceKey = new Context.Key();
        tab = new HashMap<String, Source>();
        for (Source source : Source.values()) {
            tab.put(source.name, source);
        }
        tab.put("5", JDK1_5);
        tab.put("6", JDK1_6);
        tab.put("7", JDK1_7);
        tab.put("8", JDK1_8);
        tab.put("9", JDK1_9);
        MIN = JDK1_6;
        MAX = Source.values()[Source.values().length - 1];
        DEFAULT = JDK1_8;
    }
}

