/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javac.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.openjdk.source.tree.MemberReferenceTree;
import org.openjdk.source.tree.ModuleTree;
import org.openjdk.tools.javac.code.BoundKind;
import org.openjdk.tools.javac.code.Flags;
import org.openjdk.tools.javac.code.Source;
import org.openjdk.tools.javac.code.TypeTag;
import org.openjdk.tools.javac.parser.LazyDocCommentTable;
import org.openjdk.tools.javac.parser.Lexer;
import org.openjdk.tools.javac.parser.Parser;
import org.openjdk.tools.javac.parser.ParserFactory;
import org.openjdk.tools.javac.parser.Tokens;
import org.openjdk.tools.javac.resources.CompilerProperties;
import org.openjdk.tools.javac.tree.DocCommentTable;
import org.openjdk.tools.javac.tree.EndPosTable;
import org.openjdk.tools.javac.tree.JCTree;
import org.openjdk.tools.javac.tree.TreeInfo;
import org.openjdk.tools.javac.tree.TreeMaker;
import org.openjdk.tools.javac.util.Assert;
import org.openjdk.tools.javac.util.Convert;
import org.openjdk.tools.javac.util.Filter;
import org.openjdk.tools.javac.util.IntHashTable;
import org.openjdk.tools.javac.util.JCDiagnostic;
import org.openjdk.tools.javac.util.List;
import org.openjdk.tools.javac.util.ListBuffer;
import org.openjdk.tools.javac.util.Log;
import org.openjdk.tools.javac.util.Name;
import org.openjdk.tools.javac.util.Names;

public class JavacParser
implements Parser {
    private static final int infixPrecedenceLevels = 10;
    private final boolean parseModuleInfo;
    protected Lexer S;
    protected TreeMaker F;
    private Log log;
    private Source source;
    private Names names;
    protected final AbstractEndPosTable endPosTable;
    private List<JCTree.JCAnnotation> typeAnnotationsPushedBack = List.nil();
    private boolean permitTypeAnnotationsPushBack = false;
    boolean allowDiamond;
    boolean allowMulticatch;
    boolean allowTWR;
    boolean allowEffectivelyFinalVariablesInTWR;
    boolean allowStringFolding;
    boolean allowLambda;
    boolean allowMethodReferences;
    boolean allowModules;
    boolean allowDefaultMethods;
    boolean allowStaticInterfaceMethods;
    boolean allowPrivateInterfaceMethods;
    boolean allowIntersectionTypesInCast;
    boolean keepDocComments;
    boolean keepLineMap;
    boolean allowTypeAnnotations;
    boolean allowAnnotationsAfterTypeParams;
    boolean allowUnderscoreIdentifier;
    boolean allowThisIdent;
    JCTree.JCVariableDecl receiverParam;
    protected static final int EXPR = 1;
    protected static final int TYPE = 2;
    protected static final int NOPARAMS = 4;
    protected static final int TYPEARG = 8;
    protected static final int DIAMOND = 16;
    protected int mode = 0;
    protected int lastmode = 0;
    protected Tokens.Token token;
    private JCTree.JCErroneous errorTree;
    private static final int RECOVERY_THRESHOLD = 50;
    private int errorPos = -1;
    private int count = 0;
    private final DocCommentTable docComments;
    ArrayList<JCTree.JCExpression[]> odStackSupply = new ArrayList();
    ArrayList<Tokens.Token[]> opStackSupply = new ArrayList();
    protected Filter<Tokens.TokenKind> LAX_IDENTIFIER = tokenKind -> tokenKind == Tokens.TokenKind.IDENTIFIER || tokenKind == Tokens.TokenKind.UNDERSCORE || tokenKind == Tokens.TokenKind.ASSERT || tokenKind == Tokens.TokenKind.ENUM;

    protected JavacParser(ParserFactory parserFactory, Lexer lexer, boolean bl, boolean bl2, boolean bl3) {
        this(parserFactory, lexer, bl, bl2, bl3, false);
    }

    protected JavacParser(ParserFactory parserFactory, Lexer lexer, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.S = lexer;
        this.nextToken();
        this.F = parserFactory.F;
        this.log = parserFactory.log;
        this.names = parserFactory.names;
        this.source = parserFactory.source;
        this.allowTWR = this.source.allowTryWithResources();
        this.allowEffectivelyFinalVariablesInTWR = this.source.allowEffectivelyFinalVariablesInTryWithResources();
        this.allowDiamond = this.source.allowDiamond();
        this.allowMulticatch = this.source.allowMulticatch();
        this.allowStringFolding = parserFactory.options.getBoolean("allowStringFolding", true);
        this.allowLambda = this.source.allowLambda();
        this.allowMethodReferences = this.source.allowMethodReferences();
        this.allowDefaultMethods = this.source.allowDefaultMethods();
        this.allowStaticInterfaceMethods = this.source.allowStaticInterfaceMethods();
        this.allowIntersectionTypesInCast = this.source.allowIntersectionTypesInCast();
        this.allowTypeAnnotations = this.source.allowTypeAnnotations();
        this.allowModules = this.source.allowModules();
        this.allowAnnotationsAfterTypeParams = this.source.allowAnnotationsAfterTypeParams();
        this.allowUnderscoreIdentifier = this.source.allowUnderscoreIdentifier();
        this.allowPrivateInterfaceMethods = this.source.allowPrivateInterfaceMethods();
        this.keepDocComments = bl;
        this.parseModuleInfo = bl4;
        this.docComments = this.newDocCommentTable(bl, parserFactory);
        this.keepLineMap = bl2;
        this.errorTree = this.F.Erroneous();
        this.endPosTable = this.newEndPosTable(bl3);
    }

    protected AbstractEndPosTable newEndPosTable(boolean bl) {
        return bl ? new SimpleEndPosTable(this) : new EmptyEndPosTable(this);
    }

    protected DocCommentTable newDocCommentTable(boolean bl, ParserFactory parserFactory) {
        return bl ? new LazyDocCommentTable(parserFactory) : null;
    }

    public Tokens.Token token() {
        return this.token;
    }

    public void nextToken() {
        this.S.nextToken();
        this.token = this.S.token();
    }

    protected boolean peekToken(Filter<Tokens.TokenKind> filter) {
        return this.peekToken(0, filter);
    }

    protected boolean peekToken(int n, Filter<Tokens.TokenKind> filter) {
        return filter.accepts(this.S.token((int)(n + 1)).kind);
    }

    protected boolean peekToken(Filter<Tokens.TokenKind> filter, Filter<Tokens.TokenKind> filter2) {
        return this.peekToken(0, filter, filter2);
    }

    protected boolean peekToken(int n, Filter<Tokens.TokenKind> filter, Filter<Tokens.TokenKind> filter2) {
        return filter.accepts(this.S.token((int)(n + 1)).kind) && filter2.accepts(this.S.token((int)(n + 2)).kind);
    }

    protected boolean peekToken(Filter<Tokens.TokenKind> filter, Filter<Tokens.TokenKind> filter2, Filter<Tokens.TokenKind> filter3) {
        return this.peekToken(0, filter, filter2, filter3);
    }

    protected boolean peekToken(int n, Filter<Tokens.TokenKind> filter, Filter<Tokens.TokenKind> filter2, Filter<Tokens.TokenKind> filter3) {
        return filter.accepts(this.S.token((int)(n + 1)).kind) && filter2.accepts(this.S.token((int)(n + 2)).kind) && filter3.accepts(this.S.token((int)(n + 3)).kind);
    }

    protected boolean peekToken(Filter<Tokens.TokenKind> ... filterArray) {
        return this.peekToken(0, filterArray);
    }

    protected boolean peekToken(int n, Filter<Tokens.TokenKind> ... filterArray) {
        while (n < filterArray.length) {
            if (!filterArray[n].accepts(this.S.token((int)(n + 1)).kind)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected void skip(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        while (true) {
            switch (this.token.kind) {
                case SEMI: {
                    this.nextToken();
                    return;
                }
                case PUBLIC: 
                case FINAL: 
                case ABSTRACT: 
                case MONKEYS_AT: 
                case EOF: 
                case CLASS: 
                case INTERFACE: 
                case ENUM: {
                    return;
                }
                case IMPORT: {
                    if (!bl) break;
                    return;
                }
                case LBRACE: 
                case RBRACE: 
                case PRIVATE: 
                case PROTECTED: 
                case STATIC: 
                case TRANSIENT: 
                case NATIVE: 
                case VOLATILE: 
                case SYNCHRONIZED: 
                case STRICTFP: 
                case LT: 
                case BYTE: 
                case SHORT: 
                case CHAR: 
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: 
                case BOOLEAN: 
                case VOID: {
                    if (!bl2) break;
                    return;
                }
                case UNDERSCORE: 
                case IDENTIFIER: {
                    if (!bl3) break;
                    return;
                }
                case CASE: 
                case DEFAULT: 
                case IF: 
                case FOR: 
                case WHILE: 
                case DO: 
                case TRY: 
                case SWITCH: 
                case RETURN: 
                case THROW: 
                case BREAK: 
                case CONTINUE: 
                case ELSE: 
                case FINALLY: 
                case CATCH: 
                case THIS: 
                case SUPER: 
                case NEW: {
                    if (!bl4) break;
                    return;
                }
                case ASSERT: {
                    if (!bl4) break;
                    return;
                }
            }
            this.nextToken();
        }
    }

    protected JCTree.JCErroneous syntaxError(int n, String string, Tokens.TokenKind ... tokenKindArray) {
        return this.syntaxError(n, List.nil(), string, tokenKindArray);
    }

    protected JCTree.JCErroneous syntaxError(int n, List<JCTree> list, String string, Tokens.TokenKind ... tokenKindArray) {
        JCTree jCTree;
        this.setErrorEndPos(n);
        JCTree.JCErroneous jCErroneous = this.F.at(n).Erroneous(list);
        this.reportSyntaxError(jCErroneous, string, (Object[])tokenKindArray);
        if (list != null && (jCTree = list.last()) != null) {
            this.storeEnd(jCTree, n);
        }
        return this.toP(jCErroneous);
    }

    protected void reportSyntaxError(int n, String string, Object ... objectArray) {
        JCDiagnostic.SimpleDiagnosticPosition simpleDiagnosticPosition = new JCDiagnostic.SimpleDiagnosticPosition(n);
        this.reportSyntaxError(simpleDiagnosticPosition, string, objectArray);
    }

    protected void reportSyntaxError(JCDiagnostic.DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
        int n = diagnosticPosition.getPreferredPosition();
        if (n > this.S.errPos() || n == -1) {
            if (this.token.kind == Tokens.TokenKind.EOF) {
                this.error(diagnosticPosition, "premature.eof", new Object[0]);
            } else {
                this.error(diagnosticPosition, string, objectArray);
            }
        }
        this.S.errPos(n);
        if (this.token.pos == this.errorPos) {
            Assert.check(this.count++ < 50);
        } else {
            this.count = 0;
            this.errorPos = this.token.pos;
        }
    }

    protected JCTree.JCErroneous syntaxError(String string) {
        return this.syntaxError(this.token.pos, string, new Tokens.TokenKind[0]);
    }

    protected JCTree.JCErroneous syntaxError(String string, Tokens.TokenKind tokenKind) {
        return this.syntaxError(this.token.pos, string, tokenKind);
    }

    public void accept(Tokens.TokenKind tokenKind) {
        if (this.token.kind == tokenKind) {
            this.nextToken();
        } else {
            this.setErrorEndPos(this.token.pos);
            this.reportSyntaxError(this.S.prevToken().endPos, "expected", tokenKind);
        }
    }

    JCTree.JCExpression illegal(int n) {
        this.setErrorEndPos(n);
        if ((this.mode & 1) != 0) {
            return this.syntaxError(n, "illegal.start.of.expr", new Tokens.TokenKind[0]);
        }
        return this.syntaxError(n, "illegal.start.of.type", new Tokens.TokenKind[0]);
    }

    JCTree.JCExpression illegal() {
        return this.illegal(this.token.pos);
    }

    protected void checkNoMods(long l) {
        if (l != 0L) {
            long l2 = l & -l;
            this.error(this.token.pos, "mod.not.allowed.here", Flags.asFlagSet(l2));
        }
    }

    protected void attach(JCTree jCTree, Tokens.Comment comment) {
        if (this.keepDocComments && comment != null) {
            this.docComments.putComment(jCTree, comment);
        }
    }

    protected void setErrorEndPos(int n) {
        this.endPosTable.setErrorEndPos(n);
    }

    protected void storeEnd(JCTree jCTree, int n) {
        this.endPosTable.storeEnd(jCTree, n);
    }

    protected <T extends JCTree> T to(T t) {
        return this.endPosTable.to(t);
    }

    protected <T extends JCTree> T toP(T t) {
        return this.endPosTable.toP(t);
    }

    public int getStartPos(JCTree jCTree) {
        return TreeInfo.getStartPos(jCTree);
    }

    public int getEndPos(JCTree jCTree) {
        return this.endPosTable.getEndPos(jCTree);
    }

    public Name ident() {
        return this.ident(false);
    }

    protected Name ident(boolean bl) {
        if (this.token.kind == Tokens.TokenKind.IDENTIFIER) {
            Name name = this.token.name();
            this.nextToken();
            return name;
        }
        if (this.token.kind == Tokens.TokenKind.ASSERT) {
            this.error(this.token.pos, "assert.as.identifier", new Object[0]);
            this.nextToken();
            return this.names.error;
        }
        if (this.token.kind == Tokens.TokenKind.ENUM) {
            this.error(this.token.pos, "enum.as.identifier", new Object[0]);
            this.nextToken();
            return this.names.error;
        }
        if (this.token.kind == Tokens.TokenKind.THIS) {
            if (this.allowThisIdent) {
                this.checkTypeAnnotations();
                Name name = this.token.name();
                this.nextToken();
                return name;
            }
            this.error(this.token.pos, "this.as.identifier", new Object[0]);
            this.nextToken();
            return this.names.error;
        }
        if (this.token.kind == Tokens.TokenKind.UNDERSCORE) {
            if (this.allowUnderscoreIdentifier) {
                this.warning(this.token.pos, "underscore.as.identifier", new Object[0]);
            } else {
                this.error(this.token.pos, "underscore.as.identifier", new Object[0]);
            }
            Name name = this.token.name();
            this.nextToken();
            return name;
        }
        this.accept(Tokens.TokenKind.IDENTIFIER);
        if (bl) {
            this.nextToken();
        }
        return this.names.error;
    }

    public JCTree.JCExpression qualident(boolean bl) {
        JCTree.JCExpression jCExpression = this.toP(this.F.at(this.token.pos).Ident(this.ident()));
        while (this.token.kind == Tokens.TokenKind.DOT) {
            int n = this.token.pos;
            this.nextToken();
            List<JCTree.JCAnnotation> list = null;
            if (bl) {
                list = this.typeAnnotationsOpt();
            }
            jCExpression = this.toP(this.F.at(n).Select(jCExpression, this.ident()));
            if (list == null || !list.nonEmpty()) continue;
            jCExpression = this.toP(this.F.at(((JCTree.JCAnnotation)list.head).pos).AnnotatedType(list, jCExpression));
        }
        return jCExpression;
    }

    JCTree.JCExpression literal(Name name) {
        return this.literal(name, this.token.pos);
    }

    JCTree.JCExpression literal(Name name, int n) {
        JCTree.JCExpression jCExpression = this.errorTree;
        switch (this.token.kind) {
            case INTLITERAL: {
                try {
                    jCExpression = this.F.at(n).Literal(TypeTag.INT, Convert.string2int(this.strval(name), this.token.radix()));
                }
                catch (NumberFormatException numberFormatException) {
                    this.error(this.token.pos, "int.number.too.large", this.strval(name));
                }
                break;
            }
            case LONGLITERAL: {
                try {
                    jCExpression = this.F.at(n).Literal(TypeTag.LONG, Convert.string2long(this.strval(name), this.token.radix()));
                }
                catch (NumberFormatException numberFormatException) {
                    this.error(this.token.pos, "int.number.too.large", this.strval(name));
                }
                break;
            }
            case FLOATLITERAL: {
                Float f;
                String string = this.token.radix() == 16 ? "0x" + this.token.stringVal() : this.token.stringVal();
                try {
                    f = Float.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    f = Float.valueOf(Float.NaN);
                }
                if (f.floatValue() == 0.0f && !this.isZero(string)) {
                    this.error(this.token.pos, "fp.number.too.small", new Object[0]);
                    break;
                }
                if (f.floatValue() == Float.POSITIVE_INFINITY) {
                    this.error(this.token.pos, "fp.number.too.large", new Object[0]);
                    break;
                }
                jCExpression = this.F.at(n).Literal(TypeTag.FLOAT, f);
                break;
            }
            case DOUBLELITERAL: {
                Double d;
                String string = this.token.radix() == 16 ? "0x" + this.token.stringVal() : this.token.stringVal();
                try {
                    d = Double.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    d = Double.NaN;
                }
                if (d == 0.0 && !this.isZero(string)) {
                    this.error(this.token.pos, "fp.number.too.small", new Object[0]);
                    break;
                }
                if (d == Double.POSITIVE_INFINITY) {
                    this.error(this.token.pos, "fp.number.too.large", new Object[0]);
                    break;
                }
                jCExpression = this.F.at(n).Literal(TypeTag.DOUBLE, d);
                break;
            }
            case CHARLITERAL: {
                jCExpression = this.F.at(n).Literal(TypeTag.CHAR, this.token.stringVal().charAt(0) + '\u0000');
                break;
            }
            case STRINGLITERAL: {
                jCExpression = this.F.at(n).Literal(TypeTag.CLASS, this.token.stringVal());
                break;
            }
            case TRUE: 
            case FALSE: {
                jCExpression = this.F.at(n).Literal(TypeTag.BOOLEAN, this.token.kind == Tokens.TokenKind.TRUE ? 1 : 0);
                break;
            }
            case NULL: {
                jCExpression = this.F.at(n).Literal(TypeTag.BOT, null);
                break;
            }
            default: {
                Assert.error();
            }
        }
        if (jCExpression == this.errorTree) {
            jCExpression = this.F.at(n).Erroneous();
        }
        this.storeEnd(jCExpression, this.token.endPos);
        this.nextToken();
        return jCExpression;
    }

    boolean isZero(String string) {
        int n;
        char[] cArray = string.toCharArray();
        int n2 = cArray.length > 1 && Character.toLowerCase(cArray[1]) == 'x' ? 16 : 10;
        int n3 = n = n2 == 16 ? 2 : 0;
        while (n < cArray.length && (cArray[n] == '0' || cArray[n] == '.')) {
            ++n;
        }
        return n >= cArray.length || Character.digit(cArray[n], n2) <= 0;
    }

    String strval(Name name) {
        String string = this.token.stringVal();
        return name.isEmpty() ? string : name + string;
    }

    @Override
    public JCTree.JCExpression parseExpression() {
        return this.term(1);
    }

    @Override
    public JCTree.JCExpression parseType() {
        List<JCTree.JCAnnotation> list = this.typeAnnotationsOpt();
        return this.parseType(list);
    }

    public JCTree.JCExpression parseType(List<JCTree.JCAnnotation> list) {
        JCTree.JCExpression jCExpression = this.unannotatedType();
        if (list.nonEmpty()) {
            jCExpression = this.insertAnnotationsToMostInner(jCExpression, list, false);
        }
        return jCExpression;
    }

    public JCTree.JCExpression unannotatedType() {
        return this.term(2);
    }

    protected JCTree.JCExpression term(int n) {
        int n2 = this.mode;
        this.mode = n;
        JCTree.JCExpression jCExpression = this.term();
        this.lastmode = this.mode;
        this.mode = n2;
        return jCExpression;
    }

    JCTree.JCExpression term() {
        JCTree.JCExpression jCExpression = this.term1();
        if ((this.mode & 1) != 0 && this.token.kind == Tokens.TokenKind.EQ || Tokens.TokenKind.PLUSEQ.compareTo(this.token.kind) <= 0 && this.token.kind.compareTo(Tokens.TokenKind.GTGTGTEQ) <= 0) {
            return this.termRest(jCExpression);
        }
        return jCExpression;
    }

    JCTree.JCExpression termRest(JCTree.JCExpression jCExpression) {
        switch (this.token.kind) {
            case EQ: {
                int n = this.token.pos;
                this.nextToken();
                this.mode = 1;
                JCTree.JCExpression jCExpression2 = this.term();
                return this.toP(this.F.at(n).Assign(jCExpression, jCExpression2));
            }
            case PLUSEQ: 
            case SUBEQ: 
            case STAREQ: 
            case SLASHEQ: 
            case PERCENTEQ: 
            case AMPEQ: 
            case BAREQ: 
            case CARETEQ: 
            case LTLTEQ: 
            case GTGTEQ: 
            case GTGTGTEQ: {
                int n = this.token.pos;
                Tokens.TokenKind tokenKind = this.token.kind;
                this.nextToken();
                this.mode = 1;
                JCTree.JCExpression jCExpression3 = this.term();
                return this.F.at(n).Assignop(JavacParser.optag(tokenKind), jCExpression, jCExpression3);
            }
        }
        return jCExpression;
    }

    JCTree.JCExpression term1() {
        JCTree.JCExpression jCExpression = this.term2();
        if ((this.mode & 1) != 0 && this.token.kind == Tokens.TokenKind.QUES) {
            this.mode = 1;
            return this.term1Rest(jCExpression);
        }
        return jCExpression;
    }

    JCTree.JCExpression term1Rest(JCTree.JCExpression jCExpression) {
        if (this.token.kind == Tokens.TokenKind.QUES) {
            int n = this.token.pos;
            this.nextToken();
            JCTree.JCExpression jCExpression2 = this.term();
            this.accept(Tokens.TokenKind.COLON);
            JCTree.JCExpression jCExpression3 = this.term1();
            return this.F.at(n).Conditional(jCExpression, jCExpression2, jCExpression3);
        }
        return jCExpression;
    }

    JCTree.JCExpression term2() {
        JCTree.JCExpression jCExpression = this.term3();
        if ((this.mode & 1) != 0 && JavacParser.prec(this.token.kind) >= 4) {
            this.mode = 1;
            return this.term2Rest(jCExpression, 4);
        }
        return jCExpression;
    }

    JCTree.JCExpression term2Rest(JCTree.JCExpression jCExpression, int n) {
        JCTree.JCExpression[] jCExpressionArray = this.newOdStack();
        Tokens.Token[] tokenArray = this.newOpStack();
        int n2 = 0;
        jCExpressionArray[0] = jCExpression;
        int n3 = this.token.pos;
        Tokens.Token token = Tokens.DUMMY;
        while (JavacParser.prec(this.token.kind) >= n) {
            tokenArray[n2] = token;
            token = this.token;
            this.nextToken();
            JCTree.JCExpression jCExpression2 = jCExpressionArray[++n2] = token.kind == Tokens.TokenKind.INSTANCEOF ? this.parseType() : this.term3();
            while (n2 > 0 && JavacParser.prec(token.kind) >= JavacParser.prec(this.token.kind)) {
                jCExpressionArray[n2 - 1] = this.makeOp(token.pos, token.kind, jCExpressionArray[n2 - 1], jCExpressionArray[n2]);
                token = tokenArray[--n2];
            }
        }
        Assert.check(n2 == 0);
        jCExpression = jCExpressionArray[0];
        if (jCExpression.hasTag(JCTree.Tag.PLUS)) {
            jCExpression = this.foldStrings(jCExpression);
        }
        this.odStackSupply.add(jCExpressionArray);
        this.opStackSupply.add(tokenArray);
        return jCExpression;
    }

    private JCTree.JCExpression makeOp(int n, Tokens.TokenKind tokenKind, JCTree.JCExpression jCExpression, JCTree.JCExpression jCExpression2) {
        if (tokenKind == Tokens.TokenKind.INSTANCEOF) {
            return this.F.at(n).TypeTest(jCExpression, jCExpression2);
        }
        return this.F.at(n).Binary(JavacParser.optag(tokenKind), jCExpression, jCExpression2);
    }

    protected JCTree.JCExpression foldStrings(JCTree.JCExpression jCExpression) {
        Object object;
        if (!this.allowStringFolding) {
            return jCExpression;
        }
        ListBuffer<JCTree.JCExpression> listBuffer = new ListBuffer<JCTree.JCExpression>();
        ListBuffer<JCTree.JCLiteral> listBuffer2 = new ListBuffer<JCTree.JCLiteral>();
        boolean bl = false;
        JCTree.JCExpression jCExpression2 = jCExpression;
        while (jCExpression2.hasTag(JCTree.Tag.PLUS)) {
            object = (JCTree.JCBinary)jCExpression2;
            bl |= this.foldIfNeeded(((JCTree.JCBinary)object).rhs, listBuffer2, listBuffer, false);
            jCExpression2 = ((JCTree.JCBinary)object).lhs;
        }
        if (bl |= this.foldIfNeeded(jCExpression2, listBuffer2, listBuffer, true)) {
            object = listBuffer.toList();
            JCTree.JCExpression jCExpression3 = (JCTree.JCExpression)((List)object).head;
            for (JCTree.JCExpression jCExpression4 : ((List)object).tail) {
                jCExpression3 = this.F.at(jCExpression4.getStartPosition()).Binary(JavacParser.optag(Tokens.TokenKind.PLUS), jCExpression3, jCExpression4);
                this.storeEnd(jCExpression3, this.getEndPos(jCExpression4));
            }
            return jCExpression3;
        }
        return jCExpression;
    }

    private boolean foldIfNeeded(JCTree.JCExpression jCExpression, ListBuffer<JCTree.JCLiteral> listBuffer, ListBuffer<JCTree.JCExpression> listBuffer2, boolean bl) {
        JCTree.JCLiteral jCLiteral = this.stringLiteral(jCExpression);
        if (jCLiteral != null) {
            listBuffer.prepend(jCLiteral);
            return bl && this.merge(listBuffer, listBuffer2);
        }
        boolean bl2 = this.merge(listBuffer, listBuffer2);
        listBuffer.clear();
        listBuffer2.prepend(jCExpression);
        return bl2;
    }

    boolean merge(ListBuffer<JCTree.JCLiteral> listBuffer, ListBuffer<JCTree.JCExpression> listBuffer2) {
        if (listBuffer.isEmpty()) {
            return false;
        }
        if (listBuffer.size() == 1) {
            listBuffer2.prepend(listBuffer.first());
            return false;
        }
        JCTree.JCLiteral jCLiteral2 = this.F.at(listBuffer.first().getStartPosition()).Literal(TypeTag.CLASS, listBuffer.stream().map(jCLiteral -> (String)jCLiteral.getValue()).collect(Collectors.joining()));
        this.storeEnd(jCLiteral2, listBuffer.last().getEndPosition(this.endPosTable));
        listBuffer2.prepend(jCLiteral2);
        return true;
    }

    private JCTree.JCLiteral stringLiteral(JCTree jCTree) {
        if (jCTree.hasTag(JCTree.Tag.LITERAL)) {
            JCTree.JCLiteral jCLiteral = (JCTree.JCLiteral)jCTree;
            if (jCLiteral.typetag == TypeTag.CLASS) {
                return jCLiteral;
            }
        }
        return null;
    }

    private JCTree.JCExpression[] newOdStack() {
        if (this.odStackSupply.isEmpty()) {
            return new JCTree.JCExpression[11];
        }
        return this.odStackSupply.remove(this.odStackSupply.size() - 1);
    }

    private Tokens.Token[] newOpStack() {
        if (this.opStackSupply.isEmpty()) {
            return new Tokens.Token[11];
        }
        return this.opStackSupply.remove(this.opStackSupply.size() - 1);
    }

    protected JCTree.JCExpression term3() {
        JCTree.JCExpression jCExpression;
        int n = this.token.pos;
        List<JCTree.JCExpression> list = this.typeArgumentsOpt(1);
        block0 : switch (this.token.kind) {
            case QUES: {
                if ((this.mode & 2) != 0 && (this.mode & 0xC) == 8) {
                    this.mode = 2;
                    return this.typeArgument();
                }
                return this.illegal();
            }
            case PLUSPLUS: 
            case SUBSUB: 
            case BANG: 
            case TILDE: 
            case PLUS: 
            case SUB: {
                if (list == null && (this.mode & 1) != 0) {
                    Tokens.TokenKind tokenKind = this.token.kind;
                    this.nextToken();
                    this.mode = 1;
                    if (tokenKind == Tokens.TokenKind.SUB && (this.token.kind == Tokens.TokenKind.INTLITERAL || this.token.kind == Tokens.TokenKind.LONGLITERAL) && this.token.radix() == 10) {
                        this.mode = 1;
                        jCExpression = this.literal(this.names.hyphen, n);
                        break;
                    }
                    JCTree.JCExpression jCExpression2 = this.term3();
                    return this.F.at(n).Unary(JavacParser.unoptag(tokenKind), jCExpression2);
                }
                return this.illegal();
            }
            case LPAREN: {
                if (list == null && (this.mode & 1) != 0) {
                    ParensResult parensResult = this.analyzeParens();
                    switch (parensResult) {
                        case CAST: {
                            this.accept(Tokens.TokenKind.LPAREN);
                            this.mode = 2;
                            int n2 = n;
                            JCTree.JCExpression jCExpression3 = this.term3();
                            List<JCTree.JCExpression> list2 = List.of(jCExpression3);
                            while (this.token.kind == Tokens.TokenKind.AMP) {
                                this.checkIntersectionTypesInCast();
                                this.accept(Tokens.TokenKind.AMP);
                                list2 = list2.prepend(this.term3());
                            }
                            if (list2.length() > 1) {
                                jCExpression3 = this.toP(this.F.at(n2).TypeIntersection(list2.reverse()));
                            }
                            this.accept(Tokens.TokenKind.RPAREN);
                            this.mode = 1;
                            JCTree.JCExpression jCExpression4 = this.term3();
                            return this.F.at(n).TypeCast(jCExpression3, jCExpression4);
                        }
                        case IMPLICIT_LAMBDA: 
                        case EXPLICIT_LAMBDA: {
                            jCExpression = this.lambdaExpressionOrStatement(true, parensResult == ParensResult.EXPLICIT_LAMBDA, n);
                            break block0;
                        }
                    }
                    this.accept(Tokens.TokenKind.LPAREN);
                    this.mode = 1;
                    jCExpression = this.termRest(this.term1Rest(this.term2Rest(this.term3(), 4)));
                    this.accept(Tokens.TokenKind.RPAREN);
                    jCExpression = this.toP(this.F.at(n).Parens(jCExpression));
                    break;
                }
                return this.illegal();
            }
            case THIS: {
                if ((this.mode & 1) != 0) {
                    this.mode = 1;
                    jCExpression = this.to(this.F.at(n).Ident(this.names._this));
                    this.nextToken();
                    jCExpression = list == null ? this.argumentsOpt(null, jCExpression) : this.arguments(list, jCExpression);
                    list = null;
                    break;
                }
                return this.illegal();
            }
            case SUPER: {
                if ((this.mode & 1) != 0) {
                    this.mode = 1;
                    jCExpression = this.to(this.F.at(n).Ident(this.names._super));
                    jCExpression = this.superSuffix(list, jCExpression);
                    list = null;
                    break;
                }
                return this.illegal();
            }
            case INTLITERAL: 
            case LONGLITERAL: 
            case FLOATLITERAL: 
            case DOUBLELITERAL: 
            case CHARLITERAL: 
            case STRINGLITERAL: 
            case TRUE: 
            case FALSE: 
            case NULL: {
                if (list == null && (this.mode & 1) != 0) {
                    this.mode = 1;
                    jCExpression = this.literal(this.names.empty);
                    break;
                }
                return this.illegal();
            }
            case NEW: {
                if (list != null) {
                    return this.illegal();
                }
                if ((this.mode & 1) != 0) {
                    this.mode = 1;
                    this.nextToken();
                    if (this.token.kind == Tokens.TokenKind.LT) {
                        list = this.typeArguments(false);
                    }
                    jCExpression = this.creator(n, list);
                    list = null;
                    break;
                }
                return this.illegal();
            }
            case MONKEYS_AT: {
                List<JCTree.JCAnnotation> list3 = this.typeAnnotationsOpt();
                if (list3.isEmpty()) {
                    throw new AssertionError((Object)"Expected type annotations, but found none!");
                }
                JCTree.JCExpression jCExpression5 = this.term3();
                if ((this.mode & 2) == 0) {
                    switch (jCExpression5.getTag()) {
                        case REFERENCE: {
                            JCTree.JCMemberReference jCMemberReference = (JCTree.JCMemberReference)jCExpression5;
                            jCMemberReference.expr = this.toP(this.F.at(n).AnnotatedType(list3, jCMemberReference.expr));
                            jCExpression = jCMemberReference;
                            break block0;
                        }
                        case SELECT: {
                            JCTree.JCFieldAccess jCFieldAccess = (JCTree.JCFieldAccess)jCExpression5;
                            if (jCFieldAccess.name != this.names._class) {
                                return this.illegal();
                            }
                            this.log.error(this.token.pos, "no.annotations.on.dot.class", new Object[0]);
                            return jCExpression5;
                        }
                    }
                    return this.illegal(((JCTree.JCAnnotation)list3.head).pos);
                }
                jCExpression = this.insertAnnotationsToMostInner(jCExpression5, list3, false);
                break;
            }
            case ENUM: 
            case UNDERSCORE: 
            case IDENTIFIER: 
            case ASSERT: {
                if (list != null) {
                    return this.illegal();
                }
                if ((this.mode & 1) != 0 && this.peekToken((Filter<Tokens.TokenKind>)Tokens.TokenKind.ARROW)) {
                    jCExpression = this.lambdaExpressionOrStatement(false, false, n);
                } else {
                    jCExpression = this.toP(this.F.at(this.token.pos).Ident(this.ident()));
                    block35: while (true) {
                        n = this.token.pos;
                        List<JCTree.JCAnnotation> list4 = this.typeAnnotationsOpt();
                        if (!list4.isEmpty() && this.token.kind != Tokens.TokenKind.LBRACKET && this.token.kind != Tokens.TokenKind.ELLIPSIS) {
                            return this.illegal(((JCTree.JCAnnotation)list4.head).pos);
                        }
                        switch (this.token.kind) {
                            case LBRACKET: {
                                this.nextToken();
                                if (this.token.kind == Tokens.TokenKind.RBRACKET) {
                                    this.nextToken();
                                    jCExpression = this.bracketsOpt(jCExpression);
                                    jCExpression = this.toP(this.F.at(n).TypeArray(jCExpression));
                                    if (list4.nonEmpty()) {
                                        jCExpression = this.toP(this.F.at(n).AnnotatedType(list4, jCExpression));
                                    }
                                    jCExpression = this.bracketsSuffix(jCExpression);
                                    break block35;
                                }
                                if ((this.mode & 1) != 0) {
                                    this.mode = 1;
                                    JCTree.JCExpression jCExpression6 = this.term();
                                    if (!list4.isEmpty()) {
                                        jCExpression = this.illegal(((JCTree.JCAnnotation)list4.head).pos);
                                    }
                                    jCExpression = this.to(this.F.at(n).Indexed(jCExpression, jCExpression6));
                                }
                                this.accept(Tokens.TokenKind.RBRACKET);
                                break block35;
                            }
                            case LPAREN: {
                                if ((this.mode & 1) != 0) {
                                    this.mode = 1;
                                    jCExpression = this.arguments(list, jCExpression);
                                    if (!list4.isEmpty()) {
                                        jCExpression = this.illegal(((JCTree.JCAnnotation)list4.head).pos);
                                    }
                                    list = null;
                                }
                                break block35;
                            }
                            case DOT: {
                                this.nextToken();
                                int n3 = this.mode;
                                this.mode &= 0xFFFFFFFB;
                                list = this.typeArgumentsOpt(1);
                                this.mode = n3;
                                if ((this.mode & 1) != 0) {
                                    switch (this.token.kind) {
                                        case CLASS: {
                                            if (list != null) {
                                                return this.illegal();
                                            }
                                            this.mode = 1;
                                            jCExpression = this.to(this.F.at(n).Select(jCExpression, this.names._class));
                                            this.nextToken();
                                            break block35;
                                        }
                                        case THIS: {
                                            if (list != null) {
                                                return this.illegal();
                                            }
                                            this.mode = 1;
                                            jCExpression = this.to(this.F.at(n).Select(jCExpression, this.names._this));
                                            this.nextToken();
                                            break block35;
                                        }
                                        case SUPER: {
                                            this.mode = 1;
                                            jCExpression = this.to(this.F.at(n).Select(jCExpression, this.names._super));
                                            jCExpression = this.superSuffix(list, jCExpression);
                                            list = null;
                                            break block35;
                                        }
                                        case NEW: {
                                            if (list != null) {
                                                return this.illegal();
                                            }
                                            this.mode = 1;
                                            int n4 = this.token.pos;
                                            this.nextToken();
                                            if (this.token.kind == Tokens.TokenKind.LT) {
                                                list = this.typeArguments(false);
                                            }
                                            jCExpression = this.innerCreator(n4, list, jCExpression);
                                            list = null;
                                            break block35;
                                        }
                                    }
                                }
                                List<JCTree.JCAnnotation> list5 = null;
                                if ((this.mode & 2) != 0 && this.token.kind == Tokens.TokenKind.MONKEYS_AT) {
                                    list5 = this.typeAnnotationsOpt();
                                }
                                jCExpression = this.toP(this.F.at(n).Select(jCExpression, this.ident()));
                                if (list5 == null || !list5.nonEmpty()) continue block35;
                                jCExpression = this.toP(this.F.at(((JCTree.JCAnnotation)list5.head).pos).AnnotatedType(list5, jCExpression));
                                continue block35;
                            }
                            case ELLIPSIS: {
                                if (this.permitTypeAnnotationsPushBack) {
                                    this.typeAnnotationsPushedBack = list4;
                                    break block35;
                                }
                                if (list4.nonEmpty()) {
                                    this.illegal(((JCTree.JCAnnotation)list4.head).pos);
                                }
                                break block35;
                            }
                            case LT: {
                                if ((this.mode & 2) == 0 && this.isUnboundMemberRef()) {
                                    int n5 = this.token.pos;
                                    this.accept(Tokens.TokenKind.LT);
                                    ListBuffer<JCTree.JCExpression> listBuffer = new ListBuffer<JCTree.JCExpression>();
                                    listBuffer.append(this.typeArgument());
                                    while (this.token.kind == Tokens.TokenKind.COMMA) {
                                        this.nextToken();
                                        listBuffer.append(this.typeArgument());
                                    }
                                    this.accept(Tokens.TokenKind.GT);
                                    jCExpression = this.toP(this.F.at(n5).TypeApply(jCExpression, listBuffer.toList()));
                                    while (this.token.kind == Tokens.TokenKind.DOT) {
                                        this.nextToken();
                                        this.mode = 2;
                                        jCExpression = this.toP(this.F.at(this.token.pos).Select(jCExpression, this.ident()));
                                        jCExpression = this.typeArgumentsOpt(jCExpression);
                                    }
                                    jCExpression = this.bracketsOpt(jCExpression);
                                    if (this.token.kind != Tokens.TokenKind.COLCOL) {
                                        jCExpression = this.illegal();
                                    }
                                    this.mode = 1;
                                    return this.term3Rest(jCExpression, list);
                                }
                                break block35;
                            }
                        }
                        break;
                    }
                }
                if (list != null) {
                    this.illegal();
                }
                jCExpression = this.typeArgumentsOpt(jCExpression);
                break;
            }
            case BYTE: 
            case SHORT: 
            case CHAR: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: {
                if (list != null) {
                    this.illegal();
                }
                jCExpression = this.bracketsSuffix(this.bracketsOpt(this.basicType()));
                break;
            }
            case VOID: {
                if (list != null) {
                    this.illegal();
                }
                if ((this.mode & 1) != 0) {
                    this.nextToken();
                    if (this.token.kind == Tokens.TokenKind.DOT) {
                        JCTree.JCPrimitiveTypeTree jCPrimitiveTypeTree = this.toP(this.F.at(n).TypeIdent(TypeTag.VOID));
                        jCExpression = this.bracketsSuffix(jCPrimitiveTypeTree);
                        break;
                    }
                    return this.illegal(n);
                }
                JCTree.JCPrimitiveTypeTree jCPrimitiveTypeTree = this.to(this.F.at(n).TypeIdent(TypeTag.VOID));
                this.nextToken();
                return jCPrimitiveTypeTree;
            }
            default: {
                return this.illegal();
            }
        }
        return this.term3Rest(jCExpression, list);
    }

    JCTree.JCExpression term3Rest(JCTree.JCExpression jCExpression, List<JCTree.JCExpression> list) {
        List<JCTree.JCAnnotation> list2;
        if (list != null) {
            this.illegal();
        }
        while (true) {
            int n;
            int n2 = this.token.pos;
            list2 = this.typeAnnotationsOpt();
            if (this.token.kind == Tokens.TokenKind.LBRACKET) {
                this.nextToken();
                if ((this.mode & 2) != 0) {
                    n = this.mode;
                    this.mode = 2;
                    if (this.token.kind == Tokens.TokenKind.RBRACKET) {
                        this.nextToken();
                        jCExpression = this.bracketsOpt(jCExpression);
                        jCExpression = this.toP(this.F.at(n2).TypeArray(jCExpression));
                        if (this.token.kind == Tokens.TokenKind.COLCOL) {
                            this.mode = 1;
                            continue;
                        }
                        if (list2.nonEmpty()) {
                            jCExpression = this.toP(this.F.at(n2).AnnotatedType(list2, jCExpression));
                        }
                        return jCExpression;
                    }
                    this.mode = n;
                }
                if ((this.mode & 1) != 0) {
                    this.mode = 1;
                    JCTree.JCExpression jCExpression2 = this.term();
                    jCExpression = this.to(this.F.at(n2).Indexed(jCExpression, jCExpression2));
                }
                this.accept(Tokens.TokenKind.RBRACKET);
                continue;
            }
            if (this.token.kind == Tokens.TokenKind.DOT) {
                this.nextToken();
                list = this.typeArgumentsOpt(1);
                if (this.token.kind == Tokens.TokenKind.SUPER && (this.mode & 1) != 0) {
                    this.mode = 1;
                    jCExpression = this.to(this.F.at(n2).Select(jCExpression, this.names._super));
                    this.nextToken();
                    jCExpression = this.arguments(list, jCExpression);
                    list = null;
                    continue;
                }
                if (this.token.kind == Tokens.TokenKind.NEW && (this.mode & 1) != 0) {
                    if (list != null) {
                        return this.illegal();
                    }
                    this.mode = 1;
                    n = this.token.pos;
                    this.nextToken();
                    if (this.token.kind == Tokens.TokenKind.LT) {
                        list = this.typeArguments(false);
                    }
                    jCExpression = this.innerCreator(n, list, jCExpression);
                    list = null;
                    continue;
                }
                List<JCTree.JCAnnotation> list3 = null;
                if ((this.mode & 2) != 0 && this.token.kind == Tokens.TokenKind.MONKEYS_AT) {
                    list3 = this.typeAnnotationsOpt();
                }
                jCExpression = this.toP(this.F.at(n2).Select(jCExpression, this.ident(true)));
                if (list3 != null && list3.nonEmpty()) {
                    jCExpression = this.toP(this.F.at(((JCTree.JCAnnotation)list3.head).pos).AnnotatedType(list3, jCExpression));
                }
                jCExpression = this.argumentsOpt(list, this.typeArgumentsOpt(jCExpression));
                list = null;
                continue;
            }
            if ((this.mode & 1) == 0 || this.token.kind != Tokens.TokenKind.COLCOL) break;
            this.mode = 1;
            if (list != null) {
                return this.illegal();
            }
            this.accept(Tokens.TokenKind.COLCOL);
            jCExpression = this.memberReferenceSuffix(n2, jCExpression);
        }
        if (!list2.isEmpty()) {
            if (this.permitTypeAnnotationsPushBack) {
                this.typeAnnotationsPushedBack = list2;
            } else {
                return this.illegal(((JCTree.JCAnnotation)list2.head).pos);
            }
        }
        while ((this.token.kind == Tokens.TokenKind.PLUSPLUS || this.token.kind == Tokens.TokenKind.SUBSUB) && (this.mode & 1) != 0) {
            this.mode = 1;
            jCExpression = this.to(this.F.at(this.token.pos).Unary(this.token.kind == Tokens.TokenKind.PLUSPLUS ? JCTree.Tag.POSTINC : JCTree.Tag.POSTDEC, jCExpression));
            this.nextToken();
        }
        return this.toP(jCExpression);
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean isUnboundMemberRef() {
        int n = 0;
        int n2 = 0;
        Tokens.Token token = this.S.token(n);
        while (true) {
            block0 : switch (token.kind) {
                case MONKEYS_AT: 
                case BYTE: 
                case SHORT: 
                case CHAR: 
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: 
                case BOOLEAN: 
                case UNDERSCORE: 
                case IDENTIFIER: 
                case SUPER: 
                case LBRACKET: 
                case DOT: 
                case QUES: 
                case EXTENDS: 
                case RBRACKET: 
                case COMMA: {
                    break;
                }
                case LPAREN: {
                    Tokens.TokenKind tokenKind;
                    int n3 = 0;
                    while (true) {
                        tokenKind = this.S.token((int)n).kind;
                        switch (tokenKind) {
                            case EOF: {
                                return false;
                            }
                            case LPAREN: {
                                ++n3;
                                break;
                            }
                            case RPAREN: {
                                if (--n3 == 0) break block0;
                            }
                        }
                        ++n;
                    }
                }
                case LT: {
                    ++n2;
                    break;
                }
                case GTGTGT: {
                    --n2;
                }
                case GTGT: {
                    --n2;
                }
                case GT: {
                    if (--n2 != 0) break;
                    Tokens.TokenKind tokenKind = this.S.token((int)(n + 1)).kind;
                    if (tokenKind == Tokens.TokenKind.DOT) return true;
                    if (tokenKind == Tokens.TokenKind.LBRACKET) return true;
                    if (tokenKind == Tokens.TokenKind.COLCOL) return true;
                    return false;
                }
                default: {
                    return false;
                }
            }
            token = this.S.token(++n);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    ParensResult analyzeParens() {
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        while (true) {
            Tokens.TokenKind tokenKind = this.S.token((int)n2).kind;
            block0 : switch (tokenKind) {
                case COMMA: {
                    bl = true;
                }
                case SUPER: 
                case DOT: 
                case EXTENDS: 
                case AMP: {
                    break;
                }
                case QUES: {
                    if (!this.peekToken(n2, (Filter<Tokens.TokenKind>)Tokens.TokenKind.EXTENDS) && !this.peekToken(n2, (Filter<Tokens.TokenKind>)Tokens.TokenKind.SUPER)) break;
                    bl = true;
                    break;
                }
                case BYTE: 
                case SHORT: 
                case CHAR: 
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: 
                case BOOLEAN: 
                case VOID: {
                    if (this.peekToken(n2, (Filter<Tokens.TokenKind>)Tokens.TokenKind.RPAREN)) {
                        return ParensResult.CAST;
                    }
                    if (!this.peekToken(n2, this.LAX_IDENTIFIER)) break;
                    return ParensResult.EXPLICIT_LAMBDA;
                }
                case LPAREN: {
                    if (n2 != 0) {
                        return ParensResult.PARENS;
                    }
                    if (!this.peekToken(n2, (Filter<Tokens.TokenKind>)Tokens.TokenKind.RPAREN)) break;
                    return ParensResult.EXPLICIT_LAMBDA;
                }
                case RPAREN: {
                    if (bl) {
                        return ParensResult.CAST;
                    }
                    switch (this.S.token((int)(n2 + 1)).kind) {
                        case ENUM: 
                        case BYTE: 
                        case SHORT: 
                        case CHAR: 
                        case INT: 
                        case LONG: 
                        case FLOAT: 
                        case DOUBLE: 
                        case BOOLEAN: 
                        case VOID: 
                        case UNDERSCORE: 
                        case IDENTIFIER: 
                        case THIS: 
                        case SUPER: 
                        case NEW: 
                        case ASSERT: 
                        case INTLITERAL: 
                        case LONGLITERAL: 
                        case FLOATLITERAL: 
                        case DOUBLELITERAL: 
                        case CHARLITERAL: 
                        case STRINGLITERAL: 
                        case TRUE: 
                        case FALSE: 
                        case NULL: 
                        case LPAREN: 
                        case BANG: 
                        case TILDE: {
                            return ParensResult.CAST;
                        }
                    }
                    return ParensResult.PARENS;
                }
                case ENUM: 
                case UNDERSCORE: 
                case IDENTIFIER: 
                case ASSERT: {
                    if (this.peekToken(n2, this.LAX_IDENTIFIER)) {
                        return ParensResult.EXPLICIT_LAMBDA;
                    }
                    if (this.peekToken(n2, (Filter<Tokens.TokenKind>)Tokens.TokenKind.RPAREN, (Filter<Tokens.TokenKind>)Tokens.TokenKind.ARROW)) {
                        return ParensResult.IMPLICIT_LAMBDA;
                    }
                    bl = false;
                    break;
                }
                case FINAL: 
                case ELLIPSIS: {
                    return ParensResult.EXPLICIT_LAMBDA;
                }
                case MONKEYS_AT: {
                    bl = true;
                    ++n2;
                    while (this.peekToken(n2, (Filter<Tokens.TokenKind>)Tokens.TokenKind.DOT)) {
                        n2 += 2;
                    }
                    if (!this.peekToken(n2, (Filter<Tokens.TokenKind>)Tokens.TokenKind.LPAREN)) break;
                    ++n2;
                    int n3 = 0;
                    while (true) {
                        Tokens.TokenKind tokenKind2 = this.S.token((int)n2).kind;
                        switch (tokenKind2) {
                            case EOF: {
                                return ParensResult.PARENS;
                            }
                            case LPAREN: {
                                ++n3;
                                break;
                            }
                            case RPAREN: {
                                if (--n3 == 0) break block0;
                            }
                        }
                        ++n2;
                    }
                }
                case LBRACKET: {
                    if (this.peekToken(n2, (Filter<Tokens.TokenKind>)Tokens.TokenKind.RBRACKET, this.LAX_IDENTIFIER)) {
                        return ParensResult.EXPLICIT_LAMBDA;
                    }
                    if (this.peekToken(n2, (Filter<Tokens.TokenKind>)Tokens.TokenKind.RBRACKET, (Filter<Tokens.TokenKind>)Tokens.TokenKind.RPAREN) || this.peekToken(n2, (Filter<Tokens.TokenKind>)Tokens.TokenKind.RBRACKET, (Filter<Tokens.TokenKind>)Tokens.TokenKind.AMP)) {
                        return ParensResult.CAST;
                    }
                    if (!this.peekToken(n2, (Filter<Tokens.TokenKind>)Tokens.TokenKind.RBRACKET)) {
                        return ParensResult.PARENS;
                    }
                    bl = true;
                    ++n2;
                    break;
                }
                case LT: {
                    ++n;
                    break;
                }
                case GTGTGT: {
                    --n;
                }
                case GTGT: {
                    --n;
                }
                case GT: {
                    if (--n == 0) {
                        if (this.peekToken(n2, (Filter<Tokens.TokenKind>)Tokens.TokenKind.RPAREN) || this.peekToken(n2, (Filter<Tokens.TokenKind>)Tokens.TokenKind.AMP)) {
                            return ParensResult.CAST;
                        }
                        if (this.peekToken(n2, this.LAX_IDENTIFIER, (Filter<Tokens.TokenKind>)Tokens.TokenKind.COMMA) || this.peekToken(n2, this.LAX_IDENTIFIER, (Filter<Tokens.TokenKind>)Tokens.TokenKind.RPAREN, (Filter<Tokens.TokenKind>)Tokens.TokenKind.ARROW) || this.peekToken(n2, (Filter<Tokens.TokenKind>)Tokens.TokenKind.ELLIPSIS)) {
                            return ParensResult.EXPLICIT_LAMBDA;
                        }
                        bl = true;
                        break;
                    }
                    if (n >= 0) break;
                    return ParensResult.PARENS;
                }
                default: {
                    return ParensResult.PARENS;
                }
            }
            ++n2;
        }
    }

    JCTree.JCExpression lambdaExpressionOrStatement(boolean bl, boolean bl2, int n) {
        List<JCTree.JCVariableDecl> list = bl2 ? this.formalParameters(true) : this.implicitParameters(bl);
        return this.lambdaExpressionOrStatementRest(list, n);
    }

    JCTree.JCExpression lambdaExpressionOrStatementRest(List<JCTree.JCVariableDecl> list, int n) {
        this.checkLambda();
        this.accept(Tokens.TokenKind.ARROW);
        return this.token.kind == Tokens.TokenKind.LBRACE ? this.lambdaStatement(list, n, this.token.pos) : this.lambdaExpression(list, n);
    }

    JCTree.JCExpression lambdaStatement(List<JCTree.JCVariableDecl> list, int n, int n2) {
        JCTree.JCBlock jCBlock = this.block(n2, 0L);
        return this.toP(this.F.at(n).Lambda(list, jCBlock));
    }

    JCTree.JCExpression lambdaExpression(List<JCTree.JCVariableDecl> list, int n) {
        JCTree.JCExpression jCExpression = this.parseExpression();
        return this.toP(this.F.at(n).Lambda(list, jCExpression));
    }

    JCTree.JCExpression superSuffix(List<JCTree.JCExpression> list, JCTree.JCExpression jCExpression) {
        this.nextToken();
        if (this.token.kind == Tokens.TokenKind.LPAREN || list != null) {
            jCExpression = this.arguments(list, jCExpression);
        } else if (this.token.kind == Tokens.TokenKind.COLCOL) {
            if (list != null) {
                return this.illegal();
            }
            jCExpression = this.memberReferenceSuffix(jCExpression);
        } else {
            int n = this.token.pos;
            this.accept(Tokens.TokenKind.DOT);
            list = this.token.kind == Tokens.TokenKind.LT ? this.typeArguments(false) : null;
            jCExpression = this.toP(this.F.at(n).Select(jCExpression, this.ident()));
            jCExpression = this.argumentsOpt(list, jCExpression);
        }
        return jCExpression;
    }

    JCTree.JCPrimitiveTypeTree basicType() {
        JCTree.JCPrimitiveTypeTree jCPrimitiveTypeTree = this.to(this.F.at(this.token.pos).TypeIdent(JavacParser.typetag(this.token.kind)));
        this.nextToken();
        return jCPrimitiveTypeTree;
    }

    JCTree.JCExpression argumentsOpt(List<JCTree.JCExpression> list, JCTree.JCExpression jCExpression) {
        if ((this.mode & 1) != 0 && this.token.kind == Tokens.TokenKind.LPAREN || list != null) {
            this.mode = 1;
            return this.arguments(list, jCExpression);
        }
        return jCExpression;
    }

    List<JCTree.JCExpression> arguments() {
        ListBuffer<JCTree.JCExpression> listBuffer = new ListBuffer<JCTree.JCExpression>();
        if (this.token.kind == Tokens.TokenKind.LPAREN) {
            this.nextToken();
            if (this.token.kind != Tokens.TokenKind.RPAREN) {
                listBuffer.append(this.parseExpression());
                while (this.token.kind == Tokens.TokenKind.COMMA) {
                    this.nextToken();
                    listBuffer.append(this.parseExpression());
                }
            }
            this.accept(Tokens.TokenKind.RPAREN);
        } else {
            this.syntaxError(this.token.pos, "expected", Tokens.TokenKind.LPAREN);
        }
        return listBuffer.toList();
    }

    JCTree.JCMethodInvocation arguments(List<JCTree.JCExpression> list, JCTree.JCExpression jCExpression) {
        int n = this.token.pos;
        List<JCTree.JCExpression> list2 = this.arguments();
        return this.toP(this.F.at(n).Apply(list, jCExpression, list2));
    }

    JCTree.JCExpression typeArgumentsOpt(JCTree.JCExpression jCExpression) {
        if (this.token.kind == Tokens.TokenKind.LT && (this.mode & 2) != 0 && (this.mode & 4) == 0) {
            this.mode = 2;
            return this.typeArguments(jCExpression, false);
        }
        return jCExpression;
    }

    List<JCTree.JCExpression> typeArgumentsOpt() {
        return this.typeArgumentsOpt(2);
    }

    List<JCTree.JCExpression> typeArgumentsOpt(int n) {
        if (this.token.kind == Tokens.TokenKind.LT) {
            if ((this.mode & n) == 0 || (this.mode & 4) != 0) {
                this.illegal();
            }
            this.mode = n;
            return this.typeArguments(false);
        }
        return null;
    }

    List<JCTree.JCExpression> typeArguments(boolean bl) {
        if (this.token.kind == Tokens.TokenKind.LT) {
            this.nextToken();
            if (this.token.kind == Tokens.TokenKind.GT && bl) {
                this.checkDiamond();
                this.mode |= 0x10;
                this.nextToken();
                return List.nil();
            }
            ListBuffer<JCTree.JCExpression> listBuffer = new ListBuffer<JCTree.JCExpression>();
            listBuffer.append((this.mode & 1) == 0 ? this.typeArgument() : this.parseType());
            while (this.token.kind == Tokens.TokenKind.COMMA) {
                this.nextToken();
                listBuffer.append((this.mode & 1) == 0 ? this.typeArgument() : this.parseType());
            }
            switch (this.token.kind) {
                case GTGTEQ: 
                case GTGTGTEQ: 
                case GTGTGT: 
                case GTGT: 
                case GTEQ: {
                    this.token = this.S.split();
                    break;
                }
                case GT: {
                    this.nextToken();
                    break;
                }
                default: {
                    listBuffer.append(this.syntaxError(this.token.pos, "expected", Tokens.TokenKind.GT));
                }
            }
            return listBuffer.toList();
        }
        return List.of(this.syntaxError(this.token.pos, "expected", Tokens.TokenKind.LT));
    }

    JCTree.JCExpression typeArgument() {
        JCTree.JCExpression jCExpression;
        List<JCTree.JCAnnotation> list = this.typeAnnotationsOpt();
        if (this.token.kind != Tokens.TokenKind.QUES) {
            return this.parseType(list);
        }
        int n = this.token.pos;
        this.nextToken();
        if (this.token.kind == Tokens.TokenKind.EXTENDS) {
            JCTree.TypeBoundKind typeBoundKind = this.to(this.F.at(n).TypeBoundKind(BoundKind.EXTENDS));
            this.nextToken();
            JCTree.JCExpression jCExpression2 = this.parseType();
            jCExpression = this.F.at(n).Wildcard(typeBoundKind, jCExpression2);
        } else if (this.token.kind == Tokens.TokenKind.SUPER) {
            JCTree.TypeBoundKind typeBoundKind = this.to(this.F.at(n).TypeBoundKind(BoundKind.SUPER));
            this.nextToken();
            JCTree.JCExpression jCExpression3 = this.parseType();
            jCExpression = this.F.at(n).Wildcard(typeBoundKind, jCExpression3);
        } else if (this.LAX_IDENTIFIER.accepts(this.token.kind)) {
            JCTree.TypeBoundKind typeBoundKind = this.F.at(-1).TypeBoundKind(BoundKind.UNBOUND);
            JCTree.JCExpression jCExpression4 = this.toP(this.F.at(n).Wildcard(typeBoundKind, null));
            JCTree.JCIdent jCIdent = this.toP(this.F.at(this.token.pos).Ident(this.ident()));
            JCTree.JCErroneous jCErroneous = this.F.at(n).Erroneous(List.of(jCExpression4, jCIdent));
            this.reportSyntaxError(jCErroneous, "expected3", Tokens.TokenKind.GT, Tokens.TokenKind.EXTENDS, Tokens.TokenKind.SUPER);
            jCExpression = jCErroneous;
        } else {
            JCTree.TypeBoundKind typeBoundKind = this.toP(this.F.at(n).TypeBoundKind(BoundKind.UNBOUND));
            jCExpression = this.toP(this.F.at(n).Wildcard(typeBoundKind, null));
        }
        if (!list.isEmpty()) {
            jCExpression = this.toP(this.F.at(((JCTree.JCAnnotation)list.head).pos).AnnotatedType(list, jCExpression));
        }
        return jCExpression;
    }

    JCTree.JCTypeApply typeArguments(JCTree.JCExpression jCExpression, boolean bl) {
        int n = this.token.pos;
        List<JCTree.JCExpression> list = this.typeArguments(bl);
        return this.toP(this.F.at(n).TypeApply(jCExpression, list));
    }

    private JCTree.JCExpression bracketsOpt(JCTree.JCExpression jCExpression, List<JCTree.JCAnnotation> list) {
        List<JCTree.JCAnnotation> list2 = this.typeAnnotationsOpt();
        if (this.token.kind == Tokens.TokenKind.LBRACKET) {
            int n = this.token.pos;
            this.nextToken();
            jCExpression = this.bracketsOptCont(jCExpression, n, list2);
        } else if (!list2.isEmpty()) {
            if (this.permitTypeAnnotationsPushBack) {
                this.typeAnnotationsPushedBack = list2;
            } else {
                return this.illegal(((JCTree.JCAnnotation)list2.head).pos);
            }
        }
        if (!list.isEmpty()) {
            jCExpression = this.toP(this.F.at(this.token.pos).AnnotatedType(list, jCExpression));
        }
        return jCExpression;
    }

    private JCTree.JCExpression bracketsOpt(JCTree.JCExpression jCExpression) {
        return this.bracketsOpt(jCExpression, List.nil());
    }

    private JCTree.JCExpression bracketsOptCont(JCTree.JCExpression jCExpression, int n, List<JCTree.JCAnnotation> list) {
        this.accept(Tokens.TokenKind.RBRACKET);
        jCExpression = this.bracketsOpt(jCExpression);
        jCExpression = this.toP(this.F.at(n).TypeArray(jCExpression));
        if (list.nonEmpty()) {
            jCExpression = this.toP(this.F.at(n).AnnotatedType(list, jCExpression));
        }
        return jCExpression;
    }

    JCTree.JCExpression bracketsSuffix(JCTree.JCExpression jCExpression) {
        if ((this.mode & 1) != 0 && this.token.kind == Tokens.TokenKind.DOT) {
            this.mode = 1;
            int n = this.token.pos;
            this.nextToken();
            this.accept(Tokens.TokenKind.CLASS);
            if (this.token.pos == this.endPosTable.errorEndPos) {
                Name name;
                if (this.LAX_IDENTIFIER.accepts(this.token.kind)) {
                    name = this.token.name();
                    this.nextToken();
                } else {
                    name = this.names.error;
                }
                jCExpression = this.F.at(n).Erroneous(List.of(this.toP(this.F.at(n).Select(jCExpression, name))));
            } else {
                JCTree.Tag tag = jCExpression.getTag();
                if (tag == JCTree.Tag.TYPEARRAY && TreeInfo.containsTypeAnnotation(jCExpression) || tag == JCTree.Tag.ANNOTATED_TYPE) {
                    this.syntaxError("no.annotations.on.dot.class");
                }
                jCExpression = this.toP(this.F.at(n).Select(jCExpression, this.names._class));
            }
        } else if ((this.mode & 2) != 0) {
            if (this.token.kind != Tokens.TokenKind.COLCOL) {
                this.mode = 2;
            }
        } else if (this.token.kind != Tokens.TokenKind.COLCOL) {
            this.syntaxError(this.token.pos, "dot.class.expected", new Tokens.TokenKind[0]);
        }
        return jCExpression;
    }

    JCTree.JCExpression memberReferenceSuffix(JCTree.JCExpression jCExpression) {
        int n = this.token.pos;
        this.accept(Tokens.TokenKind.COLCOL);
        return this.memberReferenceSuffix(n, jCExpression);
    }

    JCTree.JCExpression memberReferenceSuffix(int n, JCTree.JCExpression jCExpression) {
        Name name;
        MemberReferenceTree.ReferenceMode referenceMode;
        this.checkMethodReferences();
        this.mode = 1;
        List<JCTree.JCExpression> list = null;
        if (this.token.kind == Tokens.TokenKind.LT) {
            list = this.typeArguments(false);
        }
        if (this.token.kind == Tokens.TokenKind.NEW) {
            referenceMode = MemberReferenceTree.ReferenceMode.NEW;
            name = this.names.init;
            this.nextToken();
        } else {
            referenceMode = MemberReferenceTree.ReferenceMode.INVOKE;
            name = this.ident();
        }
        return this.toP(this.F.at(jCExpression.getStartPosition()).Reference(referenceMode, name, jCExpression, list));
    }

    JCTree.JCExpression creator(int n, List<JCTree.JCExpression> list) {
        List<JCTree.JCAnnotation> list2 = this.typeAnnotationsOpt();
        switch (this.token.kind) {
            case BYTE: 
            case SHORT: 
            case CHAR: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: {
                if (list != null) break;
                if (list2.isEmpty()) {
                    return this.arrayCreatorRest(n, this.basicType());
                }
                return this.arrayCreatorRest(n, this.toP(this.F.at(((JCTree.JCAnnotation)list2.head).pos).AnnotatedType(list2, this.basicType())));
            }
        }
        JCTree.JCExpression jCExpression = this.qualident(true);
        int n2 = this.mode;
        this.mode = 2;
        boolean bl = false;
        int n3 = -1;
        if (this.token.kind == Tokens.TokenKind.LT) {
            n3 = this.token.pos;
            jCExpression = this.typeArguments(jCExpression, true);
            boolean bl2 = bl = (this.mode & 0x10) != 0;
        }
        while (this.token.kind == Tokens.TokenKind.DOT) {
            if (bl) {
                this.illegal();
            }
            int n4 = this.token.pos;
            this.nextToken();
            List<JCTree.JCAnnotation> list3 = this.typeAnnotationsOpt();
            jCExpression = this.toP(this.F.at(n4).Select(jCExpression, this.ident()));
            if (list3 != null && list3.nonEmpty()) {
                jCExpression = this.toP(this.F.at(((JCTree.JCAnnotation)list3.head).pos).AnnotatedType(list3, jCExpression));
            }
            if (this.token.kind != Tokens.TokenKind.LT) continue;
            n3 = this.token.pos;
            jCExpression = this.typeArguments(jCExpression, true);
            bl = (this.mode & 0x10) != 0;
        }
        this.mode = n2;
        if (this.token.kind == Tokens.TokenKind.LBRACKET || this.token.kind == Tokens.TokenKind.MONKEYS_AT) {
            if (list2.nonEmpty()) {
                jCExpression = this.insertAnnotationsToMostInner(jCExpression, list2, false);
            }
            JCTree.JCExpression jCExpression2 = this.arrayCreatorRest(n, jCExpression);
            if (bl) {
                this.reportSyntaxError(n3, "cannot.create.array.with.diamond", new Object[0]);
                return this.toP(this.F.at(n).Erroneous(List.of(jCExpression2)));
            }
            if (list != null) {
                int n5 = n;
                if (!list.isEmpty() && ((JCTree.JCExpression)list.head).pos != -1) {
                    n5 = ((JCTree.JCExpression)list.head).pos;
                }
                this.setErrorEndPos(this.S.prevToken().endPos);
                JCTree.JCErroneous jCErroneous = this.F.at(n5).Erroneous(list.prepend(jCExpression2));
                this.reportSyntaxError(jCErroneous, "cannot.create.array.with.type.arguments", new Object[0]);
                return this.toP(jCErroneous);
            }
            return jCExpression2;
        }
        if (this.token.kind == Tokens.TokenKind.LPAREN) {
            JCTree.JCNewClass jCNewClass = this.classCreatorRest(n, null, list, jCExpression);
            if (jCNewClass.def != null) {
                assert (jCNewClass.def.mods.annotations.isEmpty());
                if (list2.nonEmpty()) {
                    jCNewClass.def.mods.pos = JavacParser.earlier(jCNewClass.def.mods.pos, ((JCTree.JCAnnotation)list2.head).pos);
                    jCNewClass.def.mods.annotations = list2;
                }
            } else if (list2.nonEmpty()) {
                jCNewClass.clazz = jCExpression = this.insertAnnotationsToMostInner(jCExpression, list2, false);
            }
            return jCNewClass;
        }
        this.setErrorEndPos(this.token.pos);
        this.reportSyntaxError(this.token.pos, "expected2", Tokens.TokenKind.LPAREN, Tokens.TokenKind.LBRACKET);
        jCExpression = this.toP(this.F.at(n).NewClass(null, list, jCExpression, List.nil(), null));
        return this.toP(this.F.at(n).Erroneous(List.of(jCExpression)));
    }

    JCTree.JCExpression innerCreator(int n, List<JCTree.JCExpression> list, JCTree.JCExpression jCExpression) {
        List<JCTree.JCAnnotation> list2 = this.typeAnnotationsOpt();
        JCTree.JCExpression jCExpression2 = this.toP(this.F.at(this.token.pos).Ident(this.ident()));
        if (list2.nonEmpty()) {
            jCExpression2 = this.toP(this.F.at(((JCTree.JCAnnotation)list2.head).pos).AnnotatedType(list2, jCExpression2));
        }
        if (this.token.kind == Tokens.TokenKind.LT) {
            int n2 = this.mode;
            jCExpression2 = this.typeArguments(jCExpression2, true);
            this.mode = n2;
        }
        return this.classCreatorRest(n, jCExpression, list, jCExpression2);
    }

    JCTree.JCExpression arrayCreatorRest(int n, JCTree.JCExpression jCExpression) {
        Object object;
        List<JCTree.JCAnnotation> list = this.typeAnnotationsOpt();
        this.accept(Tokens.TokenKind.LBRACKET);
        if (this.token.kind == Tokens.TokenKind.RBRACKET) {
            this.accept(Tokens.TokenKind.RBRACKET);
            jCExpression = this.bracketsOpt(jCExpression, list);
            if (this.token.kind == Tokens.TokenKind.LBRACE) {
                JCTree.JCNewArray jCNewArray = (JCTree.JCNewArray)this.arrayInitializer(n, jCExpression);
                if (list.nonEmpty()) {
                    JCTree.JCAnnotatedType jCAnnotatedType = (JCTree.JCAnnotatedType)jCExpression;
                    assert (jCAnnotatedType.annotations == list);
                    jCNewArray.annotations = jCAnnotatedType.annotations;
                    jCNewArray.elemtype = jCAnnotatedType.underlyingType;
                }
                return jCNewArray;
            }
            JCTree.JCExpression jCExpression2 = this.toP(this.F.at(n).NewArray(jCExpression, List.nil(), null));
            return this.syntaxError(this.token.pos, List.of(jCExpression2), "array.dimension.missing", new Tokens.TokenKind[0]);
        }
        ListBuffer<JCTree.JCExpression> listBuffer = new ListBuffer<JCTree.JCExpression>();
        ListBuffer<Object> listBuffer2 = new ListBuffer<Object>();
        listBuffer2.append(list);
        listBuffer.append(this.parseExpression());
        this.accept(Tokens.TokenKind.RBRACKET);
        while (this.token.kind == Tokens.TokenKind.LBRACKET || this.token.kind == Tokens.TokenKind.MONKEYS_AT) {
            object = this.typeAnnotationsOpt();
            int n2 = this.token.pos;
            this.nextToken();
            if (this.token.kind == Tokens.TokenKind.RBRACKET) {
                jCExpression = this.bracketsOptCont(jCExpression, n2, (List<JCTree.JCAnnotation>)object);
                continue;
            }
            if (this.token.kind == Tokens.TokenKind.RBRACKET) {
                jCExpression = this.bracketsOptCont(jCExpression, n2, (List<JCTree.JCAnnotation>)object);
                continue;
            }
            listBuffer2.append(object);
            listBuffer.append(this.parseExpression());
            this.accept(Tokens.TokenKind.RBRACKET);
        }
        object = this.toP(this.F.at(n).NewArray(jCExpression, listBuffer.toList(), null));
        ((JCTree.JCNewArray)object).dimAnnotations = listBuffer2.toList();
        return object;
    }

    JCTree.JCNewClass classCreatorRest(int n, JCTree.JCExpression jCExpression, List<JCTree.JCExpression> list, JCTree.JCExpression jCExpression2) {
        List<JCTree.JCExpression> list2 = this.arguments();
        JCTree.JCClassDecl jCClassDecl = null;
        if (this.token.kind == Tokens.TokenKind.LBRACE) {
            int n2 = this.token.pos;
            List<JCTree> list3 = this.classOrInterfaceBody(this.names.empty, false);
            JCTree.JCModifiers jCModifiers = this.F.at(-1).Modifiers(0L);
            jCClassDecl = this.toP(this.F.at(n2).AnonymousClassDef(jCModifiers, list3));
        }
        return this.toP(this.F.at(n).NewClass(jCExpression, list, jCExpression2, list2, jCClassDecl));
    }

    JCTree.JCExpression arrayInitializer(int n, JCTree.JCExpression jCExpression) {
        this.accept(Tokens.TokenKind.LBRACE);
        ListBuffer<JCTree.JCExpression> listBuffer = new ListBuffer<JCTree.JCExpression>();
        if (this.token.kind == Tokens.TokenKind.COMMA) {
            this.nextToken();
        } else if (this.token.kind != Tokens.TokenKind.RBRACE) {
            listBuffer.append(this.variableInitializer());
            while (this.token.kind == Tokens.TokenKind.COMMA) {
                this.nextToken();
                if (this.token.kind == Tokens.TokenKind.RBRACE) break;
                listBuffer.append(this.variableInitializer());
            }
        }
        this.accept(Tokens.TokenKind.RBRACE);
        return this.toP(this.F.at(n).NewArray(jCExpression, List.nil(), listBuffer.toList()));
    }

    public JCTree.JCExpression variableInitializer() {
        return this.token.kind == Tokens.TokenKind.LBRACE ? this.arrayInitializer(this.token.pos, null) : this.parseExpression();
    }

    JCTree.JCExpression parExpression() {
        int n = this.token.pos;
        this.accept(Tokens.TokenKind.LPAREN);
        JCTree.JCExpression jCExpression = this.parseExpression();
        this.accept(Tokens.TokenKind.RPAREN);
        return this.toP(this.F.at(n).Parens(jCExpression));
    }

    JCTree.JCBlock block(int n, long l) {
        this.accept(Tokens.TokenKind.LBRACE);
        List<JCTree.JCStatement> list = this.blockStatements();
        JCTree.JCBlock jCBlock = this.F.at(n).Block(l, list);
        while (this.token.kind == Tokens.TokenKind.CASE || this.token.kind == Tokens.TokenKind.DEFAULT) {
            this.syntaxError("orphaned", this.token.kind);
            this.switchBlockStatementGroups();
        }
        jCBlock.endpos = this.token.pos;
        this.accept(Tokens.TokenKind.RBRACE);
        return this.toP(jCBlock);
    }

    public JCTree.JCBlock block() {
        return this.block(this.token.pos, 0L);
    }

    List<JCTree.JCStatement> blockStatements() {
        int n = -1;
        ListBuffer<JCTree.JCStatement> listBuffer = new ListBuffer<JCTree.JCStatement>();
        List<JCTree.JCStatement> list;
        while (!(list = this.blockStatement()).isEmpty()) {
            if (this.token.pos == n) {
                return listBuffer.toList();
            }
            if (this.token.pos <= this.endPosTable.errorEndPos) {
                this.skip(false, true, true, true);
                n = this.token.pos;
            }
            listBuffer.addAll((Collection<JCTree.JCStatement>)list);
        }
        return listBuffer.toList();
    }

    JCTree.JCStatement parseStatementAsBlock() {
        int n = this.token.pos;
        List<JCTree.JCStatement> list = this.blockStatement();
        if (list.isEmpty()) {
            JCTree.JCErroneous jCErroneous = this.F.at(n).Erroneous();
            this.error(jCErroneous, "illegal.start.of.stmt", new Object[0]);
            return this.F.at(n).Exec(jCErroneous);
        }
        JCTree.JCStatement jCStatement = (JCTree.JCStatement)list.head;
        String string = null;
        switch (jCStatement.getTag()) {
            case CLASSDEF: {
                string = "class.not.allowed";
                break;
            }
            case VARDEF: {
                string = "variable.not.allowed";
            }
        }
        if (string != null) {
            this.error(jCStatement, string, new Object[0]);
            List<JCTree.JCBlock> list2 = List.of(this.F.at(jCStatement.pos).Block(0L, list));
            return this.toP(this.F.at(n).Exec(this.F.at(jCStatement.pos).Erroneous(list2)));
        }
        return jCStatement;
    }

    List<JCTree.JCStatement> blockStatement() {
        int n = this.token.pos;
        switch (this.token.kind) {
            case EOF: 
            case RBRACE: 
            case CASE: 
            case DEFAULT: {
                return List.nil();
            }
            case SEMI: 
            case LBRACE: 
            case SYNCHRONIZED: 
            case IF: 
            case FOR: 
            case WHILE: 
            case DO: 
            case TRY: 
            case SWITCH: 
            case RETURN: 
            case THROW: 
            case BREAK: 
            case CONTINUE: 
            case ELSE: 
            case FINALLY: 
            case CATCH: 
            case ASSERT: {
                return List.of(this.parseSimpleStatement());
            }
            case FINAL: 
            case MONKEYS_AT: {
                Tokens.Comment comment = this.token.comment(Tokens.Comment.CommentStyle.JAVADOC);
                JCTree.JCModifiers jCModifiers = this.modifiersOpt();
                if (this.token.kind == Tokens.TokenKind.INTERFACE || this.token.kind == Tokens.TokenKind.CLASS || this.token.kind == Tokens.TokenKind.ENUM) {
                    return List.of(this.classOrInterfaceOrEnumDeclaration(jCModifiers, comment));
                }
                JCTree.JCExpression jCExpression = this.parseType();
                ListBuffer listBuffer = this.variableDeclarators(jCModifiers, jCExpression, new ListBuffer());
                this.accept(Tokens.TokenKind.SEMI);
                this.storeEnd((JCTree)listBuffer.last(), this.S.prevToken().endPos);
                return listBuffer.toList();
            }
            case ABSTRACT: 
            case STRICTFP: {
                Tokens.Comment comment = this.token.comment(Tokens.Comment.CommentStyle.JAVADOC);
                JCTree.JCModifiers jCModifiers = this.modifiersOpt();
                return List.of(this.classOrInterfaceOrEnumDeclaration(jCModifiers, comment));
            }
            case CLASS: 
            case INTERFACE: {
                Tokens.Comment comment = this.token.comment(Tokens.Comment.CommentStyle.JAVADOC);
                return List.of(this.classOrInterfaceOrEnumDeclaration(this.modifiersOpt(), comment));
            }
            case ENUM: {
                this.error(this.token.pos, "local.enum", new Object[0]);
                Tokens.Comment comment = this.token.comment(Tokens.Comment.CommentStyle.JAVADOC);
                return List.of(this.classOrInterfaceOrEnumDeclaration(this.modifiersOpt(), comment));
            }
        }
        Tokens.Token token = this.token;
        JCTree.JCExpression jCExpression = this.term(3);
        if (this.token.kind == Tokens.TokenKind.COLON && jCExpression.hasTag(JCTree.Tag.IDENT)) {
            this.nextToken();
            JCTree.JCStatement jCStatement = this.parseStatementAsBlock();
            return List.of(this.F.at(n).Labelled(token.name(), jCStatement));
        }
        if ((this.lastmode & 2) != 0 && this.LAX_IDENTIFIER.accepts(this.token.kind)) {
            n = this.token.pos;
            JCTree.JCModifiers jCModifiers = this.F.at(-1).Modifiers(0L);
            this.F.at(n);
            ListBuffer listBuffer = this.variableDeclarators(jCModifiers, jCExpression, new ListBuffer());
            this.accept(Tokens.TokenKind.SEMI);
            this.storeEnd((JCTree)listBuffer.last(), this.S.prevToken().endPos);
            return listBuffer.toList();
        }
        jCExpression = this.checkExprStat(jCExpression);
        this.accept(Tokens.TokenKind.SEMI);
        JCTree.JCExpressionStatement jCExpressionStatement = this.toP(this.F.at(n).Exec(jCExpression));
        return List.of(jCExpressionStatement);
    }

    public JCTree.JCStatement parseSimpleStatement() {
        int n = this.token.pos;
        switch (this.token.kind) {
            case LBRACE: {
                return this.block();
            }
            case IF: {
                this.nextToken();
                JCTree.JCExpression jCExpression = this.parExpression();
                JCTree.JCStatement jCStatement = this.parseStatementAsBlock();
                JCTree.JCStatement jCStatement2 = null;
                if (this.token.kind == Tokens.TokenKind.ELSE) {
                    this.nextToken();
                    jCStatement2 = this.parseStatementAsBlock();
                }
                return this.F.at(n).If(jCExpression, jCStatement, jCStatement2);
            }
            case FOR: {
                List<Object> list;
                this.nextToken();
                this.accept(Tokens.TokenKind.LPAREN);
                List<Object> list2 = list = this.token.kind == Tokens.TokenKind.SEMI ? List.nil() : this.forInit();
                if (list.length() == 1 && ((JCTree.JCStatement)list.head).hasTag(JCTree.Tag.VARDEF) && ((JCTree.JCVariableDecl)list.head).init == null && this.token.kind == Tokens.TokenKind.COLON) {
                    JCTree.JCVariableDecl jCVariableDecl = (JCTree.JCVariableDecl)list.head;
                    this.accept(Tokens.TokenKind.COLON);
                    JCTree.JCExpression jCExpression = this.parseExpression();
                    this.accept(Tokens.TokenKind.RPAREN);
                    JCTree.JCStatement jCStatement = this.parseStatementAsBlock();
                    return this.F.at(n).ForeachLoop(jCVariableDecl, jCExpression, jCStatement);
                }
                this.accept(Tokens.TokenKind.SEMI);
                JCTree.JCExpression jCExpression = this.token.kind == Tokens.TokenKind.SEMI ? null : this.parseExpression();
                this.accept(Tokens.TokenKind.SEMI);
                List<JCTree.JCExpressionStatement> list3 = this.token.kind == Tokens.TokenKind.RPAREN ? List.nil() : this.forUpdate();
                this.accept(Tokens.TokenKind.RPAREN);
                JCTree.JCStatement jCStatement = this.parseStatementAsBlock();
                return this.F.at(n).ForLoop(list, jCExpression, list3, jCStatement);
            }
            case WHILE: {
                this.nextToken();
                JCTree.JCExpression jCExpression = this.parExpression();
                JCTree.JCStatement jCStatement = this.parseStatementAsBlock();
                return this.F.at(n).WhileLoop(jCExpression, jCStatement);
            }
            case DO: {
                this.nextToken();
                JCTree.JCStatement jCStatement = this.parseStatementAsBlock();
                this.accept(Tokens.TokenKind.WHILE);
                JCTree.JCExpression jCExpression = this.parExpression();
                this.accept(Tokens.TokenKind.SEMI);
                JCTree.JCDoWhileLoop jCDoWhileLoop = this.toP(this.F.at(n).DoLoop(jCStatement, jCExpression));
                return jCDoWhileLoop;
            }
            case TRY: {
                this.nextToken();
                List<Object> list = List.nil();
                if (this.token.kind == Tokens.TokenKind.LPAREN) {
                    this.checkTryWithResources();
                    this.nextToken();
                    list = this.resources();
                    this.accept(Tokens.TokenKind.RPAREN);
                }
                JCTree.JCBlock jCBlock = this.block();
                ListBuffer<JCTree.JCCatch> listBuffer = new ListBuffer<JCTree.JCCatch>();
                JCTree.JCBlock jCBlock2 = null;
                if (this.token.kind == Tokens.TokenKind.CATCH || this.token.kind == Tokens.TokenKind.FINALLY) {
                    while (this.token.kind == Tokens.TokenKind.CATCH) {
                        listBuffer.append(this.catchClause());
                    }
                    if (this.token.kind == Tokens.TokenKind.FINALLY) {
                        this.nextToken();
                        jCBlock2 = this.block();
                    }
                } else if (list.isEmpty()) {
                    if (this.allowTWR) {
                        this.error(n, "try.without.catch.finally.or.resource.decls", new Object[0]);
                    } else {
                        this.error(n, "try.without.catch.or.finally", new Object[0]);
                    }
                }
                return this.F.at(n).Try(list, jCBlock, listBuffer.toList(), jCBlock2);
            }
            case SWITCH: {
                this.nextToken();
                JCTree.JCExpression jCExpression = this.parExpression();
                this.accept(Tokens.TokenKind.LBRACE);
                List<JCTree.JCCase> list = this.switchBlockStatementGroups();
                JCTree.JCSwitch jCSwitch = this.to(this.F.at(n).Switch(jCExpression, list));
                this.accept(Tokens.TokenKind.RBRACE);
                return jCSwitch;
            }
            case SYNCHRONIZED: {
                this.nextToken();
                JCTree.JCExpression jCExpression = this.parExpression();
                JCTree.JCBlock jCBlock = this.block();
                return this.F.at(n).Synchronized(jCExpression, jCBlock);
            }
            case RETURN: {
                this.nextToken();
                JCTree.JCExpression jCExpression = this.token.kind == Tokens.TokenKind.SEMI ? null : this.parseExpression();
                this.accept(Tokens.TokenKind.SEMI);
                JCTree.JCReturn jCReturn = this.toP(this.F.at(n).Return(jCExpression));
                return jCReturn;
            }
            case THROW: {
                this.nextToken();
                JCTree.JCExpression jCExpression = this.parseExpression();
                this.accept(Tokens.TokenKind.SEMI);
                JCTree.JCThrow jCThrow = this.toP(this.F.at(n).Throw(jCExpression));
                return jCThrow;
            }
            case BREAK: {
                this.nextToken();
                Name name = this.LAX_IDENTIFIER.accepts(this.token.kind) ? this.ident() : null;
                this.accept(Tokens.TokenKind.SEMI);
                JCTree.JCBreak jCBreak = this.toP(this.F.at(n).Break(name));
                return jCBreak;
            }
            case CONTINUE: {
                this.nextToken();
                Name name = this.LAX_IDENTIFIER.accepts(this.token.kind) ? this.ident() : null;
                this.accept(Tokens.TokenKind.SEMI);
                JCTree.JCContinue jCContinue = this.toP(this.F.at(n).Continue(name));
                return jCContinue;
            }
            case SEMI: {
                this.nextToken();
                return this.toP(this.F.at(n).Skip());
            }
            case ELSE: {
                int n2 = this.token.pos;
                this.nextToken();
                return this.doRecover(n2, BasicErrorRecoveryAction.BLOCK_STMT, "else.without.if");
            }
            case FINALLY: {
                int n3 = this.token.pos;
                this.nextToken();
                return this.doRecover(n3, BasicErrorRecoveryAction.BLOCK_STMT, "finally.without.try");
            }
            case CATCH: {
                return this.doRecover(this.token.pos, BasicErrorRecoveryAction.CATCH_CLAUSE, "catch.without.try");
            }
            case ASSERT: {
                this.nextToken();
                JCTree.JCExpression jCExpression = this.parseExpression();
                JCTree.JCExpression jCExpression2 = null;
                if (this.token.kind == Tokens.TokenKind.COLON) {
                    this.nextToken();
                    jCExpression2 = this.parseExpression();
                }
                this.accept(Tokens.TokenKind.SEMI);
                JCTree.JCAssert jCAssert = this.toP(this.F.at(n).Assert(jCExpression, jCExpression2));
                return jCAssert;
            }
        }
        Assert.error();
        return null;
    }

    @Override
    public JCTree.JCStatement parseStatement() {
        return this.parseStatementAsBlock();
    }

    private JCTree.JCStatement doRecover(int n, ErrorRecoveryAction errorRecoveryAction, String string) {
        int n2 = this.S.errPos();
        JCTree jCTree = errorRecoveryAction.doRecover(this);
        this.S.errPos(n2);
        return this.toP(this.F.Exec(this.syntaxError(n, List.of(jCTree), string, new Tokens.TokenKind[0])));
    }

    protected JCTree.JCCatch catchClause() {
        int n = this.token.pos;
        this.accept(Tokens.TokenKind.CATCH);
        this.accept(Tokens.TokenKind.LPAREN);
        JCTree.JCModifiers jCModifiers = this.optFinal(0x200000000L);
        List<JCTree.JCExpression> list = this.catchTypes();
        JCTree.JCExpression jCExpression = list.size() > 1 ? (JCTree.JCExpression)this.toP(this.F.at(((JCTree.JCExpression)list.head).getStartPosition()).TypeUnion(list)) : (JCTree.JCExpression)list.head;
        JCTree.JCVariableDecl jCVariableDecl = this.variableDeclaratorId(jCModifiers, jCExpression);
        this.accept(Tokens.TokenKind.RPAREN);
        JCTree.JCBlock jCBlock = this.block();
        return this.F.at(n).Catch(jCVariableDecl, jCBlock);
    }

    List<JCTree.JCExpression> catchTypes() {
        ListBuffer<JCTree.JCExpression> listBuffer = new ListBuffer<JCTree.JCExpression>();
        listBuffer.add(this.parseType());
        while (this.token.kind == Tokens.TokenKind.BAR) {
            this.checkMulticatch();
            this.nextToken();
            listBuffer.add(this.parseType());
        }
        return listBuffer.toList();
    }

    List<JCTree.JCCase> switchBlockStatementGroups() {
        ListBuffer<JCTree.JCCase> listBuffer = new ListBuffer<JCTree.JCCase>();
        block4: while (true) {
            int n = this.token.pos;
            switch (this.token.kind) {
                case CASE: 
                case DEFAULT: {
                    listBuffer.append(this.switchBlockStatementGroup());
                    continue block4;
                }
                case EOF: 
                case RBRACE: {
                    return listBuffer.toList();
                }
            }
            this.nextToken();
            this.syntaxError(n, "expected3", Tokens.TokenKind.CASE, Tokens.TokenKind.DEFAULT, Tokens.TokenKind.RBRACE);
        }
    }

    protected JCTree.JCCase switchBlockStatementGroup() {
        int n = this.token.pos;
        switch (this.token.kind) {
            case CASE: {
                this.nextToken();
                JCTree.JCExpression jCExpression = this.parseExpression();
                this.accept(Tokens.TokenKind.COLON);
                List<JCTree.JCStatement> list = this.blockStatements();
                JCTree.JCCase jCCase = this.F.at(n).Case(jCExpression, list);
                if (list.isEmpty()) {
                    this.storeEnd(jCCase, this.S.prevToken().endPos);
                }
                return jCCase;
            }
            case DEFAULT: {
                this.nextToken();
                this.accept(Tokens.TokenKind.COLON);
                List<JCTree.JCStatement> list = this.blockStatements();
                JCTree.JCCase jCCase = this.F.at(n).Case(null, list);
                if (list.isEmpty()) {
                    this.storeEnd(jCCase, this.S.prevToken().endPos);
                }
                return jCCase;
            }
        }
        throw new AssertionError((Object)"should not reach here");
    }

    <T extends ListBuffer<? super JCTree.JCExpressionStatement>> T moreStatementExpressions(int n, JCTree.JCExpression jCExpression, T t) {
        t.append((JCTree.JCExpressionStatement)this.toP(this.F.at(n).Exec(this.checkExprStat(jCExpression))));
        while (this.token.kind == Tokens.TokenKind.COMMA) {
            this.nextToken();
            n = this.token.pos;
            JCTree.JCExpression jCExpression2 = this.parseExpression();
            t.append((JCTree.JCExpressionStatement)this.toP(this.F.at(n).Exec(this.checkExprStat(jCExpression2))));
        }
        return t;
    }

    List<JCTree.JCStatement> forInit() {
        ListBuffer listBuffer = new ListBuffer();
        int n = this.token.pos;
        if (this.token.kind == Tokens.TokenKind.FINAL || this.token.kind == Tokens.TokenKind.MONKEYS_AT) {
            return this.variableDeclarators(this.optFinal(0L), this.parseType(), listBuffer).toList();
        }
        JCTree.JCExpression jCExpression = this.term(3);
        if ((this.lastmode & 2) != 0 && this.LAX_IDENTIFIER.accepts(this.token.kind)) {
            return this.variableDeclarators(this.modifiersOpt(), jCExpression, listBuffer).toList();
        }
        if ((this.lastmode & 2) != 0 && this.token.kind == Tokens.TokenKind.COLON) {
            this.error(n, "bad.initializer", "for-loop");
            return List.of(this.F.at(n).VarDef(null, null, jCExpression, null));
        }
        return this.moreStatementExpressions(n, jCExpression, listBuffer).toList();
    }

    List<JCTree.JCExpressionStatement> forUpdate() {
        return this.moreStatementExpressions(this.token.pos, this.parseExpression(), new ListBuffer()).toList();
    }

    protected List<JCTree.JCAnnotation> annotationsOpt(JCTree.Tag tag) {
        if (this.token.kind != Tokens.TokenKind.MONKEYS_AT) {
            return List.nil();
        }
        ListBuffer<JCTree.JCAnnotation> listBuffer = new ListBuffer<JCTree.JCAnnotation>();
        int n = this.mode;
        while (this.token.kind == Tokens.TokenKind.MONKEYS_AT) {
            int n2 = this.token.pos;
            this.nextToken();
            listBuffer.append(this.annotation(n2, tag));
        }
        this.lastmode = this.mode;
        this.mode = n;
        List<JCTree.JCAnnotation> list = listBuffer.toList();
        return list;
    }

    List<JCTree.JCAnnotation> typeAnnotationsOpt() {
        List<JCTree.JCAnnotation> list = this.annotationsOpt(JCTree.Tag.TYPE_ANNOTATION);
        return list;
    }

    protected JCTree.JCModifiers modifiersOpt() {
        return this.modifiersOpt(null);
    }

    protected JCTree.JCModifiers modifiersOpt(JCTree.JCModifiers jCModifiers) {
        int n;
        long l;
        ListBuffer<JCTree.JCAnnotation> listBuffer = new ListBuffer<JCTree.JCAnnotation>();
        if (jCModifiers == null) {
            l = 0L;
            n = this.token.pos;
        } else {
            l = jCModifiers.flags;
            listBuffer.appendList(jCModifiers.annotations);
            n = jCModifiers.pos;
        }
        if (this.token.deprecatedFlag()) {
            l |= 0x20000L;
        }
        block20: while (true) {
            long l2;
            switch (this.token.kind) {
                case PRIVATE: {
                    l2 = 2L;
                    break;
                }
                case PROTECTED: {
                    l2 = 4L;
                    break;
                }
                case PUBLIC: {
                    l2 = 1L;
                    break;
                }
                case STATIC: {
                    l2 = 8L;
                    break;
                }
                case TRANSIENT: {
                    l2 = 128L;
                    break;
                }
                case FINAL: {
                    l2 = 16L;
                    break;
                }
                case ABSTRACT: {
                    l2 = 1024L;
                    break;
                }
                case NATIVE: {
                    l2 = 256L;
                    break;
                }
                case VOLATILE: {
                    l2 = 64L;
                    break;
                }
                case SYNCHRONIZED: {
                    l2 = 32L;
                    break;
                }
                case STRICTFP: {
                    l2 = 2048L;
                    break;
                }
                case MONKEYS_AT: {
                    l2 = 8192L;
                    break;
                }
                case DEFAULT: {
                    this.checkDefaultMethods();
                    l2 = 0x80000000000L;
                    break;
                }
                case ERROR: {
                    l2 = 0L;
                    this.nextToken();
                    break;
                }
                default: {
                    break block20;
                }
            }
            if ((l & l2) != 0L) {
                this.error(this.token.pos, "repeated.modifier", new Object[0]);
            }
            int n2 = this.token.pos;
            this.nextToken();
            if (l2 == 8192L && this.token.kind != Tokens.TokenKind.INTERFACE) {
                JCTree.JCAnnotation jCAnnotation = this.annotation(n2, JCTree.Tag.ANNOTATION);
                if (l == 0L && listBuffer.isEmpty()) {
                    n = jCAnnotation.pos;
                }
                listBuffer.append(jCAnnotation);
                l2 = 0L;
            }
            l |= l2;
        }
        switch (this.token.kind) {
            case ENUM: {
                l |= 0x4000L;
                break;
            }
            case INTERFACE: {
                l |= 0x200L;
                break;
            }
        }
        if ((l & 0x80000002DFFL) == 0L && listBuffer.isEmpty()) {
            n = -1;
        }
        JCTree.JCModifiers jCModifiers2 = this.F.at(n).Modifiers(l, listBuffer.toList());
        if (n != -1) {
            this.storeEnd(jCModifiers2, this.S.prevToken().endPos);
        }
        return jCModifiers2;
    }

    JCTree.JCAnnotation annotation(int n, JCTree.Tag tag) {
        JCTree.JCAnnotation jCAnnotation;
        if (tag == JCTree.Tag.TYPE_ANNOTATION) {
            this.checkTypeAnnotations();
        }
        JCTree.JCExpression jCExpression = this.qualident(false);
        List<JCTree.JCExpression> list = this.annotationFieldValuesOpt();
        if (tag == JCTree.Tag.ANNOTATION) {
            jCAnnotation = this.F.at(n).Annotation(jCExpression, list);
        } else if (tag == JCTree.Tag.TYPE_ANNOTATION) {
            jCAnnotation = this.F.at(n).TypeAnnotation(jCExpression, list);
        } else {
            throw new AssertionError((Object)("Unhandled annotation kind: " + (Object)((Object)tag)));
        }
        this.storeEnd(jCAnnotation, this.S.prevToken().endPos);
        return jCAnnotation;
    }

    List<JCTree.JCExpression> annotationFieldValuesOpt() {
        return this.token.kind == Tokens.TokenKind.LPAREN ? this.annotationFieldValues() : List.nil();
    }

    List<JCTree.JCExpression> annotationFieldValues() {
        this.accept(Tokens.TokenKind.LPAREN);
        ListBuffer<JCTree.JCExpression> listBuffer = new ListBuffer<JCTree.JCExpression>();
        if (this.token.kind != Tokens.TokenKind.RPAREN) {
            listBuffer.append(this.annotationFieldValue());
            while (this.token.kind == Tokens.TokenKind.COMMA) {
                this.nextToken();
                listBuffer.append(this.annotationFieldValue());
            }
        }
        this.accept(Tokens.TokenKind.RPAREN);
        return listBuffer.toList();
    }

    JCTree.JCExpression annotationFieldValue() {
        if (this.LAX_IDENTIFIER.accepts(this.token.kind)) {
            this.mode = 1;
            JCTree.JCExpression jCExpression = this.term1();
            if (jCExpression.hasTag(JCTree.Tag.IDENT) && this.token.kind == Tokens.TokenKind.EQ) {
                int n = this.token.pos;
                this.accept(Tokens.TokenKind.EQ);
                JCTree.JCExpression jCExpression2 = this.annotationValue();
                return this.toP(this.F.at(n).Assign(jCExpression, jCExpression2));
            }
            return jCExpression;
        }
        return this.annotationValue();
    }

    JCTree.JCExpression annotationValue() {
        switch (this.token.kind) {
            case MONKEYS_AT: {
                int n = this.token.pos;
                this.nextToken();
                return this.annotation(n, JCTree.Tag.ANNOTATION);
            }
            case LBRACE: {
                int n = this.token.pos;
                this.accept(Tokens.TokenKind.LBRACE);
                ListBuffer<JCTree.JCExpression> listBuffer = new ListBuffer<JCTree.JCExpression>();
                if (this.token.kind == Tokens.TokenKind.COMMA) {
                    this.nextToken();
                } else if (this.token.kind != Tokens.TokenKind.RBRACE) {
                    listBuffer.append(this.annotationValue());
                    while (this.token.kind == Tokens.TokenKind.COMMA) {
                        this.nextToken();
                        if (this.token.kind == Tokens.TokenKind.RBRACE) break;
                        listBuffer.append(this.annotationValue());
                    }
                }
                this.accept(Tokens.TokenKind.RBRACE);
                return this.toP(this.F.at(n).NewArray(null, List.nil(), listBuffer.toList()));
            }
        }
        this.mode = 1;
        return this.term1();
    }

    public <T extends ListBuffer<? super JCTree.JCVariableDecl>> T variableDeclarators(JCTree.JCModifiers jCModifiers, JCTree.JCExpression jCExpression, T t) {
        return this.variableDeclaratorsRest(this.token.pos, jCModifiers, jCExpression, this.ident(), false, null, t);
    }

    protected <T extends ListBuffer<? super JCTree.JCVariableDecl>> T variableDeclaratorsRest(int n, JCTree.JCModifiers jCModifiers, JCTree.JCExpression jCExpression, Name name, boolean bl, Tokens.Comment comment, T t) {
        t.append((JCTree.JCVariableDecl)this.variableDeclaratorRest(n, jCModifiers, jCExpression, name, bl, comment));
        while (this.token.kind == Tokens.TokenKind.COMMA) {
            this.storeEnd(t.last(), this.token.endPos);
            this.nextToken();
            t.append((JCTree.JCVariableDecl)this.variableDeclarator(jCModifiers, jCExpression, bl, comment));
        }
        return t;
    }

    JCTree.JCVariableDecl variableDeclarator(JCTree.JCModifiers jCModifiers, JCTree.JCExpression jCExpression, boolean bl, Tokens.Comment comment) {
        return this.variableDeclaratorRest(this.token.pos, jCModifiers, jCExpression, this.ident(), bl, comment);
    }

    JCTree.JCVariableDecl variableDeclaratorRest(int n, JCTree.JCModifiers jCModifiers, JCTree.JCExpression jCExpression, Name name, boolean bl, Tokens.Comment comment) {
        jCExpression = this.bracketsOpt(jCExpression);
        JCTree.JCExpression jCExpression2 = null;
        if (this.token.kind == Tokens.TokenKind.EQ) {
            this.nextToken();
            jCExpression2 = this.variableInitializer();
        } else if (bl) {
            this.syntaxError(this.token.pos, "expected", Tokens.TokenKind.EQ);
        }
        JCTree.JCVariableDecl jCVariableDecl = this.toP(this.F.at(n).VarDef(jCModifiers, name, jCExpression, jCExpression2));
        this.attach(jCVariableDecl, comment);
        return jCVariableDecl;
    }

    JCTree.JCVariableDecl variableDeclaratorId(JCTree.JCModifiers jCModifiers, JCTree.JCExpression jCExpression) {
        return this.variableDeclaratorId(jCModifiers, jCExpression, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    JCTree.JCVariableDecl variableDeclaratorId(JCTree.JCModifiers jCModifiers, JCTree.JCExpression jCExpression, boolean bl) {
        Name name;
        int n;
        block8: {
            n = this.token.pos;
            if (bl && this.token.kind == Tokens.TokenKind.UNDERSCORE) {
                this.log.error(n, "underscore.as.identifier.in.lambda", new Object[0]);
                name = this.token.name();
                this.nextToken();
            } else {
                if (this.allowThisIdent && !bl) {
                    JCTree.JCExpression jCExpression2 = this.qualident(false);
                    if (jCExpression2.hasTag(JCTree.Tag.IDENT) && ((JCTree.JCIdent)jCExpression2).name != this.names._this) {
                        name = ((JCTree.JCIdent)jCExpression2).name;
                        break block8;
                    } else {
                        if ((jCModifiers.flags & 0x400000000L) != 0L) {
                            this.log.error(this.token.pos, "varargs.and.receiver", new Object[0]);
                        }
                        if (this.token.kind == Tokens.TokenKind.LBRACKET) {
                            this.log.error(this.token.pos, "array.and.receiver", new Object[0]);
                        }
                        return this.toP(this.F.at(n).ReceiverVarDef(jCModifiers, jCExpression2, jCExpression));
                    }
                }
                name = this.ident();
            }
        }
        if ((jCModifiers.flags & 0x400000000L) != 0L && this.token.kind == Tokens.TokenKind.LBRACKET) {
            this.log.error(this.token.pos, "varargs.and.old.array.syntax", new Object[0]);
        }
        jCExpression = this.bracketsOpt(jCExpression);
        return this.toP(this.F.at(n).VarDef(jCModifiers, name, jCExpression, null));
    }

    List<JCTree> resources() {
        ListBuffer<JCTree> listBuffer = new ListBuffer<JCTree>();
        listBuffer.append(this.resource());
        while (this.token.kind == Tokens.TokenKind.SEMI) {
            this.storeEnd((JCTree)listBuffer.last(), this.token.endPos);
            int n = this.token.pos;
            this.nextToken();
            if (this.token.kind == Tokens.TokenKind.RPAREN) break;
            listBuffer.append(this.resource());
        }
        return listBuffer.toList();
    }

    protected JCTree resource() {
        int n = this.token.pos;
        if (this.token.kind == Tokens.TokenKind.FINAL || this.token.kind == Tokens.TokenKind.MONKEYS_AT) {
            JCTree.JCModifiers jCModifiers = this.optFinal(16L);
            JCTree.JCExpression jCExpression = this.parseType();
            return this.variableDeclaratorRest(this.token.pos, jCModifiers, jCExpression, this.ident(), true, null);
        }
        JCTree.JCExpression jCExpression = this.term(3);
        if ((this.lastmode & 2) != 0 && this.LAX_IDENTIFIER.accepts(this.token.kind)) {
            JCTree.JCModifiers jCModifiers = this.toP(this.F.at(n).Modifiers(16L));
            return this.variableDeclaratorRest(this.token.pos, jCModifiers, jCExpression, this.ident(), true, null);
        }
        this.checkVariableInTryWithResources(n);
        if (!jCExpression.hasTag(JCTree.Tag.IDENT) && !jCExpression.hasTag(JCTree.Tag.SELECT)) {
            this.log.error(jCExpression.pos(), "try.with.resources.expr.needs.var", new Object[0]);
        }
        return jCExpression;
    }

    @Override
    public JCTree.JCCompilationUnit parseCompilationUnit() {
        Object object;
        Object object2;
        int n;
        Tokens.Token token = this.token;
        JCTree.JCModifiers jCModifiers = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        ListBuffer<JCTree> listBuffer = new ListBuffer<JCTree>();
        if (this.token.kind == Tokens.TokenKind.MONKEYS_AT) {
            jCModifiers = this.modifiersOpt();
        }
        if (this.token.kind == Tokens.TokenKind.PACKAGE) {
            n = this.token.pos;
            List<JCTree.JCAnnotation> list = List.nil();
            bl3 = true;
            if (jCModifiers != null) {
                this.checkNoMods(jCModifiers.flags);
                list = jCModifiers.annotations;
                jCModifiers = null;
            }
            this.nextToken();
            object2 = this.qualident(false);
            this.accept(Tokens.TokenKind.SEMI);
            object = this.F.at(n).PackageDecl(list, (JCTree.JCExpression)object2);
            this.attach((JCTree)object, token.comment(Tokens.Comment.CommentStyle.JAVADOC));
            bl = true;
            this.storeEnd((JCTree)object, this.token.pos);
            listBuffer.append((JCTree)object);
        }
        n = 1;
        boolean bl4 = true;
        while (this.token.kind != Tokens.TokenKind.EOF) {
            if (this.token.pos <= this.endPosTable.errorEndPos) {
                this.skip(n != 0, false, false, false);
                if (this.token.kind == Tokens.TokenKind.EOF) break;
            }
            if (n != 0 && jCModifiers == null && this.token.kind == Tokens.TokenKind.IMPORT) {
                bl2 = true;
                listBuffer.append(this.importDeclaration());
                continue;
            }
            object2 = this.token.comment(Tokens.Comment.CommentStyle.JAVADOC);
            if (bl4 && !bl2 && !bl3) {
                object2 = token.comment(Tokens.Comment.CommentStyle.JAVADOC);
                bl = true;
            }
            if (jCModifiers != null || this.token.kind != Tokens.TokenKind.SEMI) {
                jCModifiers = this.modifiersOpt(jCModifiers);
            }
            if (bl4 && this.token.kind == Tokens.TokenKind.IDENTIFIER) {
                object = ModuleTree.ModuleKind.STRONG;
                if (this.token.name() == this.names.open) {
                    object = ModuleTree.ModuleKind.OPEN;
                    this.nextToken();
                }
                if (this.token.kind == Tokens.TokenKind.IDENTIFIER && this.token.name() == this.names.module) {
                    if (jCModifiers != null) {
                        this.checkNoMods(jCModifiers.flags & 0xFFFFFFFFFFFDFFFFL);
                    }
                    listBuffer.append(this.moduleDecl(jCModifiers, (ModuleTree.ModuleKind)((Object)object), (Tokens.Comment)object2));
                    bl = true;
                    break;
                }
                if (object != ModuleTree.ModuleKind.STRONG) {
                    this.reportSyntaxError(this.token.pos, "expected.module", new Object[0]);
                }
            }
            if ((object = this.typeDeclaration(jCModifiers, (Tokens.Comment)object2)) instanceof JCTree.JCExpressionStatement) {
                object = ((JCTree.JCExpressionStatement)object).expr;
            }
            listBuffer.append((JCTree)object);
            if (object instanceof JCTree.JCClassDecl) {
                n = 0;
            }
            jCModifiers = null;
            bl4 = false;
        }
        object2 = this.F.at(token.pos).TopLevel(listBuffer.toList());
        if (!bl) {
            this.attach((JCTree)object2, token.comment(Tokens.Comment.CommentStyle.JAVADOC));
        }
        if (listBuffer.isEmpty()) {
            this.storeEnd((JCTree)object2, this.S.prevToken().endPos);
        }
        if (this.keepDocComments) {
            ((JCTree.JCCompilationUnit)object2).docComments = this.docComments;
        }
        if (this.keepLineMap) {
            ((JCTree.JCCompilationUnit)object2).lineMap = this.S.getLineMap();
        }
        this.endPosTable.setParser(null);
        ((JCTree.JCCompilationUnit)object2).endPositions = this.endPosTable;
        return object2;
    }

    JCTree.JCModuleDecl moduleDecl(JCTree.JCModifiers jCModifiers, ModuleTree.ModuleKind moduleKind, Tokens.Comment comment) {
        int n = this.token.pos;
        if (!this.allowModules) {
            this.log.error(n, CompilerProperties.Errors.ModulesNotSupportedInSource(this.source.name));
            this.allowModules = true;
        }
        this.nextToken();
        JCTree.JCExpression jCExpression = this.qualident(false);
        List<JCTree.JCDirective> list = null;
        this.accept(Tokens.TokenKind.LBRACE);
        list = this.moduleDirectiveList();
        this.accept(Tokens.TokenKind.RBRACE);
        this.accept(Tokens.TokenKind.EOF);
        JCTree.JCModuleDecl jCModuleDecl = this.toP(this.F.at(n).ModuleDef(jCModifiers, moduleKind, jCExpression, list));
        this.attach(jCModuleDecl, comment);
        return jCModuleDecl;
    }

    List<JCTree.JCDirective> moduleDirectiveList() {
        ListBuffer<JCTree.JCDirective> listBuffer = new ListBuffer<JCTree.JCDirective>();
        while (this.token.kind == Tokens.TokenKind.IDENTIFIER) {
            List<JCTree.JCExpression> list;
            int n = this.token.pos;
            if (this.token.name() == this.names.requires) {
                this.nextToken();
                boolean bl = false;
                boolean bl2 = false;
                block5: while (true) {
                    switch (this.token.kind) {
                        case IDENTIFIER: {
                            if (this.token.name() != this.names.transitive || bl) break block5;
                            list = this.S.token(1);
                            if (((Tokens.Token)((Object)list)).kind == Tokens.TokenKind.SEMI || ((Tokens.Token)((Object)list)).kind == Tokens.TokenKind.DOT) break block5;
                            bl = true;
                            break;
                        }
                        case STATIC: {
                            if (bl2) {
                                this.error(this.token.pos, "repeated.modifier", new Object[0]);
                            }
                            bl2 = true;
                            break;
                        }
                        default: {
                            break block5;
                        }
                    }
                    this.nextToken();
                }
                list = this.qualident(false);
                this.accept(Tokens.TokenKind.SEMI);
                listBuffer.append(this.toP(this.F.at(n).Requires(bl, bl2, (JCTree.JCExpression)((Object)list))));
                continue;
            }
            if (this.token.name() == this.names.exports || this.token.name() == this.names.opens) {
                boolean bl = this.token.name() == this.names.exports;
                this.nextToken();
                JCTree.JCExpression jCExpression = this.qualident(false);
                list = null;
                if (this.token.kind == Tokens.TokenKind.IDENTIFIER && this.token.name() == this.names.to) {
                    this.nextToken();
                    list = this.qualidentList(false);
                }
                this.accept(Tokens.TokenKind.SEMI);
                JCTree.JCDirective jCDirective = bl ? this.F.at(n).Exports(jCExpression, list) : this.F.at(n).Opens(jCExpression, list);
                listBuffer.append(this.toP(jCDirective));
                continue;
            }
            if (this.token.name() == this.names.provides) {
                this.nextToken();
                JCTree.JCExpression jCExpression = this.qualident(false);
                if (this.token.kind == Tokens.TokenKind.IDENTIFIER && this.token.name() == this.names.with) {
                    this.nextToken();
                    List<JCTree.JCExpression> list2 = this.qualidentList(false);
                    this.accept(Tokens.TokenKind.SEMI);
                    listBuffer.append(this.toP(this.F.at(n).Provides(jCExpression, list2)));
                    continue;
                }
                this.error(this.token.pos, "expected", "'" + this.names.with + "'");
                this.skip(false, false, false, false);
                continue;
            }
            if (this.token.name() == this.names.uses) {
                this.nextToken();
                JCTree.JCExpression jCExpression = this.qualident(false);
                this.accept(Tokens.TokenKind.SEMI);
                listBuffer.append(this.toP(this.F.at(n).Uses(jCExpression)));
                continue;
            }
            this.setErrorEndPos(n);
            this.reportSyntaxError(n, "invalid.module.directive", new Object[0]);
            break;
        }
        return listBuffer.toList();
    }

    protected JCTree importDeclaration() {
        int n = this.token.pos;
        this.nextToken();
        boolean bl = false;
        if (this.token.kind == Tokens.TokenKind.STATIC) {
            bl = true;
            this.nextToken();
        }
        JCTree.JCExpression jCExpression = this.toP(this.F.at(this.token.pos).Ident(this.ident()));
        do {
            int n2 = this.token.pos;
            this.accept(Tokens.TokenKind.DOT);
            if (this.token.kind == Tokens.TokenKind.STAR) {
                jCExpression = this.to(this.F.at(n2).Select(jCExpression, this.names.asterisk));
                this.nextToken();
                break;
            }
            jCExpression = this.toP(this.F.at(n2).Select(jCExpression, this.ident()));
        } while (this.token.kind == Tokens.TokenKind.DOT);
        this.accept(Tokens.TokenKind.SEMI);
        return this.toP(this.F.at(n).Import(jCExpression, bl));
    }

    JCTree typeDeclaration(JCTree.JCModifiers jCModifiers, Tokens.Comment comment) {
        int n = this.token.pos;
        if (jCModifiers == null && this.token.kind == Tokens.TokenKind.SEMI) {
            this.nextToken();
            return this.toP(this.F.at(n).Skip());
        }
        return this.classOrInterfaceOrEnumDeclaration(this.modifiersOpt(jCModifiers), comment);
    }

    protected JCTree.JCStatement classOrInterfaceOrEnumDeclaration(JCTree.JCModifiers jCModifiers, Tokens.Comment comment) {
        List<JCTree> list;
        if (this.token.kind == Tokens.TokenKind.CLASS) {
            return this.classDeclaration(jCModifiers, comment);
        }
        if (this.token.kind == Tokens.TokenKind.INTERFACE) {
            return this.interfaceDeclaration(jCModifiers, comment);
        }
        if (this.token.kind == Tokens.TokenKind.ENUM) {
            return this.enumDeclaration(jCModifiers, comment);
        }
        int n = this.token.pos;
        if (this.LAX_IDENTIFIER.accepts(this.token.kind)) {
            list = List.of(jCModifiers, this.toP(this.F.at(n).Ident(this.ident())));
            this.setErrorEndPos(this.token.pos);
        } else {
            list = List.of(jCModifiers);
        }
        JCTree.JCErroneous jCErroneous = this.parseModuleInfo ? this.syntaxError(n, list, "expected.module.or.open", new Tokens.TokenKind[0]) : this.syntaxError(n, list, "expected3", Tokens.TokenKind.CLASS, Tokens.TokenKind.INTERFACE, Tokens.TokenKind.ENUM);
        return this.toP(this.F.Exec(jCErroneous));
    }

    protected JCTree.JCClassDecl classDeclaration(JCTree.JCModifiers jCModifiers, Tokens.Comment comment) {
        int n = this.token.pos;
        this.accept(Tokens.TokenKind.CLASS);
        Name name = this.ident();
        List<JCTree.JCTypeParameter> list = this.typeParametersOpt();
        JCTree.JCExpression jCExpression = null;
        if (this.token.kind == Tokens.TokenKind.EXTENDS) {
            this.nextToken();
            jCExpression = this.parseType();
        }
        List<JCTree.JCExpression> list2 = List.nil();
        if (this.token.kind == Tokens.TokenKind.IMPLEMENTS) {
            this.nextToken();
            list2 = this.typeList();
        }
        List<JCTree> list3 = this.classOrInterfaceBody(name, false);
        JCTree.JCClassDecl jCClassDecl = this.toP(this.F.at(n).ClassDef(jCModifiers, name, list, jCExpression, list2, list3));
        this.attach(jCClassDecl, comment);
        return jCClassDecl;
    }

    protected JCTree.JCClassDecl interfaceDeclaration(JCTree.JCModifiers jCModifiers, Tokens.Comment comment) {
        int n = this.token.pos;
        this.accept(Tokens.TokenKind.INTERFACE);
        Name name = this.ident();
        List<JCTree.JCTypeParameter> list = this.typeParametersOpt();
        List<JCTree.JCExpression> list2 = List.nil();
        if (this.token.kind == Tokens.TokenKind.EXTENDS) {
            this.nextToken();
            list2 = this.typeList();
        }
        List<JCTree> list3 = this.classOrInterfaceBody(name, true);
        JCTree.JCClassDecl jCClassDecl = this.toP(this.F.at(n).ClassDef(jCModifiers, name, list, null, list2, list3));
        this.attach(jCClassDecl, comment);
        return jCClassDecl;
    }

    protected JCTree.JCClassDecl enumDeclaration(JCTree.JCModifiers jCModifiers, Tokens.Comment comment) {
        int n = this.token.pos;
        this.accept(Tokens.TokenKind.ENUM);
        Name name = this.ident();
        List<JCTree.JCExpression> list = List.nil();
        if (this.token.kind == Tokens.TokenKind.IMPLEMENTS) {
            this.nextToken();
            list = this.typeList();
        }
        List<JCTree> list2 = this.enumBody(name);
        jCModifiers.flags |= 0x4000L;
        JCTree.JCClassDecl jCClassDecl = this.toP(this.F.at(n).ClassDef(jCModifiers, name, List.nil(), null, list, list2));
        this.attach(jCClassDecl, comment);
        return jCClassDecl;
    }

    List<JCTree> enumBody(Name name) {
        this.accept(Tokens.TokenKind.LBRACE);
        ListBuffer<JCTree> listBuffer = new ListBuffer<JCTree>();
        if (this.token.kind == Tokens.TokenKind.COMMA) {
            this.nextToken();
        } else if (this.token.kind != Tokens.TokenKind.RBRACE && this.token.kind != Tokens.TokenKind.SEMI) {
            listBuffer.append(this.enumeratorDeclaration(name));
            while (this.token.kind == Tokens.TokenKind.COMMA) {
                this.nextToken();
                if (this.token.kind == Tokens.TokenKind.RBRACE || this.token.kind == Tokens.TokenKind.SEMI) break;
                listBuffer.append(this.enumeratorDeclaration(name));
            }
            if (this.token.kind != Tokens.TokenKind.SEMI && this.token.kind != Tokens.TokenKind.RBRACE) {
                listBuffer.append(this.syntaxError(this.token.pos, "expected3", Tokens.TokenKind.COMMA, Tokens.TokenKind.RBRACE, Tokens.TokenKind.SEMI));
                this.nextToken();
            }
        }
        if (this.token.kind == Tokens.TokenKind.SEMI) {
            this.nextToken();
            while (this.token.kind != Tokens.TokenKind.RBRACE && this.token.kind != Tokens.TokenKind.EOF) {
                listBuffer.appendList(this.classOrInterfaceBodyDeclaration(name, false));
                if (this.token.pos > this.endPosTable.errorEndPos) continue;
                this.skip(false, true, true, false);
            }
        }
        this.accept(Tokens.TokenKind.RBRACE);
        return listBuffer.toList();
    }

    JCTree enumeratorDeclaration(Name name) {
        Object object;
        JCTree jCTree;
        Tokens.Comment comment = this.token.comment(Tokens.Comment.CommentStyle.JAVADOC);
        int n = 16409;
        if (this.token.deprecatedFlag()) {
            n |= 0x20000;
        }
        int n2 = this.token.pos;
        List<JCTree.JCAnnotation> list = this.annotationsOpt(JCTree.Tag.ANNOTATION);
        JCTree.JCModifiers jCModifiers = this.F.at(list.isEmpty() ? -1 : n2).Modifiers(n, list);
        List<JCTree.JCExpression> list2 = this.typeArgumentsOpt();
        int n3 = this.token.pos;
        Name name2 = this.ident();
        int n4 = this.token.pos;
        List<Object> list3 = this.token.kind == Tokens.TokenKind.LPAREN ? this.arguments() : List.nil();
        JCTree.JCClassDecl jCClassDecl = null;
        if (this.token.kind == Tokens.TokenKind.LBRACE) {
            jCTree = this.F.at(-1).Modifiers(16384L);
            object = this.classOrInterfaceBody(this.names.empty, false);
            jCClassDecl = this.toP(this.F.at(n3).AnonymousClassDef((JCTree.JCModifiers)jCTree, (List<JCTree>)object));
        }
        if (list3.isEmpty() && jCClassDecl == null) {
            n4 = n3;
        }
        jCTree = this.F.at(n3).Ident(name);
        object = this.F.at(n4).NewClass(null, list2, (JCTree.JCExpression)jCTree, list3, jCClassDecl);
        if (n4 != n3) {
            this.storeEnd((JCTree)object, this.S.prevToken().endPos);
        }
        jCTree = this.F.at(n3).Ident(name);
        JCTree.JCVariableDecl jCVariableDecl = this.toP(this.F.at(n2).VarDef(jCModifiers, name2, (JCTree.JCExpression)jCTree, (JCTree.JCExpression)object));
        this.attach(jCVariableDecl, comment);
        return jCVariableDecl;
    }

    List<JCTree.JCExpression> typeList() {
        ListBuffer<JCTree.JCExpression> listBuffer = new ListBuffer<JCTree.JCExpression>();
        listBuffer.append(this.parseType());
        while (this.token.kind == Tokens.TokenKind.COMMA) {
            this.nextToken();
            listBuffer.append(this.parseType());
        }
        return listBuffer.toList();
    }

    List<JCTree> classOrInterfaceBody(Name name, boolean bl) {
        this.accept(Tokens.TokenKind.LBRACE);
        if (this.token.pos <= this.endPosTable.errorEndPos) {
            this.skip(false, true, false, false);
            if (this.token.kind == Tokens.TokenKind.LBRACE) {
                this.nextToken();
            }
        }
        ListBuffer<JCTree> listBuffer = new ListBuffer<JCTree>();
        while (this.token.kind != Tokens.TokenKind.RBRACE && this.token.kind != Tokens.TokenKind.EOF) {
            listBuffer.appendList(this.classOrInterfaceBodyDeclaration(name, bl));
            if (this.token.pos > this.endPosTable.errorEndPos) continue;
            this.skip(false, true, true, false);
        }
        this.accept(Tokens.TokenKind.RBRACE);
        return listBuffer.toList();
    }

    protected List<JCTree> classOrInterfaceBodyDeclaration(Name name, boolean bl) {
        JCTree.JCExpression jCExpression;
        boolean bl2;
        List<JCTree.JCAnnotation> list;
        if (this.token.kind == Tokens.TokenKind.SEMI) {
            this.nextToken();
            return List.nil();
        }
        Tokens.Comment comment = this.token.comment(Tokens.Comment.CommentStyle.JAVADOC);
        int n = this.token.pos;
        JCTree.JCModifiers jCModifiers = this.modifiersOpt();
        if (this.token.kind == Tokens.TokenKind.CLASS || this.token.kind == Tokens.TokenKind.INTERFACE || this.token.kind == Tokens.TokenKind.ENUM) {
            return List.of(this.classOrInterfaceOrEnumDeclaration(jCModifiers, comment));
        }
        if (this.token.kind == Tokens.TokenKind.LBRACE && (jCModifiers.flags & 0xFFFL & 0xFFFFFFFFFFFFFFF7L) == 0L && jCModifiers.annotations.isEmpty()) {
            if (bl) {
                this.error(this.token.pos, "initializer.not.allowed", new Object[0]);
            }
            return List.of(this.block(n, jCModifiers.flags));
        }
        n = this.token.pos;
        List<JCTree.JCTypeParameter> list2 = this.typeParametersOpt();
        if (list2.nonEmpty() && jCModifiers.pos == -1) {
            jCModifiers.pos = n;
            this.storeEnd(jCModifiers, n);
        }
        if ((list = this.annotationsOpt(JCTree.Tag.ANNOTATION)).nonEmpty()) {
            this.checkAnnotationsAfterTypeParams(((JCTree.JCAnnotation)list.head).pos);
            jCModifiers.annotations = jCModifiers.annotations.appendList(list);
            if (jCModifiers.pos == -1) {
                jCModifiers.pos = ((JCTree.JCAnnotation)jCModifiers.annotations.head).pos;
            }
        }
        Tokens.Token token = this.token;
        n = this.token.pos;
        boolean bl3 = bl2 = this.token.kind == Tokens.TokenKind.VOID;
        if (bl2) {
            jCExpression = this.to(this.F.at(n).TypeIdent(TypeTag.VOID));
            this.nextToken();
        } else {
            jCExpression = this.unannotatedType();
        }
        if (this.token.kind == Tokens.TokenKind.LPAREN && !bl && jCExpression.hasTag(JCTree.Tag.IDENT)) {
            if (bl || token.name() != name) {
                this.error(n, "invalid.meth.decl.ret.type.req", new Object[0]);
            } else if (list.nonEmpty()) {
                this.illegal(((JCTree.JCAnnotation)list.head).pos);
            }
            return List.of(this.methodDeclaratorRest(n, jCModifiers, null, this.names.init, list2, bl, true, comment));
        }
        n = this.token.pos;
        Name name2 = this.ident();
        if (this.token.kind == Tokens.TokenKind.LPAREN) {
            return List.of(this.methodDeclaratorRest(n, jCModifiers, jCExpression, name2, list2, bl, bl2, comment));
        }
        if (!bl2 && list2.isEmpty()) {
            List<JCTree> list3 = this.variableDeclaratorsRest(n, jCModifiers, jCExpression, name2, bl, comment, new ListBuffer()).toList();
            this.accept(Tokens.TokenKind.SEMI);
            this.storeEnd((JCTree)list3.last(), this.S.prevToken().endPos);
            return list3;
        }
        n = this.token.pos;
        List<JCTree.JCMethodDecl> list4 = bl2 ? List.of(this.toP(this.F.at(n).MethodDef(jCModifiers, name2, jCExpression, list2, List.nil(), List.nil(), null, null))) : null;
        return List.of(this.syntaxError(this.token.pos, list4, "expected", Tokens.TokenKind.LPAREN));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JCTree methodDeclaratorRest(int n, JCTree.JCModifiers jCModifiers, JCTree.JCExpression jCExpression, Name name, List<JCTree.JCTypeParameter> list, boolean bl, boolean bl2, Tokens.Comment comment) {
        if (bl) {
            if ((jCModifiers.flags & 8L) != 0L) {
                this.checkStaticInterfaceMethods();
            }
            if ((jCModifiers.flags & 2L) != 0L) {
                this.checkPrivateInterfaceMethods();
            }
        }
        JCTree.JCVariableDecl jCVariableDecl = this.receiverParam;
        try {
            JCTree.JCExpression jCExpression2;
            this.receiverParam = null;
            List<JCTree.JCVariableDecl> list2 = this.formalParameters();
            if (!bl2) {
                jCExpression = this.bracketsOpt(jCExpression);
            }
            List<JCTree.JCExpression> list3 = List.nil();
            if (this.token.kind == Tokens.TokenKind.THROWS) {
                this.nextToken();
                list3 = this.qualidentList(true);
            }
            JCTree.JCBlock jCBlock = null;
            if (this.token.kind == Tokens.TokenKind.LBRACE) {
                jCBlock = this.block();
                jCExpression2 = null;
            } else {
                if (this.token.kind == Tokens.TokenKind.DEFAULT) {
                    this.accept(Tokens.TokenKind.DEFAULT);
                    jCExpression2 = this.annotationValue();
                } else {
                    jCExpression2 = null;
                }
                this.accept(Tokens.TokenKind.SEMI);
                if (this.token.pos <= this.endPosTable.errorEndPos) {
                    this.skip(false, true, false, false);
                    if (this.token.kind == Tokens.TokenKind.LBRACE) {
                        jCBlock = this.block();
                    }
                }
            }
            JCTree.JCMethodDecl jCMethodDecl = this.toP(this.F.at(n).MethodDef(jCModifiers, name, jCExpression, list, this.receiverParam, list2, list3, jCBlock, jCExpression2));
            this.attach(jCMethodDecl, comment);
            JCTree.JCMethodDecl jCMethodDecl2 = jCMethodDecl;
            return jCMethodDecl2;
        }
        finally {
            this.receiverParam = jCVariableDecl;
        }
    }

    List<JCTree.JCExpression> qualidentList(boolean bl) {
        JCTree.JCExpression jCExpression;
        ListBuffer<JCTree.JCExpression> listBuffer = new ListBuffer<JCTree.JCExpression>();
        List<Object> list = bl ? this.typeAnnotationsOpt() : List.nil();
        JCTree.JCExpression jCExpression2 = this.qualident(bl);
        if (!list.isEmpty()) {
            jCExpression = this.insertAnnotationsToMostInner(jCExpression2, list, false);
            listBuffer.append(jCExpression);
        } else {
            listBuffer.append(jCExpression2);
        }
        while (this.token.kind == Tokens.TokenKind.COMMA) {
            this.nextToken();
            list = bl ? this.typeAnnotationsOpt() : List.nil();
            jCExpression2 = this.qualident(bl);
            if (!list.isEmpty()) {
                jCExpression = this.insertAnnotationsToMostInner(jCExpression2, list, false);
                listBuffer.append(jCExpression);
                continue;
            }
            listBuffer.append(jCExpression2);
        }
        return listBuffer.toList();
    }

    protected List<JCTree.JCTypeParameter> typeParametersOpt() {
        if (this.token.kind == Tokens.TokenKind.LT) {
            ListBuffer<JCTree.JCTypeParameter> listBuffer = new ListBuffer<JCTree.JCTypeParameter>();
            this.nextToken();
            listBuffer.append(this.typeParameter());
            while (this.token.kind == Tokens.TokenKind.COMMA) {
                this.nextToken();
                listBuffer.append(this.typeParameter());
            }
            this.accept(Tokens.TokenKind.GT);
            return listBuffer.toList();
        }
        return List.nil();
    }

    JCTree.JCTypeParameter typeParameter() {
        int n = this.token.pos;
        List<JCTree.JCAnnotation> list = this.typeAnnotationsOpt();
        Name name = this.ident();
        ListBuffer<JCTree.JCExpression> listBuffer = new ListBuffer<JCTree.JCExpression>();
        if (this.token.kind == Tokens.TokenKind.EXTENDS) {
            this.nextToken();
            listBuffer.append(this.parseType());
            while (this.token.kind == Tokens.TokenKind.AMP) {
                this.nextToken();
                listBuffer.append(this.parseType());
            }
        }
        return this.toP(this.F.at(n).TypeParameter(name, listBuffer.toList(), list));
    }

    List<JCTree.JCVariableDecl> formalParameters() {
        return this.formalParameters(false);
    }

    List<JCTree.JCVariableDecl> formalParameters(boolean bl) {
        ListBuffer<JCTree.JCVariableDecl> listBuffer = new ListBuffer<JCTree.JCVariableDecl>();
        this.accept(Tokens.TokenKind.LPAREN);
        if (this.token.kind != Tokens.TokenKind.RPAREN) {
            this.allowThisIdent = true;
            JCTree.JCVariableDecl jCVariableDecl = this.formalParameter(bl);
            if (jCVariableDecl.nameexpr != null) {
                this.receiverParam = jCVariableDecl;
            } else {
                listBuffer.append(jCVariableDecl);
            }
            this.allowThisIdent = false;
            while (this.token.kind == Tokens.TokenKind.COMMA) {
                if ((jCVariableDecl.mods.flags & 0x400000000L) != 0L) {
                    this.error(jCVariableDecl, "varargs.must.be.last", new Object[0]);
                }
                this.nextToken();
                jCVariableDecl = this.formalParameter(bl);
                listBuffer.append(jCVariableDecl);
            }
        }
        if (this.token.kind == Tokens.TokenKind.RPAREN) {
            this.nextToken();
        } else {
            this.setErrorEndPos(this.token.pos);
            this.reportSyntaxError(this.S.prevToken().endPos, "expected3", Tokens.TokenKind.COMMA, Tokens.TokenKind.RPAREN, Tokens.TokenKind.LBRACKET);
        }
        return listBuffer.toList();
    }

    List<JCTree.JCVariableDecl> implicitParameters(boolean bl) {
        if (bl) {
            this.accept(Tokens.TokenKind.LPAREN);
        }
        ListBuffer<JCTree.JCVariableDecl> listBuffer = new ListBuffer<JCTree.JCVariableDecl>();
        if (this.token.kind != Tokens.TokenKind.RPAREN && this.token.kind != Tokens.TokenKind.ARROW) {
            listBuffer.append(this.implicitParameter());
            while (this.token.kind == Tokens.TokenKind.COMMA) {
                this.nextToken();
                listBuffer.append(this.implicitParameter());
            }
        }
        if (bl) {
            this.accept(Tokens.TokenKind.RPAREN);
        }
        return listBuffer.toList();
    }

    JCTree.JCModifiers optFinal(long l) {
        JCTree.JCModifiers jCModifiers = this.modifiersOpt();
        this.checkNoMods(jCModifiers.flags & 0xFFFFFFFFFFFDFFEFL);
        jCModifiers.flags |= l;
        return jCModifiers;
    }

    private JCTree.JCExpression insertAnnotationsToMostInner(JCTree.JCExpression jCExpression, List<JCTree.JCAnnotation> list, boolean bl) {
        int n = this.getEndPos(jCExpression);
        JCTree.JCExpression jCExpression2 = jCExpression;
        JCTree.JCArrayTypeTree jCArrayTypeTree = null;
        while (TreeInfo.typeIn(jCExpression2).hasTag(JCTree.Tag.TYPEARRAY)) {
            jCArrayTypeTree = (JCTree.JCArrayTypeTree)TreeInfo.typeIn(jCExpression2);
            jCExpression2 = jCArrayTypeTree.elemtype;
        }
        if (bl) {
            jCExpression2 = this.to(this.F.at(this.token.pos).TypeArray(jCExpression2));
        }
        JCTree.JCExpression jCExpression3 = jCExpression2;
        if (list.nonEmpty()) {
            JCTree.JCExpression jCExpression4 = jCExpression2;
            while (TreeInfo.typeIn(jCExpression2).hasTag(JCTree.Tag.SELECT) || TreeInfo.typeIn(jCExpression2).hasTag(JCTree.Tag.TYPEAPPLY)) {
                while (TreeInfo.typeIn(jCExpression2).hasTag(JCTree.Tag.SELECT)) {
                    jCExpression4 = jCExpression2;
                    jCExpression2 = ((JCTree.JCFieldAccess)TreeInfo.typeIn(jCExpression2)).getExpression();
                }
                while (TreeInfo.typeIn(jCExpression2).hasTag(JCTree.Tag.TYPEAPPLY)) {
                    jCExpression4 = jCExpression2;
                    jCExpression2 = ((JCTree.JCTypeApply)TreeInfo.typeIn((JCTree.JCExpression)jCExpression2)).clazz;
                }
            }
            jCExpression2 = this.F.at(((JCTree.JCAnnotation)list.head).pos).AnnotatedType(list, jCExpression2);
            if (TreeInfo.typeIn(jCExpression4).hasTag(JCTree.Tag.TYPEAPPLY)) {
                ((JCTree.JCTypeApply)TreeInfo.typeIn((JCTree.JCExpression)jCExpression4)).clazz = jCExpression2;
            } else if (TreeInfo.typeIn(jCExpression4).hasTag(JCTree.Tag.SELECT)) {
                ((JCTree.JCFieldAccess)TreeInfo.typeIn((JCTree.JCExpression)jCExpression4)).selected = jCExpression2;
            } else {
                jCExpression3 = jCExpression2;
            }
        }
        if (jCArrayTypeTree == null) {
            return jCExpression3;
        }
        jCArrayTypeTree.elemtype = jCExpression3;
        this.storeEnd(jCExpression, n);
        return jCExpression;
    }

    protected JCTree.JCVariableDecl formalParameter() {
        return this.formalParameter(false);
    }

    protected JCTree.JCVariableDecl formalParameter(boolean bl) {
        JCTree.JCModifiers jCModifiers = this.optFinal(0x200000000L);
        this.permitTypeAnnotationsPushBack = true;
        JCTree.JCExpression jCExpression = this.parseType();
        this.permitTypeAnnotationsPushBack = false;
        if (this.token.kind == Tokens.TokenKind.ELLIPSIS) {
            List<JCTree.JCAnnotation> list = this.typeAnnotationsPushedBack;
            this.typeAnnotationsPushedBack = List.nil();
            jCModifiers.flags |= 0x400000000L;
            jCExpression = this.insertAnnotationsToMostInner(jCExpression, list, true);
            this.nextToken();
        } else {
            if (this.typeAnnotationsPushedBack.nonEmpty()) {
                this.reportSyntaxError(((JCTree.JCAnnotation)this.typeAnnotationsPushedBack.head).pos, "illegal.start.of.type", new Object[0]);
            }
            this.typeAnnotationsPushedBack = List.nil();
        }
        return this.variableDeclaratorId(jCModifiers, jCExpression, bl);
    }

    protected JCTree.JCVariableDecl implicitParameter() {
        JCTree.JCModifiers jCModifiers = this.F.at(this.token.pos).Modifiers(0x200000000L);
        return this.variableDeclaratorId(jCModifiers, null, true);
    }

    void error(int n, String string, Object ... objectArray) {
        this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, n, string, objectArray);
    }

    void error(JCDiagnostic.DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
        this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, diagnosticPosition, string, objectArray);
    }

    void warning(int n, String string, Object ... objectArray) {
        this.log.warning(n, string, objectArray);
    }

    protected JCTree.JCExpression checkExprStat(JCTree.JCExpression jCExpression) {
        if (!TreeInfo.isExpressionStatement(jCExpression)) {
            JCTree.JCErroneous jCErroneous = this.F.at(jCExpression.pos).Erroneous(List.of(jCExpression));
            this.error(jCErroneous, "not.stmt", new Object[0]);
            return jCErroneous;
        }
        return jCExpression;
    }

    static int prec(Tokens.TokenKind tokenKind) {
        JCTree.Tag tag = JavacParser.optag(tokenKind);
        return tag != JCTree.Tag.NO_TAG ? TreeInfo.opPrec(tag) : -1;
    }

    static int earlier(int n, int n2) {
        if (n == -1) {
            return n2;
        }
        if (n2 == -1) {
            return n;
        }
        return n < n2 ? n : n2;
    }

    static JCTree.Tag optag(Tokens.TokenKind tokenKind) {
        switch (tokenKind) {
            case BARBAR: {
                return JCTree.Tag.OR;
            }
            case AMPAMP: {
                return JCTree.Tag.AND;
            }
            case BAR: {
                return JCTree.Tag.BITOR;
            }
            case BAREQ: {
                return JCTree.Tag.BITOR_ASG;
            }
            case CARET: {
                return JCTree.Tag.BITXOR;
            }
            case CARETEQ: {
                return JCTree.Tag.BITXOR_ASG;
            }
            case AMP: {
                return JCTree.Tag.BITAND;
            }
            case AMPEQ: {
                return JCTree.Tag.BITAND_ASG;
            }
            case EQEQ: {
                return JCTree.Tag.EQ;
            }
            case BANGEQ: {
                return JCTree.Tag.NE;
            }
            case LT: {
                return JCTree.Tag.LT;
            }
            case GT: {
                return JCTree.Tag.GT;
            }
            case LTEQ: {
                return JCTree.Tag.LE;
            }
            case GTEQ: {
                return JCTree.Tag.GE;
            }
            case LTLT: {
                return JCTree.Tag.SL;
            }
            case LTLTEQ: {
                return JCTree.Tag.SL_ASG;
            }
            case GTGT: {
                return JCTree.Tag.SR;
            }
            case GTGTEQ: {
                return JCTree.Tag.SR_ASG;
            }
            case GTGTGT: {
                return JCTree.Tag.USR;
            }
            case GTGTGTEQ: {
                return JCTree.Tag.USR_ASG;
            }
            case PLUS: {
                return JCTree.Tag.PLUS;
            }
            case PLUSEQ: {
                return JCTree.Tag.PLUS_ASG;
            }
            case SUB: {
                return JCTree.Tag.MINUS;
            }
            case SUBEQ: {
                return JCTree.Tag.MINUS_ASG;
            }
            case STAR: {
                return JCTree.Tag.MUL;
            }
            case STAREQ: {
                return JCTree.Tag.MUL_ASG;
            }
            case SLASH: {
                return JCTree.Tag.DIV;
            }
            case SLASHEQ: {
                return JCTree.Tag.DIV_ASG;
            }
            case PERCENT: {
                return JCTree.Tag.MOD;
            }
            case PERCENTEQ: {
                return JCTree.Tag.MOD_ASG;
            }
            case INSTANCEOF: {
                return JCTree.Tag.TYPETEST;
            }
        }
        return JCTree.Tag.NO_TAG;
    }

    static JCTree.Tag unoptag(Tokens.TokenKind tokenKind) {
        switch (tokenKind) {
            case PLUS: {
                return JCTree.Tag.POS;
            }
            case SUB: {
                return JCTree.Tag.NEG;
            }
            case BANG: {
                return JCTree.Tag.NOT;
            }
            case TILDE: {
                return JCTree.Tag.COMPL;
            }
            case PLUSPLUS: {
                return JCTree.Tag.PREINC;
            }
            case SUBSUB: {
                return JCTree.Tag.PREDEC;
            }
        }
        return JCTree.Tag.NO_TAG;
    }

    static TypeTag typetag(Tokens.TokenKind tokenKind) {
        switch (tokenKind) {
            case BYTE: {
                return TypeTag.BYTE;
            }
            case CHAR: {
                return TypeTag.CHAR;
            }
            case SHORT: {
                return TypeTag.SHORT;
            }
            case INT: {
                return TypeTag.INT;
            }
            case LONG: {
                return TypeTag.LONG;
            }
            case FLOAT: {
                return TypeTag.FLOAT;
            }
            case DOUBLE: {
                return TypeTag.DOUBLE;
            }
            case BOOLEAN: {
                return TypeTag.BOOLEAN;
            }
        }
        return TypeTag.NONE;
    }

    void checkDiamond() {
        if (!this.allowDiamond) {
            this.log.error(JCDiagnostic.DiagnosticFlag.SOURCE_LEVEL, this.token.pos, "diamond.not.supported.in.source", this.source.name);
        }
    }

    void checkMulticatch() {
        if (!this.allowMulticatch) {
            this.log.error(JCDiagnostic.DiagnosticFlag.SOURCE_LEVEL, this.token.pos, "multicatch.not.supported.in.source", this.source.name);
        }
    }

    void checkTryWithResources() {
        if (!this.allowTWR) {
            this.log.error(JCDiagnostic.DiagnosticFlag.SOURCE_LEVEL, this.token.pos, "try.with.resources.not.supported.in.source", this.source.name);
        }
    }

    void checkVariableInTryWithResources(int n) {
        if (!this.allowEffectivelyFinalVariablesInTWR) {
            this.log.error(JCDiagnostic.DiagnosticFlag.SOURCE_LEVEL, n, "var.in.try.with.resources.not.supported.in.source", this.source.name);
        }
    }

    void checkLambda() {
        if (!this.allowLambda) {
            this.log.error(JCDiagnostic.DiagnosticFlag.SOURCE_LEVEL, this.token.pos, "lambda.not.supported.in.source", this.source.name);
        }
    }

    void checkMethodReferences() {
        if (!this.allowMethodReferences) {
            this.log.error(JCDiagnostic.DiagnosticFlag.SOURCE_LEVEL, this.token.pos, "method.references.not.supported.in.source", this.source.name);
        }
    }

    void checkDefaultMethods() {
        if (!this.allowDefaultMethods) {
            this.log.error(JCDiagnostic.DiagnosticFlag.SOURCE_LEVEL, this.token.pos, "default.methods.not.supported.in.source", this.source.name);
        }
    }

    void checkIntersectionTypesInCast() {
        if (!this.allowIntersectionTypesInCast) {
            this.log.error(JCDiagnostic.DiagnosticFlag.SOURCE_LEVEL, this.token.pos, "intersection.types.in.cast.not.supported.in.source", this.source.name);
        }
    }

    void checkStaticInterfaceMethods() {
        if (!this.allowStaticInterfaceMethods) {
            this.log.error(JCDiagnostic.DiagnosticFlag.SOURCE_LEVEL, this.token.pos, "static.intf.methods.not.supported.in.source", this.source.name);
        }
    }

    void checkTypeAnnotations() {
        if (!this.allowTypeAnnotations) {
            this.log.error(JCDiagnostic.DiagnosticFlag.SOURCE_LEVEL, this.token.pos, "type.annotations.not.supported.in.source", this.source.name);
        }
    }

    void checkPrivateInterfaceMethods() {
        if (!this.allowPrivateInterfaceMethods) {
            this.log.error(JCDiagnostic.DiagnosticFlag.SOURCE_LEVEL, this.token.pos, CompilerProperties.Errors.PrivateIntfMethodsNotSupportedInSource(this.source.name));
        }
    }

    protected void checkAnnotationsAfterTypeParams(int n) {
        if (!this.allowAnnotationsAfterTypeParams) {
            this.log.error(JCDiagnostic.DiagnosticFlag.SOURCE_LEVEL, n, "annotations.after.type.params.not.supported.in.source", this.source.name);
        }
    }

    protected static abstract class AbstractEndPosTable
    implements EndPosTable {
        protected JavacParser parser;
        public int errorEndPos = -1;

        public AbstractEndPosTable(JavacParser javacParser) {
            this.parser = javacParser;
        }

        protected abstract <T extends JCTree> T to(T var1);

        protected abstract <T extends JCTree> T toP(T var1);

        public void setErrorEndPos(int n) {
            if (n > this.errorEndPos) {
                this.errorEndPos = n;
            }
        }

        public void setParser(JavacParser javacParser) {
            this.parser = javacParser;
        }
    }

    protected static class EmptyEndPosTable
    extends AbstractEndPosTable {
        EmptyEndPosTable(JavacParser javacParser) {
            super(javacParser);
        }

        @Override
        public void storeEnd(JCTree jCTree, int n) {
        }

        @Override
        protected <T extends JCTree> T to(T t) {
            return t;
        }

        @Override
        protected <T extends JCTree> T toP(T t) {
            return t;
        }

        @Override
        public int getEndPos(JCTree jCTree) {
            return -1;
        }

        @Override
        public int replaceTree(JCTree jCTree, JCTree jCTree2) {
            return -1;
        }
    }

    protected static class SimpleEndPosTable
    extends AbstractEndPosTable {
        private final IntHashTable endPosMap = new IntHashTable();

        SimpleEndPosTable(JavacParser javacParser) {
            super(javacParser);
        }

        @Override
        public void storeEnd(JCTree jCTree, int n) {
            this.endPosMap.putAtIndex(jCTree, this.errorEndPos > n ? this.errorEndPos : n, this.endPosMap.lookup(jCTree));
        }

        @Override
        protected <T extends JCTree> T to(T t) {
            this.storeEnd(t, this.parser.token.endPos);
            return t;
        }

        @Override
        protected <T extends JCTree> T toP(T t) {
            this.storeEnd(t, this.parser.S.prevToken().endPos);
            return t;
        }

        @Override
        public int getEndPos(JCTree jCTree) {
            int n = this.endPosMap.getFromIndex(this.endPosMap.lookup(jCTree));
            return n == -1 ? -1 : n;
        }

        @Override
        public int replaceTree(JCTree jCTree, JCTree jCTree2) {
            int n = this.endPosMap.remove(jCTree);
            if (n != -1) {
                this.storeEnd(jCTree2, n);
                return n;
            }
            return -1;
        }
    }

    static enum ParensResult {
        CAST,
        EXPLICIT_LAMBDA,
        IMPLICIT_LAMBDA,
        PARENS;

    }

    static enum BasicErrorRecoveryAction implements ErrorRecoveryAction
    {
        BLOCK_STMT{

            @Override
            public JCTree doRecover(JavacParser javacParser) {
                return javacParser.parseStatementAsBlock();
            }
        }
        ,
        CATCH_CLAUSE{

            @Override
            public JCTree doRecover(JavacParser javacParser) {
                return javacParser.catchClause();
            }
        };

    }

    static interface ErrorRecoveryAction {
        public JCTree doRecover(JavacParser var1);
    }
}

