/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javac.parser;

import java.util.HashMap;
import java.util.Map;
import org.openjdk.tools.javac.parser.DocCommentParser;
import org.openjdk.tools.javac.parser.ParserFactory;
import org.openjdk.tools.javac.parser.Tokens;
import org.openjdk.tools.javac.tree.DCTree;
import org.openjdk.tools.javac.tree.DocCommentTable;
import org.openjdk.tools.javac.tree.JCTree;
import org.openjdk.tools.javac.util.DiagnosticSource;

public class LazyDocCommentTable
implements DocCommentTable {
    ParserFactory fac;
    DiagnosticSource diagSource;
    Map<JCTree, Entry> table;

    LazyDocCommentTable(ParserFactory parserFactory) {
        this.fac = parserFactory;
        this.diagSource = parserFactory.log.currentSource();
        this.table = new HashMap<JCTree, Entry>();
    }

    @Override
    public boolean hasComment(JCTree jCTree) {
        return this.table.containsKey(jCTree);
    }

    @Override
    public Tokens.Comment getComment(JCTree jCTree) {
        Entry entry = this.table.get(jCTree);
        return entry == null ? null : entry.comment;
    }

    @Override
    public String getCommentText(JCTree jCTree) {
        Tokens.Comment comment = this.getComment(jCTree);
        return comment == null ? null : comment.getText();
    }

    @Override
    public DCTree.DCDocComment getCommentTree(JCTree jCTree) {
        Entry entry = this.table.get(jCTree);
        if (entry == null) {
            return null;
        }
        if (entry.tree == null) {
            entry.tree = new DocCommentParser(this.fac, this.diagSource, entry.comment).parse();
        }
        return entry.tree;
    }

    @Override
    public void putComment(JCTree jCTree, Tokens.Comment comment) {
        this.table.put(jCTree, new Entry(comment));
    }

    private static class Entry {
        final Tokens.Comment comment;
        DCTree.DCDocComment tree;

        Entry(Tokens.Comment comment) {
            this.comment = comment;
        }
    }
}

