/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javac.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.openjdk.tools.javac.util.ArrayUtils;
import org.openjdk.tools.javac.util.Name;
import org.openjdk.tools.javac.util.Names;

public class ByteBuffer {
    public byte[] elems;
    public int length;

    public ByteBuffer() {
        this(64);
    }

    public ByteBuffer(int n) {
        this.elems = new byte[n];
        this.length = 0;
    }

    public void appendByte(int n) {
        this.elems = ArrayUtils.ensureCapacity(this.elems, this.length);
        this.elems[this.length++] = (byte)n;
    }

    public void appendBytes(byte[] byArray, int n, int n2) {
        this.elems = ArrayUtils.ensureCapacity(this.elems, this.length + n2);
        System.arraycopy(byArray, n, this.elems, this.length, n2);
        this.length += n2;
    }

    public void appendBytes(byte[] byArray) {
        this.appendBytes(byArray, 0, byArray.length);
    }

    public void appendChar(int n) {
        this.elems = ArrayUtils.ensureCapacity(this.elems, this.length + 1);
        this.elems[this.length] = (byte)(n >> 8 & 0xFF);
        this.elems[this.length + 1] = (byte)(n & 0xFF);
        this.length += 2;
    }

    public void appendInt(int n) {
        this.elems = ArrayUtils.ensureCapacity(this.elems, this.length + 3);
        this.elems[this.length] = (byte)(n >> 24 & 0xFF);
        this.elems[this.length + 1] = (byte)(n >> 16 & 0xFF);
        this.elems[this.length + 2] = (byte)(n >> 8 & 0xFF);
        this.elems[this.length + 3] = (byte)(n & 0xFF);
        this.length += 4;
    }

    public void appendLong(long l) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeLong(l);
            this.appendBytes(byteArrayOutputStream.toByteArray(), 0, 8);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)"write");
        }
    }

    public void appendFloat(float f) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeFloat(f);
            this.appendBytes(byteArrayOutputStream.toByteArray(), 0, 4);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)"write");
        }
    }

    public void appendDouble(double d) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeDouble(d);
            this.appendBytes(byteArrayOutputStream.toByteArray(), 0, 8);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)"write");
        }
    }

    public void appendName(Name name) {
        this.appendBytes(name.getByteArray(), name.getByteOffset(), name.getByteLength());
    }

    public void reset() {
        this.length = 0;
    }

    public Name toName(Names names) {
        return names.fromUtf(this.elems, 0, this.length);
    }
}

