/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javah;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.openjdk.javax.lang.model.element.Name;
import org.openjdk.javax.lang.model.element.TypeElement;
import org.openjdk.javax.lang.model.type.ArrayType;
import org.openjdk.javax.lang.model.type.DeclaredType;
import org.openjdk.javax.lang.model.type.NoType;
import org.openjdk.javax.lang.model.type.PrimitiveType;
import org.openjdk.javax.lang.model.type.TypeKind;
import org.openjdk.javax.lang.model.type.TypeMirror;
import org.openjdk.javax.lang.model.type.TypeVariable;
import org.openjdk.javax.lang.model.util.Elements;
import org.openjdk.javax.lang.model.util.SimpleTypeVisitor9;

public class TypeSignature {
    Elements elems;
    private static final String SIG_VOID = "V";
    private static final String SIG_BOOLEAN = "Z";
    private static final String SIG_BYTE = "B";
    private static final String SIG_CHAR = "C";
    private static final String SIG_SHORT = "S";
    private static final String SIG_INT = "I";
    private static final String SIG_LONG = "J";
    private static final String SIG_FLOAT = "F";
    private static final String SIG_DOUBLE = "D";
    private static final String SIG_ARRAY = "[";
    private static final String SIG_CLASS = "L";

    public TypeSignature(Elements elements) {
        this.elems = elements;
    }

    public String getTypeSignature(String string) throws SignatureException {
        return this.getParamJVMSignature(string);
    }

    public String getTypeSignature(String string, TypeMirror typeMirror) throws SignatureException {
        String string2 = null;
        String string3 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        StringTokenizer stringTokenizer = null;
        int n4 = 0;
        if (string != null) {
            n2 = string.indexOf("(");
            n3 = string.indexOf(")");
        }
        if (n2 != -1 && n3 != -1 && n2 + 1 < string.length() && n3 < string.length()) {
            string2 = string.substring(n2 + 1, n3);
        }
        if (string2 != null) {
            if (string2.contains(",")) {
                stringTokenizer = new StringTokenizer(string2, ",");
                if (stringTokenizer != null) {
                    while (stringTokenizer.hasMoreTokens()) {
                        arrayList.add(stringTokenizer.nextToken());
                    }
                }
            } else {
                arrayList.add(string2);
            }
        }
        string3 = "(";
        while (!arrayList.isEmpty()) {
            string4 = ((String)arrayList.remove(n4)).trim();
            string5 = this.getParamJVMSignature(string4);
            if (string5 == null) continue;
            string3 = string3 + string5;
        }
        string3 = string3 + ")";
        string7 = "";
        if (typeMirror != null) {
            n = this.dimensions(typeMirror);
        }
        while (n-- > 0) {
            string7 = string7 + SIG_ARRAY;
        }
        if (typeMirror != null) {
            string6 = this.qualifiedTypeName(typeMirror);
            string7 = string7 + this.getComponentType(string6);
        } else {
            System.out.println("Invalid return type.");
        }
        string3 = string3 + string7;
        return string3;
    }

    private String getParamJVMSignature(String string) throws SignatureException {
        String string2 = "";
        String string3 = "";
        if (string != null) {
            if (string.contains("[]")) {
                int n = string.indexOf("[]");
                string3 = string.substring(0, n);
                String string4 = string.substring(n);
                if (string4 != null) {
                    while (string4.contains("[]")) {
                        string2 = string2 + SIG_ARRAY;
                        int n2 = string4.indexOf("]") + 1;
                        if (n2 < string4.length()) {
                            string4 = string4.substring(n2);
                            continue;
                        }
                        string4 = "";
                    }
                }
            } else {
                string3 = string;
            }
            string2 = string2 + this.getComponentType(string3);
        }
        return string2;
    }

    private String getComponentType(String string) throws SignatureException {
        String string2 = "";
        if (string != null) {
            switch (string) {
                case "void": {
                    string2 = string2 + SIG_VOID;
                    break;
                }
                case "boolean": {
                    string2 = string2 + SIG_BOOLEAN;
                    break;
                }
                case "byte": {
                    string2 = string2 + SIG_BYTE;
                    break;
                }
                case "char": {
                    string2 = string2 + SIG_CHAR;
                    break;
                }
                case "short": {
                    string2 = string2 + SIG_SHORT;
                    break;
                }
                case "int": {
                    string2 = string2 + SIG_INT;
                    break;
                }
                case "long": {
                    string2 = string2 + SIG_LONG;
                    break;
                }
                case "float": {
                    string2 = string2 + SIG_FLOAT;
                    break;
                }
                case "double": {
                    string2 = string2 + SIG_DOUBLE;
                    break;
                }
                default: {
                    if (string.equals("")) break;
                    TypeElement typeElement = this.elems.getTypeElement(string);
                    if (typeElement == null) {
                        throw new SignatureException(string);
                    }
                    String string3 = typeElement.getQualifiedName().toString();
                    String string4 = string3.replace('.', '/');
                    string2 = string2 + SIG_CLASS;
                    string2 = string2 + string4;
                    string2 = string2 + ";";
                }
            }
        }
        return string2;
    }

    int dimensions(TypeMirror typeMirror) {
        if (typeMirror.getKind() != TypeKind.ARRAY) {
            return 0;
        }
        return 1 + this.dimensions(((ArrayType)typeMirror).getComponentType());
    }

    String qualifiedTypeName(TypeMirror typeMirror) {
        SimpleTypeVisitor9<Name, Void> simpleTypeVisitor9 = new SimpleTypeVisitor9<Name, Void>(){

            @Override
            public Name visitArray(ArrayType arrayType, Void void_) {
                return arrayType.getComponentType().accept(this, void_);
            }

            @Override
            public Name visitDeclared(DeclaredType declaredType, Void void_) {
                return ((TypeElement)declaredType.asElement()).getQualifiedName();
            }

            @Override
            public Name visitPrimitive(PrimitiveType primitiveType, Void void_) {
                return TypeSignature.this.elems.getName(primitiveType.toString());
            }

            @Override
            public Name visitNoType(NoType noType, Void void_) {
                if (noType.getKind() == TypeKind.VOID) {
                    return TypeSignature.this.elems.getName("void");
                }
                return (Name)this.defaultAction(noType, void_);
            }

            @Override
            public Name visitTypeVariable(TypeVariable typeVariable, Void void_) {
                return typeVariable.getUpperBound().accept(this, void_);
            }
        };
        return ((Name)simpleTypeVisitor9.visit(typeMirror)).toString();
    }

    static class SignatureException
    extends Exception {
        private static final long serialVersionUID = 1L;

        SignatureException(String string) {
            super(string);
        }
    }
}

