/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.core.stream.dom;

import org.apache.axiom.core.stream.StreamException;
import org.apache.axiom.core.stream.XmlHandler;
import org.apache.axiom.core.stream.XmlReader;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

final class DOMReader
implements XmlReader {
    private static final int START = 0;
    private static final int NOT_VISITED = 1;
    private static final int VISITED = 2;
    private static final int COMPLETE = 3;
    private final XmlHandler handler;
    private final Node rootNode;
    private final boolean expandEntityReferences;
    private final boolean dom3;
    private Node currentNode;
    private int state = 0;

    DOMReader(XmlHandler handler, Node node, boolean expandEntityReferences) {
        this.handler = handler;
        this.rootNode = node;
        this.expandEntityReferences = expandEntityReferences;
        Document ownerDocument = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
        this.dom3 = ownerDocument.getImplementation().hasFeature("XML", "3.0");
    }

    private static String nullToEmptyString(String s) {
        return s == null ? "" : s;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean proceed() throws StreamException {
        currentNode = this.currentNode;
        state = this.state;
        block19: while (true) {
            switch (state) {
                case 0: {
                    if (this.rootNode instanceof Document) {
                        currentNode = this.rootNode;
                    }
                    state = 1;
                    break;
                }
                case 1: {
                    if (currentNode == null) {
                        currentNode = this.rootNode;
                        break;
                    }
                    node = currentNode.getFirstChild();
                    if (node == null) {
                        state = 2;
                        break;
                    }
                    currentNode = node;
                    break;
                }
                case 2: {
                    if (currentNode == null || currentNode instanceof Document) {
                        throw new IllegalStateException();
                    }
                    if (currentNode == this.rootNode) {
                        currentNode = null;
                        break;
                    }
                    node = currentNode.getNextSibling();
                    if (node == null) {
                        currentNode = currentNode.getParentNode();
                        break;
                    }
                    currentNode = node;
                    state = 1;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            v0 = nodeType = currentNode == null ? 9 : (int)currentNode.getNodeType();
            if (state == 2) {
                switch (nodeType) {
                    case 1: {
                        this.handler.endElement();
                        break block19;
                    }
                    case 9: {
                        this.handler.completed();
                        state = 3;
                        break block19;
                    }
                }
                continue;
            }
            switch (nodeType) {
                case 9: {
                    if (currentNode != null) {
                        document = (Document)currentNode;
                        if (this.dom3) {
                            this.handler.startDocument(document.getInputEncoding(), document.getXmlVersion(), document.getXmlEncoding(), document.getXmlStandalone());
                            break block19;
                        }
                        this.handler.startDocument(null, "1.0", null, null);
                        break block19;
                    }
                    this.handler.startFragment();
                    break block19;
                }
                case 10: {
                    docType = (DocumentType)currentNode;
                    this.handler.processDocumentTypeDeclaration(docType.getName(), docType.getPublicId(), docType.getSystemId(), docType.getInternalSubset());
                    break block19;
                }
                case 1: {
                    element = (Element)currentNode;
                    localName = element.getLocalName();
                    if (localName == null) {
                        throw new UnsupportedOperationException();
                    }
                    this.handler.startElement(DOMReader.nullToEmptyString(element.getNamespaceURI()), localName, DOMReader.nullToEmptyString(element.getPrefix()));
                    attributes = element.getAttributes();
                    length = attributes.getLength();
                    for (i = 0; i < length; ++i) {
                        attr = (Attr)attributes.item(i);
                        attrLocalName = attr.getLocalName();
                        if (attrLocalName == null) {
                            this.handler.processAttribute(attr.getName(), attr.getValue(), "CDATA", attr.getSpecified());
                            continue;
                        }
                        namespaceURI = attr.getNamespaceURI();
                        if ("http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
                            this.handler.processNamespaceDeclaration(attrLocalName.equals("xmlns") != false ? "" : attrLocalName, attr.getValue());
                            continue;
                        }
                        this.handler.processAttribute(DOMReader.nullToEmptyString(namespaceURI), attrLocalName, DOMReader.nullToEmptyString(attr.getPrefix()), attr.getValue(), "CDATA", attr.getSpecified());
                    }
                    this.handler.attributesCompleted();
                    break block19;
                }
                case 3: {
                    this.handler.processCharacterData(currentNode.getNodeValue(), this.dom3 != false && ((Text)currentNode).isElementContentWhitespace() != false);
                    break block19;
                }
                case 4: {
                    this.handler.startCDATASection();
                    this.handler.processCharacterData(currentNode.getNodeValue(), false);
                    this.handler.endCDATASection();
                    break block19;
                }
                case 8: {
                    this.handler.startComment();
                    this.handler.processCharacterData(currentNode.getNodeValue(), false);
                    this.handler.endComment();
                    break block19;
                }
                case 7: {
                    pi = (ProcessingInstruction)currentNode;
                    this.handler.startProcessingInstruction(pi.getTarget());
                    this.handler.processCharacterData(pi.getData(), false);
                    this.handler.endProcessingInstruction();
                    break block19;
                }
                case 5: {
                    if (!this.expandEntityReferences) ** break;
                    continue block19;
                    this.handler.processEntityReference(currentNode.getNodeName(), null);
                    state = 2;
                    break block19;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported node type " + nodeType);
                }
            }
            break;
        }
        this.currentNode = currentNode;
        this.state = state;
        return state == 3;
    }

    @Override
    public void dispose() {
    }
}

