/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws;

import java.io.BufferedWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.utility.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WebServiceExceptionLogger {
    private static final Log log = LogFactory.getLog(WebServiceExceptionLogger.class);

    public static void log(Method method, Throwable throwable, boolean logFully, Class serviceImplClass, Object serviceInstance, Object[] args) {
        block9: {
            try {
                if (!log.isDebugEnabled() && !log.isErrorEnabled()) {
                    return;
                }
                Throwable rootT = null;
                rootT = throwable instanceof InvocationTargetException ? ((InvocationTargetException)throwable).getTargetException() : throwable;
                String name = rootT.getClass().getName();
                log.debug((Object)("693210: root Throwable, may cause index error: " + rootT.toString()), rootT);
                String stack = WebServiceExceptionLogger.stackToString(rootT);
                Class checkedException = JavaUtils.getCheckedException(rootT, method);
                if (checkedException == null && log.isErrorEnabled()) {
                    String text = "";
                    text = logFully ? Messages.getMessage((String)"failureLogger", (String)name, (String)rootT.toString()) : Messages.getMessage((String)"failureLogger", (String)name, (String)stack);
                    log.error((Object)text);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Exception invoking a method of " + serviceImplClass.toString() + " of instance " + serviceInstance.toString()));
                    log.debug((Object)("Exception type thrown: " + throwable.getClass().getName()));
                    if (rootT != null) {
                        log.debug((Object)("Root Exception type thrown: " + rootT.getClass().getName()));
                    }
                    if (checkedException != null) {
                        log.debug((Object)("The exception is an instance of checked exception: " + checkedException.getName()));
                    }
                    if (rootT.toString().contains("org.apache.xerces.dom.ElementNSImpl incompatible")) {
                        log.debug((Object)"This exception may be due to a missing @XmlSeeAlso in the client's jaxws or jaxb classes.");
                    }
                    log.debug((Object)("Method = " + method.toGenericString()));
                    for (int i = 0; i < args.length; ++i) {
                        String value = args[i] == null ? "null" : args[i].getClass().toString();
                        log.debug((Object)(" Argument[" + i + "] is " + value));
                    }
                }
            }
            catch (Throwable t) {
                if (!log.isDebugEnabled()) break block9;
                log.debug((Object)"Caught throwable in logger", t);
                log.debug((Object)"While attempting to log original exception", throwable);
            }
        }
    }

    static String stackToString(Throwable e) {
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        PrintWriter pw = new PrintWriter(bw);
        e.printStackTrace(pw);
        pw.close();
        String text = sw.getBuffer().toString();
        int indexOfThrowable = text.indexOf("at");
        if (indexOfThrowable > 0) {
            text = text.substring(indexOfThrowable);
        }
        return text;
    }
}

