/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.processor.util;

import com.sun.tools.ws.processor.generator.GeneratorException;
import com.sun.tools.ws.util.ClassNameInfo;
import java.io.File;
import java.io.IOException;

public class DirectoryUtil {
    public static File getOutputDirectoryFor(String theClass, File rootDir) throws GeneratorException {
        File outputDir = null;
        String qualifiedClassName = theClass;
        String packagePath = null;
        String packageName = ClassNameInfo.getQualifier(qualifiedClassName);
        if (packageName != null && packageName.length() > 0) {
            packagePath = packageName.replace('.', File.separatorChar);
        }
        if (rootDir != null) {
            if (packagePath != null) {
                outputDir = new File(rootDir, packagePath);
                DirectoryUtil.ensureDirectory(outputDir);
            } else {
                outputDir = rootDir;
            }
        } else {
            String workingDirPath = System.getProperty("user.dir");
            File workingDir = new File(workingDirPath);
            if (packagePath == null) {
                outputDir = workingDir;
            } else {
                outputDir = new File(workingDir, packagePath);
                DirectoryUtil.ensureDirectory(outputDir);
            }
        }
        return outputDir;
    }

    public static String getRelativePathfromCommonBase(File file, File base) throws IOException {
        String basePath = base.getCanonicalPath();
        String filePath = file.getCanonicalPath();
        return filePath.substring(basePath.length());
    }

    private static void ensureDirectory(File dir) throws GeneratorException {
        boolean created;
        if (!(dir.exists() || (created = dir.mkdirs()) && dir.exists())) {
            throw new GeneratorException("generator.cannot.create.dir", dir.getAbsolutePath());
        }
    }
}

