/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.ds;

import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.blob.Blob;
import org.apache.axiom.om.ds.AbstractPullOMDataSource;
import org.apache.axiom.om.util.StAXUtils;

public final class BlobOMDataSource
extends AbstractPullOMDataSource {
    private Data data;

    public BlobOMDataSource(Blob blob, String encoding) {
        this.data = new Data(blob, encoding);
    }

    @Override
    public Data getObject() {
        return this.data;
    }

    @Override
    public BlobOMDataSource copy() {
        return new BlobOMDataSource(this.data.getBlob(), this.data.getEncoding());
    }

    @Override
    public boolean isDestructiveRead() {
        return false;
    }

    @Override
    public XMLStreamReader getReader() throws XMLStreamException {
        try {
            return StAXUtils.createXMLStreamReader(this.data.getBlob().getInputStream(), this.data.getEncoding());
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    @Override
    public void close() {
        this.data = null;
    }

    public static final class Data {
        private final Blob blob;
        private final String encoding;

        Data(Blob blob, String encoding) {
            this.blob = blob;
            this.encoding = encoding;
        }

        public Blob getBlob() {
            return this.blob;
        }

        public String getEncoding() {
            return this.encoding;
        }
    }
}

