/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.saaj.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.stax.StAXSource;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttachmentAccessor;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.soap.SOAPEnvelope;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SAAJUtil {
    public static Document getDocumentFromSOAPEnvelope(SOAPEnvelope env) {
        return (Document)OMXMLBuilderFactory.createStAXSOAPModelBuilder((OMMetaFactory)OMAbstractFactory.getMetaFactory((String)"dom"), (XMLStreamReader)env.getXMLStreamReader()).getSOAPMessage();
    }

    public static Element toDOOMSOAPEnvelope(SOAPEnvelope env) {
        return (Element)OMXMLBuilderFactory.createStAXSOAPModelBuilder((OMMetaFactory)OMAbstractFactory.getMetaFactory((String)"dom"), (XMLStreamReader)env.getXMLStreamReader()).getSOAPEnvelope();
    }

    public static SOAPEnvelope getSOAPEnvelopeFromDOOMDocument(Document doc) {
        return OMXMLBuilderFactory.createStAXSOAPModelBuilder((XMLStreamReader)((OMElement)doc.getDocumentElement()).getXMLStreamReader()).getSOAPEnvelope();
    }

    public static SOAPEnvelope toOMSOAPEnvelope(Element elem) {
        return OMXMLBuilderFactory.createStAXSOAPModelBuilder((XMLStreamReader)((OMElement)elem).getXMLStreamReader()).getSOAPEnvelope();
    }

    public static SOAPEnvelope toOMSOAPEnvelope(SOAPMessage message) throws SOAPException {
        final HashMap<String, DataHandler> attachments = new HashMap<String, DataHandler>();
        Iterator it = message.getAttachments();
        while (it.hasNext()) {
            AttachmentPart attachment = (AttachmentPart)it.next();
            String contentId = attachment.getContentId();
            if (contentId == null) continue;
            DataHandler dh = attachment.getDataHandler();
            if (dh == null) {
                throw new SOAPException("Attachment with NULL DataHandler");
            }
            if (contentId.startsWith("<") && contentId.endsWith(">")) {
                contentId = contentId.substring(1, contentId.length() - 1);
            }
            attachments.put(contentId, dh);
        }
        OMElement docElem = (OMElement)message.getSOAPPart().getDocumentElement();
        OMAttachmentAccessor attachmentAccessor = new OMAttachmentAccessor(){

            public DataHandler getDataHandler(String contentID) {
                return (DataHandler)attachments.get(contentID);
            }
        };
        return OMXMLBuilderFactory.createSOAPModelBuilder((OMMetaFactory)OMAbstractFactory.getMetaFactory(), (Source)new StAXSource(docElem.getXMLStreamReader()), (OMAttachmentAccessor)attachmentAccessor).getSOAPEnvelope();
    }

    public static Element toDOM(OMElement element) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        element.serialize((OutputStream)baos);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        return factory.newDocumentBuilder().parse(bais).getDocumentElement();
    }

    public static MimeHeaders copyMimeHeaders(MimeHeaders headers) {
        MimeHeaders result = new MimeHeaders();
        Iterator iterator = headers.getAllHeaders();
        while (iterator.hasNext()) {
            MimeHeader hdr = (MimeHeader)iterator.next();
            result.addHeader(hdr.getName(), hdr.getValue());
        }
        return result;
    }

    public static String normalizeContentType(String contentType) {
        int idx = contentType.indexOf(";");
        return (idx == -1 ? contentType : contentType.substring(0, idx)).trim().toLowerCase();
    }

    public static boolean compareContentTypes(String contentType1, String contentType2) {
        String ct1 = contentType1 == null ? "" : contentType1.trim().toLowerCase();
        String ct2 = contentType2 == null ? "" : contentType2.trim().toLowerCase();
        return ct1.equals(ct2);
    }
}

