/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.util;

import org.jibx.binding.util.ObjectStack;
import org.jibx.runtime.IntStack;

public class SparseStack {
    private Object m_current;
    private int m_level;
    private IntStack m_levels = new IntStack();
    private ObjectStack m_items;

    public SparseStack(Object current) {
        this.m_levels.push(-1);
        this.m_items = new ObjectStack();
        this.m_items.push(current);
        this.m_current = current;
    }

    public SparseStack() {
        this(null);
    }

    public Object getCurrent() {
        return this.m_current;
    }

    public void setCurrent(Object obj) {
        this.m_current = obj;
    }

    public void enter() {
        if (this.m_current != this.m_items.peek()) {
            this.m_levels.push(this.m_level);
            this.m_items.push(this.m_current);
        }
        ++this.m_level;
    }

    public Object exit() {
        --this.m_level;
        if (this.m_level == this.m_levels.peek()) {
            Object obj = this.m_current;
            this.m_levels.pop();
            this.m_current = this.m_items.pop();
            return obj;
        }
        return null;
    }
}

