/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.codegen;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.axis2.wsdl.codegen.CodeGenConfiguration;
import org.apache.axis2.wsdl.codegen.CodeGenerationException;
import org.apache.axis2.wsdl.codegen.emitter.Emitter;
import org.apache.axis2.wsdl.codegen.extension.CodeGenExtension;
import org.apache.axis2.wsdl.databinding.TypeMapper;
import org.apache.axis2.wsdl.i18n.CodegenMessages;
import org.apache.axis2.wsdl.util.ConfigPropertyFileLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CodeGenerationEngine {
    private static final Log log = LogFactory.getLog(CodeGenerationEngine.class);
    private List preExtensions = new ArrayList();
    private List postExtensions = new ArrayList();
    private CodeGenConfiguration configuration;

    public CodeGenerationEngine(CodeGenConfiguration configuration) throws CodeGenerationException {
        this.configuration = configuration;
        this.loadExtensions();
    }

    private void loadExtensions() throws CodeGenerationException {
        String[] postExtensions;
        String[] extensions = ConfigPropertyFileLoader.getExtensionClassNames();
        if (extensions != null) {
            for (int i = 0; i < extensions.length; ++i) {
                this.addPreExtension((CodeGenExtension)this.getObjectFromClassName(extensions[i].trim()));
            }
        }
        if ((postExtensions = ConfigPropertyFileLoader.getPostExtensionClassNames()) != null) {
            for (int i = 0; i < postExtensions.length; ++i) {
                this.addPostExtension((CodeGenExtension)this.getObjectFromClassName(postExtensions[i].trim()));
            }
        }
    }

    private void addPreExtension(CodeGenExtension ext) {
        if (ext != null) {
            this.preExtensions.add(ext);
        }
    }

    private void addPostExtension(CodeGenExtension ext) {
        if (ext != null) {
            this.postExtensions.add(ext);
        }
    }

    public void generate() throws CodeGenerationException {
        try {
            for (int i = 0; i < this.preExtensions.size(); ++i) {
                ((CodeGenExtension)this.preExtensions.get(i)).engage(this.configuration);
            }
            TypeMapper mapper = this.configuration.getTypeMapper();
            if (mapper == null) {
                throw new CodeGenerationException(CodegenMessages.getMessage("engine.noProperDatabindingException"));
            }
            Map emitterMap = ConfigPropertyFileLoader.getLanguageEmitterMap();
            String className = (String)emitterMap.get(this.configuration.getOutputLanguage());
            if (className == null) {
                throw new Exception(CodegenMessages.getMessage("engine.emitterMissing"));
            }
            Emitter emitter = (Emitter)this.getObjectFromClassName(className);
            emitter.setCodeGenConfiguration(this.configuration);
            emitter.setMapper(mapper);
            if (this.configuration.isServerSide()) {
                emitter.emitSkeleton();
                if (this.configuration.isGenerateAll()) {
                    emitter.emitStub();
                }
            } else {
                emitter.emitStub();
            }
            for (int i = 0; i < this.postExtensions.size(); ++i) {
                ((CodeGenExtension)this.postExtensions.get(i)).engage(this.configuration);
            }
        }
        catch (ClassCastException e) {
            throw new CodeGenerationException(CodegenMessages.getMessage("engine.wrongEmitter"), e);
        }
        catch (Exception e) {
            throw new CodeGenerationException(e);
        }
    }

    private Object getObjectFromClassName(String className) throws CodeGenerationException {
        try {
            Class<?> extensionClass = this.getClass().getClassLoader().loadClass(className);
            return extensionClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            log.debug((Object)CodegenMessages.getMessage("engine.extensionLoadProblem"), (Throwable)e);
            return null;
        }
        catch (InstantiationException e) {
            throw new CodeGenerationException(CodegenMessages.getMessage("engine.extensionInstantiationProblem"), e);
        }
        catch (IllegalAccessException e) {
            throw new CodeGenerationException(CodegenMessages.getMessage("engine.illegalExtension"), e);
        }
        catch (NoClassDefFoundError e) {
            log.debug((Object)CodegenMessages.getMessage("engine.extensionLoadProblem"), (Throwable)e);
            return null;
        }
        catch (Exception e) {
            throw new CodeGenerationException(e);
        }
    }

    private String getURI(String currentURI) throws URISyntaxException, IOException {
        File file = new File(currentURI);
        if (file.exists()) {
            return file.getCanonicalFile().toURI().toString();
        }
        return currentURI;
    }

    public CodeGenConfiguration getConfiguration() {
        return this.configuration;
    }
}

