/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.dom.impl.mixin;

import org.apache.axiom.core.CoreModelException;
import org.apache.axiom.dom.DOMCharacterData;
import org.apache.axiom.dom.DOMExceptionUtil;
import org.apache.axiom.dom.DOMSemantics;
import org.apache.axiom.weaver.annotation.Mixin;

@Mixin
public abstract class DOMCharacterDataMixin
implements DOMCharacterData {
    @Override
    public final String getData() {
        try {
            return this.coreGetCharacterData().toString();
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final void setData(String data) {
        try {
            this.coreSetCharacterData(data, DOMSemantics.INSTANCE);
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final String getNodeValue() {
        return this.getData();
    }

    @Override
    public final void setNodeValue(String nodeValue) {
        this.setData(nodeValue);
    }

    @Override
    public final int getLength() {
        String data = this.getData();
        return data != null ? data.length() : 0;
    }

    @Override
    public final void appendData(String arg) {
        this.setData(this.getData() + arg);
    }

    @Override
    public final void deleteData(int offset, int count) {
        this.replaceData(offset, count, null);
    }

    @Override
    public final void replaceData(int offset, int count, String arg) {
        String data = this.getData();
        int length = data.length();
        if (offset < 0 || offset > length || count < 0) {
            throw DOMExceptionUtil.newDOMException((short)1);
        }
        int end = Math.min(count + offset, length);
        if (arg == null) {
            this.setData(new StringBuilder(data).delete(offset, end).toString());
        } else {
            this.setData(new StringBuilder(data).replace(offset, end, arg).toString());
        }
    }

    @Override
    public final void insertData(int offset, String arg) {
        String data = this.getData();
        if (offset < 0 || offset > data.length()) {
            throw DOMExceptionUtil.newDOMException((short)1);
        }
        this.setData(new StringBuilder(data).insert(offset, arg).toString());
    }

    @Override
    public final String substringData(int offset, int count) {
        String data = this.getData();
        int length = data.length();
        if (offset < 0 || offset > length || count < 0) {
            throw DOMExceptionUtil.newDOMException((short)1);
        }
        return data.substring(offset, Math.min(count + offset, length));
    }
}

