/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.ws.message.handler;

import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.encoder.BaseMessageEncoder;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.ws.message.handler.HandlerChain;
import org.opensaml.ws.message.handler.HandlerChainAware;
import org.opensaml.ws.message.handler.HandlerChainResolver;
import org.opensaml.ws.message.handler.HandlerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseHandlerChainAwareMessageEncoder
extends BaseMessageEncoder
implements HandlerChainAware {
    private final Logger log = LoggerFactory.getLogger(BaseHandlerChainAwareMessageEncoder.class);

    protected void doEncode(MessageContext messageContext) throws MessageEncodingException {
        this.prepareMessageContext(messageContext);
        this.processOutboundHandlerChain(messageContext);
        this.encodeToTransport(messageContext);
    }

    protected abstract void prepareMessageContext(MessageContext var1) throws MessageEncodingException;

    protected abstract void encodeToTransport(MessageContext var1) throws MessageEncodingException;

    protected void processOutboundHandlerChain(MessageContext messageContext) throws MessageEncodingException {
        HandlerChainResolver outboundHandlerChainResolver = messageContext.getOutboundHandlerChainResolver();
        if (outboundHandlerChainResolver != null) {
            this.log.debug("Invoking outbound handler chain on message context");
            try {
                for (HandlerChain outboundHandlerChain : outboundHandlerChainResolver.resolve(messageContext)) {
                    if (outboundHandlerChain == null) continue;
                    this.invokeHandlerChain(outboundHandlerChain, messageContext);
                }
            }
            catch (HandlerException e) {
                this.log.error("Encountered HandlerException when encoding message: {}", (Object)e.getMessage());
                throw new MessageEncodingException("Handler exception while encoding message", e);
            }
        }
    }

    protected void invokeHandlerChain(HandlerChain handlerChain, MessageContext messageContext) throws HandlerException {
        if (handlerChain != null && messageContext != null) {
            handlerChain.invoke(messageContext);
        }
    }
}

