/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi;

import java.util.Arrays;
import java.util.regex.Pattern;

public class StringUtilities {
    private static final Pattern p = Pattern.compile("\\s");

    public static String replaceLinearWhiteSpace(String input) {
        return p.matcher(input).replaceAll(" ");
    }

    public static String stripControls(String input) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c > ' ' && c < '\u007f') {
                sb.append(c);
                continue;
            }
            sb.append(' ');
        }
        return sb.toString();
    }

    public static char[] union(char[] ... list) {
        StringBuilder sb = new StringBuilder();
        for (char[] characters : list) {
            for (int i = 0; i < list.length; ++i) {
                if (StringUtilities.contains(sb, characters[i])) continue;
                sb.append(list[i]);
            }
        }
        char[] toReturn = new char[sb.length()];
        sb.getChars(0, sb.length(), toReturn, 0);
        Arrays.sort(toReturn);
        return toReturn;
    }

    public static boolean contains(StringBuilder input, char c) {
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) != c) continue;
            return true;
        }
        return false;
    }

    public static String replaceNull(String test, String replace) {
        return test == null || "null".equalsIgnoreCase(test.trim()) || "".equals(test.trim()) ? replace : test;
    }

    public static int getLevenshteinDistance(String s, String t) {
        int i;
        if (s == null || t == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[] p = new int[n + 1];
        int[] d = new int[n + 1];
        for (i = 0; i <= n; ++i) {
            p[i] = i;
        }
        for (int j = 1; j <= m; ++j) {
            char t_j = t.charAt(j - 1);
            d[0] = j;
            for (i = 1; i <= n; ++i) {
                int cost = s.charAt(i - 1) == t_j ? 0 : 1;
                d[i] = Math.min(Math.min(d[i - 1] + 1, p[i] + 1), p[i - 1] + cost);
            }
            int[] _d = p;
            p = d;
            d = _d;
        }
        return p[n];
    }

    public static boolean notNullOrEmpty(String str, boolean trim) {
        if (trim) {
            return str != null && !str.trim().equals("");
        }
        return str != null && !str.equals("");
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }
}

