/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.codecs;

import org.owasp.esapi.codecs.Codec;
import org.owasp.esapi.codecs.PushbackString;
import org.owasp.esapi.reference.DefaultEncoder;

public class VBScriptCodec
extends Codec {
    public String encode(char[] immune, String input) {
        StringBuilder sb = new StringBuilder();
        boolean encoding = false;
        boolean inquotes = false;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (VBScriptCodec.containsCharacter(c, DefaultEncoder.CHAR_ALPHANUMERICS) || VBScriptCodec.containsCharacter(c, immune)) {
                if (encoding && i > 0) {
                    sb.append("&");
                }
                if (!inquotes && i > 0) {
                    sb.append("\"");
                }
                sb.append(c);
                inquotes = true;
                encoding = false;
                continue;
            }
            if (inquotes && i < input.length()) {
                sb.append("\"");
            }
            if (i > 0) {
                sb.append("&");
            }
            sb.append(this.encodeCharacter(immune, Character.valueOf(c)));
            inquotes = false;
            encoding = true;
        }
        return sb.toString();
    }

    public String encodeCharacter(char[] immune, Character c) {
        char ch = c.charValue();
        if (VBScriptCodec.containsCharacter(ch, immune)) {
            return "" + ch;
        }
        String hex = Codec.getHexForNonAlphanumeric(ch);
        if (hex == null) {
            return "" + ch;
        }
        return "chrw(" + c.charValue() + ")";
    }

    public Character decodeCharacter(PushbackString input) {
        input.mark();
        Character first = input.next();
        if (first == null) {
            input.reset();
            return null;
        }
        if (first.charValue() != '\"') {
            input.reset();
            return null;
        }
        Character second = input.next();
        return second;
    }
}

