/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.jetty.internal;

import java.text.MessageFormat;
import org.apache.felix.http.base.internal.logger.SystemLogger;
import org.eclipse.jetty.util.log.Logger;

public final class JettyLogger
implements Logger {
    private final String name;
    private boolean debugEnabled;

    public JettyLogger() {
        this("org.eclipse.jetty.log");
    }

    public JettyLogger(String name) {
        this.name = name;
    }

    @Override
    public Logger getLogger(String name) {
        JettyLogger logger = new JettyLogger(name);
        logger.setDebugEnabled(this.debugEnabled);
        return logger;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    @Override
    public void setDebugEnabled(boolean enabled) {
        this.debugEnabled = enabled;
    }

    @Override
    public void debug(Throwable throwable) {
        if (this.debugEnabled) {
            SystemLogger.debug(throwable.getMessage());
        }
    }

    @Override
    public void debug(String msg, Object ... args) {
        if (this.debugEnabled) {
            SystemLogger.debug(MessageFormat.format(msg, args));
        }
    }

    @Override
    public void debug(String msg, long value) {
        this.debug(msg, value);
    }

    @Override
    public void debug(String msg, Throwable throwable) {
        if (this.debugEnabled) {
            SystemLogger.debug(msg + ": " + throwable.getMessage());
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void ignore(Throwable throwable) {
    }

    @Override
    public void info(Throwable throwable) {
        SystemLogger.info(throwable.getMessage());
    }

    @Override
    public void info(String msg, Object ... args) {
        SystemLogger.info(MessageFormat.format(msg, args));
    }

    @Override
    public void info(String msg, Throwable throwable) {
        SystemLogger.info(msg + ": " + throwable.getMessage());
    }

    @Override
    public void warn(Throwable throwable) {
        SystemLogger.warning(null, throwable);
    }

    @Override
    public void warn(String msg, Object ... args) {
        SystemLogger.warning(MessageFormat.format(msg, args), null);
    }

    @Override
    public void warn(String msg, Throwable throwable) {
        SystemLogger.warning(msg, throwable);
    }
}

