/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.sql;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCreate;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.ignite.internal.sql.engine.sql.IgniteDdlOperator;
import org.jetbrains.annotations.Nullable;

public class IgniteSqlCreateZone
extends SqlCreate {
    private final SqlIdentifier name;
    @Nullable
    private final SqlNodeList createOptionList;

    public IgniteSqlCreateZone(SqlParserPos pos, boolean ifNotExists, SqlIdentifier name, @Nullable SqlNodeList createOptionList) {
        super((SqlOperator)new Operator(ifNotExists), pos, false, ifNotExists);
        this.name = Objects.requireNonNull(name, "name");
        this.createOptionList = createOptionList;
    }

    public IgniteDdlOperator getOperator() {
        return (IgniteDdlOperator)super.getOperator();
    }

    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.name, (Object)this.createOptionList);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("CREATE");
        writer.keyword("ZONE");
        if (this.ifNotExists()) {
            writer.keyword("IF NOT EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
        if (this.createOptionList != null) {
            writer.keyword("WITH");
            this.createOptionList.unparse(writer, 0, 0);
        }
    }

    public SqlIdentifier name() {
        return this.name;
    }

    public SqlNodeList createOptionList() {
        return this.createOptionList;
    }

    public boolean ifNotExists() {
        return this.ifNotExists;
    }

    protected static class Operator
    extends IgniteDdlOperator {
        protected Operator(boolean existFlag) {
            super("CREATE ZONE", SqlKind.OTHER_DDL, existFlag);
        }

        @Override
        public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new IgniteSqlCreateZone(pos, this.existFlag(), (SqlIdentifier)operands[0], (SqlNodeList)operands[1]);
        }
    }
}

