/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.proto;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.List;
import org.apache.ignite.internal.binarytuple.BinaryTupleBuilder;
import org.apache.ignite.internal.binarytuple.BinaryTupleReader;
import org.apache.ignite.internal.client.proto.ClientBinaryTupleUtils;
import org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.marshalling.Marshaller;
import org.apache.ignite.table.ReceiverDescriptor;
import org.jetbrains.annotations.Nullable;

public class StreamerReceiverSerializer {
    public static <A> void serializeReceiverInfoOnClient(ClientMessagePacker w, String receiverClassName, A receiverArgs, @Nullable Marshaller<A, byte[]> receiverArgsMarshaller, Collection<?> items) {
        int binaryTupleSize = 6 + items.size();
        BinaryTupleBuilder builder = new BinaryTupleBuilder(binaryTupleSize);
        builder.appendString(receiverClassName);
        ClientBinaryTupleUtils.appendObject(builder, receiverArgs);
        ClientBinaryTupleUtils.appendCollectionToBinaryTuple(builder, items);
        w.packInt(binaryTupleSize);
        w.packBinaryTuple(builder);
    }

    public static <A> byte[] serializeReceiverInfoWithElementCount(ReceiverDescriptor<A> receiver, @Nullable A receiverArgs, Collection<?> items) {
        int binaryTupleSize = 6 + items.size();
        BinaryTupleBuilder builder = new BinaryTupleBuilder(binaryTupleSize);
        builder.appendString(receiver.receiverClassName());
        ClientBinaryTupleUtils.appendObject(builder, receiverArgs);
        ClientBinaryTupleUtils.appendCollectionToBinaryTuple(builder, items);
        ByteBuffer buf = builder.build();
        int bufSize = buf.limit() - buf.position();
        byte[] res = new byte[bufSize + 4];
        ByteBuffer.wrap(res).order(ByteOrder.LITTLE_ENDIAN).putInt(binaryTupleSize);
        buf.get(res, 4, bufSize);
        return res;
    }

    public static SteamerReceiverInfo deserializeReceiverInfo(ByteBuffer bytes, int elementCount) {
        String receiverClassName;
        BinaryTupleReader reader = new BinaryTupleReader(elementCount, bytes);
        int readerIndex = 0;
        if ((receiverClassName = reader.stringValue(readerIndex++)) == null) {
            throw new IgniteException(ErrorGroups.Client.PROTOCOL_ERR, "Receiver class name is null");
        }
        Object receiverArg = ClientBinaryTupleUtils.readObject(reader, readerIndex);
        List<Object> items = ClientBinaryTupleUtils.readCollectionFromBinaryTuple(reader, readerIndex += 3);
        return new SteamerReceiverInfo(receiverClassName, receiverArg, items);
    }

    public static byte @Nullable [] serializeReceiverJobResults(@Nullable List<Object> receiverResults) {
        if (receiverResults == null || receiverResults.isEmpty()) {
            return null;
        }
        int numElements = 2 + receiverResults.size();
        BinaryTupleBuilder builder = new BinaryTupleBuilder(numElements);
        ClientBinaryTupleUtils.appendCollectionToBinaryTuple(builder, receiverResults);
        ByteBuffer res = builder.build();
        int numElementsSize = 4;
        byte[] resBytes = new byte[res.limit() - res.position() + numElementsSize];
        ByteBuffer.wrap(resBytes).order(ByteOrder.LITTLE_ENDIAN).putInt(numElements);
        res.get(resBytes, numElementsSize, resBytes.length - numElementsSize);
        return resBytes;
    }

    public static <R> List<R> deserializeReceiverJobResults(byte[] results) {
        if (results == null || results.length == 0) {
            return List.of();
        }
        ByteBuffer buf = ByteBuffer.wrap(results).order(ByteOrder.LITTLE_ENDIAN);
        int numElements = buf.getInt();
        BinaryTupleReader reader = new BinaryTupleReader(numElements, buf.slice().order(ByteOrder.LITTLE_ENDIAN));
        return ClientBinaryTupleUtils.readCollectionFromBinaryTuple(reader, 0);
    }

    public static void serializeReceiverResultsForClient(ClientMessagePacker w, byte @Nullable [] receiverJobResults) {
        if (receiverJobResults == null || receiverJobResults.length == 0) {
            w.packNil();
            return;
        }
        int numElementsSize = 4;
        int binaryTupleSize = receiverJobResults.length - numElementsSize;
        int numElements = ByteBuffer.wrap(receiverJobResults).order(ByteOrder.LITTLE_ENDIAN).getInt();
        w.packInt(numElements);
        w.packBinaryHeader(binaryTupleSize);
        w.writePayload(receiverJobResults, numElementsSize, binaryTupleSize);
    }

    @Nullable
    public static <R> List<R> deserializeReceiverResultsOnClient(ClientMessageUnpacker r) {
        if (r.tryUnpackNil()) {
            return null;
        }
        int numElements = r.unpackInt();
        byte[] bytes = r.readBinary();
        BinaryTupleReader reader = new BinaryTupleReader(numElements, bytes);
        return ClientBinaryTupleUtils.readCollectionFromBinaryTuple(reader, 0);
    }

    public static class SteamerReceiverInfo {
        private final String className;
        @Nullable
        private final Object arg;
        private final List<Object> items;

        private SteamerReceiverInfo(String className, @Nullable Object arg, List<Object> items) {
            this.className = className;
            this.arg = arg;
            this.items = items;
        }

        public String className() {
            return this.className;
        }

        @Nullable
        public Object arg() {
            return this.arg;
        }

        public List<Object> items() {
            return this.items;
        }
    }
}

