/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc.impl.core;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import org.apache.ignite.raft.jraft.Status;
import org.apache.ignite.raft.jraft.entity.PeerId;
import org.apache.ignite.raft.jraft.error.RaftError;
import org.apache.ignite.raft.jraft.error.RemotingException;
import org.apache.ignite.raft.jraft.option.NodeOptions;
import org.apache.ignite.raft.jraft.option.RpcOptions;
import org.apache.ignite.raft.jraft.rpc.InvokeContext;
import org.apache.ignite.raft.jraft.rpc.Message;
import org.apache.ignite.raft.jraft.rpc.RaftClientService;
import org.apache.ignite.raft.jraft.rpc.RpcRequests;
import org.apache.ignite.raft.jraft.rpc.RpcResponseClosure;
import org.apache.ignite.raft.jraft.rpc.impl.AbstractClientService;

public class DefaultRaftClientService
extends AbstractClientService
implements RaftClientService {
    private final ConcurrentMap<PeerId, Executor> appendEntriesExecutorMap = new ConcurrentHashMap<PeerId, Executor>();
    private NodeOptions nodeOptions;

    @Override
    public synchronized boolean init(RpcOptions rpcOptions) {
        boolean ret = super.init(rpcOptions);
        if (ret) {
            this.nodeOptions = (NodeOptions)rpcOptions;
        }
        return ret;
    }

    @Override
    public Future<Message> preVote(PeerId peerId, RpcRequests.RequestVoteRequest request, RpcResponseClosure<RpcRequests.RequestVoteResponse> done) {
        if (this.connect(peerId)) {
            return this.invokeWithDone(peerId, request, done, this.nodeOptions.getElectionTimeoutMs());
        }
        return this.onConnectionFail(this.rpcExecutor, request, done, peerId);
    }

    @Override
    public Future<Message> requestVote(PeerId peerId, RpcRequests.RequestVoteRequest request, RpcResponseClosure<RpcRequests.RequestVoteResponse> done) {
        if (this.connect(peerId)) {
            return this.invokeWithDone(peerId, request, done, this.nodeOptions.getElectionTimeoutMs());
        }
        return this.onConnectionFail(this.rpcExecutor, request, done, peerId);
    }

    @Override
    public Future<Message> appendEntries(PeerId peerId, RpcRequests.AppendEntriesRequest request, int timeoutMs, RpcResponseClosure<RpcRequests.AppendEntriesResponse> done) {
        Executor executor = this.appendEntriesExecutorMap.computeIfAbsent(peerId, k -> this.nodeOptions.getStripedExecutor().next());
        if (this.connect(peerId)) {
            return this.invokeWithDone(peerId, (Message)request, done, timeoutMs, executor);
        }
        return this.onConnectionFail(executor, request, done, peerId);
    }

    @Override
    public Future<Message> getFile(PeerId peerId, RpcRequests.GetFileRequest request, int timeoutMs, RpcResponseClosure<RpcRequests.GetFileResponse> done) {
        InvokeContext ctx = new InvokeContext();
        return this.invokeWithDone(peerId, (Message)request, ctx, done, timeoutMs);
    }

    @Override
    public Future<Message> installSnapshot(PeerId peerId, RpcRequests.InstallSnapshotRequest request, RpcResponseClosure<RpcRequests.InstallSnapshotResponse> done) {
        if (this.connect(peerId)) {
            return this.invokeWithDone(peerId, request, done, this.rpcOptions.getRpcInstallSnapshotTimeout());
        }
        return this.onConnectionFail(this.rpcExecutor, request, done, peerId);
    }

    @Override
    public Future<Message> timeoutNow(PeerId peerId, RpcRequests.TimeoutNowRequest request, int timeoutMs, RpcResponseClosure<RpcRequests.TimeoutNowResponse> done) {
        return this.invokeWithDone(peerId, request, done, timeoutMs);
    }

    @Override
    public Future<Message> readIndex(PeerId peerId, RpcRequests.ReadIndexRequest request, int timeoutMs, RpcResponseClosure<RpcRequests.ReadIndexResponse> done) {
        return this.invokeWithDone(peerId, request, done, timeoutMs);
    }

    private Future<Message> onConnectionFail(Executor executor, Message request, RpcResponseClosure<?> done, PeerId peerId) {
        CompletableFuture<Message> future = new CompletableFuture<Message>();
        executor.execute(() -> {
            String fmt = "Check connection[%s] fail and try to create new one";
            if (done != null) {
                try {
                    done.run(new Status(RaftError.EINTERNAL, "Check connection[%s] fail and try to create new one", peerId));
                }
                catch (Throwable t) {
                    LOG.error("Fail to run RpcResponseClosure, the request is {}.", t, new Object[]{request});
                }
            }
            future.completeExceptionally(new RemotingException(String.format("Check connection[%s] fail and try to create new one", peerId)));
        });
        return future;
    }
}

