/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.disaster;

import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;
import org.apache.ignite.internal.partition.replicator.network.disaster.LocalPartitionStateMessage;
import org.apache.ignite.internal.partition.replicator.network.disaster.LocalPartitionStateMessageImpl;

class LocalPartitionStateMessageSerializer
implements MessageSerializer<LocalPartitionStateMessage> {
    public static final LocalPartitionStateMessageSerializer INSTANCE = new LocalPartitionStateMessageSerializer();

    private LocalPartitionStateMessageSerializer() {
    }

    public boolean writeMessage(LocalPartitionStateMessage msg, MessageWriter writer) throws MessageMappingException {
        LocalPartitionStateMessageImpl message = (LocalPartitionStateMessageImpl)msg;
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)4)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeLong("estimatedRows", message.estimatedRows());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeLong("logIndex", message.logIndex());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeMessage("partitionId", (NetworkMessage)message.partitionId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                int ordinalShifted = message.state() == null ? 0 : message.state().ordinal() + 1;
                boolean written = writer.writeInt("state", ordinalShifted);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

