/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.raft;

import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;
import org.apache.ignite.internal.partition.replicator.network.raft.ResponseEntryImpl;
import org.apache.ignite.internal.partition.replicator.network.raft.SnapshotMvDataResponse;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;

class ResponseEntrySerializer
implements MessageSerializer<SnapshotMvDataResponse.ResponseEntry> {
    public static final ResponseEntrySerializer INSTANCE = new ResponseEntrySerializer();

    private ResponseEntrySerializer() {
    }

    public boolean writeMessage(SnapshotMvDataResponse.ResponseEntry msg, MessageWriter writer) throws MessageMappingException {
        ResponseEntryImpl message = (ResponseEntryImpl)msg;
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)6)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeInt("commitPartitionId", message.commitPartitionId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeBoxedInt("commitTableId", message.commitTableId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeUuid("rowId", message.rowId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                boolean written = writer.writeList("rowVersions", message.rowVersions(), MessageCollectionItemType.MSG);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                boolean written = writer.writeLongArray("timestamps", message.timestamps());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                boolean written = writer.writeUuid("txId", message.txId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

