/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.proto;

import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.compute.ComputeJobDataHolder;
import org.apache.ignite.internal.compute.ComputeJobDataType;
import org.apache.ignite.internal.compute.SharedComputeUtils;
import org.apache.ignite.marshalling.Marshaller;
import org.apache.ignite.marshalling.UnmarshallingException;
import org.jetbrains.annotations.Nullable;

public final class ClientComputeJobUnpacker {
    @Nullable
    public static Object unpackJobResult(ClientMessageUnpacker unpacker, @Nullable Marshaller<?, byte[]> marshaller, @Nullable Class<?> resultClass) {
        ComputeJobDataHolder holder = ClientComputeJobUnpacker.unpackJobArgumentWithoutMarshaller(unpacker);
        return SharedComputeUtils.unmarshalArgOrResult(holder, marshaller, resultClass);
    }

    @Nullable
    public static ComputeJobDataHolder unpackJobArgumentWithoutMarshaller(ClientMessageUnpacker unpacker) {
        if (unpacker.tryUnpackNil()) {
            return null;
        }
        int typeId = unpacker.unpackInt();
        ComputeJobDataType type = ComputeJobDataType.fromId(typeId);
        if (type == null) {
            throw new UnmarshallingException("Unsupported compute job type id: " + typeId);
        }
        return new ComputeJobDataHolder(type, unpacker.readBinary());
    }
}

