/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import java.util.HashMap;
import java.util.NoSuchElementException;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.referencing.provider.AbstractProvider;
import org.apache.sis.internal.referencing.provider.MapProjection3D;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.DefaultParameterDescriptor;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.ImmutableIdentifier;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.Projection;
import org.opengis.util.FactoryException;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

@XmlTransient
public abstract class MapProjection
extends AbstractProvider {
    private static final long serialVersionUID = 6280666068007678702L;
    public static final DefaultParameterDescriptor<Double> SEMI_MAJOR;
    public static final DefaultParameterDescriptor<Double> SEMI_MINOR;
    public static final DefaultParameterDescriptor<Double> ECCENTRICITY;
    @Deprecated
    private OperationMethod redimensioned;

    protected MapProjection(ParameterDescriptorGroup parameterDescriptorGroup) {
        super(2, 2, parameterDescriptorGroup);
    }

    public Class<? extends Projection> getOperationType() {
        return Projection.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public final OperationMethod redimension(int n, int n2) {
        if (n != 3 || n2 != 3) {
            return super.redimension(n, n2);
        }
        MapProjection mapProjection = this;
        synchronized (mapProjection) {
            if (this.redimensioned == null) {
                this.redimensioned = new MapProjection3D(this);
            }
            return this.redimensioned;
        }
    }

    public static void validate(ParameterDescriptor<? extends Number> parameterDescriptor, double d) throws IllegalArgumentException {
        double d2;
        if (!Double.isFinite(d)) {
            throw new IllegalArgumentException(Resources.format((short)25, parameterDescriptor.getName(), d));
        }
        Comparable comparable = parameterDescriptor.getMinimumValue();
        Comparable comparable2 = parameterDescriptor.getMaximumValue();
        double d3 = comparable instanceof Number ? ((Number)((Object)comparable)).doubleValue() : Double.NaN;
        double d4 = d2 = comparable2 instanceof Number ? ((Number)((Object)comparable2)).doubleValue() : Double.NaN;
        if ((d < d3 || d > d2) && d3 != d2) {
            throw new IllegalArgumentException(Errors.format((short)166, parameterDescriptor.getName(), comparable, comparable2, d));
        }
    }

    @Override
    public final MathTransform createMathTransform(MathTransformFactory mathTransformFactory, ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException, FactoryException {
        return this.createProjection(Parameters.castOrWrap(parameterValueGroup)).createMapProjection(mathTransformFactory);
    }

    protected abstract NormalizedProjection createProjection(Parameters var1) throws ParameterNotFoundException;

    @Override
    public final int getEllipsoidsMask() {
        return 1;
    }

    private static GenericName sameNameAs(Citation citation, GeneralParameterDescriptor generalParameterDescriptor) {
        for (GenericName genericName : generalParameterDescriptor.getAlias()) {
            if (!(genericName instanceof Identifier) || ((Identifier)genericName).getAuthority() != citation) continue;
            return genericName;
        }
        throw new NoSuchElementException();
    }

    static ParameterBuilder renameAlias(ParameterBuilder parameterBuilder, ParameterDescriptor<Double> parameterDescriptor, Citation citation, ParameterDescriptor<Double> parameterDescriptor2) {
        MapProjection.renameAliases(parameterBuilder, parameterDescriptor, new Citation[]{citation}, new ParameterDescriptor[]{parameterDescriptor2});
        return parameterBuilder;
    }

    static ParameterBuilder renameAlias(ParameterBuilder parameterBuilder, ParameterDescriptor<Double> parameterDescriptor, Citation citation, ParameterDescriptor<Double> parameterDescriptor2, Citation citation2, ParameterDescriptor<Double> parameterDescriptor3) {
        MapProjection.renameAliases(parameterBuilder, parameterDescriptor, new Citation[]{citation, citation2}, new ParameterDescriptor[]{parameterDescriptor2, parameterDescriptor3});
        return parameterBuilder;
    }

    private static void renameAliases(ParameterBuilder parameterBuilder, ParameterDescriptor<Double> parameterDescriptor, Citation[] citationArray, ParameterDescriptor<?>[] parameterDescriptorArray) {
        int n;
        Citation citation;
        parameterBuilder.addName(parameterDescriptor.getName());
        GenericName[] genericNameArray = new GenericName[citationArray.length];
        Identifier[] identifierArray = new Identifier[citationArray.length];
        for (int i = 0; i < citationArray.length; ++i) {
            genericNameArray[i] = MapProjection.sameNameAs(citationArray[i], parameterDescriptorArray[i]);
            identifierArray[i] = IdentifiedObjects.getIdentifier(parameterDescriptorArray[i], citationArray[i]);
        }
        for (GenericName genericName : parameterDescriptor.getAlias()) {
            citation = ((Identifier)genericName).getAuthority();
            for (n = 0; n < citationArray.length; ++n) {
                if (citation != citationArray[n] || genericNameArray[n] == null) continue;
                genericName = genericNameArray[n];
                genericNameArray[n] = null;
                break;
            }
            parameterBuilder.addName(genericName);
        }
        for (GenericName genericName : parameterDescriptor.getIdentifiers()) {
            citation = genericName.getAuthority();
            for (n = 0; n < citationArray.length; ++n) {
                if (citation != citationArray[n] || identifierArray[n] == null) continue;
                genericName = (ReferenceIdentifier)identifierArray[n];
                identifierArray[n] = null;
                break;
            }
            parameterBuilder.addIdentifier((ReferenceIdentifier)genericName);
        }
    }

    static InternationalString notFormalParameter(String string) {
        return Resources.formatInternational((short)60, (Object)string);
    }

    static {
        MeasurementRange<Double> measurementRange = MeasurementRange.createGreaterThan(0.0, Units.METRE);
        GenericName[] genericNameArray = new GenericName[]{new NamedIdentifier(Citations.ESRI, "Semi_Major"), new NamedIdentifier(Citations.NETCDF, "semi_major_axis"), new NamedIdentifier(Citations.GEOTIFF, "SemiMajorAxis"), new NamedIdentifier(Citations.PROJ4, "a")};
        HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
        hashMap.put("authority", Citations.OGC);
        hashMap.put("name", "semi_major");
        hashMap.put("alias", genericNameArray);
        hashMap.put("identifiers", new ImmutableIdentifier(Citations.GEOTIFF, null, "2057"));
        SEMI_MAJOR = new DefaultParameterDescriptor<Object>(hashMap, 1, 1, Double.class, measurementRange, null, null);
        hashMap.put("name", "semi_minor");
        genericNameArray[0] = new NamedIdentifier(Citations.ESRI, "Semi_Minor");
        genericNameArray[1] = new NamedIdentifier(Citations.NETCDF, "semi_minor_axis");
        genericNameArray[2] = new NamedIdentifier(Citations.GEOTIFF, "SemiMinorAxis");
        genericNameArray[3] = new NamedIdentifier(Citations.PROJ4, "b");
        hashMap.put("identifiers", new ImmutableIdentifier(Citations.GEOTIFF, null, "2058"));
        SEMI_MINOR = new DefaultParameterDescriptor<Object>(hashMap, 1, 1, Double.class, measurementRange, null, null);
        hashMap.clear();
        hashMap.put("authority", Citations.SIS);
        hashMap.put("name", "eccentricity");
        ECCENTRICITY = new DefaultParameterDescriptor<Object>(hashMap, 1, 1, Double.class, MeasurementRange.create(0.0, true, 1.0, true, null), null, null);
    }
}

