/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.objects.user;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.client.objects.Entity;
import org.nuxeo.client.objects.user.ExtendedGroup;

public class User
extends Entity {
    public static final String FIRST_NAME_PROPERTY = "firstName";
    public static final String LAST_NAME_PROPERTY = "lastName";
    public static final String EMAIL_PROPERTY = "email";
    public static final String GROUPS_PROPERTY = "groups";
    public static final String USERNAME_PROPERTY = "username";
    public static final String COMPANY_PROPERTY = "company";
    public static final String PASSWORD_PROPERTY = "password";
    public static final String TENANTID_PROPERTY = "tenantId";
    protected String id;
    protected Map<String, Object> properties = new HashMap<String, Object>();
    protected List<ExtendedGroup> extendedGroups = new ArrayList<ExtendedGroup>();
    @JsonProperty(value="isAdministrator")
    protected boolean isAdministrator;
    @JsonProperty(value="isAnonymous")
    protected boolean isAnonymous;
    @JsonProperty(value="username")
    protected String userName;

    public User() {
        super("user");
    }

    public String getId() {
        return this.id;
    }

    public boolean isAdministrator() {
        return this.isAdministrator;
    }

    public boolean isAnonymous() {
        return this.isAnonymous;
    }

    public List<ExtendedGroup> getExtendedGroups() {
        return this.extendedGroups;
    }

    public String getFirstName() {
        return (String)this.properties.get(FIRST_NAME_PROPERTY);
    }

    public String getLastName() {
        return (String)this.properties.get(LAST_NAME_PROPERTY);
    }

    public String getCompany() {
        return (String)this.properties.get(COMPANY_PROPERTY);
    }

    public String getEmail() {
        return (String)this.properties.get(EMAIL_PROPERTY);
    }

    public List<String> getGroups() {
        return (List)this.properties.get(GROUPS_PROPERTY);
    }

    public String getUserName() {
        if (this.userName == null) {
            return (String)this.properties.get(USERNAME_PROPERTY);
        }
        return this.userName;
    }

    public String getPassword() {
        return (String)this.properties.get(PASSWORD_PROPERTY);
    }

    public void setExtendedGroups(List<ExtendedGroup> extendedGroups) {
        this.extendedGroups = extendedGroups;
    }

    public void setFirstName(String firstName) {
        this.properties.put(FIRST_NAME_PROPERTY, firstName);
    }

    public void setLastName(String lastName) {
        this.properties.put(LAST_NAME_PROPERTY, lastName);
    }

    public void setCompany(String company) {
        this.properties.put(COMPANY_PROPERTY, company);
    }

    public void setEmail(String email) {
        this.properties.put(EMAIL_PROPERTY, email);
    }

    public void setGroups(List<String> groups) {
        this.properties.put(GROUPS_PROPERTY, groups);
    }

    public void setUserName(String userName) {
        this.userName = userName;
        this.properties.put(USERNAME_PROPERTY, userName);
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public void setPassword(String password) {
        this.properties.put(PASSWORD_PROPERTY, password);
    }

    public void setTenantId(String tenantId) {
        this.properties.put(TENANTID_PROPERTY, tenantId);
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }
}

