/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.parser;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.ElementSubsequent;
import com.github.sommeri.less4j.core.ast.Extend;
import com.github.sommeri.less4j.core.ast.MultiTargetExtend;
import com.github.sommeri.less4j.core.ast.PseudoClass;
import com.github.sommeri.less4j.core.ast.Selector;
import com.github.sommeri.less4j.core.ast.SelectorCombinator;
import com.github.sommeri.less4j.core.ast.SelectorPart;
import com.github.sommeri.less4j.core.ast.SimpleSelector;
import com.github.sommeri.less4j.core.parser.ASTBuilderSwitch;
import com.github.sommeri.less4j.core.parser.ConversionUtils;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.core.problems.BugHappened;
import java.util.ArrayList;
import java.util.Iterator;

public class SelectorBuilder {
    private static String EXTEND_PSEUDO = "extend";
    private final HiddenTokenAwareTree token;
    private final ASTBuilderSwitch parent;
    private SelectorCombinator leadingCombinator = null;
    private SimpleSelector currentSimpleSelector = null;
    private SelectorPart nextPart = null;

    public SelectorBuilder(HiddenTokenAwareTree token, ASTBuilderSwitch astBuilderSwitch) {
        this.token = token;
        this.parent = astBuilderSwitch;
    }

    public Selector buildSelector() {
        Iterator<HiddenTokenAwareTree> iterator = this.token.getChildren().iterator();
        Selector result = new Selector(this.token, new ArrayList<SelectorPart>());
        this.currentSimpleSelector = null;
        while (iterator.hasNext()) {
            HiddenTokenAwareTree kid = iterator.next();
            if (ConversionUtils.isSelectorCombinator(kid)) {
                this.finishPart(result);
                this.leadingCombinator = ConversionUtils.createSelectorCombinator(kid);
                continue;
            }
            ASTCssNode node = (ASTCssNode)this.parent.switchOn(kid);
            if (node instanceof SelectorPart) {
                this.openPart(result, (SelectorPart)node);
                continue;
            }
            if (this.currentSimpleSelector == null) {
                SimpleSelector empty = new SimpleSelector(kid, null, null, true);
                empty.setEmptyForm(true);
                this.openPart(result, empty);
            }
            this.currentSimpleSelector.addSubsequent((ElementSubsequent)node);
        }
        this.finishPart(result);
        return result;
    }

    private void openPart(Selector result, SelectorPart node) {
        this.finishPart(result);
        this.nextPart = node;
        if (this.nextPart instanceof SimpleSelector) {
            this.currentSimpleSelector = (SimpleSelector)this.nextPart;
        }
        this.nextPart.setLeadingCombinator(this.leadingCombinator);
        if (this.leadingCombinator != null) {
            this.nextPart.getUnderlyingStructure().moveHidden(this.leadingCombinator.getUnderlyingStructure(), null);
        }
        this.leadingCombinator = null;
    }

    private void finishPart(Selector result) {
        if (this.nextPart != null) {
            this.addPart(result, this.nextPart);
        }
        this.nextPart = null;
        this.currentSimpleSelector = null;
    }

    private void addPart(Selector selector, SelectorPart part) {
        ElementSubsequent lastSubsequent = part.getLastSubsequent();
        while (lastSubsequent != null && this.isExtends(lastSubsequent)) {
            this.convertAndAddExtends(selector, (PseudoClass)lastSubsequent);
            part.removeSubsequent(lastSubsequent);
            lastSubsequent = part.getLastSubsequent();
        }
        if (!part.isEmpty()) {
            selector.addPart(part);
        }
    }

    private void convertAndAddExtends(Selector selector, PseudoClass extendPC) {
        ASTCssNode parameter = extendPC.getParameter();
        if (parameter.getType() == ASTCssNodeType.EXTEND) {
            selector.addExtend((Extend)parameter);
        } else if (parameter.getType() == ASTCssNodeType.MULTI_TARGET_EXTEND) {
            MultiTargetExtend extend = (MultiTargetExtend)parameter;
            for (Extend node : extend.getAllExtends()) {
                selector.addExtend(node);
            }
        } else {
            throw new BugHappened("ASTBuilderSwitch grammar mismatch", parameter.getUnderlyingStructure());
        }
    }

    private boolean isExtends(ElementSubsequent subsequent) {
        return subsequent instanceof PseudoClass && EXTEND_PSEUDO.equals(subsequent.getName());
    }
}

