/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.font.container;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.pdmodel.font.PDFontLike;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.font.util.GlyphDetail;
import org.apache.pdfbox.preflight.font.util.GlyphException;

public abstract class FontContainer<T extends PDFontLike> {
    protected List<ValidationResult.ValidationError> errorBuffer = new ArrayList<ValidationResult.ValidationError>();
    protected boolean embeddedFont = true;
    private final Map<Integer, GlyphDetail> codeToDetail = new HashMap<Integer, GlyphDetail>();
    private boolean errorsAlreadyMerged = false;
    protected final T font;

    public FontContainer(T font) {
        this.font = font;
    }

    public void push(ValidationResult.ValidationError error) {
        this.errorBuffer.add(error);
    }

    public void push(List<ValidationResult.ValidationError> errors) {
        this.errorBuffer.addAll(errors);
    }

    public List<ValidationResult.ValidationError> getAllErrors() {
        return this.errorBuffer;
    }

    public boolean isValid() {
        return this.errorBuffer.isEmpty() && this.isEmbeddedFont();
    }

    public boolean errorsAleadyMerged() {
        return this.errorsAlreadyMerged;
    }

    public void setErrorsAlreadyMerged(boolean errorsAlreadyMerged) {
        this.errorsAlreadyMerged = errorsAlreadyMerged;
    }

    public boolean isEmbeddedFont() {
        return this.embeddedFont;
    }

    public void notEmbedded() {
        this.embeddedFont = false;
    }

    public void checkGlyphWidth(int code) throws GlyphException {
        if (this.isAlreadyProcessed(code)) {
            return;
        }
        try {
            if (!this.hasGlyph(code)) {
                GlyphException e = new GlyphException("3.3.1", code, "The character code " + code + " in the font program \"" + this.font.getName() + "\" is missing from the Character Encoding");
                this.markAsInvalid(code, e);
                throw e;
            }
            float expectedWidth = this.font.getWidth(code);
            float foundWidth = this.font.getWidthFromFont(code);
            this.checkWidthsConsistency(code, expectedWidth, foundWidth);
        }
        catch (IOException e) {
            throw new GlyphException("3.3", code, "Unexpected error during the width validation for the character code " + code + " : " + e.getMessage(), e);
        }
    }

    protected abstract boolean hasGlyph(int var1) throws IOException;

    private boolean isAlreadyProcessed(int code) throws GlyphException {
        boolean already = false;
        GlyphDetail detail = this.codeToDetail.get(code);
        if (detail != null) {
            detail.throwExceptionIfNotValid();
            already = true;
        }
        return already;
    }

    private void checkWidthsConsistency(int code, float expectedWidth, float foundWidth) throws GlyphException {
        if (Math.abs(foundWidth - expectedWidth) > 1.0f) {
            GlyphException e = new GlyphException("3.1.6", code, "Width (" + foundWidth + ") of the character \"" + code + "\" in the font program \"" + this.font.getName() + "\" is inconsistent with the width (" + expectedWidth + ") in the PDF dictionary.");
            this.markAsInvalid(code, e);
            throw e;
        }
        this.markAsValid(code);
    }

    public final void markAsValid(int code) {
        this.codeToDetail.put(code, new GlyphDetail(code));
    }

    public final void markAsInvalid(int code, GlyphException e) {
        this.codeToDetail.put(code, new GlyphDetail(code, e));
    }
}

