/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl.cache;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class SoftIdentityMap<K, V>
implements Map<K, V> {
    private final ReferenceQueue<K> keyQueue = new ReferenceQueue();
    private final ReferenceQueue<V> valueQueue = new ReferenceQueue();
    private final ConcurrentHashMap<SoftIdentityReference<K>, ComputeReference<V>> map = new ConcurrentHashMap();

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(mappingFunction);
        while (true) {
            ComputeReference<V> computingRef;
            this.expungeStaleEntries();
            SoftIdentityReference<K> softKey = new SoftIdentityReference<K>(key, this.keyQueue);
            ComputeReference<V> valueRef = this.map.get(softKey);
            if (valueRef != null && !valueRef.computing) {
                Object value = valueRef.get();
                if (value != null) {
                    return (V)value;
                }
                this.map.remove(softKey, valueRef);
            }
            if ((valueRef = this.map.putIfAbsent(softKey, computingRef = ComputeReference.computing(this.valueQueue))) == null) {
                try {
                    V newValue = mappingFunction.apply(key);
                    if (newValue == null) {
                        this.map.remove(softKey, computingRef);
                        return null;
                    }
                    ComputeReference<V> newValueRef = new ComputeReference<V>(newValue, this.valueQueue);
                    this.map.replace(softKey, computingRef, newValueRef);
                    return newValue;
                }
                catch (Throwable t) {
                    this.map.remove(softKey, computingRef);
                    throw t;
                }
            }
            if (valueRef.computing) continue;
            Object value = valueRef.get();
            if (value != null) {
                return (V)value;
            }
            if (!this.map.remove(softKey, valueRef)) continue;
        }
    }

    private void expungeStaleEntries() {
        Reference<Object> ref;
        while ((ref = this.keyQueue.poll()) != null) {
            this.map.remove(ref);
        }
        while ((ref = this.valueQueue.poll()) != null) {
            this.map.values().remove(ref);
        }
    }

    @Override
    public int size() {
        this.expungeStaleEntries();
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        this.expungeStaleEntries();
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        this.expungeStaleEntries();
        return this.map.containsKey(new SoftIdentityReference<Object>(key, (ReferenceQueue<Object>)null));
    }

    @Override
    public boolean containsValue(Object value) {
        this.expungeStaleEntries();
        for (Reference reference : this.map.values()) {
            Object v = reference.get();
            if (v == null || v != value) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        this.expungeStaleEntries();
        Reference ref = this.map.get(new SoftIdentityReference<Object>(key, (ReferenceQueue<Object>)null));
        return ref != null ? (V)ref.get() : null;
    }

    @Override
    public V put(K key, V value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        this.expungeStaleEntries();
        Reference oldValueRef = this.map.put(new SoftIdentityReference<K>(key, this.keyQueue), new ComputeReference<V>(value, this.valueQueue));
        return oldValueRef != null ? (V)oldValueRef.get() : null;
    }

    @Override
    public V remove(Object key) {
        this.expungeStaleEntries();
        Reference valueRef = this.map.remove(new SoftIdentityReference<Object>(key, (ReferenceQueue<Object>)null));
        return valueRef != null ? (V)valueRef.get() : null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        Objects.requireNonNull(m);
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        this.map.clear();
        this.expungeStaleEntries();
    }

    @Override
    public Set<K> keySet() {
        throw new UnsupportedOperationException("keySet not supported");
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException("values not supported");
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException("entrySet not supported");
    }

    private static class SoftIdentityReference<T>
    extends SoftReference<T> {
        private final int hash;

        SoftIdentityReference(T referent, ReferenceQueue<T> queue) {
            super(referent, queue);
            this.hash = referent.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof SoftIdentityReference)) {
                return false;
            }
            SoftIdentityReference other = (SoftIdentityReference)obj;
            Object thisRef = this.get();
            Object otherRef = other.get();
            return thisRef != null && thisRef.equals(otherRef);
        }

        public int hashCode() {
            return this.hash;
        }
    }

    private static class ComputeReference<V>
    extends SoftReference<V> {
        private final boolean computing;

        ComputeReference(V value, ReferenceQueue<V> queue) {
            super(value, queue);
            this.computing = false;
        }

        private ComputeReference(ReferenceQueue<V> queue) {
            super(null, queue);
            this.computing = true;
        }

        static <V> ComputeReference<V> computing(ReferenceQueue<V> queue) {
            return new ComputeReference<V>(queue);
        }
    }
}

