/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.maven.it;

import java.io.File;
import java.util.Properties;

import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.assertEquals;

/**
 * This is a test set for <a href="https://issues.apache.org/jira/browse/MNG-3833">MNG-3833</a>.
 *
 * @author Benjamin Bentmann
 *
 */
public class MavenITmng3833PomInterpolationDataFlowChainTest extends AbstractMavenIntegrationTestCase {

    public MavenITmng3833PomInterpolationDataFlowChainTest() {
        super(ALL_MAVEN_VERSIONS);
    }

    /**
     * Test that POM interpolation fully interpolates all properties in data flow chain, i.e. where property
     * A depends on property B, and property B depends on property C and so on.
     *
     * @throws Exception in case of failure
     */
    @Test
    public void testitMNG3833() throws Exception {
        File testDir = extractResources("/mng-3833");

        Verifier verifier = newVerifier(testDir.getAbsolutePath());
        verifier.setAutoclean(false);
        verifier.deleteDirectory("target");
        verifier.addCliArgument("validate");
        verifier.execute();
        verifier.verifyErrorFreeLog();

        Properties props = verifier.loadProperties("target/interpolated.properties");

        for (int i = 0; i < 24; i++) {
            String index = ((i < 10) ? "0" : "") + i;
            assertEquals("PASSED", props.getProperty("project.properties.property" + index));
        }
    }
}
