/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.batch.v2;

import java.util.List;
import org.apache.olingo.odata2.api.batch.BatchException;
import org.apache.olingo.odata2.core.batch.v2.BatchParserCommon;
import org.apache.olingo.odata2.core.batch.v2.BatchPart;
import org.apache.olingo.odata2.core.batch.v2.Header;
import org.apache.olingo.odata2.core.batch.v2.Line;

public class BatchQueryOperation
implements BatchPart {
    protected final boolean isStrict;
    protected Line httpStatusLine;
    protected Header headers;
    protected List<Line> body;
    protected int bodySize;
    protected List<Line> message;

    public BatchQueryOperation(List<Line> message, boolean isStrict) {
        this.isStrict = isStrict;
        this.message = message;
    }

    public BatchQueryOperation parse() throws BatchException {
        this.httpStatusLine = this.consumeHttpStatusLine(this.message);
        this.headers = BatchParserCommon.consumeHeaders(this.message);
        BatchParserCommon.consumeBlankLine(this.message, this.isStrict);
        this.body = this.message;
        return this;
    }

    protected Line consumeHttpStatusLine(List<Line> message) throws BatchException {
        if (!message.isEmpty() && !"".equals(message.get(0).toString().trim())) {
            Line method = message.get(0);
            message.remove(0);
            return method;
        }
        int line = !message.isEmpty() ? message.get(0).getLineNumber() : 0;
        throw new BatchException(BatchException.MISSING_METHOD.addContent(new Object[]{line}));
    }

    public Line getHttpStatusLine() {
        return this.httpStatusLine;
    }

    public List<Line> getBody() {
        return this.body;
    }

    public int getBodySize() {
        return this.bodySize;
    }

    @Override
    public Header getHeaders() {
        return this.headers;
    }

    @Override
    public boolean isStrict() {
        return this.isStrict;
    }
}

