/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.provider.springmvc.reference.async;

import java.lang.reflect.Type;
import java.util.Arrays;
import org.apache.servicecomb.provider.springmvc.reference.CseHttpMessageConverter;
import org.apache.servicecomb.provider.springmvc.reference.CseRestTemplate;
import org.apache.servicecomb.provider.springmvc.reference.CseUriTemplateHandler;
import org.apache.servicecomb.provider.springmvc.reference.async.CseAsyncClientHttpRequestFactory;
import org.apache.servicecomb.provider.springmvc.reference.async.CseAsyncRequestCallback;
import org.springframework.core.task.AsyncListenableTaskExecutor;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.http.HttpEntity;
import org.springframework.http.client.AsyncClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.web.client.AsyncRequestCallback;
import org.springframework.web.client.AsyncRestTemplate;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriTemplateHandler;

public class CseAsyncRestTemplate
extends AsyncRestTemplate {
    public CseAsyncRestTemplate() {
        super((AsyncClientHttpRequestFactory)CseAsyncRestTemplate.createSimpleClientHttpRequestFactory(), CseAsyncRestTemplate.createRestTemplate());
        this.setMessageConverters(Arrays.asList(new CseHttpMessageConverter()));
        this.setAsyncRequestFactory(new CseAsyncClientHttpRequestFactory());
        this.setUriTemplateHandler((UriTemplateHandler)new CseUriTemplateHandler());
    }

    private static SimpleClientHttpRequestFactory createSimpleClientHttpRequestFactory() {
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setTaskExecutor((AsyncListenableTaskExecutor)new SimpleAsyncTaskExecutor());
        return requestFactory;
    }

    private static RestTemplate createRestTemplate() {
        return new CseRestTemplate();
    }

    protected <T> AsyncRequestCallback httpEntityCallback(HttpEntity<T> requestBody) {
        return new CseAsyncRequestCallback<T>(requestBody);
    }

    protected <T> AsyncRequestCallback httpEntityCallback(HttpEntity<T> requestBody, Type responseType) {
        return new CseAsyncRequestCallback<T>(requestBody);
    }
}

