/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.fs;

import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.compiler.fs.FileSystem;
import com.google.gxp.compiler.fs.JavaFileRef;
import java.io.IOException;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public class JavaFileManagerImpl
extends ForwardingJavaFileManager<JavaFileManager> {
    private final FileSystem fileSystem;

    public JavaFileManagerImpl(JavaFileManager javaFileManager, FileSystem fileSystem) {
        super(javaFileManager);
        this.fileSystem = Preconditions.checkNotNull(fileSystem);
    }

    private JavaFileRef getJavaFileRef(String className, JavaFileObject.Kind kind) {
        String filename = "/" + className.replace('.', '/') + kind.extension;
        return new JavaFileRef(this.fileSystem.parseFilename(filename));
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        return location.equals(StandardLocation.SOURCE_PATH) || location.equals(StandardLocation.CLASS_OUTPUT) ? this.getJavaFileRef(className, kind) : super.getJavaFileForInput(location, className, kind);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        return location.equals(StandardLocation.CLASS_OUTPUT) ? this.getJavaFileRef(className, kind) : super.getJavaFileForOutput(location, className, kind, sibling);
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        if (location.equals(StandardLocation.CLASS_OUTPUT)) {
            String name = file.getName();
            name = name.substring(1, name.length() - 6).replace("/", ".");
            return name;
        }
        return super.inferBinaryName(location, file);
    }
}

