/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.depend;

import com.google.gxp.com.google.common.base.Objects;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.collect.ImmutableSet;
import com.google.gxp.compiler.base.Callable;
import com.google.gxp.compiler.base.TemplateName;
import java.io.Serializable;
import java.util.Set;

public class DependencyNode
implements Serializable {
    private final TemplateName.FullyQualified name;
    private final long lastModified;
    private final Set<Callable> requirements;

    public DependencyNode(TemplateName.FullyQualified name, long lastModified, Set<Callable> requirements) {
        this.name = Preconditions.checkNotNull(name);
        this.lastModified = lastModified;
        this.requirements = ImmutableSet.copyOf(requirements);
    }

    public TemplateName.FullyQualified getName() {
        return this.name;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public Set<Callable> getRequirements() {
        return this.requirements;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof DependencyNode && this.equals((DependencyNode)that);
    }

    public boolean equals(DependencyNode that) {
        return Objects.equal(this.getName(), that.getName()) && this.getLastModified() == that.getLastModified() && Objects.equal(this.getRequirements(), that.getRequirements());
    }

    public int hashCode() {
        return Objects.hashCode(this.getName(), this.getLastModified(), this.getRequirements());
    }
}

