/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.syncope.common.lib.SyncopeConstants;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.syncope.core.persistence.api.attrvalue.validation.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.DynRealmDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.search.AbstractSearchCond;
import org.apache.syncope.core.persistence.api.dao.search.AnyCond;
import org.apache.syncope.core.persistence.api.dao.search.AttrCond;
import org.apache.syncope.core.persistence.api.dao.search.DynRealmCond;
import org.apache.syncope.core.persistence.api.dao.search.MemberCond;
import org.apache.syncope.core.persistence.api.dao.search.MembershipCond;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.apache.syncope.core.persistence.api.dao.search.RelationshipCond;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.springframework.util.CollectionUtils;

public abstract class AbstractAnySearchDAO
extends AbstractDAO<Any<?>>
implements AnySearchDAO {
    private static final String[] ORDER_BY_NOT_ALLOWED = new String[]{"serialVersionUID", "password", "securityQuestion", "securityAnswer", "token", "tokenExpireTime"};
    protected static final String[] RELATIONSHIP_FIELDS = new String[]{"realm", "userOwner", "groupOwner"};
    protected final RealmDAO realmDAO;
    protected final DynRealmDAO dynRealmDAO;
    protected final UserDAO userDAO;
    protected final GroupDAO groupDAO;
    protected final AnyObjectDAO anyObjectDAO;
    protected final PlainSchemaDAO plainSchemaDAO;
    protected final EntityFactory entityFactory;
    protected final AnyUtilsFactory anyUtilsFactory;
    protected final PlainAttrValidationManager validator;

    protected static SearchCond buildEffectiveCond(SearchCond cond, Set<String> dynRealmKeys, Set<String> groupOwners, AnyTypeKind kind) {
        List groupOwnerConds;
        ArrayList<SearchCond> result = new ArrayList<SearchCond>();
        result.add(cond);
        List dynRealmConds = dynRealmKeys.stream().map(key -> {
            DynRealmCond dynRealmCond = new DynRealmCond();
            dynRealmCond.setDynRealm(key);
            return SearchCond.getLeaf((AbstractSearchCond)dynRealmCond);
        }).collect(Collectors.toList());
        if (!dynRealmConds.isEmpty()) {
            result.add(SearchCond.getOr(dynRealmConds));
        }
        if (!(groupOwnerConds = groupOwners.stream().map(key -> {
            MembershipCond asc;
            if (kind == AnyTypeKind.GROUP) {
                AnyCond anyCond = new AnyCond(AttrCond.Type.EQ);
                anyCond.setSchema("id");
                anyCond.setExpression(key);
                asc = anyCond;
            } else {
                MembershipCond membershipCond = new MembershipCond();
                membershipCond.setGroup(key);
                asc = membershipCond;
            }
            return SearchCond.getLeaf((AbstractSearchCond)asc);
        }).collect(Collectors.toList())).isEmpty()) {
            result.add(SearchCond.getOr(groupOwnerConds));
        }
        return SearchCond.getAnd(result);
    }

    public AbstractAnySearchDAO(RealmDAO realmDAO, DynRealmDAO dynRealmDAO, UserDAO userDAO, GroupDAO groupDAO, AnyObjectDAO anyObjectDAO, PlainSchemaDAO plainSchemaDAO, EntityFactory entityFactory, AnyUtilsFactory anyUtilsFactory, PlainAttrValidationManager validator) {
        this.realmDAO = realmDAO;
        this.dynRealmDAO = dynRealmDAO;
        this.userDAO = userDAO;
        this.groupDAO = groupDAO;
        this.anyObjectDAO = anyObjectDAO;
        this.plainSchemaDAO = plainSchemaDAO;
        this.entityFactory = entityFactory;
        this.anyUtilsFactory = anyUtilsFactory;
        this.validator = validator;
    }

    protected abstract int doCount(Realm var1, boolean var2, Set<String> var3, SearchCond var4, AnyTypeKind var5);

    public int count(Realm base, boolean recursive, Set<String> adminRealms, SearchCond cond, AnyTypeKind kind) {
        if (CollectionUtils.isEmpty(adminRealms)) {
            LOG.error("No realms provided");
            return 0;
        }
        LOG.debug("Search condition:\n{}", (Object)cond);
        if (cond == null || !cond.isValid()) {
            LOG.error("Invalid search condition:\n{}", (Object)cond);
            return 0;
        }
        return this.doCount(base, recursive, adminRealms, cond, kind);
    }

    public <T extends Any<?>> List<T> search(SearchCond cond, AnyTypeKind kind) {
        return this.search(cond, List.of(), kind);
    }

    public <T extends Any<?>> List<T> search(SearchCond cond, List<OrderByClause> orderBy, AnyTypeKind kind) {
        return this.search(this.realmDAO.getRoot(), true, SyncopeConstants.FULL_ADMIN_REALMS, cond, -1, -1, orderBy, kind);
    }

    protected abstract <T extends Any<?>> List<T> doSearch(Realm var1, boolean var2, Set<String> var3, SearchCond var4, int var5, int var6, List<OrderByClause> var7, AnyTypeKind var8);

    protected Pair<PlainSchema, PlainAttrValue> check(AttrCond cond, AnyTypeKind kind) {
        AnyUtils anyUtils = this.anyUtilsFactory.getInstance(kind);
        PlainSchema schema = Optional.ofNullable((PlainSchema)this.plainSchemaDAO.find(cond.getSchema())).orElseThrow(() -> new IllegalArgumentException("Invalid schema " + cond.getSchema()));
        PlainAttrValue attrValue = schema.isUniqueConstraint() ? anyUtils.newPlainAttrUniqueValue() : anyUtils.newPlainAttrValue();
        try {
            if (cond.getType() != AttrCond.Type.LIKE && cond.getType() != AttrCond.Type.ILIKE && cond.getType() != AttrCond.Type.ISNULL && cond.getType() != AttrCond.Type.ISNOTNULL) {
                this.validator.validate(schema, cond.getExpression(), attrValue);
            }
        }
        catch (ValidationException e) {
            throw new IllegalArgumentException("Could not validate expression " + cond.getExpression());
        }
        return Pair.of((Object)schema, (Object)attrValue);
    }

    protected Triple<PlainSchema, PlainAttrValue, AnyCond> check(AnyCond cond, AnyTypeKind kind) {
        AnyCond computed = new AnyCond(cond.getType());
        computed.setSchema(cond.getSchema());
        computed.setExpression(cond.getExpression());
        AnyUtils anyUtils = this.anyUtilsFactory.getInstance(kind);
        Field anyField = Optional.ofNullable(anyUtils.getField(computed.getSchema())).orElseThrow(() -> new IllegalArgumentException("Invalid schema " + computed.getSchema()));
        if ("key".equals(computed.getSchema())) {
            computed.setSchema("id");
        }
        PlainSchema schema = (PlainSchema)this.entityFactory.newEntity(PlainSchema.class);
        schema.setKey(anyField.getName());
        for (AttrSchemaType attrSchemaType : AttrSchemaType.values()) {
            if (!anyField.getType().isAssignableFrom(attrSchemaType.getType())) continue;
            schema.setType(attrSchemaType);
        }
        boolean foundBooleanMin = false;
        boolean foundBooleanMax = false;
        if (Integer.class.equals(anyField.getType())) {
            for (Annotation annotation : anyField.getAnnotations()) {
                if (Min.class.equals(annotation.annotationType())) {
                    foundBooleanMin = ((Min)annotation).value() == 0L;
                    continue;
                }
                if (!Max.class.equals(annotation.annotationType())) continue;
                foundBooleanMax = ((Max)annotation).value() == 1L;
            }
        }
        if (foundBooleanMin && foundBooleanMax) {
            schema.setType(AttrSchemaType.Boolean);
        }
        if (ArrayUtils.contains((Object[])RELATIONSHIP_FIELDS, (Object)computed.getSchema())) {
            computed.setSchema(computed.getSchema() + "_id");
            schema.setType(AttrSchemaType.String);
        }
        PlainAttrValue attrValue = anyUtils.newPlainAttrValue();
        if (computed.getType() != AttrCond.Type.LIKE && computed.getType() != AttrCond.Type.ILIKE && computed.getType() != AttrCond.Type.ISNULL && computed.getType() != AttrCond.Type.ISNOTNULL) {
            try {
                this.validator.validate(schema, computed.getExpression(), attrValue);
            }
            catch (ValidationException e) {
                throw new IllegalArgumentException("Could not validate expression " + computed.getExpression());
            }
        }
        return Triple.of((Object)schema, (Object)attrValue, (Object)computed);
    }

    protected List<String> check(MembershipCond cond) {
        List groups;
        List list = SyncopeConstants.UUID_PATTERN.matcher(cond.getGroup()).matches() ? List.of(cond.getGroup()) : (groups = cond.getGroup().indexOf(37) == -1 ? Optional.ofNullable(this.groupDAO.findKey(cond.getGroup())).map(List::of).orElseGet(List::of) : this.groupDAO.findKeysByNamePattern(cond.getGroup()));
        if (groups.isEmpty()) {
            throw new IllegalArgumentException("Could not find group(s) for " + cond.getGroup());
        }
        return groups;
    }

    protected Set<String> check(RelationshipCond cond) {
        Set<String> rightAnyObjects;
        Set<String> set = cond.getAnyObject() == null ? Set.of() : (rightAnyObjects = SyncopeConstants.UUID_PATTERN.matcher(cond.getAnyObject()).matches() ? Set.of(cond.getAnyObject()) : this.anyObjectDAO.findByName(cond.getAnyObject()).stream().map(Entity::getKey).collect(Collectors.toSet()));
        if (rightAnyObjects.isEmpty()) {
            throw new IllegalArgumentException("Could not find any object for " + cond.getAnyObject());
        }
        return rightAnyObjects;
    }

    protected Set<String> check(MemberCond cond) {
        Set<String> members;
        Set<String> set = cond.getMember() == null ? Set.of() : (members = SyncopeConstants.UUID_PATTERN.matcher(cond.getMember()).matches() ? Set.of(cond.getMember()) : Optional.ofNullable(this.userDAO.findKey(cond.getMember())).map(Set::of).orElseGet(() -> this.anyObjectDAO.findByName(cond.getMember()).stream().map(Entity::getKey).collect(Collectors.toSet())));
        if (members.isEmpty()) {
            throw new IllegalArgumentException("Could not find user or any object for " + cond.getMember());
        }
        return members;
    }

    protected <T extends Any<?>> List<T> buildResult(List<Object> raw, AnyTypeKind kind) {
        List keys = raw.stream().map(key -> key instanceof Object[] ? (String)((Object[])key)[0] : (String)key).collect(Collectors.toList());
        List anys = this.anyUtilsFactory.getInstance(kind).dao().findByKeys(keys).stream().sorted(Comparator.comparing(any -> keys.indexOf(any.getKey()))).collect(Collectors.toList());
        keys.stream().filter(key -> !anys.stream().anyMatch(any -> key.equals(any.getKey()))).forEach(key -> LOG.error("Could not find {} with id {}, even if returned by native query", (Object)kind, key));
        return anys;
    }

    public <T extends Any<?>> List<T> search(Realm base, boolean recursive, Set<String> adminRealms, SearchCond cond, int page, int itemsPerPage, List<OrderByClause> orderBy, AnyTypeKind kind) {
        List<OrderByClause> effectiveOrderBy;
        if (CollectionUtils.isEmpty(adminRealms)) {
            LOG.error("No realms provided");
            return List.of();
        }
        LOG.debug("Search condition:\n{}", (Object)cond);
        if (cond == null || !cond.isValid()) {
            LOG.error("Invalid search condition:\n{}", (Object)cond);
            return List.of();
        }
        if (orderBy.isEmpty()) {
            OrderByClause keyClause = new OrderByClause();
            keyClause.setField(kind == AnyTypeKind.USER ? "username" : "name");
            keyClause.setDirection(OrderByClause.Direction.ASC);
            effectiveOrderBy = List.of(keyClause);
        } else {
            effectiveOrderBy = orderBy.stream().filter(clause -> !ArrayUtils.contains((Object[])ORDER_BY_NOT_ALLOWED, (Object)clause.getField())).collect(Collectors.toList());
        }
        return this.doSearch(base, recursive, adminRealms, cond, page, itemsPerPage, effectiveOrderBy, kind);
    }
}

