/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net;

import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.net.NodeID;
import com.tc.util.Assert;
import java.io.IOException;
import java.io.Serializable;

public class StripeID
implements NodeID,
Serializable {
    public static final StripeID NULL_ID = new StripeID("NULL-ID");
    private static final String UNINITIALIZED = "Uninitialized";
    private String name;

    public StripeID() {
        this.name = UNINITIALIZED;
    }

    public StripeID(String name) {
        this.name = name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof StripeID) {
            StripeID that = (StripeID)o;
            return this.name.equals(that.name);
        }
        return false;
    }

    public String getName() {
        Assert.assertTrue(this.name != UNINITIALIZED);
        return this.name;
    }

    public String toString() {
        return "StripeID[" + this.getName() + "]";
    }

    @Override
    public boolean isNull() {
        return NULL_ID.equals(this);
    }

    @Override
    public StripeID deserializeFrom(TCByteBufferInput in) throws IOException {
        this.name = in.readString();
        return this;
    }

    @Override
    public void serializeTo(TCByteBufferOutput out) {
        Assert.assertTrue(this.name != UNINITIALIZED);
        out.writeString(this.name);
    }

    @Override
    public byte getNodeType() {
        return 4;
    }

    @Override
    public int compareTo(NodeID n) {
        if (this.getNodeType() != n.getNodeType()) {
            return this.getNodeType() - n.getNodeType();
        }
        StripeID target = (StripeID)n;
        return this.name.compareTo(target.name);
    }
}

