/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.lib.batch;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.client.ClientConfiguration;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.syncope.common.rest.api.RESTHeaders;
import org.apache.syncope.common.rest.api.batch.BatchItem;
import org.apache.syncope.common.rest.api.batch.BatchPayloadParser;
import org.apache.syncope.common.rest.api.batch.BatchResponseItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchResponse {
    private static final Logger LOG = LoggerFactory.getLogger(BatchResponse.class);
    private final String boundary;
    private final String jwt;
    private final URI monitor;
    private final TLSClientParameters tlsClientParameters;
    private Response response;

    public static Response poll(URI monitor, String jwt, String boundary, TLSClientParameters tlsClientParameters) {
        WebClient webClient = WebClient.create((URI)monitor).header("Authorization", new Object[]{"Bearer " + jwt}).type(RESTHeaders.multipartMixedWith((String)boundary.substring(2)));
        if (tlsClientParameters != null) {
            ClientConfiguration config = WebClient.getConfig((Object)webClient);
            HTTPConduit httpConduit = (HTTPConduit)config.getConduit();
            httpConduit.setTlsClientParameters(tlsClientParameters);
        }
        return webClient.get();
    }

    public static List<BatchResponseItem> getItems(Response response) throws IOException {
        String body = IOUtils.toString((InputStream)((InputStream)response.getEntity()), (String)StandardCharsets.UTF_8.name());
        LOG.debug("Batch response body:\n{}", (Object)body);
        return BatchPayloadParser.parse((InputStream)new ByteArrayInputStream(body.getBytes()), (MediaType)response.getMediaType(), (BatchItem)new BatchResponseItem());
    }

    public BatchResponse(String boundary, String jwt, TLSClientParameters tlsClientParameters, Response response) {
        this.boundary = boundary;
        this.jwt = jwt;
        this.tlsClientParameters = tlsClientParameters;
        this.monitor = response.getLocation();
        this.response = response;
    }

    public String getBoundary() {
        return this.boundary;
    }

    public URI getMonitor() {
        return this.monitor;
    }

    public Response getResponse() {
        return this.response;
    }

    public Response poll() {
        this.response = BatchResponse.poll(this.monitor, this.jwt, this.boundary, this.tlsClientParameters);
        return this.response;
    }

    public List<BatchResponseItem> getItems() throws IOException {
        return BatchResponse.getItems(this.response);
    }
}

