/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.support;

import java.io.Serializable;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.AccountExpiredException;
import javax.security.auth.login.AccountLockedException;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import lombok.Generated;
import org.apereo.cas.DefaultMessageDescriptor;
import org.apereo.cas.authentication.AuthenticationAccountStateHandler;
import org.apereo.cas.authentication.MessageDescriptor;
import org.apereo.cas.authentication.exceptions.AccountDisabledException;
import org.apereo.cas.authentication.exceptions.AccountPasswordMustChangeException;
import org.apereo.cas.authentication.exceptions.InvalidLoginLocationException;
import org.apereo.cas.authentication.exceptions.InvalidLoginTimeException;
import org.apereo.cas.authentication.support.password.PasswordExpiringWarningMessageDescriptor;
import org.apereo.cas.authentication.support.password.PasswordPolicyContext;
import org.apereo.cas.util.DateTimeUtils;
import org.ldaptive.LdapAttribute;
import org.ldaptive.auth.AccountState;
import org.ldaptive.auth.AuthenticationResponse;
import org.ldaptive.auth.ext.ActiveDirectoryAccountState;
import org.ldaptive.auth.ext.EDirectoryAccountState;
import org.ldaptive.auth.ext.FreeIPAAccountState;
import org.ldaptive.auth.ext.PasswordExpirationAccountState;
import org.ldaptive.control.PasswordPolicyControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.LinkedCaseInsensitiveMap;

public class DefaultLdapAccountStateHandler
implements AuthenticationAccountStateHandler<AuthenticationResponse, PasswordPolicyContext> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultLdapAccountStateHandler.class);
    private static final int DEFAULT_ERROR_COUNT = 30;
    protected Map<AccountState.Error, LoginException> errorMap;
    private Map<String, Class<? extends LoginException>> attributesToErrorMap = new LinkedCaseInsensitiveMap(30);

    public DefaultLdapAccountStateHandler() {
        this.errorMap = new HashMap<AccountState.Error, LoginException>(30);
        this.errorMap.put((AccountState.Error)ActiveDirectoryAccountState.Error.ACCOUNT_DISABLED, (LoginException)new AccountDisabledException());
        this.errorMap.put((AccountState.Error)ActiveDirectoryAccountState.Error.ACCOUNT_LOCKED_OUT, new AccountLockedException());
        this.errorMap.put((AccountState.Error)ActiveDirectoryAccountState.Error.INVALID_LOGON_HOURS, (LoginException)new InvalidLoginTimeException());
        this.errorMap.put((AccountState.Error)ActiveDirectoryAccountState.Error.INVALID_WORKSTATION, (LoginException)new InvalidLoginLocationException());
        this.errorMap.put((AccountState.Error)ActiveDirectoryAccountState.Error.PASSWORD_MUST_CHANGE, (LoginException)new AccountPasswordMustChangeException());
        this.errorMap.put((AccountState.Error)ActiveDirectoryAccountState.Error.PASSWORD_EXPIRED, new CredentialExpiredException());
        this.errorMap.put((AccountState.Error)ActiveDirectoryAccountState.Error.ACCOUNT_EXPIRED, new AccountExpiredException());
        this.errorMap.put((AccountState.Error)ActiveDirectoryAccountState.Error.LOGON_FAILURE, new FailedLoginException());
        this.errorMap.put((AccountState.Error)EDirectoryAccountState.Error.ACCOUNT_EXPIRED, new AccountExpiredException());
        this.errorMap.put((AccountState.Error)EDirectoryAccountState.Error.FAILED_AUTHENTICATION, new FailedLoginException());
        this.errorMap.put((AccountState.Error)EDirectoryAccountState.Error.LOGIN_LOCKOUT, new AccountLockedException());
        this.errorMap.put((AccountState.Error)EDirectoryAccountState.Error.LOGIN_TIME_LIMITED, (LoginException)new InvalidLoginTimeException());
        this.errorMap.put((AccountState.Error)EDirectoryAccountState.Error.PASSWORD_EXPIRED, new CredentialExpiredException());
        this.errorMap.put((AccountState.Error)PasswordExpirationAccountState.Error.PASSWORD_EXPIRED, new CredentialExpiredException());
        this.errorMap.put((AccountState.Error)PasswordPolicyControl.Error.ACCOUNT_LOCKED, new AccountLockedException());
        this.errorMap.put((AccountState.Error)PasswordPolicyControl.Error.PASSWORD_EXPIRED, new CredentialExpiredException());
        this.errorMap.put((AccountState.Error)PasswordPolicyControl.Error.INSUFFICIENT_PASSWORD_QUALITY, (LoginException)new AccountPasswordMustChangeException());
        this.errorMap.put((AccountState.Error)PasswordPolicyControl.Error.CHANGE_AFTER_RESET, (LoginException)new AccountPasswordMustChangeException());
        this.errorMap.put((AccountState.Error)FreeIPAAccountState.Error.FAILED_AUTHENTICATION, new FailedLoginException());
        this.errorMap.put((AccountState.Error)FreeIPAAccountState.Error.PASSWORD_EXPIRED, new CredentialExpiredException());
        this.errorMap.put((AccountState.Error)FreeIPAAccountState.Error.ACCOUNT_EXPIRED, new AccountExpiredException());
        this.errorMap.put((AccountState.Error)FreeIPAAccountState.Error.MAXIMUM_LOGINS_EXCEEDED, new AccountLockedException());
        this.errorMap.put((AccountState.Error)FreeIPAAccountState.Error.LOGIN_TIME_LIMITED, (LoginException)new InvalidLoginTimeException());
        this.errorMap.put((AccountState.Error)FreeIPAAccountState.Error.LOGIN_LOCKOUT, new AccountLockedException());
        this.errorMap.put((AccountState.Error)FreeIPAAccountState.Error.ACCOUNT_NOT_FOUND, new AccountNotFoundException());
        this.errorMap.put((AccountState.Error)FreeIPAAccountState.Error.CREDENTIAL_NOT_FOUND, new FailedLoginException());
        this.errorMap.put((AccountState.Error)FreeIPAAccountState.Error.ACCOUNT_DISABLED, (LoginException)new AccountDisabledException());
    }

    public List<MessageDescriptor> handle(AuthenticationResponse response, PasswordPolicyContext configuration) throws LoginException {
        AccountState state;
        LOGGER.debug("Attempting to handle LDAP account state for [{}]", (Object)response);
        if (!this.attributesToErrorMap.isEmpty() && response.isSuccess()) {
            LOGGER.debug("Handling policy based on pre-defined attributes");
            this.handlePolicyAttributes(response);
        }
        if ((state = response.getAccountState()) == null && !response.isSuccess()) {
            this.handleFailingResponse(response, configuration);
        }
        if (state == null) {
            LOGGER.debug("Account state not defined. Returning empty list of messages.");
            return new ArrayList<MessageDescriptor>(0);
        }
        ArrayList<MessageDescriptor> messages = new ArrayList<MessageDescriptor>();
        this.handleError(state.getError(), response, configuration, messages);
        this.handleWarning(state.getWarning(), response, configuration, messages);
        return messages;
    }

    protected void handleFailingResponse(AuthenticationResponse response, PasswordPolicyContext configuration) throws LoginException {
        ActiveDirectoryAccountState.Error error = ActiveDirectoryAccountState.Error.parse((String)response.getDiagnosticMessage());
        this.handleError((AccountState.Error)error, response, configuration, new ArrayList<MessageDescriptor>());
    }

    protected void handleError(AccountState.Error error, AuthenticationResponse response, PasswordPolicyContext configuration, List<MessageDescriptor> messages) throws LoginException {
        LOGGER.debug("Handling LDAP account state error [{}]", (Object)error);
        if (error != null && this.errorMap.containsKey(error)) {
            throw this.errorMap.get(error);
        }
        LOGGER.debug("No LDAP error mapping defined for [{}]", (Object)error);
    }

    protected void handleWarning(AccountState.Warning warning, AuthenticationResponse response, PasswordPolicyContext configuration, List<MessageDescriptor> messages) {
        LOGGER.debug("Handling account state warning [{}]", (Object)warning);
        if (warning == null) {
            LOGGER.debug("Account state warning not defined");
            return;
        }
        if (warning.getExpiration() != null) {
            ZonedDateTime expDate = DateTimeUtils.zonedDateTimeOf((TemporalAccessor)warning.getExpiration());
            long ttl = ZonedDateTime.now(ZoneOffset.UTC).until(expDate, ChronoUnit.DAYS);
            LOGGER.debug("Password expires in [{}] days. Expiration warning threshold is [{}] days.", (Object)ttl, (Object)configuration.getPasswordWarningNumberOfDays());
            if (configuration.isAlwaysDisplayPasswordExpirationWarning() || ttl < (long)configuration.getPasswordWarningNumberOfDays()) {
                messages.add((MessageDescriptor)new PasswordExpiringWarningMessageDescriptor("Password expires in {0} days.", ttl));
            }
        } else {
            LOGGER.debug("No account expiration warning was provided as part of the account state");
        }
        if (warning.getLoginsRemaining() > 0) {
            messages.add((MessageDescriptor)new DefaultMessageDescriptor("password.expiration.loginsRemaining", "You have {0} logins remaining before you MUST change your password.", new Serializable[]{Integer.valueOf(warning.getLoginsRemaining())}));
        }
    }

    protected void handlePolicyAttributes(AuthenticationResponse response) {
        Collection attributes = response.getLdapEntry().getAttributes();
        for (LdapAttribute attr : attributes) {
            if (!this.attributesToErrorMap.containsKey(attr.getName()) || !Boolean.parseBoolean(attr.getStringValue())) continue;
            Class<? extends LoginException> clazz = this.attributesToErrorMap.get(attr.getName());
            throw clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
    }

    @Generated
    public void setAttributesToErrorMap(Map<String, Class<? extends LoginException>> attributesToErrorMap) {
        this.attributesToErrorMap = attributesToErrorMap;
    }
}

