/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.security;

import com.nimbusds.jose.JWSAlgorithm;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="security")
public class SecurityProperties {
    private String adminUser;
    private String adminPassword;
    private CipherAlgorithm adminPasswordAlgorithm;
    private String anonymousUser;
    private String anonymousKey;
    private String jwtIssuer = "ApacheSyncope";
    private String jwsKey;
    private String jwsAlgorithm = JWSAlgorithm.HS512.getName();
    private String secretKey;
    private String groovyBlacklist = "classpath:META-INF/groovy.blacklist";
    private final DigesterProperties digester = new DigesterProperties();

    public String getAdminUser() {
        return this.adminUser;
    }

    public void setAdminUser(String adminUser) {
        this.adminUser = adminUser;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }

    public CipherAlgorithm getAdminPasswordAlgorithm() {
        return this.adminPasswordAlgorithm;
    }

    public void setAdminPasswordAlgorithm(CipherAlgorithm adminPasswordAlgorithm) {
        this.adminPasswordAlgorithm = adminPasswordAlgorithm;
    }

    public String getAnonymousUser() {
        return this.anonymousUser;
    }

    public void setAnonymousUser(String anonymousUser) {
        this.anonymousUser = anonymousUser;
    }

    public String getAnonymousKey() {
        return this.anonymousKey;
    }

    public void setAnonymousKey(String anonymousKey) {
        this.anonymousKey = anonymousKey;
    }

    public String getJwtIssuer() {
        return this.jwtIssuer;
    }

    public void setJwtIssuer(String jwtIssuer) {
        this.jwtIssuer = jwtIssuer;
    }

    public String getJwsKey() {
        return this.jwsKey;
    }

    public void setJwsKey(String jwsKey) {
        this.jwsKey = jwsKey;
    }

    public String getJwsAlgorithm() {
        return this.jwsAlgorithm;
    }

    public void setJwsAlgorithm(String jwsAlgorithm) {
        this.jwsAlgorithm = jwsAlgorithm;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getGroovyBlacklist() {
        return this.groovyBlacklist;
    }

    public void setGroovyBlacklist(String groovyBlacklist) {
        this.groovyBlacklist = groovyBlacklist;
    }

    public DigesterProperties getDigester() {
        return this.digester;
    }

    public static class DigesterProperties {
        private int saltIterations = 1;
        private int saltSizeBytes = 8;
        private boolean invertPositionOfPlainSaltInEncryptionResults = true;
        private boolean invertPositionOfSaltInMessageBeforeDigesting = true;
        private boolean useLenientSaltSizeCheck = true;

        public int getSaltIterations() {
            return this.saltIterations;
        }

        public void setSaltIterations(int saltIterations) {
            this.saltIterations = saltIterations;
        }

        public int getSaltSizeBytes() {
            return this.saltSizeBytes;
        }

        public void setSaltSizeBytes(int saltSizeBytes) {
            this.saltSizeBytes = saltSizeBytes;
        }

        public boolean isInvertPositionOfPlainSaltInEncryptionResults() {
            return this.invertPositionOfPlainSaltInEncryptionResults;
        }

        public void setInvertPositionOfPlainSaltInEncryptionResults(boolean invertPositionOfPlainSaltInEncryptionResults) {
            this.invertPositionOfPlainSaltInEncryptionResults = invertPositionOfPlainSaltInEncryptionResults;
        }

        public boolean isInvertPositionOfSaltInMessageBeforeDigesting() {
            return this.invertPositionOfSaltInMessageBeforeDigesting;
        }

        public void setInvertPositionOfSaltInMessageBeforeDigesting(boolean invertPositionOfSaltInMessageBeforeDigesting) {
            this.invertPositionOfSaltInMessageBeforeDigesting = invertPositionOfSaltInMessageBeforeDigesting;
        }

        public boolean isUseLenientSaltSizeCheck() {
            return this.useLenientSaltSizeCheck;
        }

        public void setUseLenientSaltSizeCheck(boolean useLenientSaltSizeCheck) {
            this.useLenientSaltSizeCheck = useLenientSaltSizeCheck;
        }
    }
}

