/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.security;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.syncope.common.keymaster.client.api.DomainOps;
import org.apache.syncope.common.keymaster.client.api.KeymasterException;
import org.apache.syncope.common.keymaster.client.api.model.Domain;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.UserProvisioningManager;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.AuthDataAccessor;
import org.apache.syncope.core.spring.security.DefaultCredentialChecker;
import org.apache.syncope.core.spring.security.Encryptor;
import org.apache.syncope.core.spring.security.SecurityProperties;
import org.apache.syncope.core.spring.security.SyncopeAuthenticationDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;

@Configurable
public class UsernamePasswordAuthenticationProvider
implements AuthenticationProvider {
    protected static final Logger LOG = LoggerFactory.getLogger(UsernamePasswordAuthenticationProvider.class);
    protected static final Encryptor ENCRYPTOR = Encryptor.getInstance();
    protected final DomainOps domainOps;
    protected final AuthDataAccessor dataAccessor;
    protected final UserProvisioningManager provisioningManager;
    protected final DefaultCredentialChecker credentialChecker;
    protected final SecurityProperties securityProperties;

    public UsernamePasswordAuthenticationProvider(DomainOps domainOps, AuthDataAccessor dataAccessor, UserProvisioningManager provisioningManager, DefaultCredentialChecker credentialChecker, SecurityProperties securityProperties) {
        this.domainOps = domainOps;
        this.dataAccessor = dataAccessor;
        this.provisioningManager = provisioningManager;
        this.credentialChecker = credentialChecker;
        this.securityProperties = securityProperties;
    }

    public Authentication authenticate(Authentication authentication) {
        Boolean authenticated;
        Domain domain;
        if ("Master".equals(((SyncopeAuthenticationDetails)SyncopeAuthenticationDetails.class.cast(authentication.getDetails())).getDomain())) {
            domain = new Domain.Builder("Master").build();
        } else {
            try {
                domain = this.domainOps.read(((SyncopeAuthenticationDetails)SyncopeAuthenticationDetails.class.cast(authentication.getDetails())).getDomain());
            }
            catch (KeymasterException | NotFoundException e) {
                throw new BadCredentialsException("Could not find domain " + ((SyncopeAuthenticationDetails)SyncopeAuthenticationDetails.class.cast(authentication.getDetails())).getDomain(), e);
            }
        }
        AtomicReference<String> username = new AtomicReference<String>();
        AtomicReference<String> delegationKey = new AtomicReference<String>();
        if (this.securityProperties.getAnonymousUser().equals(authentication.getName())) {
            username.set(this.securityProperties.getAnonymousUser());
            this.credentialChecker.checkIsDefaultAnonymousKeyInUse();
            authenticated = authentication.getCredentials().toString().equals(this.securityProperties.getAnonymousKey());
        } else if (this.securityProperties.getAdminUser().equals(authentication.getName())) {
            username.set(this.securityProperties.getAdminUser());
            if ("Master".equals(domain.getKey())) {
                this.credentialChecker.checkIsDefaultAdminPasswordInUse();
                authenticated = ENCRYPTOR.verify(authentication.getCredentials().toString(), this.securityProperties.getAdminPasswordAlgorithm(), this.securityProperties.getAdminPassword());
            } else {
                authenticated = ENCRYPTOR.verify(authentication.getCredentials().toString(), domain.getAdminCipherAlgorithm(), domain.getAdminPassword());
            }
        } else {
            Triple authResult = AuthContextUtils.callAsAdmin(domain.getKey(), () -> this.dataAccessor.authenticate(domain.getKey(), authentication));
            authenticated = (Boolean)authResult.getMiddle();
            if (authResult.getLeft() != null && authResult.getMiddle() != null) {
                username.set(((User)authResult.getLeft()).getUsername());
                if (!authenticated.booleanValue()) {
                    AuthContextUtils.callAsAdmin(domain.getKey(), () -> {
                        this.provisioningManager.internalSuspend(((User)authResult.getLeft()).getKey(), this.securityProperties.getAdminUser(), "Failed authentication");
                        return null;
                    });
                }
            }
            delegationKey.set((String)authResult.getRight());
        }
        if (username.get() == null) {
            username.set(authentication.getPrincipal().toString());
        }
        return this.finalizeAuthentication(authenticated, domain.getKey(), (String)username.get(), (String)delegationKey.get(), authentication);
    }

    protected Authentication finalizeAuthentication(Boolean authenticated, String domain, String username, String delegationKey, Authentication authentication) {
        if (!BooleanUtils.isTrue((Boolean)authenticated)) {
            AuthContextUtils.callAsAdmin(domain, () -> {
                this.dataAccessor.audit(username, delegationKey, AuditElements.Result.FAILURE, false, authentication, "Not authenticated");
                return null;
            });
            LOG.debug("User {} not authenticated", (Object)username);
            throw new BadCredentialsException("User " + username + " not authenticated");
        }
        UsernamePasswordAuthenticationToken token = AuthContextUtils.callAsAdmin(domain, () -> {
            UsernamePasswordAuthenticationToken upat = new UsernamePasswordAuthenticationToken((Object)username, null, this.dataAccessor.getAuthorities(username, delegationKey));
            upat.setDetails(authentication.getDetails());
            this.dataAccessor.audit(username, delegationKey, AuditElements.Result.SUCCESS, true, authentication, "Successfully authenticated, with entitlements: " + String.valueOf(upat.getAuthorities()));
            return upat;
        });
        LOG.debug("User {} successfully authenticated, with entitlements {}", (Object)username, (Object)token.getAuthorities());
        return token;
    }

    public boolean supports(Class<?> authentication) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

