/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels.search;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.panels.search.AbstractSearchPanel;
import org.apache.syncope.client.console.panels.search.SearchClause;
import org.apache.syncope.client.console.rest.AnyTypeRestClient;
import org.apache.syncope.client.console.rest.SchemaRestClient;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.common.lib.search.AbstractFiqlSearchConditionBuilder;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.syncope.common.lib.to.SchemaTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.wicket.PageReference;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class AnyObjectSearchPanel
extends AbstractSearchPanel {
    private static final long serialVersionUID = -1769527800450203738L;
    @SpringBean
    protected SchemaRestClient schemaRestClient;
    @SpringBean
    protected AnyTypeRestClient anyTypeRestClient;

    protected AnyObjectSearchPanel(String id, AnyTypeKind kind, Builder builder) {
        super(id, kind, builder);
    }

    protected AnyObjectSearchPanel(String id, AnyTypeKind kind, String type, Builder builder) {
        super(id, kind, type, builder);
    }

    @Override
    protected AbstractFiqlSearchConditionBuilder<?, ?, ?> getSearchConditionBuilder() {
        return SyncopeClient.getAnyObjectSearchConditionBuilder((String)this.anyType);
    }

    @Override
    protected String getFIQLQueryTarget() {
        return this.anyType;
    }

    @Override
    protected void populate() {
        super.populate();
        this.types = new LoadableDetachableModel<List<SearchClause.Type>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<SearchClause.Type> load() {
                return AnyObjectSearchPanel.this.getAvailableTypes();
            }
        };
        this.groupNames = new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<String> load() {
                return AnyObjectSearchPanel.this.groupRestClient.search("/", null, 1, 30, (SortParam<String>)new SortParam((Object)"name", true), null).stream().map(GroupTO::getName).collect(Collectors.toList());
            }
        };
        this.anames = new LoadableDetachableModel<Map<String, PlainSchemaTO>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected Map<String, PlainSchemaTO> load() {
                return AnyObjectSearchPanel.this.schemaRestClient.getSchemas(SchemaType.PLAIN, null, (String[])AnyObjectSearchPanel.this.anyTypeRestClient.read(AnyObjectSearchPanel.this.anyType).getClasses().toArray(String[]::new)).stream().collect(Collectors.toMap(SchemaTO::getKey, Function.identity()));
            }
        };
    }

    protected List<SearchClause.Type> getAvailableTypes() {
        ArrayList<SearchClause.Type> result = new ArrayList<SearchClause.Type>();
        result.add(SearchClause.Type.ATTRIBUTE);
        result.add(SearchClause.Type.GROUP_MEMBERSHIP);
        result.add(SearchClause.Type.AUX_CLASS);
        result.add(SearchClause.Type.RESOURCE);
        result.add(SearchClause.Type.RELATIONSHIP);
        return result;
    }

    public static class Builder
    extends AbstractSearchPanel.Builder<AnyObjectSearchPanel> {
        private static final long serialVersionUID = 6308997285778809578L;
        private final String type;

        public Builder(String type, IModel<List<SearchClause>> model, PageReference pageRef) {
            super(model, pageRef);
            this.type = type;
        }

        @Override
        public AnyObjectSearchPanel build(String id) {
            return new AnyObjectSearchPanel(id, AnyTypeKind.ANY_OBJECT, this.type, this);
        }
    }
}

