/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.EventSubscriptionUtil;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.engine.runtime.Execution;
import org.flowable.eventsubscription.service.EventSubscriptionService;
import org.flowable.eventsubscription.service.impl.persistence.entity.EventSubscriptionEntity;
import org.flowable.eventsubscription.service.impl.persistence.entity.SignalEventSubscriptionEntity;

public class SignalEventReceivedCmd
implements Command<Void> {
    protected final String eventName;
    protected final String executionId;
    protected final Map<String, Object> payload;
    protected final boolean async;
    protected String tenantId;

    public SignalEventReceivedCmd(String eventName, String executionId, Map<String, Object> processVariables, String tenantId) {
        this.eventName = eventName;
        this.executionId = executionId;
        this.payload = processVariables != null ? new HashMap<String, Object>(processVariables) : null;
        this.async = false;
        this.tenantId = tenantId;
    }

    public SignalEventReceivedCmd(String eventName, String executionId, boolean async, String tenantId) {
        this.eventName = eventName;
        this.executionId = executionId;
        this.async = async;
        this.payload = null;
        this.tenantId = tenantId;
    }

    public Void execute(CommandContext commandContext) {
        List signalEvents = null;
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        EventSubscriptionService eventSubscriptionService = processEngineConfiguration.getEventSubscriptionServiceConfiguration().getEventSubscriptionService();
        if (this.executionId == null) {
            signalEvents = eventSubscriptionService.findSignalEventSubscriptionsByEventName(this.eventName, this.tenantId);
        } else {
            ExecutionEntity execution = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager(commandContext).findById(this.executionId);
            if (execution == null) {
                throw new FlowableObjectNotFoundException("Cannot find execution with id '" + this.executionId + "'", Execution.class);
            }
            if (execution.isSuspended()) {
                throw new FlowableException("Cannot throw signal event '" + this.eventName + "' because execution '" + this.executionId + "' is suspended");
            }
            if (Flowable5Util.isFlowable5ProcessDefinitionId(commandContext, execution.getProcessDefinitionId())) {
                Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
                compatibilityHandler.signalEventReceived(this.eventName, this.executionId, this.payload, this.async, this.tenantId);
                return null;
            }
            signalEvents = eventSubscriptionService.findSignalEventSubscriptionsByNameAndExecution(this.eventName, this.executionId);
            if (signalEvents.isEmpty()) {
                throw new FlowableException("Execution '" + this.executionId + "' has not subscribed to a signal event with name '" + this.eventName + "'.");
            }
        }
        for (SignalEventSubscriptionEntity signalEventSubscriptionEntity : signalEvents) {
            if (!signalEventSubscriptionEntity.isGlobalScoped()) continue;
            if (this.executionId == null && Flowable5Util.isFlowable5ProcessDefinitionId(commandContext, signalEventSubscriptionEntity.getProcessDefinitionId())) {
                Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
                compatibilityHandler.signalEventReceived(signalEventSubscriptionEntity, this.payload, this.async);
                continue;
            }
            processEngineConfiguration.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createSignalEvent(FlowableEngineEventType.ACTIVITY_SIGNALED, signalEventSubscriptionEntity.getActivityId(), this.eventName, this.payload, signalEventSubscriptionEntity.getExecutionId(), signalEventSubscriptionEntity.getProcessInstanceId(), signalEventSubscriptionEntity.getProcessDefinitionId()), processEngineConfiguration.getEngineCfgKey());
            EventSubscriptionUtil.eventReceived((EventSubscriptionEntity)signalEventSubscriptionEntity, this.payload, this.async);
        }
        return null;
    }
}

