/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.common.validation;

import jakarta.validation.ConstraintValidatorContext;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.core.persistence.api.entity.Relationship;
import org.apache.syncope.core.persistence.api.entity.RelationshipType;
import org.apache.syncope.core.persistence.common.validation.AbstractValidator;
import org.apache.syncope.core.persistence.common.validation.RelationshipCheck;

public class RelationshipValidator
extends AbstractValidator<RelationshipCheck, Relationship<?, ?>> {
    public boolean isValid(Relationship<?, ?> relationship, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        boolean isValid = true;
        RelationshipType relationshipType = relationship.getType();
        if (relationship.getLeftEnd() != null && !relationshipType.getLeftEndAnyType().equals((Object)relationship.getLeftEnd().getType())) {
            context.buildConstraintViolationWithTemplate(RelationshipValidator.getTemplate(EntityViolationType.InvalidAnyType, relationship.getLeftEnd().getType().getKey())).addPropertyNode("leftEnd").addConstraintViolation();
            isValid = false;
        }
        if (relationship.getRightEnd() != null && !relationshipType.getRightEndAnyType().equals((Object)relationship.getRightEnd().getType())) {
            context.buildConstraintViolationWithTemplate(RelationshipValidator.getTemplate(EntityViolationType.InvalidAnyType, relationship.getRightEnd().getType().getKey())).addPropertyNode("rightEnd").addConstraintViolation();
            isValid = false;
        }
        return isValid;
    }
}

