/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.security;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.syncope.core.persistence.api.ApplicationContextProvider;
import org.apache.syncope.core.persistence.api.Encryptor;
import org.apache.syncope.core.spring.security.SecureRandomUtils;
import org.apache.syncope.core.spring.security.SecurityProperties;
import org.jasypt.digest.StandardStringDigester;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.crypto.bcrypt.BCrypt;

public class DefaultEncryptor
implements Encryptor {
    protected static final Logger LOG = LoggerFactory.getLogger(DefaultEncryptor.class);
    protected static final String DEFAULT_SECRET_KEY = "1abcdefghilmnopqrstuvz2!";
    protected final Map<CipherAlgorithm, StandardStringDigester> digesters = new ConcurrentHashMap<CipherAlgorithm, StandardStringDigester>();
    protected SecretKeySpec keySpec;

    protected DefaultEncryptor(String secretKey) {
        String actualKey = secretKey;
        if (actualKey.length() < 16) {
            StringBuilder actualKeyPadding = new StringBuilder(actualKey);
            int length = 16 - actualKey.length();
            String randomChars = SecureRandomUtils.generateRandomPassword(length);
            actualKeyPadding.append(randomChars);
            actualKey = actualKeyPadding.toString();
            LOG.warn("The secret key is too short (< 16), adding some random characters. Passwords encrypted with AES and this key will not be recoverable as a result if the container is restarted.");
        }
        try {
            this.keySpec = new SecretKeySpec(ArrayUtils.subarray((byte[])actualKey.getBytes(StandardCharsets.UTF_8), (int)0, (int)16), CipherAlgorithm.AES.getAlgorithm());
        }
        catch (Exception e) {
            LOG.error("Error during key specification", (Throwable)e);
        }
    }

    public String encode(String value, CipherAlgorithm cipherAlgorithm) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        String encoded = null;
        if (value != null) {
            if (cipherAlgorithm == null || cipherAlgorithm == CipherAlgorithm.AES) {
                Cipher cipher = Cipher.getInstance(CipherAlgorithm.AES.getAlgorithm());
                cipher.init(1, this.keySpec);
                encoded = Base64.getEncoder().encodeToString(cipher.doFinal(value.getBytes(StandardCharsets.UTF_8)));
            } else {
                encoded = cipherAlgorithm == CipherAlgorithm.BCRYPT ? BCrypt.hashpw((String)value, (String)BCrypt.gensalt()) : this.getDigester(cipherAlgorithm).digest(value);
            }
        }
        return encoded;
    }

    public boolean verify(String value, CipherAlgorithm cipherAlgorithm, String encoded) {
        boolean verified = false;
        try {
            if (value != null) {
                verified = cipherAlgorithm == null || cipherAlgorithm == CipherAlgorithm.AES ? this.encode(value, cipherAlgorithm).equals(encoded) : (cipherAlgorithm == CipherAlgorithm.BCRYPT ? BCrypt.checkpw((String)value, (String)encoded) : this.getDigester(cipherAlgorithm).matches(value, encoded));
            }
        }
        catch (Exception e) {
            LOG.error("Could not verify encoded value", (Throwable)e);
        }
        return verified;
    }

    public String decode(String encoded, CipherAlgorithm cipherAlgorithm) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        String decoded = null;
        if (encoded != null && cipherAlgorithm == CipherAlgorithm.AES) {
            Cipher cipher = Cipher.getInstance(CipherAlgorithm.AES.getAlgorithm());
            cipher.init(2, this.keySpec);
            decoded = new String(cipher.doFinal(Base64.getDecoder().decode(encoded)), StandardCharsets.UTF_8);
        }
        return decoded;
    }

    private StandardStringDigester getDigester(CipherAlgorithm cipherAlgorithm) {
        StandardStringDigester digester = this.digesters.get(cipherAlgorithm);
        if (digester == null) {
            digester = new StandardStringDigester();
            if (cipherAlgorithm.getAlgorithm().startsWith("S-")) {
                SecurityProperties securityProperties = (SecurityProperties)ApplicationContextProvider.getApplicationContext().getBean(SecurityProperties.class);
                digester.setAlgorithm(cipherAlgorithm.getAlgorithm().replaceFirst("S\\-", ""));
                digester.setIterations(securityProperties.getDigester().getSaltIterations());
                digester.setSaltSizeBytes(securityProperties.getDigester().getSaltSizeBytes());
                digester.setInvertPositionOfPlainSaltInEncryptionResults(securityProperties.getDigester().isInvertPositionOfPlainSaltInEncryptionResults());
                digester.setInvertPositionOfSaltInMessageBeforeDigesting(securityProperties.getDigester().isInvertPositionOfSaltInMessageBeforeDigesting());
                digester.setUseLenientSaltSizeCheck(securityProperties.getDigester().isUseLenientSaltSizeCheck());
            } else {
                digester.setAlgorithm(cipherAlgorithm.getAlgorithm());
                digester.setIterations(1);
                digester.setSaltSizeBytes(0);
            }
            digester.setStringOutputType("hexadecimal");
            this.digesters.put(cipherAlgorithm, digester);
        }
        return digester;
    }
}

