/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.persistence.support.sqlite;

import com.googlecode.cqengine.attribute.SimpleAttribute;
import com.googlecode.cqengine.index.sqlite.SQLiteIdentityIndex;
import com.googlecode.cqengine.index.sqlite.SQLitePersistence;
import com.googlecode.cqengine.index.support.CloseableIterator;
import com.googlecode.cqengine.persistence.support.ObjectSet;
import com.googlecode.cqengine.persistence.support.ObjectStore;
import com.googlecode.cqengine.query.QueryFactory;
import com.googlecode.cqengine.query.option.QueryOptions;
import com.googlecode.cqengine.resultset.ResultSet;
import com.googlecode.cqengine.resultset.iterator.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class SQLiteObjectStore<O, A extends Comparable<A>>
implements ObjectStore<O> {
    final SQLitePersistence<O, A> persistence;
    final SQLiteIdentityIndex<A, O> backingIndex;
    final SimpleAttribute<O, A> primaryKeyAttribute;
    final Class<O> objectType;

    public SQLiteObjectStore(SQLitePersistence<O, A> persistence) {
        this.persistence = persistence;
        this.objectType = persistence.getPrimaryKeyAttribute().getObjectType();
        this.primaryKeyAttribute = persistence.getPrimaryKeyAttribute();
        this.backingIndex = persistence.createIdentityIndex();
    }

    public void init(QueryOptions queryOptions) {
        this.backingIndex.init(this, queryOptions);
    }

    public SQLitePersistence<O, A> getPersistence() {
        return this.persistence;
    }

    public SQLiteIdentityIndex<A, O> getBackingIndex() {
        return this.backingIndex;
    }

    @Override
    public int size(QueryOptions queryOptions) {
        return this.backingIndex.retrieve(QueryFactory.has(this.primaryKeyAttribute), queryOptions).size();
    }

    @Override
    public boolean contains(Object o, QueryOptions queryOptions) {
        Object object = o;
        Comparable objectId = (Comparable)this.primaryKeyAttribute.getValue(object, queryOptions);
        return this.backingIndex.retrieve(QueryFactory.equal(this.primaryKeyAttribute, objectId), queryOptions).size() > 0;
    }

    @Override
    public CloseableIterator<O> iterator(QueryOptions queryOptions) {
        final ResultSet<O> rs = this.backingIndex.retrieve(QueryFactory.has(this.primaryKeyAttribute), queryOptions);
        final Iterator<O> i = rs.iterator();
        class CloseableIteratorImpl
        extends UnmodifiableIterator<O>
        implements CloseableIterator<O> {
            CloseableIteratorImpl() {
            }

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public O next() {
                return i.next();
            }

            @Override
            public void close() {
                rs.close();
            }
        }
        return new CloseableIteratorImpl();
    }

    @Override
    public boolean isEmpty(QueryOptions queryOptions) {
        return this.size(queryOptions) == 0;
    }

    @Override
    public boolean add(O object, QueryOptions queryOptions) {
        return this.backingIndex.addAll(ObjectSet.fromCollection(Collections.singleton(object)), queryOptions);
    }

    @Override
    public boolean remove(Object o, QueryOptions queryOptions) {
        Object object = o;
        return this.backingIndex.removeAll(ObjectSet.fromCollection(Collections.singleton(object)), queryOptions);
    }

    @Override
    public boolean containsAll(Collection<?> c, QueryOptions queryOptions) {
        for (Object o : c) {
            if (this.contains(o, queryOptions)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends O> c, QueryOptions queryOptions) {
        Collection<? extends O> objects = c;
        return this.backingIndex.addAll(ObjectSet.fromCollection(objects), queryOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> c, QueryOptions queryOptions) {
        ArrayList<O> objectsToRemove = new ArrayList<O>();
        try (ResultSet<O> allObjects = this.backingIndex.retrieve(QueryFactory.has(this.primaryKeyAttribute), queryOptions);){
            for (O object : allObjects) {
                if (c.contains(object)) continue;
                objectsToRemove.add(object);
            }
        }
        return this.backingIndex.removeAll(ObjectSet.fromCollection(objectsToRemove), queryOptions);
    }

    @Override
    public boolean removeAll(Collection<?> c, QueryOptions queryOptions) {
        Collection<?> objects = c;
        return this.backingIndex.removeAll(ObjectSet.fromCollection(objects), queryOptions);
    }

    @Override
    public void clear(QueryOptions queryOptions) {
        this.backingIndex.clear(queryOptions);
    }
}

