/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.ArrayList;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.springframework.data.jpa.repository.query.JpqlBaseVisitor;
import org.springframework.data.jpa.repository.query.JpqlParser;
import org.springframework.data.jpa.repository.query.QueryRenderer;
import org.springframework.data.jpa.repository.query.QueryTokenStream;
import org.springframework.data.jpa.repository.query.QueryTokens;
import org.springframework.util.CollectionUtils;

class JpqlQueryRenderer
extends JpqlBaseVisitor<QueryTokenStream> {
    JpqlQueryRenderer() {
    }

    @Override
    public QueryTokenStream visitStart(JpqlParser.StartContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.ql_statement());
    }

    @Override
    public QueryTokenStream visitQl_statement(JpqlParser.Ql_statementContext ctx) {
        if (ctx.select_statement() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.select_statement());
        }
        if (ctx.update_statement() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.update_statement());
        }
        if (ctx.delete_statement() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.delete_statement());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitSelect_statement(JpqlParser.Select_statementContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.select_clause()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.from_clause()));
        if (ctx.where_clause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.where_clause()));
        }
        if (ctx.groupby_clause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.groupby_clause()));
        }
        if (ctx.having_clause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.having_clause()));
        }
        if (ctx.orderby_clause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.orderby_clause()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitUpdate_statement(JpqlParser.Update_statementContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.update_clause()));
        if (ctx.where_clause() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.where_clause()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitDelete_statement(JpqlParser.Delete_statementContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.delete_clause()));
        if (ctx.where_clause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.where_clause()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitFrom_clause(JpqlParser.From_clauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.FROM()));
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.identification_variable_declaration()));
        if (!ctx.identificationVariableDeclarationOrCollectionMemberDeclaration().isEmpty()) {
            builder.append(QueryTokens.TOKEN_COMMA);
            builder.appendExpression(QueryTokenStream.concat(ctx.identificationVariableDeclarationOrCollectionMemberDeclaration(), arg_0 -> ((JpqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitIdentificationVariableDeclarationOrCollectionMemberDeclaration(JpqlParser.IdentificationVariableDeclarationOrCollectionMemberDeclarationContext ctx) {
        if (ctx.identification_variable_declaration() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.identification_variable_declaration());
        }
        if (ctx.collection_member_declaration() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.collection_member_declaration());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitIdentification_variable_declaration(JpqlParser.Identification_variable_declarationContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.range_variable_declaration()));
        ctx.join().forEach(joinContext -> builder.append((QueryTokenStream)this.visit((ParseTree)joinContext)));
        ctx.fetch_join().forEach(fetchJoinContext -> builder.append((QueryTokenStream)this.visit((ParseTree)fetchJoinContext)));
        return builder;
    }

    @Override
    public QueryTokenStream visitRange_variable_declaration(JpqlParser.Range_variable_declarationContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.entity_name()));
        if (ctx.AS() != null) {
            builder.append(QueryTokens.expression(ctx.AS()));
        }
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.identification_variable()));
        return builder;
    }

    @Override
    public QueryTokenStream visitJoin(JpqlParser.JoinContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.join_spec()));
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.join_association_path_expression()));
        if (ctx.AS() != null) {
            builder.append(QueryTokens.expression(ctx.AS()));
        }
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.identification_variable()));
        if (ctx.join_condition() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.join_condition()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitFetch_join(JpqlParser.Fetch_joinContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.join_spec()));
        builder.append(QueryTokens.expression(ctx.FETCH()));
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.join_association_path_expression()));
        return builder;
    }

    @Override
    public QueryTokenStream visitJoin_spec(JpqlParser.Join_specContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.LEFT() != null) {
            builder.append(QueryTokens.expression(ctx.LEFT()));
        }
        if (ctx.OUTER() != null) {
            builder.append(QueryTokens.expression(ctx.OUTER()));
        }
        if (ctx.INNER() != null) {
            builder.append(QueryTokens.expression(ctx.INNER()));
        }
        if (ctx.JOIN() != null) {
            builder.append(QueryTokens.expression(ctx.JOIN()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitJoin_condition(JpqlParser.Join_conditionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.ON()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.conditional_expression()));
        return builder;
    }

    @Override
    public QueryTokenStream visitJoin_association_path_expression(JpqlParser.Join_association_path_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.TREAT() == null) {
            if (ctx.join_collection_valued_path_expression() != null) {
                builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.join_collection_valued_path_expression()));
            } else if (ctx.join_single_valued_path_expression() != null) {
                builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.join_single_valued_path_expression()));
            }
        } else if (ctx.join_collection_valued_path_expression() != null) {
            builder.append(QueryTokens.token(ctx.TREAT()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.join_collection_valued_path_expression()));
            builder.append(QueryTokens.expression(ctx.AS()));
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.subtype()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.join_single_valued_path_expression() != null) {
            builder.append(QueryTokens.token(ctx.TREAT()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.join_single_valued_path_expression()));
            builder.append(QueryTokens.expression(ctx.AS()));
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.subtype()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitJoin_collection_valued_path_expression(JpqlParser.Join_collection_valued_path_expressionContext ctx) {
        ArrayList<ParserRuleContext> items = new ArrayList<ParserRuleContext>(3 + ctx.single_valued_embeddable_object_field().size());
        items.add(ctx.identification_variable());
        items.addAll(ctx.single_valued_embeddable_object_field());
        items.add(ctx.collection_valued_field());
        return QueryTokenStream.concat(items, arg_0 -> ((JpqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_DOT);
    }

    @Override
    public QueryTokenStream visitJoin_single_valued_path_expression(JpqlParser.Join_single_valued_path_expressionContext ctx) {
        ArrayList<ParserRuleContext> items = new ArrayList<ParserRuleContext>(3 + ctx.single_valued_embeddable_object_field().size());
        items.add(ctx.identification_variable());
        items.addAll(ctx.single_valued_embeddable_object_field());
        items.add(ctx.single_valued_object_field());
        return QueryTokenStream.concat(items, arg_0 -> ((JpqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_DOT);
    }

    @Override
    public QueryTokenStream visitCollection_member_declaration(JpqlParser.Collection_member_declarationContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.IN()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.collection_valued_path_expression()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        if (ctx.AS() != null) {
            builder.append(QueryTokens.expression(ctx.AS()));
        }
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.identification_variable()));
        return builder;
    }

    @Override
    public QueryTokenStream visitQualified_identification_variable(JpqlParser.Qualified_identification_variableContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.map_field_identification_variable() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.map_field_identification_variable()));
        } else if (ctx.identification_variable() != null) {
            builder.append(QueryTokens.expression(ctx.ENTRY()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.identification_variable()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitMap_field_identification_variable(JpqlParser.Map_field_identification_variableContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.KEY() != null) {
            builder.append(QueryTokens.token(ctx.KEY()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.identification_variable()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.VALUE() != null) {
            builder.append(QueryTokens.token(ctx.VALUE()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.identification_variable()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitSingle_valued_path_expression(JpqlParser.Single_valued_path_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.qualified_identification_variable() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.qualified_identification_variable()));
        } else if (ctx.qualified_identification_variable() != null) {
            builder.append(QueryTokens.token(ctx.TREAT()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.qualified_identification_variable()));
            builder.append(QueryTokens.expression(ctx.AS()));
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.subtype()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.state_field_path_expression() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.state_field_path_expression()));
        } else if (ctx.single_valued_object_path_expression() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.single_valued_object_path_expression()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitGeneral_identification_variable(JpqlParser.General_identification_variableContext ctx) {
        if (ctx.identification_variable() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.identification_variable());
        }
        if (ctx.map_field_identification_variable() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.map_field_identification_variable());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitGeneral_subpath(JpqlParser.General_subpathContext ctx) {
        if (ctx.simple_subpath() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.simple_subpath());
        }
        if (ctx.treated_subpath() != null) {
            ArrayList<ParserRuleContext> items = new ArrayList<ParserRuleContext>(1 + ctx.single_valued_object_field().size());
            items.add(ctx.treated_subpath());
            items.addAll(ctx.single_valued_object_field());
            return QueryTokenStream.concat(items, arg_0 -> ((JpqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_DOT);
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitSimple_subpath(JpqlParser.Simple_subpathContext ctx) {
        ArrayList<ParserRuleContext> items = new ArrayList<ParserRuleContext>(1 + ctx.single_valued_object_field().size());
        items.add(ctx.general_identification_variable());
        items.addAll(ctx.single_valued_object_field());
        return QueryTokenStream.concat(items, arg_0 -> ((JpqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_DOT);
    }

    @Override
    public QueryTokenStream visitTreated_subpath(JpqlParser.Treated_subpathContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.TREAT()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.general_subpath()));
        builder.append(QueryTokens.expression(ctx.AS()));
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.subtype()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitState_field_path_expression(JpqlParser.State_field_path_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.general_subpath()));
        builder.append(QueryTokens.TOKEN_DOT);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.state_field()));
        return builder;
    }

    @Override
    public QueryTokenStream visitState_valued_path_expression(JpqlParser.State_valued_path_expressionContext ctx) {
        if (ctx.state_field_path_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.state_field_path_expression());
        }
        if (ctx.general_identification_variable() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.general_identification_variable());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitSingle_valued_object_path_expression(JpqlParser.Single_valued_object_path_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.general_subpath()));
        builder.append(QueryTokens.TOKEN_DOT);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.single_valued_object_field()));
        return builder;
    }

    @Override
    public QueryTokenStream visitCollection_valued_path_expression(JpqlParser.Collection_valued_path_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.general_subpath()));
        builder.append(QueryTokens.TOKEN_DOT);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.collection_value_field()));
        return builder;
    }

    @Override
    public QueryTokenStream visitUpdate_clause(JpqlParser.Update_clauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.UPDATE()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.entity_name()));
        if (ctx.AS() != null) {
            builder.append(QueryTokens.expression(ctx.AS()));
        }
        if (ctx.identification_variable() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.identification_variable()));
        }
        builder.append(QueryTokens.expression(ctx.SET()));
        builder.append(QueryTokenStream.concat(ctx.update_item(), arg_0 -> ((JpqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        return builder;
    }

    @Override
    public QueryTokenStream visitUpdate_item(JpqlParser.Update_itemContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        ArrayList<ParserRuleContext> items = new ArrayList<ParserRuleContext>(2 + ctx.single_valued_embeddable_object_field().size());
        if (ctx.identification_variable() != null) {
            items.add(ctx.identification_variable());
        }
        items.addAll(ctx.single_valued_embeddable_object_field());
        if (ctx.state_field() != null) {
            items.add(ctx.state_field());
        } else if (ctx.single_valued_object_field() != null) {
            items.add(ctx.single_valued_object_field());
        }
        builder.appendInline(QueryTokenStream.concat(items, arg_0 -> ((JpqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_DOT));
        builder.append(QueryTokens.TOKEN_EQUALS);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.new_value()));
        return builder;
    }

    @Override
    public QueryTokenStream visitNew_value(JpqlParser.New_valueContext ctx) {
        if (ctx.scalar_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.scalar_expression());
        }
        if (ctx.simple_entity_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.simple_entity_expression());
        }
        if (ctx.NULL() != null) {
            return QueryRenderer.from(QueryTokens.expression(ctx.NULL()));
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitDelete_clause(JpqlParser.Delete_clauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.DELETE()));
        builder.append(QueryTokens.expression(ctx.FROM()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.entity_name()));
        if (ctx.AS() != null) {
            builder.append(QueryTokens.expression(ctx.AS()));
        }
        if (ctx.identification_variable() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.identification_variable()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitSelect_clause(JpqlParser.Select_clauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.SELECT()));
        if (ctx.DISTINCT() != null) {
            builder.append(QueryTokens.expression(ctx.DISTINCT()));
        }
        builder.append(QueryTokenStream.concat(ctx.select_item(), arg_0 -> ((JpqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        return builder;
    }

    @Override
    public QueryTokenStream visitSelect_item(JpqlParser.Select_itemContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.select_expression()));
        if (ctx.AS() != null || ctx.result_variable() != null) {
            if (ctx.AS() != null) {
                builder.append(QueryTokens.expression(ctx.AS()));
            }
            if (ctx.result_variable() != null) {
                builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.result_variable()));
            }
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitSelect_expression(JpqlParser.Select_expressionContext ctx) {
        if (ctx.single_valued_path_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.single_valued_path_expression());
        }
        if (ctx.scalar_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.scalar_expression());
        }
        if (ctx.aggregate_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.aggregate_expression());
        }
        if (ctx.identification_variable() != null) {
            if (ctx.OBJECT() == null) {
                return (QueryTokenStream)this.visit((ParseTree)ctx.identification_variable());
            }
            QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
            builder.append(QueryTokens.token(ctx.OBJECT()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.identification_variable()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
            return builder;
        }
        if (ctx.constructor_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.constructor_expression());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitConstructor_expression(JpqlParser.Constructor_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.NEW()));
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.constructor_name()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline(QueryTokenStream.concat(ctx.constructor_item(), arg_0 -> ((JpqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitConstructor_item(JpqlParser.Constructor_itemContext ctx) {
        if (ctx.single_valued_path_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.single_valued_path_expression());
        }
        if (ctx.scalar_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.scalar_expression());
        }
        if (ctx.aggregate_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.aggregate_expression());
        }
        if (ctx.identification_variable() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.identification_variable());
        }
        if (ctx.literal() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.literal());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitAggregate_expression(JpqlParser.Aggregate_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.AVG() != null || ctx.MAX() != null || ctx.MIN() != null || ctx.SUM() != null) {
            if (ctx.AVG() != null) {
                builder.append(QueryTokens.token(ctx.AVG()));
            }
            if (ctx.MAX() != null) {
                builder.append(QueryTokens.token(ctx.MAX()));
            }
            if (ctx.MIN() != null) {
                builder.append(QueryTokens.token(ctx.MIN()));
            }
            if (ctx.SUM() != null) {
                builder.append(QueryTokens.token(ctx.SUM()));
            }
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            if (ctx.DISTINCT() != null) {
                builder.append(QueryTokens.expression(ctx.DISTINCT()));
            }
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.state_valued_path_expression()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.COUNT() != null) {
            builder.append(QueryTokens.token(ctx.COUNT()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            if (ctx.DISTINCT() != null) {
                builder.append(QueryTokens.expression(ctx.DISTINCT()));
            }
            if (ctx.identification_variable() != null) {
                builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.identification_variable()));
            } else if (ctx.state_valued_path_expression() != null) {
                builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.state_valued_path_expression()));
            } else if (ctx.single_valued_object_path_expression() != null) {
                builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.single_valued_object_path_expression()));
            }
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.function_invocation() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.function_invocation()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitWhere_clause(JpqlParser.Where_clauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.WHERE()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.conditional_expression()));
        return builder;
    }

    @Override
    public QueryTokenStream visitGroupby_clause(JpqlParser.Groupby_clauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.GROUP()));
        builder.append(QueryTokens.expression(ctx.BY()));
        builder.appendExpression(QueryTokenStream.concat(ctx.groupby_item(), arg_0 -> ((JpqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        return builder;
    }

    @Override
    public QueryTokenStream visitGroupby_item(JpqlParser.Groupby_itemContext ctx) {
        if (ctx.single_valued_path_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.single_valued_path_expression());
        }
        if (ctx.identification_variable() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.identification_variable());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitHaving_clause(JpqlParser.Having_clauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.HAVING()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.conditional_expression()));
        return builder;
    }

    @Override
    public QueryTokenStream visitOrderby_clause(JpqlParser.Orderby_clauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.ORDER()));
        builder.append(QueryTokens.expression(ctx.BY()));
        builder.appendExpression(QueryTokenStream.concat(ctx.orderby_item(), arg_0 -> ((JpqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        return builder;
    }

    @Override
    public QueryTokenStream visitOrderby_item(JpqlParser.Orderby_itemContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.state_field_path_expression() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.state_field_path_expression()));
        } else if (ctx.general_identification_variable() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.general_identification_variable()));
        } else if (ctx.result_variable() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.result_variable()));
        }
        if (ctx.ASC() != null) {
            builder.append(QueryTokens.expression(ctx.ASC()));
        }
        if (ctx.DESC() != null) {
            builder.append(QueryTokens.expression(ctx.DESC()));
        }
        if (ctx.nullsPrecedence() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.nullsPrecedence()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitNullsPrecedence(JpqlParser.NullsPrecedenceContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.TOKEN_NULLS);
        if (ctx.FIRST() != null) {
            builder.append(QueryTokens.TOKEN_FIRST);
        } else if (ctx.LAST() != null) {
            builder.append(QueryTokens.TOKEN_LAST);
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitSubquery(JpqlParser.SubqueryContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.simple_select_clause()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.subquery_from_clause()));
        if (ctx.where_clause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.where_clause()));
        }
        if (ctx.groupby_clause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.groupby_clause()));
        }
        if (ctx.having_clause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.having_clause()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitSubquery_from_clause(JpqlParser.Subquery_from_clauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.FROM()));
        builder.appendExpression(QueryTokenStream.concat(ctx.subselect_identification_variable_declaration(), arg_0 -> ((JpqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        return builder;
    }

    @Override
    public QueryTokenStream visitSubselect_identification_variable_declaration(JpqlParser.Subselect_identification_variable_declarationContext ctx) {
        return (QueryTokenStream)super.visitSubselect_identification_variable_declaration(ctx);
    }

    @Override
    public QueryTokenStream visitDerived_path_expression(JpqlParser.Derived_path_expressionContext ctx) {
        return (QueryTokenStream)super.visitDerived_path_expression(ctx);
    }

    @Override
    public QueryTokenStream visitGeneral_derived_path(JpqlParser.General_derived_pathContext ctx) {
        return (QueryTokenStream)super.visitGeneral_derived_path(ctx);
    }

    @Override
    public QueryTokenStream visitSimple_derived_path(JpqlParser.Simple_derived_pathContext ctx) {
        return (QueryTokenStream)super.visitSimple_derived_path(ctx);
    }

    @Override
    public QueryTokenStream visitTreated_derived_path(JpqlParser.Treated_derived_pathContext ctx) {
        return (QueryTokenStream)super.visitTreated_derived_path(ctx);
    }

    @Override
    public QueryTokenStream visitDerived_collection_member_declaration(JpqlParser.Derived_collection_member_declarationContext ctx) {
        return (QueryTokenStream)super.visitDerived_collection_member_declaration(ctx);
    }

    @Override
    public QueryTokenStream visitSimple_select_clause(JpqlParser.Simple_select_clauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.SELECT()));
        if (ctx.DISTINCT() != null) {
            builder.append(QueryTokens.expression(ctx.DISTINCT()));
        }
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.simple_select_expression()));
        return builder;
    }

    @Override
    public QueryTokenStream visitSimple_select_expression(JpqlParser.Simple_select_expressionContext ctx) {
        if (ctx.single_valued_path_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.single_valued_path_expression());
        }
        if (ctx.scalar_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.scalar_expression());
        }
        if (ctx.aggregate_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.aggregate_expression());
        }
        if (ctx.identification_variable() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.identification_variable());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitScalar_expression(JpqlParser.Scalar_expressionContext ctx) {
        if (ctx.arithmetic_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression());
        }
        if (ctx.string_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.string_expression());
        }
        if (ctx.enum_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.enum_expression());
        }
        if (ctx.datetime_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.datetime_expression());
        }
        if (ctx.boolean_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.boolean_expression());
        }
        if (ctx.case_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.case_expression());
        }
        if (ctx.entity_type_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.entity_type_expression());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitConditional_expression(JpqlParser.Conditional_expressionContext ctx) {
        if (ctx.conditional_expression() != null) {
            QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.conditional_expression()));
            builder.append(QueryTokens.expression(ctx.OR()));
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.conditional_term()));
            return builder;
        }
        return (QueryTokenStream)this.visit((ParseTree)ctx.conditional_term());
    }

    @Override
    public QueryTokenStream visitConditional_term(JpqlParser.Conditional_termContext ctx) {
        if (ctx.conditional_term() != null) {
            QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.conditional_term()));
            builder.append(QueryTokens.expression(ctx.AND()));
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.conditional_factor()));
            return builder;
        }
        return (QueryTokenStream)this.visit((ParseTree)ctx.conditional_factor());
    }

    @Override
    public QueryTokenStream visitConditional_factor(JpqlParser.Conditional_factorContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.NOT() != null) {
            builder.append(QueryTokens.expression(ctx.NOT()));
        }
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.conditional_primary()));
        return builder;
    }

    @Override
    public QueryTokenStream visitConditional_primary(JpqlParser.Conditional_primaryContext ctx) {
        if (ctx.simple_cond_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.simple_cond_expression());
        }
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.conditional_expression() != null) {
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.conditional_expression()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitSimple_cond_expression(JpqlParser.Simple_cond_expressionContext ctx) {
        if (ctx.comparison_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.comparison_expression());
        }
        if (ctx.between_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.between_expression());
        }
        if (ctx.in_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.in_expression());
        }
        if (ctx.like_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.like_expression());
        }
        if (ctx.null_comparison_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.null_comparison_expression());
        }
        if (ctx.empty_collection_comparison_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.empty_collection_comparison_expression());
        }
        if (ctx.collection_member_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.collection_member_expression());
        }
        if (ctx.exists_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.exists_expression());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitBetween_expression(JpqlParser.Between_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.arithmetic_expression(0) != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(0)));
            if (ctx.NOT() != null) {
                builder.append(QueryTokens.expression(ctx.NOT()));
            }
            builder.append(QueryTokens.expression(ctx.BETWEEN()));
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(1)));
            builder.append(QueryTokens.expression(ctx.AND()));
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(2)));
        } else if (ctx.string_expression(0) != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.string_expression(0)));
            if (ctx.NOT() != null) {
                builder.append(QueryTokens.expression(ctx.NOT()));
            }
            builder.append(QueryTokens.expression(ctx.BETWEEN()));
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.string_expression(1)));
            builder.append(QueryTokens.expression(ctx.AND()));
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.string_expression(2)));
        } else if (ctx.datetime_expression(0) != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.datetime_expression(0)));
            if (ctx.NOT() != null) {
                builder.append(QueryTokens.expression(ctx.NOT()));
            }
            builder.append(QueryTokens.expression(ctx.BETWEEN()));
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.datetime_expression(1)));
            builder.append(QueryTokens.expression(ctx.AND()));
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.datetime_expression(2)));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitIn_expression(JpqlParser.In_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.string_expression() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.string_expression()));
        }
        if (ctx.type_discriminator() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.type_discriminator()));
        }
        if (ctx.NOT() != null) {
            builder.append(QueryTokens.expression(ctx.NOT()));
        }
        if (ctx.IN() != null) {
            builder.append(QueryTokens.expression(ctx.IN()));
        }
        if (ctx.in_item() != null && !ctx.in_item().isEmpty()) {
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline(QueryTokenStream.concat(ctx.in_item(), arg_0 -> ((JpqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.subquery() != null) {
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.subquery()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.collection_valued_input_parameter() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.collection_valued_input_parameter()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitIn_item(JpqlParser.In_itemContext ctx) {
        if (ctx.literal() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.literal());
        }
        if (ctx.string_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.string_expression());
        }
        if (ctx.boolean_literal() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.boolean_literal());
        }
        if (ctx.numeric_literal() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.numeric_literal());
        }
        if (ctx.date_time_timestamp_literal() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.date_time_timestamp_literal());
        }
        if (ctx.single_valued_input_parameter() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.single_valued_input_parameter());
        }
        if (ctx.conditional_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.conditional_expression());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitLike_expression(JpqlParser.Like_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.string_expression()));
        if (ctx.NOT() != null) {
            builder.append(QueryTokens.expression(ctx.NOT()));
        }
        builder.append(QueryTokens.expression(ctx.LIKE()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.pattern_value()));
        if (ctx.ESCAPE() != null) {
            builder.append(QueryTokens.expression(ctx.ESCAPE()));
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.escape_character()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitNull_comparison_expression(JpqlParser.Null_comparison_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.single_valued_path_expression() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.single_valued_path_expression()));
        } else if (ctx.input_parameter() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.input_parameter()));
        }
        builder.append(QueryTokens.expression(ctx.IS()));
        if (ctx.NOT() != null) {
            builder.append(QueryTokens.expression(ctx.NOT()));
        }
        builder.append(QueryTokens.expression(ctx.NULL()));
        return builder;
    }

    @Override
    public QueryTokenStream visitEmpty_collection_comparison_expression(JpqlParser.Empty_collection_comparison_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.collection_valued_path_expression()));
        builder.append(QueryTokens.expression(ctx.IS()));
        if (ctx.NOT() != null) {
            builder.append(QueryTokens.expression(ctx.NOT()));
        }
        builder.append(QueryTokens.expression(ctx.EMPTY()));
        return builder;
    }

    @Override
    public QueryTokenStream visitCollection_member_expression(JpqlParser.Collection_member_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.entity_or_value_expression()));
        if (ctx.NOT() != null) {
            builder.append(QueryTokens.expression(ctx.NOT()));
        }
        builder.append(QueryTokens.expression(ctx.MEMBER()));
        if (ctx.OF() != null) {
            builder.append(QueryTokens.expression(ctx.OF()));
        }
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.collection_valued_path_expression()));
        return builder;
    }

    @Override
    public QueryTokenStream visitEntity_or_value_expression(JpqlParser.Entity_or_value_expressionContext ctx) {
        if (ctx.single_valued_object_path_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.single_valued_object_path_expression());
        }
        if (ctx.state_field_path_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.state_field_path_expression());
        }
        if (ctx.simple_entity_or_value_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.simple_entity_or_value_expression());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitSimple_entity_or_value_expression(JpqlParser.Simple_entity_or_value_expressionContext ctx) {
        if (ctx.identification_variable() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.identification_variable());
        }
        if (ctx.input_parameter() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.input_parameter());
        }
        if (ctx.literal() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.literal());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitExists_expression(JpqlParser.Exists_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.NOT() != null) {
            builder.append(QueryTokens.expression(ctx.NOT()));
        }
        builder.append(QueryTokens.expression(ctx.EXISTS()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.subquery()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitAll_or_any_expression(JpqlParser.All_or_any_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.ALL() != null) {
            builder.append(QueryTokens.expression(ctx.ALL()));
        } else if (ctx.ANY() != null) {
            builder.append(QueryTokens.expression(ctx.ANY()));
        } else if (ctx.SOME() != null) {
            builder.append(QueryTokens.expression(ctx.SOME()));
        }
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.subquery()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitStringComparison(JpqlParser.StringComparisonContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.string_expression(0)));
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.comparison_operator()));
        if (ctx.string_expression(1) != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.string_expression(1)));
        } else {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.all_or_any_expression()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitBooleanComparison(JpqlParser.BooleanComparisonContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.boolean_expression(0)));
        builder.append(QueryTokens.ventilated(ctx.op));
        if (ctx.boolean_expression(1) != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.boolean_expression(1)));
        } else {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.all_or_any_expression()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitDirectBooleanCheck(JpqlParser.DirectBooleanCheckContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.boolean_expression());
    }

    @Override
    public QueryTokenStream visitEnumComparison(JpqlParser.EnumComparisonContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.enum_expression(0)));
        builder.append(QueryTokens.ventilated(ctx.op));
        if (ctx.enum_expression(1) != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.enum_expression(1)));
        } else {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.all_or_any_expression()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitDatetimeComparison(JpqlParser.DatetimeComparisonContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.datetime_expression(0)));
        builder.append(QueryTokens.ventilated(ctx.comparison_operator().op));
        if (ctx.datetime_expression(1) != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.datetime_expression(1)));
        } else {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.all_or_any_expression()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitEntityComparison(JpqlParser.EntityComparisonContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.entity_expression(0)));
        builder.append(QueryTokens.expression(ctx.op));
        if (ctx.entity_expression(1) != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.entity_expression(1)));
        } else {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.all_or_any_expression()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitArithmeticComparison(JpqlParser.ArithmeticComparisonContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(0)));
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.comparison_operator()));
        if (ctx.arithmetic_expression(1) != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(1)));
        } else {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.all_or_any_expression()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitEntityTypeComparison(JpqlParser.EntityTypeComparisonContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.entity_type_expression(0)));
        builder.append(QueryTokens.ventilated(ctx.op));
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.entity_type_expression(1)));
        return builder;
    }

    @Override
    public QueryTokenStream visitRegexpComparison(JpqlParser.RegexpComparisonContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.string_expression()));
        builder.append(QueryTokens.expression(ctx.REGEXP()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.string_literal()));
        return builder;
    }

    @Override
    public QueryTokenStream visitComparison_operator(JpqlParser.Comparison_operatorContext ctx) {
        return QueryRenderer.QueryRendererBuilder.from(QueryTokens.ventilated(ctx.op));
    }

    @Override
    public QueryTokenStream visitArithmetic_expression(JpqlParser.Arithmetic_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.arithmetic_expression() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression()));
            builder.append(QueryTokens.expression(ctx.op));
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_term()));
        } else {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_term()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitArithmetic_term(JpqlParser.Arithmetic_termContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.arithmetic_term() != null) {
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_term()));
            builder.append(QueryTokens.ventilated(ctx.op));
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_factor()));
        } else {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_factor()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitArithmetic_factor(JpqlParser.Arithmetic_factorContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.op != null) {
            builder.append(QueryTokens.token(ctx.op));
        }
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_primary()));
        return builder;
    }

    @Override
    public QueryTokenStream visitArithmetic_primary(JpqlParser.Arithmetic_primaryContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.state_valued_path_expression() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.state_valued_path_expression()));
        } else if (ctx.numeric_literal() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.numeric_literal()));
        } else if (ctx.arithmetic_expression() != null) {
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.input_parameter() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.input_parameter()));
        } else if (ctx.functions_returning_numerics() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.functions_returning_numerics()));
        } else if (ctx.aggregate_expression() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.aggregate_expression()));
        } else if (ctx.case_expression() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.case_expression()));
        } else if (ctx.arithmetic_cast_function() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_cast_function()));
        } else if (ctx.type_cast_function() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.type_cast_function()));
        } else if (ctx.function_invocation() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.function_invocation()));
        } else if (ctx.subquery() != null) {
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.subquery()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitString_expression(JpqlParser.String_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.state_valued_path_expression() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.state_valued_path_expression()));
        } else if (ctx.string_literal() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.string_literal()));
        } else if (ctx.input_parameter() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.input_parameter()));
        } else if (ctx.functions_returning_strings() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.functions_returning_strings()));
        } else if (ctx.aggregate_expression() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.aggregate_expression()));
        } else if (ctx.case_expression() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.case_expression()));
        } else if (ctx.string_cast_function() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.string_cast_function()));
        } else if (ctx.type_cast_function() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.type_cast_function()));
        } else if (ctx.function_invocation() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.function_invocation()));
        } else if (ctx.subquery() != null) {
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.subquery()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitDatetime_expression(JpqlParser.Datetime_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.state_valued_path_expression() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.state_valued_path_expression()));
        } else if (ctx.input_parameter() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.input_parameter()));
        } else if (ctx.input_parameter() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.input_parameter()));
        } else if (ctx.functions_returning_datetime() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.functions_returning_datetime()));
        } else if (ctx.aggregate_expression() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.aggregate_expression()));
        } else if (ctx.case_expression() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.case_expression()));
        } else if (ctx.function_invocation() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.function_invocation()));
        } else if (ctx.date_time_timestamp_literal() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.date_time_timestamp_literal()));
        } else if (ctx.subquery() != null) {
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.subquery()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitBoolean_expression(JpqlParser.Boolean_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.state_valued_path_expression() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.state_valued_path_expression()));
        } else if (ctx.boolean_literal() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.boolean_literal()));
        } else if (ctx.input_parameter() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.input_parameter()));
        } else if (ctx.case_expression() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.case_expression()));
        } else if (ctx.function_invocation() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.function_invocation()));
        } else if (ctx.subquery() != null) {
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.subquery()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitEnum_expression(JpqlParser.Enum_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.state_valued_path_expression() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.state_valued_path_expression()));
        } else if (ctx.enum_literal() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.enum_literal()));
        } else if (ctx.input_parameter() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.input_parameter()));
        } else if (ctx.case_expression() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.case_expression()));
        } else if (ctx.subquery() != null) {
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.subquery()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitEntity_expression(JpqlParser.Entity_expressionContext ctx) {
        if (ctx.single_valued_object_path_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.single_valued_object_path_expression());
        }
        if (ctx.simple_entity_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.simple_entity_expression());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitSimple_entity_expression(JpqlParser.Simple_entity_expressionContext ctx) {
        if (ctx.identification_variable() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.identification_variable());
        }
        if (ctx.input_parameter() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.input_parameter());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitEntity_type_expression(JpqlParser.Entity_type_expressionContext ctx) {
        if (ctx.type_discriminator() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.type_discriminator());
        }
        if (ctx.entity_type_literal() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.entity_type_literal());
        }
        if (ctx.input_parameter() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.input_parameter());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitType_discriminator(JpqlParser.Type_discriminatorContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.TYPE()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        if (ctx.general_identification_variable() != null) {
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.general_identification_variable()));
        } else if (ctx.single_valued_object_path_expression() != null) {
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.single_valued_object_path_expression()));
        } else if (ctx.input_parameter() != null) {
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.input_parameter()));
        }
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitFunctions_returning_numerics(JpqlParser.Functions_returning_numericsContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.LENGTH() != null) {
            builder.append(QueryTokens.token(ctx.LENGTH()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.string_expression(0)));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.LOCATE() != null) {
            builder.append(QueryTokens.token(ctx.LOCATE()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.string_expression(0)));
            builder.append(QueryTokens.TOKEN_COMMA);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.string_expression(1)));
            if (ctx.arithmetic_expression() != null) {
                builder.append(QueryTokens.TOKEN_COMMA);
                builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(0)));
            }
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.ABS() != null) {
            builder.append(QueryTokens.token(ctx.ABS()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(0)));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.CEILING() != null) {
            builder.append(QueryTokens.token(ctx.CEILING()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(0)));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.EXP() != null) {
            builder.append(QueryTokens.token(ctx.EXP()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(0)));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.FLOOR() != null) {
            builder.append(QueryTokens.token(ctx.FLOOR()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(0)));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.LN() != null) {
            builder.append(QueryTokens.token(ctx.LN()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(0)));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.SIGN() != null) {
            builder.append(QueryTokens.token(ctx.SIGN()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(0)));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.SQRT() != null) {
            builder.append(QueryTokens.token(ctx.SQRT()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(0)));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.MOD() != null) {
            builder.append(QueryTokens.token(ctx.MOD()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(0)));
            builder.append(QueryTokens.TOKEN_COMMA);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(1)));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.POWER() != null) {
            builder.append(QueryTokens.token(ctx.POWER()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(0)));
            builder.append(QueryTokens.TOKEN_COMMA);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(1)));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.ROUND() != null) {
            builder.append(QueryTokens.token(ctx.ROUND()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(0)));
            builder.append(QueryTokens.TOKEN_COMMA);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.arithmetic_expression(1)));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.SIZE() != null) {
            builder.append(QueryTokens.token(ctx.SIZE()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.collection_valued_path_expression()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.INDEX() != null) {
            builder.append(QueryTokens.token(ctx.INDEX()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.identification_variable()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitFunctions_returning_datetime(JpqlParser.Functions_returning_datetimeContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.CURRENT_DATE() != null) {
            builder.append(QueryTokens.expression(ctx.CURRENT_DATE()));
        } else if (ctx.CURRENT_TIME() != null) {
            builder.append(QueryTokens.expression(ctx.CURRENT_TIME()));
        } else if (ctx.CURRENT_TIMESTAMP() != null) {
            builder.append(QueryTokens.expression(ctx.CURRENT_TIMESTAMP()));
        } else if (ctx.LOCAL() != null) {
            builder.append(QueryTokens.expression(ctx.LOCAL()));
            if (ctx.DATE() != null) {
                builder.append(QueryTokens.expression(ctx.DATE()));
            } else if (ctx.TIME() != null) {
                builder.append(QueryTokens.expression(ctx.TIME()));
            } else if (ctx.DATETIME() != null) {
                builder.append(QueryTokens.expression(ctx.DATETIME()));
            }
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitFunctions_returning_strings(JpqlParser.Functions_returning_stringsContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.CONCAT() != null) {
            builder.append(QueryTokens.token(ctx.CONCAT()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline(QueryTokenStream.concat(ctx.string_expression(), arg_0 -> ((JpqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.SUBSTRING() != null) {
            builder.append(QueryTokens.token(ctx.SUBSTRING()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.string_expression(0)));
            builder.appendInline(QueryTokenStream.concat(ctx.arithmetic_expression(), arg_0 -> ((JpqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.TRIM() != null) {
            builder.append(QueryTokens.token(ctx.TRIM()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            if (ctx.trim_specification() != null) {
                builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.trim_specification()));
            }
            if (ctx.trim_character() != null) {
                builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.trim_character()));
            }
            if (ctx.FROM() != null) {
                builder.append(QueryTokens.expression(ctx.FROM()));
            }
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.string_expression(0)));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.LOWER() != null) {
            builder.append(QueryTokens.token(ctx.LOWER()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.string_expression(0)));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        } else if (ctx.UPPER() != null) {
            builder.append(QueryTokens.token(ctx.UPPER()));
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.string_expression(0)));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitTrim_specification(JpqlParser.Trim_specificationContext ctx) {
        if (ctx.LEADING() != null) {
            return QueryRenderer.from(QueryTokens.expression(ctx.LEADING()));
        }
        if (ctx.TRAILING() != null) {
            return QueryRenderer.from(QueryTokens.expression(ctx.TRAILING()));
        }
        return QueryRenderer.from(QueryTokens.expression(ctx.BOTH()));
    }

    @Override
    public QueryTokenStream visitArithmetic_cast_function(JpqlParser.Arithmetic_cast_functionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.CAST()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.string_expression()));
        if (ctx.AS() != null) {
            builder.append(QueryTokens.expression(ctx.AS()));
        }
        builder.append(QueryTokens.token(ctx.f));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitType_cast_function(JpqlParser.Type_cast_functionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.CAST()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.scalar_expression()));
        if (ctx.AS() != null) {
            builder.append(QueryTokens.expression(ctx.AS()));
        }
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.identification_variable()));
        if (!CollectionUtils.isEmpty(ctx.numeric_literal())) {
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline(QueryTokenStream.concat(ctx.numeric_literal(), arg_0 -> ((JpqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        }
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitString_cast_function(JpqlParser.String_cast_functionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.CAST()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.scalar_expression()));
        builder.append(QueryTokens.expression(ctx.AS()));
        builder.append(QueryTokens.token(ctx.STRING()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitFunction_invocation(JpqlParser.Function_invocationContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.FUNCTION()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.function_name()));
        if (!ctx.function_arg().isEmpty()) {
            builder.append(QueryTokens.TOKEN_COMMA);
            builder.appendInline(QueryTokenStream.concat(ctx.function_arg(), arg_0 -> ((JpqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        }
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitExtract_datetime_field(JpqlParser.Extract_datetime_fieldContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.EXTRACT()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.datetime_field()));
        builder.append(QueryTokens.expression(ctx.FROM()));
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.datetime_expression()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitDatetime_field(JpqlParser.Datetime_fieldContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.identification_variable());
    }

    @Override
    public QueryTokenStream visitExtract_datetime_part(JpqlParser.Extract_datetime_partContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.EXTRACT()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.datetime_part()));
        builder.append(QueryTokens.expression(ctx.FROM()));
        builder.append((QueryTokenStream)this.visit((ParseTree)ctx.datetime_expression()));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitDatetime_part(JpqlParser.Datetime_partContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.identification_variable());
    }

    @Override
    public QueryTokenStream visitFunction_arg(JpqlParser.Function_argContext ctx) {
        if (ctx.literal() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.literal());
        }
        if (ctx.state_valued_path_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.state_valued_path_expression());
        }
        if (ctx.input_parameter() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.input_parameter());
        }
        return (QueryTokenStream)this.visit((ParseTree)ctx.scalar_expression());
    }

    @Override
    public QueryTokenStream visitCase_expression(JpqlParser.Case_expressionContext ctx) {
        if (ctx.general_case_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.general_case_expression());
        }
        if (ctx.simple_case_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.simple_case_expression());
        }
        if (ctx.coalesce_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.coalesce_expression());
        }
        return (QueryTokenStream)this.visit((ParseTree)ctx.nullif_expression());
    }

    @Override
    public QueryTokenStream visitGeneral_case_expression(JpqlParser.General_case_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.CASE()));
        builder.appendExpression(QueryTokenStream.concat(ctx.when_clause(), arg_0 -> ((JpqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_SPACE));
        builder.append(QueryTokens.expression(ctx.ELSE()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.scalar_expression()));
        builder.append(QueryTokens.expression(ctx.END()));
        return builder;
    }

    @Override
    public QueryTokenStream visitWhen_clause(JpqlParser.When_clauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.WHEN()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.conditional_expression()));
        builder.append(QueryTokens.expression(ctx.THEN()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.scalar_expression()));
        return builder;
    }

    @Override
    public QueryTokenStream visitSimple_case_expression(JpqlParser.Simple_case_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.CASE()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.case_operand()));
        builder.appendExpression(QueryTokenStream.concat(ctx.simple_when_clause(), arg_0 -> ((JpqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_SPACE));
        builder.append(QueryTokens.expression(ctx.ELSE()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.scalar_expression()));
        builder.append(QueryTokens.expression(ctx.END()));
        return builder;
    }

    @Override
    public QueryTokenStream visitCase_operand(JpqlParser.Case_operandContext ctx) {
        if (ctx.state_valued_path_expression() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.state_valued_path_expression());
        }
        return (QueryTokenStream)this.visit((ParseTree)ctx.type_discriminator());
    }

    @Override
    public QueryTokenStream visitSimple_when_clause(JpqlParser.Simple_when_clauseContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.WHEN()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.scalar_expression(0)));
        builder.append(QueryTokens.expression(ctx.THEN()));
        builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.scalar_expression(1)));
        return builder;
    }

    @Override
    public QueryTokenStream visitCoalesce_expression(JpqlParser.Coalesce_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.token(ctx.COALESCE()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline(QueryTokenStream.concat(ctx.scalar_expression(), arg_0 -> ((JpqlQueryRenderer)this).visit(arg_0), QueryTokens.TOKEN_COMMA));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitNullif_expression(JpqlParser.Nullif_expressionContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        builder.append(QueryTokens.expression(ctx.NULLIF()));
        builder.append(QueryTokens.TOKEN_OPEN_PAREN);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.scalar_expression(0)));
        builder.append(QueryTokens.TOKEN_COMMA);
        builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.scalar_expression(1)));
        builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        return builder;
    }

    @Override
    public QueryTokenStream visitTrim_character(JpqlParser.Trim_characterContext ctx) {
        if (ctx.CHARACTER() != null) {
            return QueryRenderer.from(QueryTokens.expression(ctx.CHARACTER()));
        }
        if (ctx.character_valued_input_parameter() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.character_valued_input_parameter());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitIdentification_variable(JpqlParser.Identification_variableContext ctx) {
        if (ctx.IDENTIFICATION_VARIABLE() != null) {
            return QueryRenderer.from(QueryTokens.expression(ctx.IDENTIFICATION_VARIABLE()));
        }
        if (ctx.f != null) {
            return QueryRenderer.from(QueryTokens.token(ctx.f));
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitConstructor_name(JpqlParser.Constructor_nameContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.entity_name());
    }

    @Override
    public QueryTokenStream visitLiteral(JpqlParser.LiteralContext ctx) {
        if (ctx.STRINGLITERAL() != null) {
            return QueryRenderer.from(QueryTokens.expression(ctx.STRINGLITERAL()));
        }
        if (ctx.JAVASTRINGLITERAL() != null) {
            return QueryRenderer.from(QueryTokens.expression(ctx.JAVASTRINGLITERAL()));
        }
        if (ctx.INTLITERAL() != null) {
            return QueryRenderer.from(QueryTokens.expression(ctx.INTLITERAL()));
        }
        if (ctx.FLOATLITERAL() != null) {
            return QueryRenderer.from(QueryTokens.expression(ctx.FLOATLITERAL()));
        }
        if (ctx.LONGLITERAL() != null) {
            return QueryRenderer.from(QueryTokens.expression(ctx.LONGLITERAL()));
        }
        if (ctx.boolean_literal() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.boolean_literal());
        }
        if (ctx.entity_type_literal() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.entity_type_literal());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitInput_parameter(JpqlParser.Input_parameterContext ctx) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.INTLITERAL() != null) {
            builder.append(QueryTokens.TOKEN_QUESTION_MARK);
            builder.append(QueryTokens.token(ctx.INTLITERAL()));
        } else if (ctx.identification_variable() != null) {
            builder.append(QueryTokens.TOKEN_COLON);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.identification_variable()));
        }
        return builder;
    }

    @Override
    public QueryTokenStream visitPattern_value(JpqlParser.Pattern_valueContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.string_expression());
    }

    @Override
    public QueryTokenStream visitDate_time_timestamp_literal(JpqlParser.Date_time_timestamp_literalContext ctx) {
        return QueryRenderer.from(QueryTokens.expression(ctx.STRINGLITERAL()));
    }

    @Override
    public QueryTokenStream visitEntity_type_literal(JpqlParser.Entity_type_literalContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.identification_variable());
    }

    @Override
    public QueryTokenStream visitEscape_character(JpqlParser.Escape_characterContext ctx) {
        if (ctx.CHARACTER() != null) {
            return QueryRenderer.from(QueryTokens.expression(ctx.CHARACTER()));
        }
        if (ctx.character_valued_input_parameter() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.character_valued_input_parameter());
        }
        if (ctx.string_literal() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.string_literal());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitNumeric_literal(JpqlParser.Numeric_literalContext ctx) {
        if (ctx.INTLITERAL() != null) {
            return QueryRenderer.from(QueryTokens.token(ctx.INTLITERAL()));
        }
        if (ctx.FLOATLITERAL() != null) {
            return QueryRenderer.from(QueryTokens.token(ctx.FLOATLITERAL()));
        }
        if (ctx.LONGLITERAL() != null) {
            return QueryRenderer.from(QueryTokens.token(ctx.LONGLITERAL()));
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitBoolean_literal(JpqlParser.Boolean_literalContext ctx) {
        if (ctx.TRUE() != null) {
            return QueryRenderer.from(QueryTokens.expression(ctx.TRUE()));
        }
        if (ctx.FALSE() != null) {
            return QueryRenderer.from(QueryTokens.expression(ctx.FALSE()));
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitEnum_literal(JpqlParser.Enum_literalContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.state_field_path_expression());
    }

    @Override
    public QueryTokenStream visitString_literal(JpqlParser.String_literalContext ctx) {
        if (ctx.CHARACTER() != null) {
            return QueryRenderer.from(QueryTokens.expression(ctx.CHARACTER()));
        }
        if (ctx.STRINGLITERAL() != null) {
            return QueryRenderer.from(QueryTokens.expression(ctx.STRINGLITERAL()));
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitSingle_valued_embeddable_object_field(JpqlParser.Single_valued_embeddable_object_fieldContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.identification_variable());
    }

    @Override
    public QueryTokenStream visitSubtype(JpqlParser.SubtypeContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.identification_variable());
    }

    @Override
    public QueryTokenStream visitCollection_valued_field(JpqlParser.Collection_valued_fieldContext ctx) {
        if (ctx.reserved_word() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.reserved_word());
        }
        return (QueryTokenStream)this.visit((ParseTree)ctx.identification_variable());
    }

    @Override
    public QueryTokenStream visitSingle_valued_object_field(JpqlParser.Single_valued_object_fieldContext ctx) {
        if (ctx.reserved_word() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.reserved_word());
        }
        return (QueryTokenStream)this.visit((ParseTree)ctx.identification_variable());
    }

    @Override
    public QueryTokenStream visitState_field(JpqlParser.State_fieldContext ctx) {
        if (ctx.reserved_word() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.reserved_word());
        }
        return (QueryTokenStream)this.visit((ParseTree)ctx.identification_variable());
    }

    @Override
    public QueryTokenStream visitCollection_value_field(JpqlParser.Collection_value_fieldContext ctx) {
        if (ctx.reserved_word() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.reserved_word());
        }
        return (QueryTokenStream)this.visit((ParseTree)ctx.identification_variable());
    }

    @Override
    public QueryTokenStream visitEntity_name(JpqlParser.Entity_nameContext ctx) {
        return QueryTokenStream.concat(ctx.reserved_word(), this::visitReserved_word, QueryTokens.TOKEN_DOT);
    }

    @Override
    public QueryTokenStream visitResult_variable(JpqlParser.Result_variableContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.identification_variable());
    }

    @Override
    public QueryTokenStream visitSuperquery_identification_variable(JpqlParser.Superquery_identification_variableContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.identification_variable());
    }

    @Override
    public QueryTokenStream visitCollection_valued_input_parameter(JpqlParser.Collection_valued_input_parameterContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.input_parameter());
    }

    @Override
    public QueryTokenStream visitSingle_valued_input_parameter(JpqlParser.Single_valued_input_parameterContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.input_parameter());
    }

    @Override
    public QueryTokenStream visitFunction_name(JpqlParser.Function_nameContext ctx) {
        return (QueryTokenStream)this.visit((ParseTree)ctx.string_literal());
    }

    @Override
    public QueryTokenStream visitCharacter_valued_input_parameter(JpqlParser.Character_valued_input_parameterContext ctx) {
        if (ctx.CHARACTER() != null) {
            return QueryRenderer.from(QueryTokens.expression(ctx.CHARACTER()));
        }
        if (ctx.input_parameter() != null) {
            return (QueryTokenStream)this.visit((ParseTree)ctx.input_parameter());
        }
        return QueryTokenStream.empty();
    }

    @Override
    public QueryTokenStream visitReserved_word(JpqlParser.Reserved_wordContext ctx) {
        if (ctx.IDENTIFICATION_VARIABLE() != null) {
            return QueryRenderer.from(QueryTokens.token(ctx.IDENTIFICATION_VARIABLE()));
        }
        if (ctx.f != null) {
            return QueryRenderer.from(QueryTokens.token(ctx.f));
        }
        return QueryTokenStream.empty();
    }
}

