/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.attribute;

import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.attribute.UsernameAttributeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleUsernameAttributeProvider
implements UsernameAttributeProvider {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleUsernameAttributeProvider.class);
    private static final String DEFAULT_USERNAME_ATTRIBUTE = "username";
    private String usernameAttribute = "username";

    public String getUsernameFromQuery(Map<String, List<Object>> query) {
        List<Object> usernameAttributeValues = this.getUsernameAttributeValues(query);
        LOGGER.debug("Username attribute value found from the query map is [{}]", usernameAttributeValues);
        if (usernameAttributeValues == null || usernameAttributeValues.isEmpty()) {
            return null;
        }
        Object firstValue = usernameAttributeValues.getFirst();
        if (firstValue == null) {
            return null;
        }
        String username = StringUtils.trimToNull((String)String.valueOf(firstValue));
        if (username == null || username.contains("*")) {
            return null;
        }
        return username;
    }

    private List<Object> getUsernameAttributeValues(Map<String, List<Object>> query) {
        if (query.containsKey(this.usernameAttribute)) {
            List<Object> usernameAttributeValues = query.get(this.usernameAttribute);
            LOGGER.debug("Using [{}] attribute to get username from the query map", (Object)this.usernameAttribute);
            return usernameAttributeValues;
        }
        List<Object> usernameAttributeValues = query.get(DEFAULT_USERNAME_ATTRIBUTE);
        LOGGER.debug("Using [{}] attribute to get username from the query map", (Object)DEFAULT_USERNAME_ATTRIBUTE);
        return usernameAttributeValues;
    }

    @Generated
    public void setUsernameAttribute(String usernameAttribute) {
        this.usernameAttribute = usernameAttribute;
    }

    @Generated
    public String getUsernameAttribute() {
        return this.usernameAttribute;
    }

    @Generated
    public SimpleUsernameAttributeProvider(String usernameAttribute) {
        this.usernameAttribute = usernameAttribute;
    }

    @Generated
    public SimpleUsernameAttributeProvider() {
    }
}

