/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.api.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;

public class RealmUtils {
    private static final Predicate<String> DYN_REALMS_PREDICATE = r -> !r.startsWith("/");
    protected final Map<String, Field> fields = new HashMap<String, Field>();

    public static String getGroupOwnerRealm(String realmPath, String groupKey) {
        return realmPath + "@" + groupKey;
    }

    public static Optional<Pair<String, String>> parseGroupOwnerRealm(String input) {
        String[] split = input.split("@");
        return split == null || split.length < 2 ? Optional.empty() : Optional.of(Pair.of((Object)split[0], (Object)split[1]));
    }

    public static boolean normalizingAddTo(Set<String> realms, String newRealm) {
        boolean dontAdd = false;
        HashSet<String> toRemove = new HashSet<String>();
        for (String realm : realms) {
            if (newRealm.startsWith(realm)) {
                dontAdd = true;
                continue;
            }
            if (!realm.startsWith(newRealm)) continue;
            toRemove.add(realm);
        }
        realms.removeAll(toRemove);
        if (!dontAdd) {
            realms.add(newRealm);
        }
        return !dontAdd;
    }

    public static Pair<Set<String>, Set<String>> normalize(Collection<String> realms) {
        HashSet normalized = new HashSet();
        HashSet groupOwnership = new HashSet();
        if (realms != null) {
            realms.forEach(realm -> {
                if (realm.indexOf(64) == -1) {
                    RealmUtils.normalizingAddTo(normalized, realm);
                } else {
                    groupOwnership.add(realm);
                }
            });
        }
        return Pair.of(normalized, groupOwnership);
    }

    public static Set<String> getEffective(Set<String> allowedRealms, String requestedRealm) {
        Pair<Set<String>, Set<String>> normalized = RealmUtils.normalize(allowedRealms);
        Set<String> requested = Set.of(requestedRealm);
        StartsWithPredicate normalizedFilter = new StartsWithPredicate((Collection)normalized.getLeft());
        StartsWithPredicate requestedFilter = new StartsWithPredicate(requested);
        HashSet<String> effective = new HashSet<String>();
        effective.addAll(requested.stream().filter(normalizedFilter).collect(Collectors.toSet()));
        effective.addAll(((Set)normalized.getLeft()).stream().filter(requestedFilter).collect(Collectors.toSet()));
        effective.addAll((Collection)normalized.getRight());
        if (allowedRealms != null) {
            effective.addAll(allowedRealms.stream().filter(DYN_REALMS_PREDICATE).collect(Collectors.toSet()));
        }
        return effective;
    }

    protected static void initFieldNames(Class<?> entityClass, Map<String, Field> fields) {
        List classes = ClassUtils.getAllSuperclasses(entityClass);
        classes.add(entityClass);
        classes.forEach(clazz -> {
            for (Field field : clazz.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers()) || field.getName().startsWith("pc") || Collection.class.isAssignableFrom(field.getType()) || Map.class.isAssignableFrom(field.getType())) continue;
                fields.put(field.getName(), field);
                if (!"id".equals(field.getName())) continue;
                fields.put("key", field);
            }
        });
    }

    public RealmUtils(EntityFactory entityFactory) {
        RealmUtils.initFieldNames(entityFactory.realmClass(), this.fields);
    }

    public Optional<Field> getField(String name) {
        return Optional.ofNullable(this.fields.get(name));
    }

    private static class StartsWithPredicate
    implements Predicate<String> {
        private final Collection<String> targets;

        StartsWithPredicate(Collection<String> targets) {
            this.targets = targets;
        }

        @Override
        public boolean test(String realm) {
            return this.targets.stream().anyMatch(realm::startsWith);
        }
    }
}

