/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.console.panels.AMSessionPanel;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.rest.AMSessionRestClient;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.DatePropertyColumn;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.KeyPropertyColumn;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.JsonEditorPanel;
import org.apache.syncope.client.ui.commons.pages.BaseWebPage;
import org.apache.syncope.client.ui.commons.panels.ModalPanel;
import org.apache.syncope.client.ui.commons.rest.RestClient;
import org.apache.syncope.common.lib.AMSession;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;

public class AMSessionDirectoryPanel
extends DirectoryPanel<AMSession, AMSession, AMSessionProvider, AMSessionRestClient> {
    private static final long serialVersionUID = 24083331272114L;
    private final String listEntitlement;
    private final String deleteEntitlement;
    private final BaseModal<String> viewModal;
    private String keyword;

    public AMSessionDirectoryPanel(String id, AMSessionRestClient restClient, String listEntitlement, String deleteEntitlement, PageReference pageRef) {
        super(id, (RestClient)restClient, pageRef);
        this.listEntitlement = listEntitlement;
        this.deleteEntitlement = deleteEntitlement;
        this.restClient = restClient;
        this.disableCheckBoxes();
        this.viewModal = new BaseModal<String>("outer"){
            private static final long serialVersionUID = 389935548143327858L;

            protected void onConfigure() {
                super.onConfigure();
                this.setFooterVisible(false);
            }
        };
        this.viewModal.size(Modal.Size.Extra_large);
        this.viewModal.setWindowClosedCallback((BaseModal.WindowClosedCallback & Serializable)target -> this.viewModal.show(false));
        this.addOuterObject(new Component[]{this.viewModal});
        this.initResultTable();
    }

    protected List<IColumn<AMSession, String>> getColumns() {
        ArrayList<IColumn<AMSession, String>> columns = new ArrayList<IColumn<AMSession, String>>();
        columns.add((IColumn<AMSession, String>)new KeyPropertyColumn((IModel)new StringResourceModel("key", (Component)this), "key"));
        columns.add((IColumn<AMSession, String>)new DatePropertyColumn((IModel)new ResourceModel("authenticationDate"), "authenticationDate", "authenticationDate"));
        columns.add((IColumn<AMSession, String>)new PropertyColumn((IModel)new ResourceModel("principal"), (Object)"principal", "principal"));
        return columns;
    }

    protected ActionsPanel<AMSession> getActions(final IModel<AMSession> model) {
        ActionsPanel panel = super.getActions(model);
        panel.add((ActionLink)new ActionLink<AMSession>(){
            private static final long serialVersionUID = 22687128346032L;

            public void onClick(AjaxRequestTarget target, AMSession ignore) {
                AMSessionDirectoryPanel.this.viewModal.header((IModel)new ResourceModel("details"));
                target.add(new Component[]{AMSessionDirectoryPanel.this.viewModal.setContent((ModalPanel)new JsonEditorPanel(AMSessionDirectoryPanel.this.viewModal, (IModel)Model.of((Serializable)((Object)((AMSession)model.getObject()).getJson())), true, AMSessionDirectoryPanel.this.pageRef))});
                AMSessionDirectoryPanel.this.viewModal.show(true);
            }
        }, ActionLink.ActionType.VIEW, this.listEntitlement);
        panel.add((ActionLink)new ActionLink<AMSession>(){
            private static final long serialVersionUID = -4608353559809323466L;

            public void onClick(AjaxRequestTarget target, AMSession ignore) {
                AMSession session = (AMSession)model.getObject();
                try {
                    ((AMSessionRestClient)AMSessionDirectoryPanel.this.restClient).delete(session.getKey());
                    SyncopeConsoleSession.get().success((Serializable)((Object)AMSessionDirectoryPanel.this.getString("operation_succeeded")));
                    target.add(new Component[]{AMSessionDirectoryPanel.this.container});
                }
                catch (SyncopeClientException e) {
                    DirectoryPanel.LOG.error("While deleting {}", (Object)session.getKey(), (Object)e);
                    SyncopeConsoleSession.get().onException((Exception)((Object)e));
                }
                ((BaseWebPage)AMSessionDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, this.deleteEntitlement, true);
        return panel;
    }

    protected Collection<ActionLink.ActionType> getBatches() {
        return List.of();
    }

    protected AMSessionProvider dataProvider() {
        return new AMSessionProvider(this.rows);
    }

    protected String paginatorRowsKey() {
        return "wasession.paginator.rows";
    }

    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof AMSessionPanel.AMSessionSearchEvent) {
            AMSessionPanel.AMSessionSearchEvent payload = (AMSessionPanel.AMSessionSearchEvent)AMSessionPanel.AMSessionSearchEvent.class.cast(event.getPayload());
            this.keyword = payload.getKeyword();
            this.updateResultTable(payload.getTarget());
        } else {
            super.onEvent(event);
        }
    }

    protected final class AMSessionProvider
    extends DirectoryDataProvider<AMSession> {
        private static final long serialVersionUID = 18002870965042L;
        private final SortableDataProviderComparator<AMSession> comparator;

        public AMSessionProvider(int paginatorRows) {
            super(paginatorRows);
            this.setSort("authenticationDate", SortOrder.ASCENDING);
            this.comparator = new SortableDataProviderComparator((SortableDataProvider)this);
        }

        private Stream<AMSession> filtered() {
            Stream<AMSession> stream = ((AMSessionRestClient)AMSessionDirectoryPanel.this.restClient).list().stream();
            return AMSessionDirectoryPanel.this.keyword == null ? stream : stream.filter(s -> s.getJson().contains(AMSessionDirectoryPanel.this.keyword));
        }

        public Iterator<? extends AMSession> iterator(long first, long count) {
            return this.filtered().skip(first).limit(count).sorted((Comparator<AMSession>)this.comparator).iterator();
        }

        public long size() {
            return this.filtered().count();
        }

        public IModel<AMSession> model(AMSession waSession) {
            return new CompoundPropertyModel((Object)waSession);
        }
    }
}

